/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.Vector2;
import com.google.common.base.Function;
import forge.Forge;
import forge.Graphics;
import forge.adventure.data.AdventureEventData;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.util.AdventureEventController;
import forge.adventure.util.Config;
import forge.adventure.util.Current;
import forge.assets.FImage;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.card.CardEdition;
import forge.card.CardZoom;
import forge.deck.AddBasicLandsDialog;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckFormat;
import forge.deck.DeckSection;
import forge.deck.FDeckViewer;
import forge.game.GameType;
import forge.gamemodes.limited.BoosterDraft;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.ItemColumn;
import forge.itemmanager.ItemManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.filters.ItemFilter;
import forge.localinstance.properties.ForgePreferences;
import forge.menu.FCheckBoxMenuItem;
import forge.menu.FDropDownMenu;
import forge.menu.FMenuItem;
import forge.menu.FPopupMenu;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.TabPageScreen;
import forge.toolbox.FContainer;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.toolbox.FOptionPane;
import forge.toolbox.GuiChoose;
import forge.util.Callback;
import forge.util.ItemPool;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AdventureDeckEditor
extends TabPageScreen<AdventureDeckEditor> {
    public static AdventureEventData currentEvent;
    private static final FileHandle deckIcon;
    private static final FImage MAIN_DECK_ICON;
    private static final FileHandle sideIcon;
    private static final FImage SIDEBOARD_ICON;
    private static final float HEADER_HEIGHT;
    private static final FileHandle binderIcon;
    private static final FImage CATALOG_ICON;
    private static final FileHandle sellIcon;
    private static final FLabel lblGold;
    private static ItemPool<InventoryItem> decksUsingMyCards;
    private int selected = 0;
    private CatalogPage catalogPage;
    private static DeckSectionPage mainDeckPage;
    private static DeckSectionPage sideboardPage;
    private DeckSectionPage commanderPage;
    protected final DeckHeader deckHeader = this.add(new DeckHeader());
    protected final FLabel lblName = this.deckHeader.add(new FLabel.Builder().font(FSkinFont.get(16)).insets(new Vector2(Utils.scale(5.0f), 0.0f)).build());
    private final FLabel btnMoreOptions = this.deckHeader.add(new FLabel.Builder().text("...").font(FSkinFont.get(20)).align(1).pressedColor(FScreen.Header.getBtnPressedColor()).build());
    boolean isShop;

    public static BoosterDraft getDraft() {
        if (currentEvent == null) {
            return null;
        }
        return currentEvent.getDraft();
    }

    public void setEvent(AdventureEventData event) {
        currentEvent = event;
    }

    public void completeDraft() {
        AdventureDeckEditor.currentEvent.isDraftComplete = true;
        Deck[] opponentDecks = currentEvent.getDraft().getDecks();
        for (int i = 0; i < AdventureDeckEditor.currentEvent.participants.length && i < opponentDecks.length; ++i) {
            AdventureDeckEditor.currentEvent.participants[i].setDeck(opponentDecks[i]);
        }
        AdventureDeckEditor.currentEvent.draftedDeck = (Deck)AdventureDeckEditor.currentEvent.registeredDeck.copyTo("Draft Deck");
        if (this.allowsAddBasic()) {
            this.launchBasicLandDialog();
        }
        if (AdventureDeckEditor.currentEvent.eventStatus == AdventureEventController.EventStatus.Entered) {
            AdventureDeckEditor.currentEvent.eventStatus = AdventureEventController.EventStatus.Ready;
        }
    }

    public static void leave() {
        if (currentEvent != null && currentEvent.getDraft() != null && !AdventureDeckEditor.currentEvent.isDraftComplete) {
            FOptionPane.showConfirmDialog(Forge.getLocalizer().getMessageorUseDefault("lblEndAdventureEventConfirm", "This will end the current event, and your entry fee will not be refunded.\n\nLeave anyway?", new Object[0]), Forge.getLocalizer().getMessage("lblLeaveDraft", new Object[0]), Forge.getLocalizer().getMessage("lblLeave", new Object[0]), Forge.getLocalizer().getMessage("lblCancel", new Object[0]), false, new Callback<Boolean>(){

                @Override
                public void run(Boolean result) {
                    if (result.booleanValue()) {
                        AdventureDeckEditor.currentEvent.eventStatus = AdventureEventController.EventStatus.Abandoned;
                        AdventurePlayer.current().getNewCards().clear();
                        Forge.clearCurrentScreen();
                        Forge.switchToLast();
                    }
                }
            });
        } else {
            AdventurePlayer.current().getNewCards().clear();
            Forge.clearCurrentScreen();
            Forge.switchToLast();
        }
    }

    @Override
    public void onActivate() {
        decksUsingMyCards = new ItemPool<InventoryItem>(InventoryItem.class);
        for (int i = 0; i < 10; ++i) {
            Deck deck = AdventurePlayer.current().getDeck(i);
            CardPool main = deck.getMain();
            for (Map.Entry e : main) {
                decksUsingMyCards.add((InventoryItem)e.getKey());
            }
            if (!deck.has(DeckSection.Sideboard)) continue;
            for (Map.Entry e : deck.get(DeckSection.Sideboard)) {
                if (main.contains((PaperCard)e.getKey())) continue;
                decksUsingMyCards.add((InventoryItem)e.getKey());
            }
        }
        lblGold.setText(String.valueOf(AdventurePlayer.current().getGold()));
    }

    public void refresh() {
        for (TabPageScreen.TabPage tabPage : this.tabPages) {
            ((DeckEditorPage)tabPage).initialize();
        }
        for (TabPageScreen.TabPage page : this.tabPages) {
            if (!(page instanceof CardManagerPage)) continue;
            ((CardManagerPage)page).refresh();
        }
    }

    private static DeckEditorPage[] getPages(boolean isShop) {
        if (isShop) {
            return new DeckEditorPage[]{new StoreCatalogPage()};
        }
        return new DeckEditorPage[]{new CollectionCatalogPage(), new DeckSectionPage(DeckSection.Main, ItemManagerConfig.QUEST_DECK_EDITOR), new DeckSectionPage(DeckSection.Sideboard, ItemManagerConfig.QUEST_DECK_EDITOR)};
    }

    private static DeckEditorPage[] getPages(AdventureEventData event) {
        if (event == null) {
            return AdventureDeckEditor.getPages(false);
        }
        if (event.format == AdventureEventController.EventFormat.Draft) {
            switch (event.eventStatus) {
                case Available: {
                    return null;
                }
                case Started: 
                case Completed: 
                case Abandoned: 
                case Ready: {
                    return new DeckEditorPage[]{new DeckSectionPage(DeckSection.Main, ItemManagerConfig.DRAFT_POOL), new DeckSectionPage(DeckSection.Sideboard, ItemManagerConfig.SIDEBOARD)};
                }
                case Entered: {
                    return new DeckEditorPage[]{event.getDraft() != null ? new DraftPackPage() : new CatalogPage(ItemManagerConfig.DRAFT_PACK, Forge.getLocalizer().getMessage("lblInventory", new Object[0]), CATALOG_ICON), new DeckSectionPage(DeckSection.Main, ItemManagerConfig.DRAFT_POOL), new DeckSectionPage(DeckSection.Sideboard, ItemManagerConfig.SIDEBOARD)};
                }
            }
            return new DeckEditorPage[]{new CatalogPage(ItemManagerConfig.QUEST_EDITOR_POOL, Forge.getLocalizer().getMessage("lblInventory", new Object[0]), CATALOG_ICON), new DeckSectionPage(DeckSection.Main, ItemManagerConfig.QUEST_DECK_EDITOR), new DeckSectionPage(DeckSection.Sideboard, ItemManagerConfig.SIDEBOARD)};
        }
        if (event.format == AdventureEventController.EventFormat.Jumpstart) {
            return new DeckEditorPage[]{new DeckSectionPage(DeckSection.Main, ItemManagerConfig.DRAFT_POOL), new DeckSectionPage(DeckSection.Sideboard, ItemManagerConfig.SIDEBOARD)};
        }
        return new DeckEditorPage[0];
    }

    private static DeckEditorPage[] getPages(Deck deckToPreview) {
        return new DeckEditorPage[]{new ContentPreviewPage(deckToPreview)};
    }

    public AdventureDeckEditor(boolean createAsShop) {
        super((FEvent e) -> AdventureDeckEditor.leave(), AdventureDeckEditor.getPages(createAsShop));
        this.isShop = createAsShop;
        this.doSetup();
    }

    public AdventureDeckEditor(AdventureEventData event) {
        super((FEvent e) -> AdventureDeckEditor.leave(), AdventureDeckEditor.getPages(event));
        currentEvent = event;
        this.doSetup();
    }

    public AdventureDeckEditor(Deck deckToPreview) {
        super((FEvent e) -> AdventureDeckEditor.leave(), AdventureDeckEditor.getPages(deckToPreview));
        this.doSetup();
    }

    public AdventureDeckEditor(boolean createAsShop, AdventureEventData event) {
        super((FEvent e) -> AdventureDeckEditor.leave(), event == null ? AdventureDeckEditor.getPages(createAsShop) : AdventureDeckEditor.getPages(event));
        this.doSetup();
    }

    private void doSetup() {
        for (TabPageScreen.TabPage tabPage : this.tabPages) {
            if (tabPage instanceof CatalogPage) {
                this.catalogPage = (CatalogPage)tabPage;
                continue;
            }
            if (!(tabPage instanceof DeckSectionPage)) continue;
            DeckSectionPage deckSectionPage = (DeckSectionPage)tabPage;
            switch (deckSectionPage.deckSection) {
                case Main: 
                case Schemes: 
                case Planes: {
                    mainDeckPage = deckSectionPage;
                    break;
                }
                case Sideboard: {
                    sideboardPage = deckSectionPage;
                    break;
                }
                case Commander: {
                    this.commanderPage = deckSectionPage;
                    break;
                }
            }
        }
        this.btnMoreOptions.setCommand(new FEvent.FEventHandler(){

            @Override
            public void handleEvent(FEvent e) {
                FPopupMenu menu = new FPopupMenu(){

                    @Override
                    protected void buildMenu() {
                        this.addItem(new FMenuItem(Forge.getLocalizer().getMessage("btnCopyToClipboard", new Object[0]), Forge.hdbuttons ? FSkinImage.HDEXPORT : FSkinImage.BLANK, e1 -> FDeckViewer.copyDeckToClipboard(AdventureDeckEditor.this.getDeck())));
                        if (AdventureDeckEditor.this.allowsAddBasic()) {
                            FMenuItem addBasic = new FMenuItem(Forge.getLocalizer().getMessage("lblAddBasicLands", new Object[0]), FSkinImage.LANDLOGO, e1 -> AdventureDeckEditor.this.launchBasicLandDialog());
                            this.addItem(addBasic);
                        }
                        if (!AdventureDeckEditor.this.isShop && AdventureDeckEditor.this.catalogPage != null && !(AdventureDeckEditor.this.catalogPage instanceof ContentPreviewPage)) {
                            if (((AdventureDeckEditor)AdventureDeckEditor.this).catalogPage.showNoSellCards) {
                                FMenuItem hideNoSell = new FMenuItem(Forge.getLocalizer().getMessage("lblHideNoSell", new Object[0]), Forge.hdbuttons ? FSkinImage.HDMINUS : FSkinImage.MINUS, e1 -> AdventureDeckEditor.this.catalogPage.toggleNoSellCards(false));
                                this.addItem(hideNoSell);
                                hideNoSell.setEnabled(((AdventureDeckEditor)AdventureDeckEditor.this).catalogPage.showAutoSellCards || ((AdventureDeckEditor)AdventureDeckEditor.this).catalogPage.showCollectionCards);
                            } else {
                                this.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblShowNoSell", new Object[0]), Forge.hdbuttons ? FSkinImage.HDPLUS : FSkinImage.PLUS, e1 -> AdventureDeckEditor.this.catalogPage.toggleNoSellCards(true)));
                            }
                            if (((AdventureDeckEditor)AdventureDeckEditor.this).catalogPage.showAutoSellCards) {
                                FMenuItem hideAutoSell = new FMenuItem(Forge.getLocalizer().getMessage("lblHideAutoSell", new Object[0]), Forge.hdbuttons ? FSkinImage.HDMINUS : FSkinImage.MINUS, e1 -> AdventureDeckEditor.this.catalogPage.toggleAutoSellCards(false));
                                this.addItem(hideAutoSell);
                                hideAutoSell.setEnabled(((AdventureDeckEditor)AdventureDeckEditor.this).catalogPage.showCollectionCards || ((AdventureDeckEditor)AdventureDeckEditor.this).catalogPage.showNoSellCards);
                            } else {
                                this.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblShowAutoSell", new Object[0]), Forge.hdbuttons ? FSkinImage.HDPLUS : FSkinImage.PLUS, e1 -> AdventureDeckEditor.this.catalogPage.toggleAutoSellCards(true)));
                            }
                            if (((AdventureDeckEditor)AdventureDeckEditor.this).catalogPage.showCollectionCards) {
                                FMenuItem hideCollection = new FMenuItem(Forge.getLocalizer().getMessage("lblHideCollection", new Object[0]), Forge.hdbuttons ? FSkinImage.HDMINUS : FSkinImage.MINUS, e1 -> AdventureDeckEditor.this.catalogPage.toggleCollectionCards(false));
                                this.addItem(hideCollection);
                                hideCollection.setEnabled(((AdventureDeckEditor)AdventureDeckEditor.this).catalogPage.showAutoSellCards || ((AdventureDeckEditor)AdventureDeckEditor.this).catalogPage.showNoSellCards);
                            } else {
                                this.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblShowCollection", new Object[0]), Forge.hdbuttons ? FSkinImage.HDPLUS : FSkinImage.PLUS, e1 -> AdventureDeckEditor.this.catalogPage.toggleCollectionCards(true)));
                            }
                            if (!(((AdventureDeckEditor)AdventureDeckEditor.this).catalogPage.showNoSellCards && ((AdventureDeckEditor)AdventureDeckEditor.this).catalogPage.showAutoSellCards && ((AdventureDeckEditor)AdventureDeckEditor.this).catalogPage.showCollectionCards)) {
                                this.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblShowAll", new Object[0]), Forge.hdbuttons ? FSkinImage.HDPLUS : FSkinImage.PLUS, e1 -> AdventureDeckEditor.this.catalogPage.showAllCards()));
                            }
                        }
                        ((DeckEditorPage)AdventureDeckEditor.this.getSelectedPage()).buildDeckMenu(this);
                    }
                };
                menu.show(AdventureDeckEditor.this.btnMoreOptions, 0.0f, AdventureDeckEditor.this.btnMoreOptions.getHeight());
            }
        });
    }

    protected void launchBasicLandDialog() {
        CardEdition defaultLandSet;
        HashSet<CardEdition> availableEditionCodes = new HashSet<CardEdition>();
        if (currentEvent != null) {
            for (PaperCard p : AdventureDeckEditor.currentEvent.registeredDeck.getAllCardsInASinglePool().toFlatList()) {
                availableEditionCodes.add(FModel.getMagicDb().getEditions().get(p.getEdition()));
            }
            defaultLandSet = CardEdition.Predicates.getRandomSetWithAllBasicLands(availableEditionCodes);
        } else {
            defaultLandSet = FModel.getMagicDb().getEditions().get("JMP");
        }
        if (defaultLandSet == null) {
            defaultLandSet = FModel.getMagicDb().getEditions().get("JMP");
        }
        ArrayList<CardEdition> unlockedEditions = new ArrayList<CardEdition>();
        unlockedEditions.add(defaultLandSet);
        AddBasicLandsDialog dialog = new AddBasicLandsDialog(this.getDeck(), defaultLandSet, new Callback<CardPool>(){

            @Override
            public void run(CardPool landsToAdd) {
                AdventureDeckEditor.getMainDeckPage().addCards(landsToAdd);
            }
        }, unlockedEditions);
        dialog.show();
        this.setSelectedPage(AdventureDeckEditor.getMainDeckPage());
    }

    protected boolean allowsAddBasic() {
        if (currentEvent == null) {
            return true;
        }
        if (!AdventureDeckEditor.currentEvent.eventRules.allowsAddBasicLands) {
            return false;
        }
        if (AdventureDeckEditor.currentEvent.eventStatus == AdventureEventController.EventStatus.Entered && AdventureDeckEditor.currentEvent.isDraftComplete) {
            return true;
        }
        return AdventureDeckEditor.currentEvent.eventStatus == AdventureEventController.EventStatus.Ready;
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        if (this.deckHeader.isVisible()) {
            this.deckHeader.setBounds(0.0f, startY, width, HEADER_HEIGHT);
            startY += HEADER_HEIGHT;
        }
        super.doLayout(startY, width, height);
    }

    public Deck getDeck() {
        if (currentEvent == null) {
            return AdventurePlayer.current().getSelectedDeck();
        }
        return AdventureDeckEditor.currentEvent.registeredDeck;
    }

    protected CatalogPage getCatalogPage() {
        return this.catalogPage;
    }

    protected static DeckSectionPage getMainDeckPage() {
        return mainDeckPage;
    }

    protected static DeckSectionPage getSideboardPage() {
        return sideboardPage;
    }

    protected DeckSectionPage getCommanderPage() {
        return this.commanderPage;
    }

    @Override
    public void onClose(Callback<Boolean> canCloseCallback) {
        String errorMessage = GameType.Adventure.getDeckFormat().getDeckConformanceProblem(this.getDeck());
        if (errorMessage != null) {
            FOptionPane.showErrorDialog(errorMessage);
        }
        if (currentEvent.getDraft() != null && !this.isShop) {
            if (AdventureDeckEditor.currentEvent.isDraftComplete || canCloseCallback == null) {
                super.onClose(canCloseCallback);
                return;
            }
            FOptionPane.showConfirmDialog(Forge.getLocalizer().getMessageorUseDefault("lblEndAdventureEventConfirm", "This will end the current event, and your entry fee will not be refunded.\n\nLeave anyway?", new Object[0]), Forge.getLocalizer().getMessage("lblLeaveDraft", new Object[0]), Forge.getLocalizer().getMessage("lblLeave", new Object[0]), Forge.getLocalizer().getMessage("lblCancel", new Object[0]), false, canCloseCallback);
        }
    }

    @Override
    public FScreen getLandscapeBackdropScreen() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean keyDown(int keyCode) {
        if (keyCode == 109) {
            return this.tabHeader.btnBack.trigger();
        }
        if (keyCode == 103) {
            if (this.getSelectedPage() instanceof CatalogPage) {
                ((CatalogPage)this.getSelectedPage()).cardManager.closeMenu();
            } else if (this.getSelectedPage() instanceof DeckSectionPage) {
                ((DeckSectionPage)this.getSelectedPage()).cardManager.closeMenu();
            }
            ++this.selected;
            if (this.selected > 2) {
                this.selected = 0;
            }
            this.setSelectedPage((TabPageScreen.TabPage)this.tabPages.get(this.selected));
            if (this.getSelectedPage() instanceof CatalogPage) {
                ((CatalogPage)this.getSelectedPage()).cardManager.getConfig().setPileBy(null);
                ((CatalogPage)this.getSelectedPage()).cardManager.setHideFilters(true);
                return true;
            } else {
                if (!(this.getSelectedPage() instanceof DeckSectionPage)) return true;
                ((DeckSectionPage)this.getSelectedPage()).cardManager.getConfig().setPileBy(null);
                ((DeckSectionPage)this.getSelectedPage()).cardManager.setHideFilters(true);
            }
            return true;
        } else if (keyCode == 22) {
            if (this.getSelectedPage() instanceof CatalogPage) {
                if (((CatalogPage)this.getSelectedPage()).cardManager.getConfig().getViewIndex() != 1) return true;
                ((CatalogPage)this.getSelectedPage()).setNextSelected();
                return true;
            } else {
                if (!(this.getSelectedPage() instanceof DeckSectionPage) || ((DeckSectionPage)this.getSelectedPage()).cardManager.getConfig().getViewIndex() != 1) return true;
                ((DeckSectionPage)this.getSelectedPage()).setNextSelected();
            }
            return true;
        } else if (keyCode == 21) {
            if (this.getSelectedPage() instanceof CatalogPage) {
                if (((CatalogPage)this.getSelectedPage()).cardManager.getConfig().getViewIndex() != 1) return true;
                ((CatalogPage)this.getSelectedPage()).setPreviousSelected();
                return true;
            } else {
                if (!(this.getSelectedPage() instanceof DeckSectionPage) || ((DeckSectionPage)this.getSelectedPage()).cardManager.getConfig().getViewIndex() != 1) return true;
                ((DeckSectionPage)this.getSelectedPage()).setPreviousSelected();
            }
            return true;
        } else if (keyCode == 20) {
            if (this.getSelectedPage() instanceof CatalogPage) {
                if (((CatalogPage)this.getSelectedPage()).cardManager.isContextMenuOpen()) {
                    ((CatalogPage)this.getSelectedPage()).cardManager.selectNextContext();
                    return true;
                } else if (((CatalogPage)this.getSelectedPage()).cardManager.getSelectedIndex() < 0) {
                    ((CatalogPage)this.getSelectedPage()).setNextSelected();
                    return true;
                } else if (((CatalogPage)this.getSelectedPage()).cardManager.getConfig().getViewIndex() == 1) {
                    ((CatalogPage)this.getSelectedPage()).setNextSelected(((CatalogPage)this.getSelectedPage()).cardManager.getConfig().getImageColumnCount());
                    return true;
                } else {
                    ((CatalogPage)this.getSelectedPage()).setNextSelected();
                }
                return true;
            } else {
                if (!(this.getSelectedPage() instanceof DeckSectionPage)) return true;
                if (((DeckSectionPage)this.getSelectedPage()).cardManager.isContextMenuOpen()) {
                    ((DeckSectionPage)this.getSelectedPage()).cardManager.selectNextContext();
                    return true;
                } else if (((DeckSectionPage)this.getSelectedPage()).cardManager.getSelectedIndex() < 0) {
                    ((DeckSectionPage)this.getSelectedPage()).setNextSelected();
                    return true;
                } else if (((DeckSectionPage)this.getSelectedPage()).cardManager.getConfig().getViewIndex() == 1) {
                    ((DeckSectionPage)this.getSelectedPage()).setNextSelected(((DeckSectionPage)this.getSelectedPage()).cardManager.getConfig().getImageColumnCount());
                    return true;
                } else {
                    ((DeckSectionPage)this.getSelectedPage()).setNextSelected();
                }
            }
            return true;
        } else if (keyCode == 19) {
            if (this.getSelectedPage() instanceof CatalogPage) {
                if (((CatalogPage)this.getSelectedPage()).cardManager.isContextMenuOpen()) {
                    ((CatalogPage)this.getSelectedPage()).cardManager.selectPreviousContext();
                    return true;
                } else if (((CatalogPage)this.getSelectedPage()).cardManager.getSelectedIndex() < 0) {
                    ((CatalogPage)this.getSelectedPage()).setNextSelected();
                    return true;
                } else if (((CatalogPage)this.getSelectedPage()).cardManager.getConfig().getViewIndex() == 1) {
                    ((CatalogPage)this.getSelectedPage()).setPreviousSelected(((CatalogPage)this.getSelectedPage()).cardManager.getConfig().getImageColumnCount());
                    return true;
                } else {
                    ((CatalogPage)this.getSelectedPage()).setPreviousSelected();
                }
                return true;
            } else {
                if (!(this.getSelectedPage() instanceof DeckSectionPage)) return true;
                if (((DeckSectionPage)this.getSelectedPage()).cardManager.isContextMenuOpen()) {
                    ((DeckSectionPage)this.getSelectedPage()).cardManager.selectPreviousContext();
                    return true;
                } else if (((DeckSectionPage)this.getSelectedPage()).cardManager.getSelectedIndex() < 0) {
                    ((DeckSectionPage)this.getSelectedPage()).setNextSelected();
                    return true;
                } else if (((DeckSectionPage)this.getSelectedPage()).cardManager.getConfig().getViewIndex() == 1) {
                    ((DeckSectionPage)this.getSelectedPage()).setPreviousSelected(((DeckSectionPage)this.getSelectedPage()).cardManager.getConfig().getImageColumnCount());
                    return true;
                } else {
                    ((DeckSectionPage)this.getSelectedPage()).setPreviousSelected();
                }
            }
            return true;
        } else if (keyCode == 96) {
            if (this.getSelectedPage() instanceof CatalogPage) {
                if (((CatalogPage)this.getSelectedPage()).cardManager.isContextMenuOpen()) {
                    ((CatalogPage)this.getSelectedPage()).cardManager.activateSelectedContext();
                    return true;
                } else {
                    ((CatalogPage)this.getSelectedPage()).cardManager.showMenu(true);
                }
                return true;
            } else {
                if (!(this.getSelectedPage() instanceof DeckSectionPage)) return true;
                if (((DeckSectionPage)this.getSelectedPage()).cardManager.isContextMenuOpen()) {
                    ((DeckSectionPage)this.getSelectedPage()).cardManager.activateSelectedContext();
                    return true;
                } else {
                    ((DeckSectionPage)this.getSelectedPage()).cardManager.showMenu(true);
                }
            }
            return true;
        } else if (keyCode == 97) {
            if (this.getSelectedPage() instanceof CatalogPage) {
                if (!((CatalogPage)this.getSelectedPage()).cardManager.isContextMenuOpen()) return this.tabHeader.btnBack.trigger();
                ((CatalogPage)this.getSelectedPage()).cardManager.closeMenu();
                return true;
            } else {
                if (!(this.getSelectedPage() instanceof DeckSectionPage)) return true;
                if (!((DeckSectionPage)this.getSelectedPage()).cardManager.isContextMenuOpen()) return this.tabHeader.btnBack.trigger();
                ((DeckSectionPage)this.getSelectedPage()).cardManager.closeMenu();
            }
            return true;
        } else if (keyCode == 100) {
            if (this.getSelectedPage() instanceof CatalogPage) {
                if (!((CatalogPage)this.getSelectedPage()).cardManager.isContextMenuOpen()) {
                    if (((CatalogPage)this.getSelectedPage()).cardManager.getCurrentView().getSelectionCount() <= 0) return true;
                    ((CatalogPage)this.getSelectedPage()).cardManager.getCurrentView().zoomSelected();
                    return true;
                } else {
                    ((CatalogPage)this.getSelectedPage()).cardManager.closeMenu();
                    if (((CatalogPage)this.getSelectedPage()).cardManager.getCurrentView().getSelectionCount() <= 0) return true;
                    ((CatalogPage)this.getSelectedPage()).cardManager.getCurrentView().zoomSelected();
                }
                return true;
            } else {
                if (!(this.getSelectedPage() instanceof DeckSectionPage)) return true;
                if (!((DeckSectionPage)this.getSelectedPage()).cardManager.isContextMenuOpen()) {
                    if (((DeckSectionPage)this.getSelectedPage()).cardManager.getCurrentView().getSelectionCount() <= 0) return true;
                    ((DeckSectionPage)this.getSelectedPage()).cardManager.getCurrentView().zoomSelected();
                    return true;
                } else {
                    ((DeckSectionPage)this.getSelectedPage()).cardManager.closeMenu();
                    if (((DeckSectionPage)this.getSelectedPage()).cardManager.getCurrentView().getSelectionCount() <= 0) return true;
                    ((DeckSectionPage)this.getSelectedPage()).cardManager.getCurrentView().zoomSelected();
                }
            }
            return true;
        } else {
            if (keyCode != 102) return true;
            if (this.getSelectedPage() instanceof CatalogPage) {
                ((CatalogPage)this.getSelectedPage()).cardManager.closeMenu();
                int index = ((CatalogPage)this.getSelectedPage()).cardManager.getConfig().getViewIndex() == 1 ? 0 : 1;
                ((CatalogPage)this.getSelectedPage()).cardManager.setViewIndex(index);
                return true;
            } else {
                if (!(this.getSelectedPage() instanceof DeckSectionPage)) return true;
                ((DeckSectionPage)this.getSelectedPage()).cardManager.closeMenu();
                int index = ((DeckSectionPage)this.getSelectedPage()).cardManager.getConfig().getViewIndex() == 1 ? 0 : 1;
                ((DeckSectionPage)this.getSelectedPage()).cardManager.setViewIndex(index);
            }
        }
        return true;
    }

    static {
        deckIcon = Config.instance().getFile("ui/maindeck.png");
        MAIN_DECK_ICON = deckIcon.exists() ? new FImage(){

            @Override
            public float getWidth() {
                return 100.0f;
            }

            @Override
            public float getHeight() {
                return 100.0f;
            }

            @Override
            public void draw(Graphics g2, float x, float y, float w, float h2) {
                g2.drawImage(Forge.getAssets().getTexture(deckIcon), x, y, w, h2);
            }
        } : (Forge.hdbuttons ? FSkinImage.HDLIBRARY : FSkinImage.DECKLIST);
        sideIcon = Config.instance().getFile("ui/sideboard.png");
        SIDEBOARD_ICON = sideIcon.exists() ? new FImage(){

            @Override
            public float getWidth() {
                return 100.0f;
            }

            @Override
            public float getHeight() {
                return 100.0f;
            }

            @Override
            public void draw(Graphics g2, float x, float y, float w, float h2) {
                g2.drawImage(Forge.getAssets().getTexture(sideIcon), x, y, w, h2);
            }
        } : (Forge.hdbuttons ? FSkinImage.HDSIDEBOARD : FSkinImage.FLASHBACK);
        HEADER_HEIGHT = Math.round(Utils.AVG_FINGER_HEIGHT * 0.8f);
        binderIcon = Config.instance().getFile("ui/binder.png");
        CATALOG_ICON = binderIcon.exists() ? new FImage(){

            @Override
            public float getWidth() {
                return 100.0f;
            }

            @Override
            public float getHeight() {
                return 100.0f;
            }

            @Override
            public void draw(Graphics g2, float x, float y, float w, float h2) {
                g2.drawImage(Forge.getAssets().getTexture(binderIcon), x, y, w, h2);
            }
        } : FSkinImage.QUEST_BOX;
        sellIcon = Config.instance().getFile("ui/sell.png");
        lblGold = new FLabel.Builder().text("0").icon(Forge.getAssets().getTexture(sellIcon) == null ? FSkinImage.QUEST_COINSTACK : new FImage(){

            @Override
            public float getWidth() {
                return 100.0f;
            }

            @Override
            public float getHeight() {
                return 100.0f;
            }

            @Override
            public void draw(Graphics g2, float x, float y, float w, float h2) {
                g2.drawImage(Forge.getAssets().getTexture(sellIcon), x, y, w, h2);
            }
        }).font(FSkinFont.get(16)).insets(new Vector2(Utils.scale(5.0f), 0.0f)).build();
        decksUsingMyCards = new ItemPool<InventoryItem>(InventoryItem.class);
    }

    protected static class DeckSectionPage
    extends CardManagerPage {
        private final String captionPrefix;
        private final DeckSection deckSection;

        private void setNextSelected() {
            this.setNextSelected(1);
        }

        private void setNextSelected(int val) {
            if (this.cardManager.getItemCount() < 1) {
                return;
            }
            if (this.cardManager.getSelectedIndex() + val < this.cardManager.getItemCount()) {
                this.cardManager.setSelectedIndex(this.cardManager.getSelectedIndex() + val);
            } else if (this.cardManager.getSelectedIndex() + 1 < this.cardManager.getItemCount()) {
                this.cardManager.setSelectedIndex(this.cardManager.getSelectedIndex() + 1);
            }
        }

        private void setPreviousSelected() {
            this.setPreviousSelected(1);
        }

        private void setPreviousSelected(int val) {
            if (this.cardManager.getItemCount() < 1) {
                return;
            }
            if (this.cardManager.getSelectedIndex() - val > -1) {
                this.cardManager.setSelectedIndex(this.cardManager.getSelectedIndex() - val);
            } else if (this.cardManager.getSelectedIndex() - 1 > -1) {
                this.cardManager.setSelectedIndex(this.cardManager.getSelectedIndex() - 1);
            }
        }

        protected DeckSectionPage(DeckSection deckSection0, ItemManagerConfig config) {
            super(config, null, null);
            this.deckSection = deckSection0;
            switch (this.deckSection) {
                default: {
                    this.captionPrefix = Forge.getLocalizer().getMessage("lblMain", new Object[0]);
                    this.cardManager.setCaption(Forge.getLocalizer().getMessage("ttMain", new Object[0]));
                    this.icon = MAIN_DECK_ICON;
                    break;
                }
                case Sideboard: {
                    this.captionPrefix = Forge.getLocalizer().getMessage("lblSide", new Object[0]);
                    this.cardManager.setCaption(Forge.getLocalizer().getMessage("lblSideboard", new Object[0]));
                    this.icon = SIDEBOARD_ICON;
                    break;
                }
                case Commander: {
                    this.captionPrefix = Forge.getLocalizer().getMessage("lblCommander", new Object[0]);
                    this.cardManager.setCaption(Forge.getLocalizer().getMessage("lblCommander", new Object[0]));
                    this.icon = FSkinImage.COMMANDER;
                }
            }
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.cardManager.setPool(((AdventureDeckEditor)this.parentScreen).getDeck().getOrCreate(this.deckSection));
            this.updateCaption();
        }

        @Override
        protected void updateCaption() {
            this.caption = this.deckSection == DeckSection.Commander ? this.captionPrefix : this.captionPrefix + " (" + ((AdventureDeckEditor)this.parentScreen).getDeck().get(this.deckSection).countAll() + ")";
        }

        @Override
        protected void onCardActivated(PaperCard card) {
            CatalogPage catalog = this.parentScreen == null ? null : ((AdventureDeckEditor)this.parentScreen).getCatalogPage();
            switch (this.deckSection) {
                case Main: 
                case Schemes: 
                case Planes: {
                    this.removeCard(card);
                    if (currentEvent == null || currentEvent.getDraft() == null) {
                        if (catalog == null) break;
                        catalog.addCard(card);
                        break;
                    }
                    if (AdventureDeckEditor.getSideboardPage() == null) break;
                    AdventureDeckEditor.getSideboardPage().addCard(card);
                    break;
                }
                case Sideboard: {
                    this.removeCard(card);
                    AdventureDeckEditor.getMainDeckPage().addCard(card);
                    break;
                }
            }
        }

        @Override
        protected void buildMenu(FDropDownMenu menu, final PaperCard card) {
            final CatalogPage catalog = this.parentScreen == null ? null : ((AdventureDeckEditor)this.parentScreen).getCatalogPage();
            switch (this.deckSection) {
                case Main: {
                    this.addItem(menu, Forge.getLocalizer().getMessage("lblAdd", new Object[0]), null, Forge.hdbuttons ? FSkinImage.HDPLUS : FSkinImage.PLUS, true, false, new Callback<Integer>(){

                        @Override
                        public void run(Integer result) {
                            if (result == null || result <= 0) {
                                return;
                            }
                            if (catalog != null) {
                                catalog.removeCard(card, result);
                                this.addCard(card, result);
                            }
                        }
                    });
                    if (currentEvent == null) {
                        this.addItem(menu, Forge.getLocalizer().getMessage("lblRemove", new Object[0]), null, Forge.hdbuttons ? FSkinImage.HDMINUS : FSkinImage.MINUS, false, false, new Callback<Integer>(){

                            @Override
                            public void run(Integer result) {
                                if (result == null || result <= 0) {
                                    return;
                                }
                                if (catalog != null) {
                                    this.removeCard(card, result);
                                    catalog.addCard(card, result);
                                }
                            }
                        });
                    }
                    if (AdventureDeckEditor.getSideboardPage() != null) {
                        this.addItem(menu, Forge.getLocalizer().getMessage("lblMove", new Object[0]), Forge.getLocalizer().getMessage("lbltosideboard", new Object[0]), AdventureDeckEditor.getSideboardPage().getIcon(), false, false, new Callback<Integer>(){

                            @Override
                            public void run(Integer result) {
                                if (result == null || result <= 0) {
                                    return;
                                }
                                this.removeCard(card, result);
                                AdventureDeckEditor.getSideboardPage().addCard(card, result);
                            }
                        });
                    }
                    this.addCommanderItems(menu, card, false, false);
                    break;
                }
                case Sideboard: {
                    this.addItem(menu, Forge.getLocalizer().getMessage("lblAdd", new Object[0]), null, Forge.hdbuttons ? FSkinImage.HDPLUS : FSkinImage.PLUS, true, false, new Callback<Integer>(){

                        @Override
                        public void run(Integer result) {
                            if (result == null || result <= 0) {
                                return;
                            }
                            if (catalog != null) {
                                catalog.removeCard(card, result);
                                this.addCard(card, result);
                            }
                        }
                    });
                    if (currentEvent == null) {
                        this.addItem(menu, Forge.getLocalizer().getMessage("lblRemove", new Object[0]), null, Forge.hdbuttons ? FSkinImage.HDMINUS : FSkinImage.MINUS, false, false, new Callback<Integer>(){

                            @Override
                            public void run(Integer result) {
                                if (result == null || result <= 0) {
                                    return;
                                }
                                if (catalog != null) {
                                    this.removeCard(card, result);
                                    catalog.addCard(card, result);
                                }
                            }
                        });
                    }
                    this.addItem(menu, Forge.getLocalizer().getMessage("lblMove", new Object[0]), Forge.getLocalizer().getMessage("lblToMainDeck", new Object[0]), AdventureDeckEditor.getMainDeckPage().getIcon(), false, false, new Callback<Integer>(){

                        @Override
                        public void run(Integer result) {
                            if (result == null || result <= 0) {
                                return;
                            }
                            this.removeCard(card, result);
                            AdventureDeckEditor.getMainDeckPage().addCard(card, result);
                        }
                    });
                    this.addCommanderItems(menu, card, false, false);
                    break;
                }
                case Commander: {
                    if (!this.isPartnerCommander(card)) break;
                    this.addItem(menu, Forge.getLocalizer().getMessage("lblRemove", new Object[0]), null, Forge.hdbuttons ? FSkinImage.HDMINUS : FSkinImage.MINUS, false, false, new Callback<Integer>(){

                        @Override
                        public void run(Integer result) {
                            if (result == null || result <= 0) {
                                return;
                            }
                            if (catalog != null) {
                                this.removeCard(card, result);
                                catalog.refresh();
                                if (parentScreen != null) {
                                    ((AdventureDeckEditor)parentScreen).setSelectedPage(catalog);
                                }
                            }
                        }
                    });
                    break;
                }
            }
        }

        public void addCards(Iterable<Map.Entry<PaperCard, Integer>> cards) {
            if (this.canAddCards()) {
                this.cardManager.addItems(cards);
                this.updateCaption();
            }
        }

        private boolean isPartnerCommander(PaperCard card) {
            if (((AdventureDeckEditor)this.parentScreen).getCommanderPage() == null || ((AdventureDeckEditor)this.parentScreen).getDeck().getCommanders().isEmpty()) {
                return false;
            }
            PaperCard firstCmdr = ((AdventureDeckEditor)this.parentScreen).getDeck().getCommanders().get(0);
            return !card.getName().equals(firstCmdr.getName());
        }
    }

    protected static class CatalogPage
    extends CardManagerPage {
        private boolean initialized;
        private boolean needRefreshWhenShown;
        boolean showCollectionCards = true;
        boolean showAutoSellCards = false;
        boolean showNoSellCards = true;

        public void showAllCards() {
            this.showCollectionCards = true;
            this.showAutoSellCards = true;
            this.showNoSellCards = true;
            this.refresh();
        }

        public void toggleCollectionCards(boolean show) {
            this.showCollectionCards = show;
            this.refresh();
        }

        public void toggleAutoSellCards(boolean show) {
            this.showAutoSellCards = show;
            this.refresh();
        }

        public void toggleNoSellCards(boolean show) {
            this.showNoSellCards = show;
            this.refresh();
        }

        protected CatalogPage(ItemManagerConfig config, String caption0, FImage icon0) {
            super(config, caption0, icon0);
            this.refresh();
        }

        private void setNextSelected() {
            this.setNextSelected(1);
        }

        private void setNextSelected(int val) {
            if (this.cardManager.getItemCount() < 1) {
                return;
            }
            if (this.cardManager.getSelectedIndex() + val < this.cardManager.getItemCount()) {
                this.cardManager.setSelectedIndex(this.cardManager.getSelectedIndex() + val);
            } else if (this.cardManager.getSelectedIndex() + 1 < this.cardManager.getItemCount()) {
                this.cardManager.setSelectedIndex(this.cardManager.getSelectedIndex() + 1);
            }
        }

        private void setPreviousSelected() {
            this.setPreviousSelected(1);
        }

        private void setPreviousSelected(int val) {
            if (this.cardManager.getItemCount() < 1) {
                return;
            }
            if (this.cardManager.getSelectedIndex() - val > -1) {
                this.cardManager.setSelectedIndex(this.cardManager.getSelectedIndex() - val);
            } else if (this.cardManager.getSelectedIndex() - 1 > -1) {
                this.cardManager.setSelectedIndex(this.cardManager.getSelectedIndex() - 1);
            }
        }

        @Override
        protected void initialize() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            super.initialize();
            this.cardManager.setCaption(this.getItemManagerCaption());
            if (!this.isVisible()) {
                this.needRefreshWhenShown = true;
            }
        }

        @Override
        protected boolean canAddCards() {
            if (this.needRefreshWhenShown) {
                this.needRefreshWhenShown = false;
                this.refresh();
            }
            return !this.cardManager.isInfinite();
        }

        protected String getItemManagerCaption() {
            return Forge.getLocalizer().getMessage("lblCards", new Object[0]);
        }

        @Override
        public void setVisible(boolean visible0) {
            if (this.isVisible() == visible0) {
                return;
            }
            super.setVisible(visible0);
            if (visible0 && this.needRefreshWhenShown) {
                this.needRefreshWhenShown = false;
                this.refresh();
            }
        }

        @Override
        public void refresh() {
            ItemPool<PaperCard> adventurePool = new ItemPool<PaperCard>(PaperCard.class);
            ItemPool<PaperCard> cardsInUse = new ItemPool<PaperCard>(PaperCard.class);
            cardsInUse.addAll(AdventurePlayer.current().getSelectedDeck().getMain());
            cardsInUse.addAll(AdventurePlayer.current().getSelectedDeck().getOrCreate(DeckSection.Sideboard));
            if (this.showCollectionCards) {
                adventurePool.addAll(AdventurePlayer.current().getCollectionCards(false));
            }
            if (this.showNoSellCards) {
                adventurePool.addAll(AdventurePlayer.current().getNoSellCards());
                adventurePool.removeAll(cardsInUse);
            } else {
                cardsInUse.removeAll(AdventurePlayer.current().getNoSellCards());
                adventurePool.removeAll(cardsInUse);
            }
            if (this.showAutoSellCards) {
                adventurePool.addAll(AdventurePlayer.current().getAutoSellCards());
            }
            this.cardManager.setPool(adventurePool);
        }

        @Override
        protected void onCardActivated(PaperCard card) {
            if (this.getMaxMoveQuantity(true, true) == 0) {
                return;
            }
            if (this.needsCommander()) {
                this.setCommander(card);
                return;
            }
            if (this.canOnlyBePartnerCommander(card)) {
                return;
            }
            DeckSectionPage main = AdventureDeckEditor.getMainDeckPage();
            if (main == null) {
                return;
            }
            if (!this.cardManager.isInfinite()) {
                this.removeCard(card);
            }
            main.addCard(card);
        }

        @Override
        protected void buildMenu(FDropDownMenu menu, final PaperCard card) {
            if (!(this.needsCommander() || this.canOnlyBePartnerCommander(card) || ((AdventureDeckEditor)this.parentScreen).isShop)) {
                this.addItem(menu, Forge.getLocalizer().getMessage("lblAdd", new Object[0]), Forge.getLocalizer().getMessage("lblTo", new Object[0]) + " " + AdventureDeckEditor.getMainDeckPage().cardManager.getCaption(), AdventureDeckEditor.getMainDeckPage().getIcon(), true, true, new Callback<Integer>(){

                    @Override
                    public void run(Integer result) {
                        if (result == null || result <= 0) {
                            return;
                        }
                        if (!cardManager.isInfinite()) {
                            this.removeCard(card, result);
                        }
                        AdventureDeckEditor.getMainDeckPage().addCard(card, result);
                    }
                });
                if (AdventureDeckEditor.getSideboardPage() != null) {
                    this.addItem(menu, Forge.getLocalizer().getMessage("lblAdd", new Object[0]), Forge.getLocalizer().getMessage("lbltosideboard", new Object[0]), AdventureDeckEditor.getSideboardPage().getIcon(), true, true, new Callback<Integer>(){

                        @Override
                        public void run(Integer result) {
                            if (result == null || result <= 0) {
                                return;
                            }
                            if (!cardManager.isInfinite()) {
                                this.removeCard(card, result);
                            }
                            AdventureDeckEditor.getSideboardPage().addCard(card, result);
                        }
                    });
                }
            }
            this.addCommanderItems(menu, card, true, true);
        }

        @Override
        protected void buildDeckMenu(FPopupMenu menu) {
            if (this.cardManager.getConfig().getShowUniqueCardsOption()) {
                menu.addItem(new FCheckBoxMenuItem(Forge.getLocalizer().getMessage("lblUniqueCardsOnly", new Object[0]), this.cardManager.getWantUnique(), e -> {
                    boolean wantUnique = !this.cardManager.getWantUnique();
                    this.cardManager.setWantUnique(wantUnique);
                    this.refresh();
                    this.cardManager.getConfig().setUniqueCardsOnly(wantUnique);
                }));
            }
        }
    }

    protected static abstract class CardManagerPage
    extends DeckEditorPage {
        private final ItemManagerConfig config;
        protected final CardManager cardManager = this.add(new CardManager(false));
        private final Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> fnNewCompare = from -> AdventurePlayer.current().getNewCards().contains((PaperCard)from.getKey()) ? Integer.valueOf(1) : Integer.valueOf(0);
        private final Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnNewGet = from -> AdventurePlayer.current().getNewCards().contains((PaperCard)from.getKey()) ? "NEW" : "";
        public static final Function<Map.Entry<InventoryItem, Integer>, Comparable<?>> fnDeckCompare = from -> Integer.valueOf(decksUsingMyCards.count((InventoryItem)from.getKey()));
        public static final Function<Map.Entry<? extends InventoryItem, Integer>, Object> fnDeckGet = from -> Integer.valueOf(decksUsingMyCards.count((InventoryItem)from.getKey())).toString();

        protected CardManagerPage(ItemManagerConfig config0, String caption0, FImage icon0) {
            super(caption0, icon0);
            this.config = config0;
            this.cardManager.setItemActivateHandler(e -> this.onCardActivated((PaperCard)this.cardManager.getSelectedItem()));
            this.cardManager.setContextMenuBuilder(new ItemManager.ContextMenuBuilder<PaperCard>(){

                @Override
                public void buildMenu(FDropDownMenu menu, PaperCard card) {
                    this.buildMenu(menu, card);
                }
            });
        }

        @Override
        protected void initialize() {
            HashMap<ColumnDef, ItemColumn> colOverrides = new HashMap<ColumnDef, ItemColumn>();
            ItemColumn.addColOverride(this.config, colOverrides, ColumnDef.NEW, this.fnNewCompare, this.fnNewGet);
            ItemColumn.addColOverride(this.config, colOverrides, ColumnDef.DECKS, fnDeckCompare, fnDeckGet);
            this.cardManager.setup(this.config, colOverrides);
        }

        protected boolean canAddCards() {
            return true;
        }

        public void addCard(PaperCard card) {
            this.addCard(card, 1);
        }

        public void addCard(PaperCard card, int qty) {
            if (this.canAddCards()) {
                this.cardManager.addItem(card, qty);
                this.updateCaption();
            }
        }

        public void removeCard(PaperCard card) {
            this.removeCard(card, 1);
        }

        public void removeCard(PaperCard card, int qty) {
            this.cardManager.removeItem(card, qty);
            this.updateCaption();
        }

        public void setCards(CardPool cards) {
            this.cardManager.setItems(cards);
            this.updateCaption();
        }

        protected void updateCaption() {
        }

        protected abstract void onCardActivated(PaperCard var1);

        protected abstract void buildMenu(FDropDownMenu var1, PaperCard var2);

        private ItemPool<PaperCard> getAllowedAdditions(Iterable<Map.Entry<PaperCard, Integer>> itemsToAdd, boolean isAddSource) {
            ItemPool<PaperCard> additions = new ItemPool<PaperCard>(this.cardManager.getGenericType());
            Deck deck = ((AdventureDeckEditor)this.parentScreen).getDeck();
            for (Map.Entry<PaperCard, Integer> itemEntry : itemsToAdd) {
                int qty;
                int max;
                PaperCard card = itemEntry.getKey();
                if (deck == null || card == null) {
                    max = Integer.MAX_VALUE;
                } else if (DeckFormat.canHaveAnyNumberOf(card)) {
                    max = Integer.MAX_VALUE;
                } else {
                    max = FModel.getPreferences().getPrefInt(ForgePreferences.FPref.DECK_DEFAULT_CARD_LIMIT);
                    Integer cardCopies = DeckFormat.canHaveSpecificNumberInDeck(card);
                    if (cardCopies != null) {
                        max = cardCopies;
                    }
                    max -= deck.getAllCardsInASinglePool().countAll(paperCard -> paperCard.getCardName().equals(card.getCardName()));
                }
                if (isAddSource) {
                    qty = itemEntry.getValue();
                } else {
                    try {
                        qty = ((AdventureDeckEditor)this.parentScreen).getCatalogPage().cardManager.getItemCount(card);
                    }
                    catch (Exception e) {
                        qty = 0;
                    }
                }
                if (qty > max) {
                    qty = max;
                }
                if (qty <= 0) continue;
                additions.add(card, qty);
            }
            return additions;
        }

        protected int getMaxMoveQuantity(boolean isAddMenu, boolean isAddSource) {
            ItemPool<PaperCard> selectedItemPool = this.cardManager.getSelectedItemPool();
            if (isAddMenu) {
                selectedItemPool = this.getAllowedAdditions(selectedItemPool, isAddSource);
            }
            if (selectedItemPool.isEmpty()) {
                return 0;
            }
            int max = Integer.MAX_VALUE;
            for (Map.Entry<PaperCard, Integer> entry : selectedItemPool) {
                if (entry.getValue() >= max) continue;
                max = entry.getValue();
            }
            return max;
        }

        protected void addItem(FDropDownMenu menu, String verb, String dest, FImage icon, boolean isAddMenu, boolean isAddSource, Callback<Integer> callback) {
            int max = this.getMaxMoveQuantity(isAddMenu, isAddSource);
            if (max == 0) {
                return;
            }
            String label = verb;
            if (!StringUtils.isEmpty(dest)) {
                label = label + " " + dest;
            }
            menu.addItem(new FMenuItem(label, icon, e -> {
                if (max == 1) {
                    callback.run(max);
                } else {
                    GuiChoose.getInteger(this.cardManager.getSelectedItem() + " - " + verb + " " + Forge.getLocalizer().getMessage("lblHowMany", new Object[0]), 1, max, 20, callback);
                }
            }));
        }

        protected void addCommanderItems(FDropDownMenu menu, final PaperCard card, boolean isAddMenu, boolean isAddSource) {
            if (((AdventureDeckEditor)this.parentScreen).getCommanderPage() == null || card == null) {
                return;
            }
            String captionSuffix = Forge.getLocalizer().getMessage("lblCommander", new Object[0]);
            boolean isLegalCommander = DeckFormat.Commander.isLegalCommander(card.getRules());
            if (isLegalCommander && !((AdventureDeckEditor)this.parentScreen).getCommanderPage().cardManager.getPool().contains(card)) {
                this.addItem(menu, "Set", "as " + captionSuffix, ((AdventureDeckEditor)this.parentScreen).getCommanderPage().getIcon(), isAddMenu, isAddSource, new Callback<Integer>(){

                    @Override
                    public void run(Integer result) {
                        if (result == null || result <= 0) {
                            return;
                        }
                        this.setCommander(card);
                    }
                });
            }
            if (this.canHavePartnerCommander() && card.getRules().canBePartnerCommander()) {
                this.addItem(menu, "Set", "as Partner " + captionSuffix, ((AdventureDeckEditor)this.parentScreen).getCommanderPage().getIcon(), isAddMenu, isAddSource, new Callback<Integer>(){

                    @Override
                    public void run(Integer result) {
                        if (result == null || result <= 0) {
                            return;
                        }
                        this.setPartnerCommander(card);
                    }
                });
            }
            if (this.canHaveSignatureSpell() && card.getRules().canBeSignatureSpell()) {
                this.addItem(menu, "Set", "as Signature Spell", FSkinImage.SORCERY, isAddMenu, isAddSource, new Callback<Integer>(){

                    @Override
                    public void run(Integer result) {
                        if (result == null || result <= 0) {
                            return;
                        }
                        this.setSignatureSpell(card);
                    }
                });
            }
        }

        protected boolean needsCommander() {
            return ((AdventureDeckEditor)this.parentScreen).getCommanderPage() != null && ((AdventureDeckEditor)this.parentScreen).getDeck().getCommanders().isEmpty();
        }

        protected boolean canHavePartnerCommander() {
            return ((AdventureDeckEditor)this.parentScreen).getCommanderPage() != null && ((AdventureDeckEditor)this.parentScreen).getDeck().getCommanders().size() == 1 && ((AdventureDeckEditor)this.parentScreen).getDeck().getCommanders().get(0).getRules().canBePartnerCommander();
        }

        protected boolean canOnlyBePartnerCommander(PaperCard card) {
            if (((AdventureDeckEditor)this.parentScreen).getCommanderPage() == null) {
                return false;
            }
            int cmdCI = 0;
            for (PaperCard p : ((AdventureDeckEditor)this.parentScreen).getDeck().getCommanders()) {
                cmdCI = (byte)(cmdCI | p.getRules().getColorIdentity().getColor());
            }
            return !card.getRules().getColorIdentity().hasNoColorsExcept(cmdCI);
        }

        protected boolean canHaveSignatureSpell() {
            return ((AdventureDeckEditor)this.parentScreen).getDeck().getOathbreaker() != null;
        }

        protected void setCommander(PaperCard card) {
            if (!this.cardManager.isInfinite()) {
                this.removeCard(card);
            }
            CardPool newPool = new CardPool();
            newPool.add(card);
            ((AdventureDeckEditor)this.parentScreen).getCommanderPage().setCards(newPool);
            this.refresh();
        }

        protected void setPartnerCommander(PaperCard card) {
            if (!this.cardManager.isInfinite()) {
                this.removeCard(card);
            }
            ((AdventureDeckEditor)this.parentScreen).getCommanderPage().addCard(card);
            this.refresh();
        }

        protected void setSignatureSpell(PaperCard card) {
            PaperCard signatureSpell;
            if (!this.cardManager.isInfinite()) {
                this.removeCard(card);
            }
            if ((signatureSpell = ((AdventureDeckEditor)this.parentScreen).getDeck().getSignatureSpell()) != null) {
                ((AdventureDeckEditor)this.parentScreen).getCommanderPage().removeCard(signatureSpell);
            }
            ((AdventureDeckEditor)this.parentScreen).getCommanderPage().addCard(card);
        }

        public void refresh() {
        }

        @Override
        protected void doLayout(float width, float height) {
            float x = 0.0f;
            if (Forge.isLandscapeMode()) {
                x = ItemFilter.PADDING;
                width -= 2.0f * x;
            }
            this.cardManager.setBounds(x, 0.0f, width, height);
        }
    }

    protected static abstract class DeckEditorPage
    extends TabPageScreen.TabPage<AdventureDeckEditor> {
        protected DeckEditorPage(String caption0, FImage icon0) {
            super(caption0, icon0);
        }

        protected void buildDeckMenu(FPopupMenu menu) {
        }

        protected abstract void initialize();

        @Override
        public boolean fling(float velocityX, float velocityY) {
            return false;
        }
    }

    protected class DeckHeader
    extends FContainer {
        boolean init;

        private DeckHeader() {
            this.setHeight(HEADER_HEIGHT);
        }

        @Override
        public void drawBackground(Graphics g2) {
            g2.fillRect(FScreen.Header.getBackColor(), 0.0f, 0.0f, this.getWidth(), HEADER_HEIGHT);
        }

        @Override
        public void drawOverlay(Graphics g2) {
            float y = HEADER_HEIGHT - FScreen.Header.LINE_THICKNESS / 2.0f;
            g2.drawLine(FScreen.Header.LINE_THICKNESS, FScreen.Header.getLineColor(), 0.0f, y, this.getWidth(), y);
        }

        @Override
        protected void doLayout(float width, float height) {
            float x = 0.0f;
            AdventureDeckEditor.this.lblName.setBounds(0.0f, 0.0f, width - 2.0f * height, height);
            x += AdventureDeckEditor.this.lblName.getWidth();
            AdventureDeckEditor.this.btnMoreOptions.setBounds(x += height, 0.0f, height, height);
            if (!this.init) {
                this.add(lblGold);
                this.init = true;
            }
            lblGold.setBounds(0.0f, 0.0f, width, height);
        }
    }

    private static class CollectionCatalogPage
    extends CatalogPage {
        protected CollectionCatalogPage() {
            super(ItemManagerConfig.QUEST_EDITOR_POOL, Forge.getLocalizer().getMessage("lblInventory", new Object[0]), CATALOG_ICON);
        }

        @Override
        protected void buildMenu(FDropDownMenu menu, final PaperCard card) {
            this.addItem(menu, Forge.getLocalizer().getMessage("lblAdd", new Object[0]), Forge.getLocalizer().getMessage("lblTo", new Object[0]) + " " + AdventureDeckEditor.getMainDeckPage().cardManager.getCaption(), AdventureDeckEditor.getMainDeckPage().getIcon(), true, true, new Callback<Integer>(){

                @Override
                public void run(Integer result) {
                    if (result == null || result <= 0) {
                        return;
                    }
                    if (!cardManager.isInfinite()) {
                        this.removeCard(card, result);
                    }
                    if (Current.player().autoSellCards.contains(card)) {
                        Current.player().autoSellCards.remove(card);
                    }
                    AdventureDeckEditor.getMainDeckPage().addCard(card, result);
                }
            });
            if (AdventureDeckEditor.getSideboardPage() != null) {
                this.addItem(menu, Forge.getLocalizer().getMessage("lblAdd", new Object[0]), Forge.getLocalizer().getMessage("lbltosideboard", new Object[0]), AdventureDeckEditor.getSideboardPage().getIcon(), true, true, new Callback<Integer>(){

                    @Override
                    public void run(Integer result) {
                        if (result == null || result <= 0) {
                            return;
                        }
                        if (!cardManager.isInfinite()) {
                            this.removeCard(card, result);
                        }
                        if (Current.player().autoSellCards.contains(card)) {
                            Current.player().autoSellCards.remove(card);
                        }
                        AdventureDeckEditor.getSideboardPage().addCard(card, result);
                    }
                });
            }
            int noSellCount = Current.player().noSellCards.count(card);
            int autoSellCount = Current.player().autoSellCards.count(card);
            int sellableCount = Current.player().getSellableCards().count(card);
            if (noSellCount > 0) {
                FMenuItem unsellableCount = new FMenuItem(Forge.getLocalizer().getMessage("lblUnsellableCount", noSellCount), null, null);
                unsellableCount.setEnabled(false);
                menu.addItem(unsellableCount);
            }
            if (sellableCount > 0) {
                FMenuItem moveToAutosell = new FMenuItem(Forge.getLocalizer().getMessage("lbltoSell", autoSellCount, sellableCount), Forge.hdbuttons ? FSkinImage.HDMINUS : FSkinImage.MINUS, e1 -> Current.player().autoSellCards.add(card));
                moveToAutosell.setEnabled(sellableCount - autoSellCount > 0);
                menu.addItem(moveToAutosell);
                FMenuItem moveToCatalog = new FMenuItem(Forge.getLocalizer().getMessage("lbltoInventory", autoSellCount, sellableCount), Forge.hdbuttons ? FSkinImage.HDPLUS : FSkinImage.PLUS, e1 -> Current.player().autoSellCards.remove(card));
                moveToCatalog.setEnabled(autoSellCount > 0);
                menu.addItem(moveToCatalog);
            }
        }

        @Override
        public void refresh() {
            ItemPool<PaperCard> collectionPool = new ItemPool<PaperCard>(PaperCard.class);
            ItemPool<PaperCard> cardsInUse = new ItemPool<PaperCard>(PaperCard.class);
            cardsInUse.addAllFlat(AdventurePlayer.current().getSelectedDeck().getAllCardsInASinglePool().toFlatList());
            if (this.showCollectionCards) {
                collectionPool.addAllFlat(AdventurePlayer.current().getCollectionCards(false).toFlatList());
            }
            if (this.showNoSellCards) {
                collectionPool.addAllFlat(AdventurePlayer.current().getNoSellCards().toFlatList());
                collectionPool.removeAllFlat(cardsInUse.toFlatList());
            } else {
                cardsInUse.removeAllFlat(AdventurePlayer.current().getNoSellCards().toFlatList());
                collectionPool.removeAllFlat(cardsInUse.toFlatList());
            }
            if (this.showAutoSellCards) {
                collectionPool.addAllFlat(AdventurePlayer.current().getAutoSellCards().toFlatList());
            }
            this.cardManager.setPool(collectionPool);
        }
    }

    private static class StoreCatalogPage
    extends CatalogPage {
        protected StoreCatalogPage() {
            super(ItemManagerConfig.QUEST_EDITOR_POOL, Forge.getLocalizer().getMessage("lblInventory", new Object[0]), CATALOG_ICON);
            Current.player().onGoldChange(() -> lblGold.setText(String.valueOf(AdventurePlayer.current().getGold())));
        }

        @Override
        protected void buildMenu(FDropDownMenu menu, final PaperCard card) {
            this.addItem(menu, Forge.getLocalizer().getMessage("lblSellFor", new Object[0]), String.valueOf(AdventurePlayer.current().cardSellPrice(card)), SIDEBOARD_ICON, false, true, new Callback<Integer>(){

                @Override
                public void run(Integer result) {
                    if (result == null || result <= 0) {
                        return;
                    }
                    if (!cardManager.isInfinite()) {
                        this.removeCard(card, result);
                    }
                    AdventurePlayer.current().sellCard(card, result);
                    lblGold.setText(String.valueOf(AdventurePlayer.current().getGold()));
                }
            });
        }

        @Override
        protected void onCardActivated(PaperCard card) {
            CardZoom.show(card);
        }

        @Override
        public void refresh() {
            this.cardManager.setPool(AdventurePlayer.current().getSellableCards());
        }
    }

    private static class DraftPackPage
    extends CatalogPage {
        protected DraftPackPage() {
            super(ItemManagerConfig.DRAFT_PACK, Forge.getLocalizer().getMessage("lblPackN", String.valueOf(1)), FSkinImage.PACK);
        }

        @Override
        public void refresh() {
            BoosterDraft draft = AdventureDeckEditor.getDraft();
            if (draft == null || !draft.hasNextChoice()) {
                return;
            }
            CardPool pool = draft.nextChoice();
            if (pool == null || pool.isEmpty()) {
                return;
            }
            int packNumber = draft.getCurrentBoosterIndex() + 1;
            this.caption = Forge.getLocalizer().getMessage("lblPackN", String.valueOf(packNumber));
            this.cardManager.setPool(pool);
            this.cardManager.setShowRanking(true);
        }

        @Override
        protected void onCardActivated(PaperCard card) {
            super.onCardActivated(card);
            this.afterCardPicked(card);
        }

        @Override
        protected int getMaxMoveQuantity(boolean isAddMenu, boolean isAddSource) {
            return 1;
        }

        private void afterCardPicked(PaperCard card) {
            BoosterDraft draft = AdventureDeckEditor.getDraft();
            assert (draft != null);
            draft.setChoice(card);
            if (draft.hasNextChoice()) {
                this.refresh();
            } else {
                this.hideTab();
                ((AdventureDeckEditor)this.parentScreen).completeDraft();
            }
        }

        @Override
        protected void buildMenu(FDropDownMenu menu, final PaperCard card) {
            this.addItem(menu, Forge.getLocalizer().getMessage("lblAdd", new Object[0]), Forge.getLocalizer().getMessage("lblToMainDeck", new Object[0]), AdventureDeckEditor.getMainDeckPage().getIcon(), true, true, new Callback<Integer>(){

                @Override
                public void run(Integer result) {
                    mainDeckPage.addCard(card);
                    this.afterCardPicked(card);
                }
            });
            this.addItem(menu, Forge.getLocalizer().getMessage("lblAdd", new Object[0]), Forge.getLocalizer().getMessage("lbltosideboard", new Object[0]), AdventureDeckEditor.getSideboardPage().getIcon(), true, true, new Callback<Integer>(){

                @Override
                public void run(Integer result) {
                    AdventureDeckEditor.getSideboardPage().addCard(card);
                    this.afterCardPicked(card);
                }
            });
        }
    }

    private static class ContentPreviewPage
    extends CatalogPage {
        Deck contents = new Deck();

        protected ContentPreviewPage(Deck cardsToShow) {
            super(ItemManagerConfig.QUEST_EDITOR_POOL, Forge.getLocalizer().getMessage("lblInventory", new Object[0]), CATALOG_ICON);
            this.contents = cardsToShow;
        }

        @Override
        protected void buildMenu(FDropDownMenu menu, PaperCard card) {
        }

        @Override
        public void refresh() {
            if (this.contents != null) {
                this.cardManager.setPool(this.contents.getAllCardsInASinglePool());
            }
        }
    }
}

