/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.pointofintrest;

import forge.adventure.util.Current;
import forge.adventure.util.SaveFileContent;
import forge.adventure.util.SaveFileData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;

public class PointOfInterestChanges
implements SaveFileContent {
    private final HashSet<Integer> deletedObjects = new HashSet();
    private final HashMap<Integer, HashSet<Integer>> cardsBought = new HashMap();
    private final java.util.Map<String, Byte> mapFlags = new HashMap<String, Byte>();
    private final java.util.Map<Integer, Long> shopSeeds = new HashMap<Integer, Long>();
    private final java.util.Map<Integer, Integer> reputation = new HashMap<Integer, Integer>();
    private Boolean isBookmarked;
    int maxRepToApply = 20;
    float priceModifierPerRep = 0.005f;

    @Override
    public void load(SaveFileData data) {
        this.deletedObjects.clear();
        this.deletedObjects.addAll((HashSet)data.readObject("deletedObjects"));
        this.cardsBought.clear();
        this.cardsBought.putAll((HashMap)data.readObject("cardsBought"));
        this.shopSeeds.clear();
        this.shopSeeds.putAll((java.util.Map)data.readObject("shopSeeds"));
        this.mapFlags.clear();
        this.mapFlags.putAll((java.util.Map)data.readObject("mapFlags"));
        this.reputation.clear();
        if (data.containsKey("reputation")) {
            this.reputation.putAll((java.util.Map)data.readObject("reputation"));
        }
        this.isBookmarked = (Boolean)data.readObject("isBookmarked");
    }

    @Override
    public SaveFileData save() {
        SaveFileData data = new SaveFileData();
        data.storeObject("deletedObjects", this.deletedObjects);
        data.storeObject("cardsBought", this.cardsBought);
        data.storeObject("mapFlags", this.mapFlags);
        data.storeObject("shopSeeds", this.shopSeeds);
        data.storeObject("reputation", this.reputation);
        data.storeObject("isBookmarked", this.isBookmarked);
        return data;
    }

    public boolean isObjectDeleted(int objectID) {
        return this.deletedObjects.contains(objectID);
    }

    public boolean deleteObject(int objectID) {
        return this.deletedObjects.add(objectID);
    }

    public java.util.Map<String, Byte> getMapFlags() {
        return this.mapFlags;
    }

    public void buyCard(int objectID, int cardIndex) {
        if (!this.cardsBought.containsKey(objectID)) {
            this.cardsBought.put(objectID, new HashSet());
        }
        this.cardsBought.get(objectID).add(cardIndex);
    }

    public boolean wasCardBought(int objectID, int cardIndex) {
        if (!this.cardsBought.containsKey(objectID)) {
            return false;
        }
        return this.cardsBought.get(objectID).contains(cardIndex);
    }

    public long getShopSeed(int objectID) {
        if (!this.shopSeeds.containsKey(objectID)) {
            this.generateNewShopSeed(objectID);
        }
        return this.shopSeeds.get(objectID);
    }

    public void generateNewShopSeed(int objectID) {
        this.shopSeeds.put(objectID, this.shopSeeds.containsKey(objectID) ? new Random(this.shopSeeds.get(objectID)).nextLong() : Current.world().getRandom().nextLong());
        this.cardsBought.put(objectID, new HashSet());
    }

    public void setRotatingShopSeed(int objectID, long seed) {
        if (this.shopSeeds.containsKey(objectID) && this.shopSeeds.get(objectID) != seed) {
            this.cardsBought.put(objectID, new HashSet());
        }
        this.shopSeeds.put(objectID, seed);
    }

    public float getShopPriceModifier(int objectID) {
        int shopRep = this.reputation.getOrDefault(objectID, 0);
        shopRep = Integer.min(this.maxRepToApply, Integer.max(-this.maxRepToApply, shopRep));
        return 1.0f + (float)shopRep * this.priceModifierPerRep;
    }

    public float getTownPriceModifier() {
        int townRep = this.reputation.getOrDefault(0, 0);
        townRep = Integer.min(this.maxRepToApply, Integer.max(-this.maxRepToApply, townRep));
        return 1.0f - (float)Math.round(this.priceModifierPerRep * (float)townRep * 1000.0f) / 1000.0f;
    }

    public void addMapReputation(int delta) {
        this.addObjectReputation(0, delta);
    }

    public void addObjectReputation(int id, int delta) {
        this.reputation.put(id, this.reputation.getOrDefault(id, 0) + delta);
    }

    public int getMapReputation() {
        return this.getObjectReputation(0);
    }

    public int getObjectReputation(int id) {
        if (!this.reputation.containsKey(id)) {
            this.reputation.put(id, 0);
        }
        return this.reputation.get(id);
    }

    public boolean hasDeletedObjects() {
        return this.deletedObjects != null && !this.deletedObjects.isEmpty();
    }

    public boolean isBookmarked() {
        if (this.isBookmarked == null) {
            return false;
        }
        return this.isBookmarked;
    }

    public void setIsBookmarked(boolean val) {
        this.isBookmarked = val;
    }

    public void clearDeletedObjects() {
        this.deletedObjects.clear();
    }

    public static class Map
    extends HashMap<String, PointOfInterestChanges>
    implements SaveFileContent {
        @Override
        public void load(SaveFileData data) {
            this.clear();
            if (data == null || !data.containsKey("keys")) {
                return;
            }
            String[] keys = (String[])data.readObject("keys");
            for (int i = 0; i < keys.length; ++i) {
                SaveFileData elementData = data.readSubData("value_" + i);
                PointOfInterestChanges newChanges = new PointOfInterestChanges();
                newChanges.load(elementData);
                this.put(keys[i], newChanges);
            }
        }

        @Override
        public SaveFileData save() {
            SaveFileData data = new SaveFileData();
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<PointOfInterestChanges> items = new ArrayList<PointOfInterestChanges>();
            for (Map.Entry entry : this.entrySet()) {
                keys.add((String)entry.getKey());
                items.add((PointOfInterestChanges)entry.getValue());
            }
            data.storeObject("keys", keys.toArray(new String[0]));
            for (int i = 0; i < items.size(); ++i) {
                data.store("value_" + i, ((PointOfInterestChanges)items.get(i)).save());
            }
            return data;
        }
    }
}

