/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.player;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import com.github.tommyettinger.textra.TextraLabel;
import com.google.common.collect.Lists;
import forge.Forge;
import forge.adventure.data.AdventureEventData;
import forge.adventure.data.AdventureQuestData;
import forge.adventure.data.DifficultyData;
import forge.adventure.data.EffectData;
import forge.adventure.data.HeroListData;
import forge.adventure.data.ItemData;
import forge.adventure.player.PlayerStatistic;
import forge.adventure.pointofintrest.PointOfInterestChanges;
import forge.adventure.scene.AdventureDeckEditor;
import forge.adventure.scene.DeckEditScene;
import forge.adventure.stage.GameStage;
import forge.adventure.stage.MapStage;
import forge.adventure.stage.WorldStage;
import forge.adventure.util.AdventureEventController;
import forge.adventure.util.AdventureQuestController;
import forge.adventure.util.CardUtil;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;
import forge.adventure.util.Reward;
import forge.adventure.util.SaveFileContent;
import forge.adventure.util.SaveFileData;
import forge.adventure.util.SignalList;
import forge.adventure.world.WorldSave;
import forge.card.ColorSet;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckProxy;
import forge.deck.DeckSection;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.sound.SoundEffectType;
import forge.sound.SoundSystem;
import forge.util.ItemPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdventurePlayer
implements Serializable,
SaveFileContent {
    public static final int NUMBER_OF_DECKS = 10;
    private String name;
    private int heroRace;
    private int avatarIndex;
    private boolean isFemale;
    private ColorSet colorIdentity = ColorSet.ALL_COLORS;
    private Deck deck;
    private final Deck[] decks = new Deck[10];
    private int selectedDeckIndex = 0;
    private final DifficultyData difficultyData = new DifficultyData();
    private float worldPosX;
    private float worldPosY;
    private int gold = 0;
    private int maxLife = 20;
    private int life = 20;
    private int shards = 0;
    private EffectData blessing;
    private final PlayerStatistic statistic = new PlayerStatistic();
    private final Map<String, Byte> questFlags = new HashMap<String, Byte>();
    private final Map<String, Byte> characterFlags = new HashMap<String, Byte>();
    private final Map<String, Byte> tutorialFlags = new HashMap<String, Byte>();
    private final Array<String> inventoryItems = new Array();
    private final Array<Deck> boostersOwned = new Array();
    private final HashMap<String, String> equippedItems = new HashMap();
    private final List<AdventureQuestData> quests = new ArrayList<AdventureQuestData>();
    private final List<AdventureEventData> events = new ArrayList<AdventureEventData>();
    private boolean fantasyMode = false;
    private boolean announceFantasy = false;
    private boolean usingCustomDeck = false;
    private boolean announceCustom = false;
    final SignalList onLifeTotalChangeList = new SignalList();
    final SignalList onShardsChangeList = new SignalList();
    final SignalList onGoldChangeList = new SignalList();
    final SignalList onPlayerChangeList = new SignalList();
    final SignalList onEquipmentChange = new SignalList();
    final SignalList onBlessing = new SignalList();
    private PointOfInterestChanges currentLocationChanges;
    private final CardPool cards = new CardPool();
    private final ItemPool<PaperCard> newCards = new ItemPool<PaperCard>(PaperCard.class);
    public final ItemPool<PaperCard> autoSellCards = new ItemPool<PaperCard>(PaperCard.class);
    public final ItemPool<PaperCard> noSellCards = new ItemPool<PaperCard>(PaperCard.class);

    public AdventurePlayer() {
        this.clear();
    }

    public PlayerStatistic getStatistic() {
        return this.statistic;
    }

    private void clearDecks() {
        for (int i = 0; i < 10; ++i) {
            this.decks[i] = new Deck(Forge.getLocalizer().getMessage("lblEmptyDeck", new Object[0]));
        }
        this.deck = this.decks[0];
        this.selectedDeckIndex = 0;
    }

    private void clear() {
        this.fantasyMode = false;
        this.announceFantasy = false;
        this.usingCustomDeck = false;
        this.blessing = null;
        this.gold = 0;
        this.maxLife = 20;
        this.life = 20;
        this.shards = 0;
        this.clearDecks();
        this.inventoryItems.clear();
        this.boostersOwned.clear();
        this.equippedItems.clear();
        this.characterFlags.clear();
        this.questFlags.clear();
        this.quests.clear();
        this.events.clear();
        this.cards.clear();
        this.statistic.clear();
        this.newCards.clear();
        this.autoSellCards.clear();
        this.noSellCards.clear();
        AdventureEventController.clear();
        AdventureQuestController.clear();
    }

    public static AdventurePlayer current() {
        return WorldSave.getCurrentSave().getPlayer();
    }

    public void create(String n, Deck startingDeck, boolean male, int race, int avatar, boolean isFantasy, boolean isUsingCustomDeck, DifficultyData difficultyData) {
        this.clear();
        this.announceFantasy = this.fantasyMode = isFantasy;
        this.announceCustom = this.usingCustomDeck = isUsingCustomDeck;
        this.decks[0] = this.deck = startingDeck;
        this.cards.addAllFlat(this.deck.getAllCardsInASinglePool().toFlatList());
        this.difficultyData.startingLife = difficultyData.startingLife;
        this.difficultyData.staringMoney = difficultyData.staringMoney;
        this.difficultyData.startingDifficulty = difficultyData.startingDifficulty;
        this.difficultyData.name = difficultyData.name;
        this.difficultyData.spawnRank = difficultyData.spawnRank;
        this.difficultyData.enemyLifeFactor = difficultyData.enemyLifeFactor;
        this.difficultyData.sellFactor = difficultyData.sellFactor;
        this.difficultyData.shardSellRatio = difficultyData.shardSellRatio;
        this.difficultyData.goldLoss = difficultyData.goldLoss;
        this.difficultyData.lifeLoss = difficultyData.lifeLoss;
        this.gold = difficultyData.staringMoney;
        this.name = n;
        this.heroRace = race;
        this.avatarIndex = avatar;
        this.isFemale = !male;
        this.setColorIdentity(DeckProxy.getColorIdentity(this.deck));
        this.life = this.maxLife = difficultyData.startingLife;
        this.shards = difficultyData.startingShards;
        this.inventoryItems.addAll((String[])difficultyData.startItems);
        this.onGoldChangeList.emit();
        this.onLifeTotalChangeList.emit();
        this.onShardsChangeList.emit();
    }

    public void setSelectedDeckSlot(int slot) {
        if (slot >= 0 && slot < 10) {
            this.selectedDeckIndex = slot;
            this.deck = this.decks[this.selectedDeckIndex];
            this.setColorIdentity(DeckProxy.getColorIdentity(this.deck));
        }
    }

    public void updateDifficulty(DifficultyData diff) {
        this.maxLife = diff.startingLife;
        this.difficultyData.startingShards = diff.startingShards;
        this.difficultyData.startingLife = diff.startingLife;
        this.difficultyData.staringMoney = diff.staringMoney;
        this.difficultyData.startingDifficulty = diff.startingDifficulty;
        this.difficultyData.name = diff.name;
        this.difficultyData.spawnRank = diff.spawnRank;
        this.difficultyData.enemyLifeFactor = diff.enemyLifeFactor;
        this.difficultyData.sellFactor = diff.sellFactor;
        this.difficultyData.shardSellRatio = diff.shardSellRatio;
        this.difficultyData.goldLoss = diff.goldLoss;
        this.difficultyData.lifeLoss = diff.lifeLoss;
        this.resetToMaxLife();
    }

    public int getSelectedDeckIndex() {
        return this.selectedDeckIndex;
    }

    public Deck getSelectedDeck() {
        return this.deck;
    }

    public Array<String> getItems() {
        return this.inventoryItems;
    }

    public Array<Deck> getBoostersOwned() {
        return this.boostersOwned;
    }

    public Deck getDeck(int index) {
        return this.decks[index];
    }

    public CardPool getCards() {
        return this.cards;
    }

    public String getName() {
        return this.name;
    }

    public Boolean isFemale() {
        return this.isFemale;
    }

    public float getWorldPosX() {
        return this.worldPosX;
    }

    public float getWorldPosY() {
        return this.worldPosY;
    }

    public int getGold() {
        return this.gold;
    }

    public int getLife() {
        return this.life;
    }

    public int getMaxLife() {
        return this.maxLife;
    }

    public int getShards() {
        return this.shards;
    }

    @Null
    public EffectData getBlessing() {
        return this.blessing;
    }

    public Collection<String> getEquippedItems() {
        return this.equippedItems.values();
    }

    public ItemPool<PaperCard> getNewCards() {
        return this.newCards;
    }

    public ColorSet getColorIdentity() {
        return this.colorIdentity;
    }

    public String getColorIdentityLong() {
        return this.colorIdentity.toString();
    }

    public void setWorldPosX(float worldPosX) {
        this.worldPosX = worldPosX;
    }

    public void setWorldPosY(float worldPosY) {
        this.worldPosY = worldPosY;
    }

    public void setColorIdentity(String C2) {
        this.colorIdentity = ColorSet.fromNames(C2.toCharArray());
    }

    public void setColorIdentity(ColorSet set) {
        this.colorIdentity = set;
    }

    @Override
    public void load(SaveFileData data) {
        Object[] q;
        String[] keys;
        int i;
        Object temp;
        this.clear();
        this.statistic.load(data.readSubData("statistic"));
        this.difficultyData.startingLife = data.readInt("startingLife");
        this.difficultyData.staringMoney = data.readInt("staringMoney");
        this.difficultyData.startingDifficulty = data.readBool("startingDifficulty");
        this.difficultyData.name = data.readString("difficultyName");
        this.difficultyData.enemyLifeFactor = data.readFloat("enemyLifeFactor");
        this.difficultyData.sellFactor = data.readFloat("sellFactor");
        if (this.difficultyData.sellFactor == 0.0f) {
            this.difficultyData.sellFactor = 0.2f;
        }
        DifficultyData configuredDifficulty = null;
        for (DifficultyData candidate : Config.instance().getConfigData().difficulties) {
            if (!candidate.name.equals(this.difficultyData.name)) continue;
            configuredDifficulty = candidate;
            break;
        }
        this.difficultyData.shardSellRatio = configuredDifficulty != null && (this.difficultyData.shardSellRatio == data.readFloat("shardSellRatio") || data.readFloat("shardSellRatio") == 0.0f) ? configuredDifficulty.shardSellRatio : data.readFloat("shardSellRatio");
        this.difficultyData.goldLoss = configuredDifficulty != null && !data.containsKey("goldLoss") ? configuredDifficulty.goldLoss : data.readFloat("goldLoss");
        this.difficultyData.lifeLoss = configuredDifficulty != null && !data.containsKey("lifeLoss") ? configuredDifficulty.lifeLoss : data.readFloat("lifeLoss");
        this.difficultyData.spawnRank = configuredDifficulty != null && !data.containsKey("spawnRank") ? configuredDifficulty.spawnRank : data.readInt("spawnRank");
        this.difficultyData.rewardMaxFactor = configuredDifficulty != null && !data.containsKey("rewardMaxFactor") ? configuredDifficulty.rewardMaxFactor : data.readFloat("rewardMaxFactor");
        this.name = data.readString("name");
        this.heroRace = data.readInt("heroRace");
        this.avatarIndex = data.readInt("avatarIndex");
        this.isFemale = data.readBool("isFemale");
        if (data.containsKey("colorIdentity")) {
            temp = data.readString("colorIdentity");
            if (temp != null) {
                this.setColorIdentity((String)temp);
            } else {
                this.colorIdentity = ColorSet.ALL_COLORS;
            }
        } else {
            this.colorIdentity = ColorSet.ALL_COLORS;
        }
        this.gold = data.readInt("gold");
        this.maxLife = data.readInt("maxLife");
        this.life = data.readInt("life");
        this.shards = data.containsKey("shards") ? data.readInt("shards") : 0;
        this.worldPosX = data.readFloat("worldPosX");
        this.worldPosY = data.readFloat("worldPosY");
        if (data.containsKey("blessing") && (temp = (EffectData)data.readObject("blessing")) != null) {
            this.blessing = temp;
        }
        if (data.containsKey("inventory")) {
            String[] inv;
            for (String string : inv = (String[])data.readObject("inventory")) {
                if (ItemData.getItem(string) != null) {
                    this.inventoryItems.add(string);
                    continue;
                }
                System.err.printf("Cannot find item name %s\n", string);
                System.out.println("Developers have blessed you! You are allowed to cheat the cost of the item back!");
            }
        }
        if (data.containsKey("equippedSlots") && data.containsKey("equippedItems")) {
            String[] slots = (String[])data.readObject("equippedSlots");
            String[] items = (String[])data.readObject("equippedItems");
            assert (slots.length == items.length);
            for (i = 0; i < slots.length; ++i) {
                if (ItemData.getItem(items[i]) != null) {
                    this.equippedItems.put(slots[i], items[i]);
                    continue;
                }
                System.err.printf("Cannot find equip name %s\n", items[i]);
            }
        }
        if (data.containsKey("boosters")) {
            Deck[] decks = (Deck[])data.readObject("boosters");
            if (decks != null) {
                Deck[] items = decks;
                i = items.length;
                for (int j = 0; j < i; ++j) {
                    Deck deck = items[j];
                    if (deck != null && !deck.isEmpty()) {
                        this.boostersOwned.add(deck);
                        continue;
                    }
                    System.err.printf("Null or empty booster %s\n", deck);
                    System.out.println("You have an empty booster pack in your inventory.");
                }
            } else {
                System.err.println("Deck[] is null! [boosters]");
            }
        }
        this.deck = new Deck(data.readString("deckName"));
        this.deck.getMain().addAll(CardPool.fromCardList(Lists.newArrayList((String[])data.readObject("deckCards"))));
        if (data.containsKey("sideBoardCards")) {
            this.deck.getOrCreate(DeckSection.Sideboard).addAll(CardPool.fromCardList(Lists.newArrayList((String[])data.readObject("sideBoardCards"))));
        }
        if (data.containsKey("characterFlagsKey") && data.containsKey("characterFlagsValue")) {
            keys = (String[])data.readObject("characterFlagsKey");
            Byte[] values = (Byte[])data.readObject("characterFlagsValue");
            assert (keys.length == values.length);
            for (i = 0; i < keys.length; ++i) {
                this.characterFlags.put(keys[i], values[i]);
            }
        }
        if (data.containsKey("questFlagsKey") && data.containsKey("questFlagsValue")) {
            keys = (String[])data.readObject("questFlagsKey");
            Byte[] values = (Byte[])data.readObject("questFlagsValue");
            assert (keys.length == values.length);
            for (i = 0; i < keys.length; ++i) {
                this.questFlags.put(keys[i], values[i]);
            }
        }
        if (data.containsKey("quests")) {
            this.quests.clear();
            q = (Object[])data.readObject("quests");
            if (q != null) {
                for (Object object : q) {
                    this.quests.add((AdventureQuestData)object);
                }
            }
        }
        if (data.containsKey("events")) {
            this.events.clear();
            q = (Object[])data.readObject("events");
            if (q != null) {
                for (Object object : q) {
                    this.events.add((AdventureEventData)object);
                }
            }
        }
        for (int i3 = 0; i3 < 10; ++i3) {
            if (!data.containsKey("deck_name_" + i3)) {
                if (i3 == 0) {
                    this.decks[i3] = this.deck;
                    continue;
                }
                this.decks[i3] = new Deck(Forge.getLocalizer().getMessage("lblEmptyDeck", new Object[0]));
                continue;
            }
            this.decks[i3] = new Deck(data.readString("deck_name_" + i3));
            this.decks[i3].getMain().addAll(CardPool.fromCardList(Lists.newArrayList((String[])data.readObject("deck_" + i3))));
            if (!data.containsKey("sideBoardCards_" + i3)) continue;
            this.decks[i3].getOrCreate(DeckSection.Sideboard).addAll(CardPool.fromCardList(Lists.newArrayList((String[])data.readObject("sideBoardCards_" + i3))));
        }
        this.setSelectedDeckSlot(data.readInt("selectedDeckIndex"));
        this.cards.addAll(CardPool.fromCardList(Lists.newArrayList((String[])data.readObject("cards"))));
        if (data.containsKey("newCards")) {
            InventoryItem[] items;
            for (InventoryItem inventoryItem : items = (InventoryItem[])data.readObject("newCards")) {
                this.newCards.add((PaperCard)inventoryItem);
            }
        }
        if (data.containsKey("noSellCards")) {
            PaperCard[] items;
            for (PaperCard paperCard : items = (PaperCard[])data.readObject("noSellCards")) {
                this.noSellCards.add(paperCard);
            }
        }
        if (data.containsKey("autoSellCards")) {
            PaperCard[] items;
            for (PaperCard paperCard : items = (PaperCard[])data.readObject("autoSellCards")) {
                this.autoSellCards.add(paperCard);
            }
        }
        this.fantasyMode = data.containsKey("fantasyMode") && data.readBool("fantasyMode");
        this.announceFantasy = data.containsKey("announceFantasy") && data.readBool("announceFantasy");
        this.usingCustomDeck = data.containsKey("usingCustomDeck") && data.readBool("usingCustomDeck");
        this.announceCustom = data.containsKey("announceCustom") && data.readBool("announceCustom");
        this.onLifeTotalChangeList.emit();
        this.onShardsChangeList.emit();
        this.onGoldChangeList.emit();
        this.onBlessing.emit();
    }

    @Override
    public SaveFileData save() {
        SaveFileData data = new SaveFileData();
        data.store("statistic", this.statistic.save());
        data.store("startingLife", this.difficultyData.startingLife);
        data.store("staringMoney", this.difficultyData.staringMoney);
        data.store("startingDifficulty", this.difficultyData.startingDifficulty);
        data.store("difficultyName", this.difficultyData.name);
        data.store("enemyLifeFactor", this.difficultyData.enemyLifeFactor);
        data.store("sellFactor", this.difficultyData.sellFactor);
        data.store("shardSellRatio", this.difficultyData.shardSellRatio);
        data.store("goldLoss", this.difficultyData.goldLoss);
        data.store("lifeLoss", this.difficultyData.lifeLoss);
        data.store("spawnRank", this.difficultyData.spawnRank);
        data.store("rewardMaxFactor", this.difficultyData.rewardMaxFactor);
        data.store("name", this.name);
        data.store("heroRace", this.heroRace);
        data.store("avatarIndex", this.avatarIndex);
        data.store("isFemale", this.isFemale);
        data.store("colorIdentity", this.colorIdentity.getColor());
        data.store("fantasyMode", this.fantasyMode);
        data.store("announceFantasy", this.announceFantasy);
        data.store("usingCustomDeck", this.usingCustomDeck);
        data.store("announceCustom", this.announceCustom);
        data.store("worldPosX", this.worldPosX);
        data.store("worldPosY", this.worldPosY);
        data.store("gold", this.gold);
        data.store("life", this.life);
        data.store("maxLife", this.maxLife);
        data.store("shards", this.shards);
        data.store("deckName", this.deck.getName());
        data.storeObject("inventory", this.inventoryItems.toArray(String.class));
        ArrayList<String> slots = new ArrayList<String>();
        ArrayList<String> items = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.equippedItems.entrySet()) {
            slots.add(entry.getKey());
            items.add(entry.getValue());
        }
        data.storeObject("equippedSlots", slots.toArray(new String[0]));
        data.storeObject("equippedItems", items.toArray(new String[0]));
        data.storeObject("boosters", this.boostersOwned.toArray(Deck.class));
        data.storeObject("blessing", this.blessing);
        ArrayList<String> characterFlagsKey = new ArrayList<String>();
        ArrayList<Byte> characterFlagsValue = new ArrayList<Byte>();
        for (Map.Entry<String, Byte> entry : this.characterFlags.entrySet()) {
            characterFlagsKey.add(entry.getKey());
            characterFlagsValue.add(entry.getValue());
        }
        data.storeObject("characterFlagsKey", characterFlagsKey.toArray(new String[0]));
        data.storeObject("characterFlagsValue", characterFlagsValue.toArray(new Byte[0]));
        ArrayList<String> questFlagsKey = new ArrayList<String>();
        ArrayList<Byte> questFlagsValue = new ArrayList<Byte>();
        for (Map.Entry<String, Byte> entry : this.questFlags.entrySet()) {
            questFlagsKey.add(entry.getKey());
            questFlagsValue.add(entry.getValue());
        }
        data.storeObject("questFlagsKey", questFlagsKey.toArray(new String[0]));
        data.storeObject("questFlagsValue", questFlagsValue.toArray(new Byte[0]));
        data.storeObject("quests", this.quests.toArray());
        data.storeObject("events", this.events.toArray());
        data.storeObject("deckCards", this.deck.getMain().toCardList("\n").split("\n"));
        if (this.deck.get(DeckSection.Sideboard) != null) {
            data.storeObject("sideBoardCards", this.deck.get(DeckSection.Sideboard).toCardList("\n").split("\n"));
        }
        for (int i = 0; i < 10; ++i) {
            data.store("deck_name_" + i, this.decks[i].getName());
            data.storeObject("deck_" + i, this.decks[i].getMain().toCardList("\n").split("\n"));
            if (this.decks[i].get(DeckSection.Sideboard) == null) continue;
            data.storeObject("sideBoardCards_" + i, this.decks[i].get(DeckSection.Sideboard).toCardList("\n").split("\n"));
        }
        data.store("selectedDeckIndex", this.selectedDeckIndex);
        data.storeObject("cards", this.cards.toCardList("\n").split("\n"));
        data.storeObject("newCards", this.newCards.toFlatList().toArray(new PaperCard[0]));
        data.storeObject("autoSellCards", this.autoSellCards.toFlatList().toArray(new PaperCard[0]));
        data.storeObject("noSellCards", this.noSellCards.toFlatList().toArray(new PaperCard[0]));
        return data;
    }

    public String spriteName() {
        return HeroListData.getHero(this.heroRace, this.isFemale);
    }

    public FileHandle sprite() {
        return Config.instance().getFile(HeroListData.getHero(this.heroRace, this.isFemale));
    }

    public TextureRegion avatar() {
        return HeroListData.getAvatar(this.heroRace, this.isFemale, this.avatarIndex);
    }

    public String raceName() {
        return HeroListData.getRaces().get(Current.player().heroRace);
    }

    public GameStage getCurrentGameStage() {
        if (MapStage.getInstance().isInMap()) {
            return MapStage.getInstance();
        }
        return WorldStage.getInstance();
    }

    public void addStatusMessage(String iconName, String message, Integer itemCount, float x, float y) {
        String symbol = itemCount == null || itemCount < 0 ? "" : " +";
        String icon = iconName == null ? "" : "[+" + iconName + "]";
        String count = itemCount == null ? "" : String.valueOf(itemCount);
        TextraLabel actor = Controls.newTextraLabel("[%95]" + icon + "[WHITE]" + symbol + count + " " + message);
        actor.setPosition(x, y);
        actor.addAction(Actions.sequence((Action)Actions.parallel((Action)Actions.moveBy(0.0f, 5.0f, 3.0f), (Action)Actions.fadeIn(2.0f)), (Action)Actions.hide(), (Action)Actions.removeActor()));
        this.getCurrentGameStage().addActor(actor);
    }

    public void addCard(PaperCard card) {
        this.cards.add(card);
        this.newCards.add(card);
    }

    public void addReward(Reward reward) {
        switch (reward.getType()) {
            case Card: {
                this.cards.add(reward.getCard());
                this.newCards.add(reward.getCard());
                if (reward.isAutoSell()) {
                    this.autoSellCards.add(reward.getCard());
                    this.refreshEditor();
                    break;
                }
                if (!reward.isNoSell()) break;
                this.noSellCards.add(reward.getCard());
                this.refreshEditor();
                break;
            }
            case Gold: {
                this.addGold(reward.getCount());
                break;
            }
            case Item: {
                if (reward.getItem() == null) break;
                this.addItem(reward.getItem().name);
                break;
            }
            case CardPack: {
                if (reward.getDeck() == null) break;
                this.boostersOwned.add(reward.getDeck());
                break;
            }
            case Life: {
                this.addMaxLife(reward.getCount());
                break;
            }
            case Shards: {
                this.addShards(reward.getCount());
            }
        }
    }

    private void refreshEditor() {
        AdventureDeckEditor editor = (AdventureDeckEditor)DeckEditScene.getInstance().getScreen();
        if (editor != null) {
            editor.refresh();
        }
    }

    private void addGold(int goldCount) {
        this.gold += goldCount;
        this.onGoldChangeList.emit();
    }

    public void onShardsChange(Runnable o) {
        this.onShardsChangeList.add(o);
        o.run();
    }

    public void onLifeChange(Runnable o) {
        this.onLifeTotalChangeList.add(o);
        o.run();
    }

    public void onPlayerChanged(Runnable o) {
        this.onPlayerChangeList.add(o);
        o.run();
    }

    public void onEquipmentChanged(Runnable o) {
        this.onEquipmentChange.add(o);
        o.run();
    }

    public void onGoldChange(Runnable o) {
        this.onGoldChangeList.add(o);
        o.run();
    }

    public void onBlessing(Runnable o) {
        this.onBlessing.add(o);
        o.run();
    }

    public boolean fullHeal() {
        if (this.life < this.maxLife) {
            this.resetToMaxLife();
            return true;
        }
        return false;
    }

    public void resetToMaxLife() {
        this.life = this.maxLife;
        this.onLifeTotalChangeList.emit();
    }

    public boolean potionOfFalseLife() {
        if (this.gold >= this.falseLifeCost() && this.life == this.maxLife) {
            this.life = this.maxLife + 2;
            this.gold -= this.falseLifeCost();
            this.onLifeTotalChangeList.emit();
            this.onGoldChangeList.emit();
            return true;
        }
        System.out.println("Can't afford cost of false life " + this.falseLifeCost());
        System.out.println("Only has this much gold " + this.gold);
        return false;
    }

    public int falseLifeCost() {
        int ret = 200 + (int)(50.0f * this.getStatistic().winLossRatio());
        return ret < 0 ? 250 : ret;
    }

    public void heal(int amount) {
        this.life = Math.min(this.life + amount, this.maxLife);
        this.onLifeTotalChangeList.emit();
    }

    public void heal(float percent) {
        this.life = Math.min(this.life + (int)((float)this.maxLife * percent), this.maxLife);
        this.onLifeTotalChangeList.emit();
    }

    public boolean defeated() {
        this.gold = (int)((float)this.gold - (float)this.gold * this.difficultyData.goldLoss);
        this.life = (int)((float)this.life - (float)this.maxLife * this.difficultyData.lifeLoss);
        this.onLifeTotalChangeList.emit();
        this.onGoldChangeList.emit();
        return this.life < 1;
    }

    public void win() {
        Current.player().addShards(1);
    }

    public void addMaxLife(int count) {
        this.maxLife += count;
        this.life += count;
        this.onLifeTotalChangeList.emit();
    }

    public void giveGold(int price) {
        this.takeGold(-price);
    }

    public void takeGold(int price) {
        this.gold -= price;
        this.onGoldChangeList.emit();
        SoundSystem.instance.play(SoundEffectType.CoinsDrop, false);
    }

    public void addShards(int number) {
        this.takeShards(-number);
    }

    public void takeShards(int number) {
        this.shards -= number;
        this.onShardsChangeList.emit();
        SoundSystem.instance.play(SoundEffectType.TakeShard, false);
    }

    public void setShards(int number) {
        boolean changed;
        boolean bl = changed = this.shards != number;
        if (changed) {
            this.shards = number;
            this.onShardsChangeList.emit();
        }
    }

    public void addBlessing(EffectData bless) {
        this.blessing = bless;
        this.onBlessing.emit();
    }

    public void clearBlessing() {
        this.blessing = null;
        this.onBlessing.emit();
    }

    public boolean hasBlessing(String name) {
        if (this.blessing == null) {
            return false;
        }
        return this.blessing.name.equals(name);
    }

    public boolean isFantasyMode() {
        return this.fantasyMode;
    }

    public boolean isUsingCustomDeck() {
        return this.usingCustomDeck;
    }

    public boolean hasAnnounceFantasy() {
        return this.announceFantasy;
    }

    public void clearAnnounceFantasy() {
        this.announceFantasy = false;
    }

    public boolean hasAnnounceCustom() {
        return this.announceCustom;
    }

    public void clearAnnounceCustom() {
        this.announceCustom = false;
    }

    public boolean hasColorView() {
        for (String name : this.equippedItems.values()) {
            ItemData data = ItemData.getItem(name);
            if (data == null || data.effect == null || !data.effect.colorView) continue;
            return true;
        }
        if (this.blessing != null) {
            return this.blessing.colorView;
        }
        return false;
    }

    public ItemData getRandomEquippedArmor() {
        Array<ItemData> armor = new Array<ItemData>();
        for (String name : this.equippedItems.values()) {
            ItemData data = ItemData.getItem(name);
            if (data == null || !"Boots".equalsIgnoreCase(data.equipmentSlot) && !"Body".equalsIgnoreCase(data.equipmentSlot) && !"Neck".equalsIgnoreCase(data.equipmentSlot)) continue;
            armor.add(data);
        }
        return (ItemData)armor.random();
    }

    public ItemData getEquippedAbility1() {
        for (String name : this.equippedItems.values()) {
            ItemData data = ItemData.getItem(name);
            if (data == null || !"Ability1".equalsIgnoreCase(data.equipmentSlot)) continue;
            return data;
        }
        return null;
    }

    public ItemData getEquippedAbility2() {
        for (String name : this.equippedItems.values()) {
            ItemData data = ItemData.getItem(name);
            if (data == null || !"Ability2".equalsIgnoreCase(data.equipmentSlot)) continue;
            return data;
        }
        return null;
    }

    public int bonusDeckCards() {
        int result = 0;
        for (String name : this.equippedItems.values()) {
            ItemData data = ItemData.getItem(name);
            if (data == null || data.effect == null || data.effect.cardRewardBonus <= 0) continue;
            result += data.effect.cardRewardBonus;
        }
        if (this.blessing != null && this.blessing.cardRewardBonus > 0) {
            result += this.blessing.cardRewardBonus;
        }
        return Math.min(result, 3);
    }

    public DifficultyData getDifficulty() {
        return this.difficultyData;
    }

    public boolean isHardorInsaneDifficulty() {
        return "Hard".equalsIgnoreCase(this.difficultyData.name) || "Insane".equalsIgnoreCase(this.difficultyData.name);
    }

    public void renameDeck(String text) {
        this.decks[this.selectedDeckIndex] = this.deck = (Deck)this.deck.copyTo(text);
    }

    public int cardSellPrice(PaperCard card) {
        return (int)((float)CardUtil.getCardPrice(card) * this.difficultyData.sellFactor * (2.0f - this.currentLocationChanges.getTownPriceModifier()));
    }

    public void sellCard(PaperCard card, Integer result) {
        float price = CardUtil.getCardPrice(card) * result;
        this.cards.remove(card, result);
        this.addGold((int)(price *= this.difficultyData.sellFactor));
    }

    public void removeItem(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        this.inventoryItems.removeValue(name, false);
        if (this.equippedItems.values().contains(name) && !this.inventoryItems.contains(name, false)) {
            this.equippedItems.values().remove(name);
        }
    }

    public void equip(ItemData item) {
        if (this.equippedItems.get(item.equipmentSlot) != null && this.equippedItems.get(item.equipmentSlot).equals(item.name)) {
            this.equippedItems.remove(item.equipmentSlot);
        } else {
            this.equippedItems.put(item.equipmentSlot, item.name);
        }
        this.onEquipmentChange.emit();
    }

    public String itemInSlot(String key) {
        return this.equippedItems.get(key);
    }

    public float equipmentSpeed() {
        float factor = 1.0f;
        for (String name : this.equippedItems.values()) {
            ItemData data = ItemData.getItem(name);
            if (data == null || data.effect == null || !((double)data.effect.moveSpeed > 0.0)) continue;
            factor *= data.effect.moveSpeed;
        }
        if (this.blessing != null && (double)this.blessing.moveSpeed > 0.0) {
            factor *= this.blessing.moveSpeed;
        }
        return factor;
    }

    public float goldModifier(boolean sale) {
        float factor = 1.0f;
        for (String name : this.equippedItems.values()) {
            ItemData data = ItemData.getItem(name);
            if (data == null || data.effect == null || !((double)data.effect.goldModifier > 0.0)) continue;
            factor *= data.effect.goldModifier;
        }
        if (this.blessing != null && (double)this.blessing.goldModifier > 0.0) {
            factor *= this.blessing.goldModifier;
        }
        if (sale) {
            return Math.max(1.0f + (1.0f - factor), 2.5f);
        }
        return Math.max(factor, 0.25f);
    }

    public float goldModifier() {
        return this.goldModifier(false);
    }

    public boolean hasItem(String name) {
        return this.inventoryItems.contains(name, false);
    }

    public int countItem(String name) {
        int count = 0;
        if (!this.hasItem(name)) {
            return count;
        }
        for (String s2 : this.inventoryItems) {
            if (!s2.equals(name)) continue;
            ++count;
        }
        return count;
    }

    public boolean addItem(String name) {
        ItemData item = ItemData.getItem(name);
        if (item == null) {
            return false;
        }
        this.inventoryItems.add(name);
        AdventureQuestController.instance().updateItemReceived(item);
        return true;
    }

    public boolean addBooster(Deck booster) {
        if (booster == null || booster.isEmpty()) {
            return false;
        }
        this.boostersOwned.add(booster);
        return true;
    }

    public void removeBooster(Deck booster) {
        this.boostersOwned.removeValue(booster, true);
    }

    public void setCharacterFlag(String key, int value) {
        if (value != 0) {
            this.characterFlags.put(key, (byte)value);
        } else {
            this.characterFlags.remove(key);
        }
        AdventureQuestController.instance().updateQuestsCharacterFlag(key, value);
    }

    public void advanceCharacterFlag(String key) {
        if (this.characterFlags.get(key) != null) {
            this.characterFlags.put(key, (byte)(this.characterFlags.get(key) + 1));
        } else {
            this.characterFlags.put(key, (byte)1);
        }
    }

    public boolean checkCharacterFlag(String key) {
        return this.characterFlags.get(key) != null;
    }

    public int getCharacterFlag(String key) {
        return this.characterFlags.getOrDefault(key, (byte)0).byteValue();
    }

    public void setQuestFlag(String key, int value) {
        if (value != 0) {
            this.questFlags.put(key, (byte)value);
        } else {
            this.questFlags.remove(key);
        }
        AdventureQuestController.instance().updateQuestsQuestFlag(key, value);
    }

    public void advanceQuestFlag(String key) {
        if (this.questFlags.get(key) != null) {
            this.questFlags.put(key, (byte)(this.questFlags.get(key) + 1));
        } else {
            this.questFlags.put(key, (byte)1);
        }
    }

    public boolean checkQuestFlag(String key) {
        return this.questFlags.get(key) != null;
    }

    public int getQuestFlag(String key) {
        return this.questFlags.getOrDefault(key, (byte)0).byteValue();
    }

    public void resetQuestFlags() {
        this.questFlags.clear();
    }

    public void addQuest(String questID) {
        int id = Integer.parseInt(questID);
        this.addQuest(id);
    }

    public void addQuest(int questID) {
        AdventureQuestData toAdd = AdventureQuestController.instance().generateQuest(questID);
        if (toAdd != null) {
            this.addQuest(toAdd);
        }
    }

    public void addQuest(AdventureQuestData q) {
        boolean noTrackedQuests = true;
        for (AdventureQuestData existing : this.quests) {
            if (!noTrackedQuests || !existing.isTracked) continue;
            noTrackedQuests = false;
            break;
        }
        this.quests.add(q);
        if (noTrackedQuests || q.autoTrack) {
            AdventureQuestController.trackQuest(q);
        }
        q.activateNextStages();
        AdventureQuestController.instance().showQuestDialogs(MapStage.getInstance());
    }

    public List<AdventureQuestData> getQuests() {
        return this.quests;
    }

    public void addEvent(AdventureEventData e) {
        this.events.add(e);
    }

    public List<AdventureEventData> getEvents() {
        return this.events;
    }

    public int getEnemyDeckNumber(String enemyName, int maxDecks) {
        int enemyWins;
        int playerWins;
        int deckNumber = 0;
        if (this.statistic.getWinLossRecord().get(enemyName) != null && (playerWins = this.statistic.getWinLossRecord().get(enemyName).getKey().intValue()) > (enemyWins = this.statistic.getWinLossRecord().get(enemyName).getValue().intValue())) {
            int deckNumberAfterAlgorithmOutput = (int)((float)(playerWins - enemyWins) * (this.difficultyData.enemyLifeFactor / 3.0f));
            deckNumber = deckNumberAfterAlgorithmOutput < maxDecks ? deckNumberAfterAlgorithmOutput : maxDecks - 1;
        }
        return deckNumber;
    }

    public void removeQuest(AdventureQuestData quest) {
        this.quests.remove(quest);
    }

    public void deleteDeck() {
        this.deck = this.decks[this.selectedDeckIndex] = new Deck(Forge.getLocalizer().getMessage("lblEmptyDeck", new Object[0]));
    }

    public int copyDeck() {
        for (int i = 0; i < this.decks.length; ++i) {
            if (!this.isEmptyDeck(i)) continue;
            this.decks[i] = (Deck)this.deck.copyTo(this.deck.getName() + " (" + Forge.getLocalizer().getMessage("lblCopy", new Object[0]) + ")");
            return i;
        }
        return -1;
    }

    public boolean isEmptyDeck(int deckIndex) {
        return this.decks[deckIndex].isEmpty() && this.decks[deckIndex].getName().equals(Forge.getLocalizer().getMessage("lblEmptyDeck", new Object[0]));
    }

    public void removeEvent(AdventureEventData completedEvent) {
        this.events.remove(completedEvent);
    }

    public ItemPool<PaperCard> getAutoSellCards() {
        return this.autoSellCards;
    }

    public ItemPool<PaperCard> getNoSellCards() {
        return this.noSellCards;
    }

    public ItemPool<PaperCard> getSellableCards() {
        ItemPool<PaperCard> sellableCards = new ItemPool<PaperCard>(PaperCard.class);
        sellableCards.addAllFlat(this.cards.toFlatList());
        sellableCards.removeAll(this.noSellCards);
        HashMap<PaperCard, Integer> maxCardCounts = new HashMap<PaperCard, Integer>();
        for (int i = 0; i < 10; ++i) {
            for (Map.Entry cp : this.decks[i].getAllCardsInASinglePool()) {
                int count = cp.getValue() - this.noSellCards.count((PaperCard)cp.getKey());
                if (count <= 0 || count <= maxCardCounts.getOrDefault(cp.getKey(), 0)) continue;
                maxCardCounts.put((PaperCard)cp.getKey(), cp.getValue());
            }
        }
        for (PaperCard card : maxCardCounts.keySet()) {
            sellableCards.remove(card, (Integer)maxCardCounts.get(card));
        }
        return sellableCards;
    }

    public CardPool getCollectionCards(boolean allCards) {
        CardPool collectionCards = new CardPool();
        collectionCards.addAll(this.cards);
        if (!allCards) {
            collectionCards.removeAll(this.autoSellCards);
            collectionCards.removeAll(this.noSellCards);
        }
        return collectionCards;
    }

    public void loadChanges(PointOfInterestChanges changes) {
        this.currentLocationChanges = changes;
    }

    public void doAutosell() {
        int profit = 0;
        for (PaperCard cardToSell : this.autoSellCards.toFlatList()) {
            profit += AdventurePlayer.current().cardSellPrice(cardToSell);
            this.autoSellCards.remove(cardToSell);
            this.cards.remove(cardToSell, 1);
        }
        this.addGold(profit);
    }
}

