/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import forge.adventure.Main;
import forge.adventure.data.BiomeData;
import forge.adventure.data.WorldData;
import forge.adventure.editor.BiomeEdit;
import forge.adventure.editor.FloatSpinner;
import forge.adventure.editor.FormPanel;
import forge.adventure.editor.IntSpinner;
import forge.adventure.editor.SwingAtlas;
import forge.adventure.editor.TextListEdit;
import forge.adventure.util.Config;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class WorldEditor
extends JComponent {
    WorldData currentData;
    IntSpinner width = new IntSpinner(0, 100000, 1);
    IntSpinner height = new IntSpinner(0, 100000, 1);
    FloatSpinner playerStartPosX = new FloatSpinner(0.0f, 1.0f, 0.1f);
    FloatSpinner playerStartPosY = new FloatSpinner(0.0f, 1.0f, 0.1f);
    FloatSpinner noiseZoomBiome = new FloatSpinner(0.0f, 1000.0f, 1.0f);
    IntSpinner tileSize = new IntSpinner(0, 100000, 1);
    JTextField biomesSprites = new JTextField();
    FloatSpinner maxRoadDistance = new FloatSpinner(0.0f, 100000.0f, 1.0f);
    TextListEdit biomesNames = new TextListEdit();
    DefaultListModel<BiomeData> model = new DefaultListModel();
    JList<BiomeData> list = new JList<BiomeData>(this.model);
    BiomeEdit edit = new BiomeEdit();
    JTabbedPane tabs = new JTabbedPane();
    static HashMap<String, SwingAtlas> atlas = new HashMap();

    private void updateBiome() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.edit.setCurrentBiome(this.model.get(selected));
    }

    public WorldEditor() {
        this.list.setCellRenderer(new BiomeDataRenderer());
        this.list.addListSelectionListener(e -> this.updateBiome());
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add(this.tabs);
        JSplitPane biomeData = new JSplitPane();
        this.tabs.addTab("BiomeData", biomeData);
        FormPanel worldPanel = new FormPanel();
        worldPanel.add("width:", (JComponent)this.width);
        worldPanel.add("height:", (JComponent)this.height);
        worldPanel.add("playerStartPosX:", (JComponent)this.playerStartPosX);
        worldPanel.add("playerStartPosY:", (JComponent)this.playerStartPosY);
        worldPanel.add("noiseZoomBiome:", (JComponent)this.noiseZoomBiome);
        worldPanel.add("tileSize:", (JComponent)this.tileSize);
        worldPanel.add("biomesSprites:", (JComponent)this.biomesSprites);
        worldPanel.add("maxRoadDistance:", (JComponent)this.maxRoadDistance);
        worldPanel.add("biomesNames:", (JComponent)this.biomesNames);
        this.tabs.addTab("WorldData", worldPanel);
        JScrollPane pane = new JScrollPane(this.edit);
        biomeData.setLeftComponent(this.list);
        biomeData.setRightComponent(pane);
        this.load();
        JToolBar toolBar = new JToolBar("toolbar");
        this.add((Component)toolBar, "First");
        JButton newButton = new JButton("save");
        newButton.addActionListener(e -> this.save());
        toolBar.add(newButton);
        newButton = new JButton("save selected biome");
        newButton.addActionListener(e -> this.saveBiome());
        toolBar.add(newButton);
        newButton = new JButton("load");
        newButton.addActionListener(e -> this.load());
        toolBar.add(newButton);
        toolBar.addSeparator();
        newButton = new JButton("test map");
        newButton.addActionListener(e -> this.test());
        toolBar.add(newButton);
        newButton = new JButton("edit effects");
        newButton.addActionListener(e -> this.startEffectEditor());
        toolBar.add(newButton);
    }

    private void startEffectEditor() {
    }

    private void test() {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String classpath = System.getProperty("java.class.path");
        String className = Main.class.getName();
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBin);
        command.add("-cp");
        command.add(classpath);
        command.add(className);
        command.add("testMap");
        ProcessBuilder build = new ProcessBuilder(command);
        build.redirectInput(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT);
        try {
            Process process = build.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void saveBiome() {
        this.edit.updateTerrain();
        Json json = new Json(JsonWriter.OutputType.json);
        FileHandle handle = Config.instance().getFile(this.currentData.biomesNames[this.list.getSelectedIndex()]);
        handle.writeString(json.prettyPrint(json.toJson((Object)this.edit.currentData, BiomeData.class)), false);
    }

    void save() {
        this.currentData.width = this.width.intValue();
        this.currentData.height = this.height.intValue();
        this.currentData.playerStartPosX = this.playerStartPosX.floatValue();
        this.currentData.playerStartPosY = this.playerStartPosY.floatValue();
        this.currentData.noiseZoomBiome = this.noiseZoomBiome.floatValue();
        this.currentData.tileSize = this.tileSize.intValue();
        this.currentData.biomesSprites = this.biomesSprites.getText();
        this.currentData.maxRoadDistance = this.maxRoadDistance.floatValue();
        this.currentData.biomesNames = this.biomesNames.getList();
        Json json = new Json(JsonWriter.OutputType.json);
        FileHandle handle = Config.instance().getFile("world/world.json");
        handle.writeString(json.prettyPrint(json.toJson((Object)this.currentData, WorldData.class)), false);
    }

    void load() {
        this.model.clear();
        Json json = new Json();
        FileHandle handle = Config.instance().getFile("world/world.json");
        if (handle.exists()) {
            this.currentData = json.fromJson(WorldData.class, WorldData.class, handle);
        }
        this.update();
    }

    private void update() {
        this.width.setValue(this.currentData.width);
        this.height.setValue(this.currentData.height);
        this.playerStartPosX.setValue(Float.valueOf(this.currentData.playerStartPosX));
        this.playerStartPosY.setValue(Float.valueOf(this.currentData.playerStartPosY));
        this.noiseZoomBiome.setValue(Float.valueOf(this.currentData.noiseZoomBiome));
        this.tileSize.setValue(this.currentData.tileSize);
        this.biomesSprites.setText(this.currentData.biomesSprites);
        this.maxRoadDistance.setValue(Float.valueOf(this.currentData.maxRoadDistance));
        this.biomesNames.setText(this.currentData.biomesNames);
        for (String path : this.currentData.biomesNames) {
            Json json = new Json();
            FileHandle handle = Config.instance().getFile(path);
            if (!handle.exists()) continue;
            BiomeData data = json.fromJson(BiomeData.class, BiomeData.class, handle);
            this.model.addElement(data);
        }
    }

    public class BiomeDataRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SwingAtlas poiAtlas;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof BiomeData)) {
                return label;
            }
            BiomeData biome = (BiomeData)value;
            label.setText(biome.name);
            if (!atlas.containsKey(biome.tilesetAtlas)) {
                atlas.put(biome.tilesetAtlas, new SwingAtlas(Config.instance().getFile(biome.tilesetAtlas)));
            }
            if ((poiAtlas = atlas.get(biome.tilesetAtlas)).has(biome.tilesetName)) {
                label.setIcon(poiAtlas.get(biome.tilesetName));
            } else {
                ImageIcon img = poiAtlas.getAny();
                if (img != null) {
                    label.setIcon(img);
                }
            }
            return label;
        }
    }
}

