/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import java.awt.Dimension;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class TextListEdit
extends Box {
    JTextField edit = new JTextField();
    JButton findButton = new JButton(UIManager.getIcon("add"));
    JComboBox elements;

    public TextListEdit(String[] possibleElements) {
        super(0);
        this.findButton.addActionListener(e -> this.find());
        this.add(this.edit);
        this.edit.setPreferredSize(new Dimension(400, this.edit.getPreferredSize().height));
        this.add(this.findButton);
        this.elements = new JComboBox<String>(possibleElements);
        this.add(this.elements);
    }

    public TextListEdit() {
        this(new String[0]);
    }

    JTextField getEdit() {
        return this.edit;
    }

    private void find() {
        this.edit.setText((this.edit.getText().trim().length() > 0 ? this.edit.getText() + ";" : "") + this.elements.getSelectedItem().toString());
        this.elements.remove(this.elements.getSelectedIndex());
        this.elements.setSelectedIndex(0);
    }

    public void setOptions(List<String> itemNames) {
        if (itemNames == null) {
            this.elements.removeAllItems();
        } else {
            for (String item : itemNames) {
                this.elements.addItem(item);
            }
        }
    }

    public void setText(List<String> itemNames) {
        if (itemNames == null) {
            this.edit.setText("");
        } else {
            this.edit.setText(String.join((CharSequence)";", itemNames));
        }
    }

    public void setText(String[] itemName) {
        if (itemName == null) {
            this.edit.setText("");
        } else {
            this.edit.setText(String.join((CharSequence)";", itemName));
        }
    }

    public void setText(int[] intValues) {
        if (intValues == null) {
            this.edit.setText("");
            return;
        }
        StringBuilder values = new StringBuilder();
        for (int i = 0; i < intValues.length; ++i) {
            values.append(intValues[i]);
            if (intValues.length <= i + 2) continue;
            values.append("\n");
        }
        this.edit.setText(values.toString());
    }

    public String[] getList() {
        return this.edit.getText().isEmpty() ? null : this.edit.getText().split(";");
    }

    public int[] getListAsInt() {
        if (this.edit.getText().isEmpty()) {
            return null;
        }
        String[] stringList = this.getList();
        int[] retList = new int[stringList.length];
        for (int i = 0; i < retList.length; ++i) {
            String intName = stringList[i];
            try {
                retList[i] = Integer.parseInt(intName);
                continue;
            }
            catch (NumberFormatException e) {
                retList[i] = 0;
            }
        }
        return retList;
    }
}

