/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.BiomeData;
import forge.adventure.data.BiomeTerrainData;
import forge.adventure.editor.BiomeTerrainEdit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TerrainsEditor
extends JComponent {
    DefaultListModel<BiomeTerrainData> model = new DefaultListModel();
    JList<BiomeTerrainData> list = new JList<BiomeTerrainData>(this.model);
    JToolBar toolBar = new JToolBar("toolbar");
    BiomeTerrainEdit edit = new BiomeTerrainEdit();
    BiomeData currentData;

    public void addButton(String name, ActionListener action) {
        JButton newButton = new JButton(name);
        newButton.addActionListener(action);
        this.toolBar.add(newButton);
    }

    public TerrainsEditor() {
        this.list.setCellRenderer(new TerrainDataRenderer());
        this.list.addListSelectionListener(e -> this.updateEdit());
        this.addButton("add", e -> this.addTerrain());
        this.addButton("remove", e -> this.remove());
        this.addButton("copy", e -> this.copy());
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add(this.list, "Before");
        this.add((Component)this.toolBar, "First");
        this.add((Component)this.edit, "Center");
        this.edit.addChangeListener(e -> this.emitChanged());
    }

    protected void emitChanged() {
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        if (listeners != null && listeners.length > 0) {
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    private void copy() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        BiomeTerrainData data = new BiomeTerrainData(this.model.get(selected));
        this.model.add(this.model.size(), data);
    }

    private void updateEdit() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.edit.setCurrentTerrain(this.model.get(selected), this.currentData);
    }

    void addTerrain() {
        BiomeTerrainData data = new BiomeTerrainData();
        this.model.add(this.model.size(), data);
    }

    void remove() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.model.remove(selected);
    }

    public void setTerrains(BiomeData data) {
        this.currentData = data;
        this.model.clear();
        if (data == null || data.terrain == null) {
            return;
        }
        for (int i = 0; i < data.terrain.length; ++i) {
            this.model.add(i, data.terrain[i]);
        }
        this.list.setSelectedIndex(0);
    }

    public BiomeTerrainData[] getBiomeTerrainData() {
        BiomeTerrainData[] rewards = new BiomeTerrainData[this.model.getSize()];
        for (int i = 0; i < this.model.getSize(); ++i) {
            rewards[i] = this.model.get(i);
        }
        return rewards;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public class TerrainDataRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof BiomeTerrainData)) {
                return label;
            }
            BiomeTerrainData terrainData = (BiomeTerrainData)value;
            StringBuilder builder = new StringBuilder();
            builder.append("Terrain");
            builder.append(" ");
            builder.append(terrainData.spriteName);
            label.setText(builder.toString());
            return label;
        }
    }
}

