/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.editor.SwingAtlas;
import forge.adventure.util.Config;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.apache.commons.lang3.tuple.Pair;

public class SwingAtlasPreview
extends Box {
    int imageSize = 32;
    private String sprite = "";
    private String spriteName = "";
    Timer timer;
    static Map<String, Map<Integer, SwingAtlas>> cache = new HashMap<String, Map<Integer, SwingAtlas>>();
    int counter = 0;
    List<Pair<JLabel, ArrayList<ImageIcon>>> labels = new ArrayList<Pair<JLabel, ArrayList<ImageIcon>>>();

    public SwingAtlasPreview() {
        this(64, 200);
    }

    public SwingAtlasPreview(int imageSize, int timeDelay) {
        super(1);
        this.timer = new Timer(timeDelay, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ++SwingAtlasPreview.this.counter;
                for (Pair<JLabel, ArrayList<ImageIcon>> element : SwingAtlasPreview.this.labels) {
                    element.getKey().setIcon(element.getValue().get(SwingAtlasPreview.this.counter % element.getValue().size()));
                }
            }
        });
        this.imageSize = imageSize;
    }

    public SwingAtlasPreview(int size) {
        this();
        this.imageSize = size;
    }

    public void setSpritePath(String sprite) {
        this.setSpritePath(sprite, null);
    }

    public void setSpritePath(String sprite, String name) {
        if (this.sprite == null || sprite == null || this.sprite.equals(sprite) && this.spriteName != null && this.spriteName.equals(name)) {
            return;
        }
        this.removeAll();
        this.counter = 0;
        this.labels.clear();
        this.sprite = sprite;
        this.spriteName = name;
        if (!cache.containsKey(sprite)) {
            cache.put(sprite, new HashMap());
        }
        if (!cache.get(sprite).containsKey(this.imageSize)) {
            cache.get(sprite).put(this.imageSize, new SwingAtlas(Config.instance().getFile(sprite), this.imageSize));
        }
        SwingAtlas atlas = cache.get(sprite).get(this.imageSize);
        int maxCount = 0;
        for (Map.Entry<String, ArrayList<ImageIcon>> element : atlas.getImages().entrySet()) {
            if (name != null && !element.getKey().equals(name)) continue;
            JLabel image = new JLabel(element.getValue().get(0));
            if (maxCount < element.getValue().size()) {
                maxCount = element.getValue().size();
            }
            this.add(new JLabel(element.getKey()));
            this.add(image);
            this.labels.add(Pair.of(image, element.getValue()));
        }
        if (maxCount <= 1) {
            this.timer.stop();
        } else {
            this.timer.restart();
        }
    }
}

