/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class SwingAtlas {
    int imageSize = 32;
    HashMap<String, ArrayList<ImageIcon>> images = new HashMap();

    public HashMap<String, ArrayList<ImageIcon>> getImages() {
        return this.images;
    }

    public SwingAtlas(FileHandle path, int imageSize) {
        this.imageSize = imageSize;
        if (!path.exists() || !path.toString().endsWith(".atlas")) {
            return;
        }
        TextureAtlas.TextureAtlasData data = new TextureAtlas.TextureAtlasData(path, path.parent(), false);
        for (TextureAtlas.TextureAtlasData.Region region : new Array.ArrayIterator<TextureAtlas.TextureAtlasData.Region>(data.getRegions())) {
            String name = region.name;
            if (!this.images.containsKey(name)) {
                this.images.put(name, new ArrayList());
            }
            ArrayList<ImageIcon> imageList = this.images.get(name);
            try {
                imageList.add(this.spriteToImage(region));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public SwingAtlas(FileHandle path) {
        this(path, 32);
    }

    private ImageIcon spriteToImage(TextureAtlas.TextureAtlasData.Region sprite) throws IOException {
        try {
            BufferedImage img = ImageIO.read(sprite.page.textureFile.file());
            if (sprite.width == sprite.height) {
                return new ImageIcon(img.getSubimage(sprite.left, sprite.top, sprite.width, sprite.height).getScaledInstance(this.imageSize, this.imageSize, 2));
            }
            if (sprite.width > sprite.height) {
                return new ImageIcon(img.getSubimage(sprite.left, sprite.top, sprite.width, sprite.height).getScaledInstance(this.imageSize, (int)((float)this.imageSize * ((float)sprite.height / (float)sprite.width)), 2));
            }
            return new ImageIcon(img.getSubimage(sprite.left, sprite.top, sprite.width, sprite.height).getScaledInstance((int)((float)this.imageSize * ((float)sprite.width / (float)sprite.height)), this.imageSize, 2));
        }
        catch (IOException e) {
            return null;
        }
    }

    public ImageIcon get(String name) {
        if (this.images.get(name).size() == 0) {
            return null;
        }
        return this.images.get(name).get(0);
    }

    public boolean has(String name) {
        return this.images.containsKey(name);
    }

    public ImageIcon getAny() {
        if (this.images.isEmpty()) {
            return null;
        }
        ArrayList<ImageIcon> imageList = this.images.get(this.images.keySet().iterator().next());
        if (imageList.isEmpty()) {
            return null;
        }
        return imageList.get(0);
    }
}

