/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import com.badlogic.gdx.graphics.Color;
import forge.adventure.data.BiomeData;
import forge.adventure.data.BiomeStructureData;
import forge.adventure.editor.BiomeStructureEdit;
import forge.adventure.editor.EditorMainWindow;
import forge.adventure.util.Config;
import forge.adventure.world.BiomeStructure;
import forge.adventure.world.ColorMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StructureEditor
extends JComponent {
    DefaultListModel<BiomeStructureData> model = new DefaultListModel();
    JList<BiomeStructureData> list = new JList<BiomeStructureData>(this.model);
    JToolBar toolBar = new JToolBar("toolbar");
    BiomeStructureEdit edit = new BiomeStructureEdit();
    BiomeData currentData;

    public void addButton(String name, ActionListener action) {
        JButton newButton = new JButton(name);
        newButton.addActionListener(action);
        this.toolBar.add(newButton);
    }

    public StructureEditor() {
        this.list.setCellRenderer(new StructureDataRenderer());
        this.list.addListSelectionListener(e -> this.updateEdit());
        this.addButton("add", e -> this.addStructure());
        this.addButton("remove", e -> this.remove());
        this.addButton("copy", e -> this.copy());
        this.addButton("test", e -> this.test());
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add(this.list, "West");
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.edit, "Center");
        this.edit.addChangeListener(e -> this.emitChanged());
    }

    protected void emitChanged() {
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        if (listeners != null && listeners.length > 0) {
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    private void test() {
        if (this.list.isSelectionEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        BiomeStructureData data = this.model.get(this.list.getSelectedIndex());
        try {
            BiomeStructure struct = new BiomeStructure(data, System.currentTimeMillis(), (int)(this.currentData.width * (float)EditorMainWindow.worldEditor.width.intValue()), (int)(this.currentData.width * (float)EditorMainWindow.worldEditor.height.intValue()));
            BufferedImage sourceImage = null;
            try {
                sourceImage = ImageIO.read(new File(struct.sourceImagePath()));
                ColorMap sourceColorMap = new ColorMap(sourceImage.getWidth(), sourceImage.getHeight());
                for (int y = 0; y < sourceColorMap.getHeight(); ++y) {
                    for (int x = 0; x < sourceColorMap.getWidth(); ++x) {
                        Color c = new Color();
                        Color.argb8888ToColor(c, sourceImage.getRGB(x, y));
                        sourceColorMap.setColor(x, y, c);
                    }
                }
                BufferedImage maskImage = ImageIO.read(new File(struct.maskImagePath()));
                ColorMap maskColorMap = new ColorMap(maskImage.getWidth(), maskImage.getHeight());
                for (int y = 0; y < maskColorMap.getHeight(); ++y) {
                    for (int x = 0; x < maskColorMap.getWidth(); ++x) {
                        Color c = new Color();
                        Color.argb8888ToColor(c, maskImage.getRGB(x, y));
                        maskColorMap.setColor(x, y, c);
                    }
                }
                struct.initialize(sourceColorMap, maskColorMap);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            float calcTime = (float)(System.currentTimeMillis() - start) / 1000.0f;
            JLabel label = new JLabel();
            ColorMap colorMap = struct.image;
            BufferedImage image = new BufferedImage(colorMap.getWidth(), colorMap.getHeight(), 2);
            for (int y = 0; y < colorMap.getHeight(); ++y) {
                for (int x = 0; x < colorMap.getWidth(); ++x) {
                    image.setRGB(x, y, Color.argb8888(colorMap.getColor(x, y)));
                }
            }
            if (image.getWidth() < 640 | image.getHeight() < 640) {
                if (image.getHeight() > image.getWidth()) {
                    BufferedImage nimage = new BufferedImage(640, 640 * (image.getWidth() / image.getHeight()), 2);
                    AffineTransform at = new AffineTransform();
                    at.scale(640 / image.getHeight(), 640 / image.getHeight());
                    AffineTransformOp scaleOp = new AffineTransformOp(at, 1);
                    image = scaleOp.filter(image, nimage);
                } else {
                    BufferedImage nimage = new BufferedImage(640 * (image.getHeight() / image.getWidth()), 640, 2);
                    AffineTransform at = new AffineTransform();
                    at.scale(640 / image.getWidth(), 640 / image.getWidth());
                    AffineTransformOp scaleOp = new AffineTransformOp(at, 1);
                    image = scaleOp.filter(image, nimage);
                }
            }
            label.setIcon(new ImageIcon(image));
            label.setSize(640, 640);
            JOptionPane.showMessageDialog(this, label, "Calculating took " + calcTime + " seconds", -1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "WaveFunctionCollapse was not successful", "can not calculate function " + e.getMessage(), 0);
        }
    }

    private void copy() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        BiomeStructureData data = new BiomeStructureData(this.model.get(selected));
        this.model.add(this.model.size(), data);
    }

    private void updateEdit() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.edit.setCurrentStructure(this.model.get(selected), this.currentData);
    }

    void addStructure() {
        BiomeStructureData data = new BiomeStructureData();
        this.model.add(this.model.size(), data);
    }

    void remove() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.model.remove(selected);
    }

    public void setStructures(BiomeData data) {
        this.currentData = data;
        this.model.clear();
        if (data == null || data.structures == null) {
            this.edit.setCurrentStructure(null, null);
            return;
        }
        for (int i = 0; i < data.structures.length; ++i) {
            this.model.add(i, data.structures[i]);
        }
        this.list.setSelectedIndex(0);
    }

    public BiomeStructureData[] getBiomeStructureData() {
        BiomeStructureData[] rewards = new BiomeStructureData[this.model.getSize()];
        for (int i = 0; i < this.model.getSize(); ++i) {
            rewards[i] = this.model.get(i);
        }
        return rewards;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public class StructureDataRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof BiomeStructureData)) {
                return label;
            }
            BiomeStructureData structureData = (BiomeStructureData)value;
            label.setText("Structure");
            label.setIcon(new ImageIcon(Config.instance().getFilePath(structureData.sourcePath)));
            return label;
        }
    }
}

