/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.RewardData;
import forge.adventure.editor.RewardEdit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RewardsEditor
extends JComponent {
    DefaultListModel<RewardData> model = new DefaultListModel();
    JList<RewardData> list = new JList<RewardData>(this.model);
    JToolBar toolBar = new JToolBar("toolbar");
    RewardEdit edit = new RewardEdit();
    boolean updating;

    public void addButton(String name, ActionListener action) {
        JButton newButton = new JButton(name);
        newButton.addActionListener(action);
        this.toolBar.add(newButton);
    }

    public RewardsEditor() {
        this.list.setCellRenderer(new RewardDataRenderer());
        this.list.addListSelectionListener(e -> this.updateEdit());
        this.addButton("add", e -> this.addReward());
        this.addButton("remove", e -> this.remove());
        this.addButton("copy", e -> this.copy());
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add(this.list, "Before");
        this.add((Component)this.toolBar, "First");
        this.add((Component)this.edit, "Center");
        this.edit.addChangeListener(e -> this.emitChanged());
    }

    protected void emitChanged() {
        if (this.updating) {
            return;
        }
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        if (listeners != null && listeners.length > 0) {
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    private void copy() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        RewardData data = new RewardData(this.model.get(selected));
        this.model.add(this.model.size(), data);
    }

    private void updateEdit() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.edit.setCurrentReward(this.model.get(selected));
    }

    void addReward() {
        RewardData data = new RewardData();
        this.model.add(this.model.size(), data);
    }

    void remove() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.model.remove(selected);
    }

    public void setRewards(RewardData[] rewards) {
        this.model.clear();
        if (rewards == null) {
            return;
        }
        for (int i = 0; i < rewards.length; ++i) {
            this.model.add(i, rewards[i]);
        }
    }

    public RewardData[] getRewards() {
        RewardData[] rewards = new RewardData[this.model.getSize()];
        for (int i = 0; i < this.model.getSize(); ++i) {
            rewards[i] = this.model.get(i);
        }
        return rewards;
    }

    public void clear() {
        this.updating = true;
        this.model.clear();
        this.updating = false;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public class RewardDataRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof RewardData)) {
                return label;
            }
            RewardData reward = (RewardData)value;
            StringBuilder builder = new StringBuilder();
            if (reward.type == null || reward.type.isEmpty()) {
                builder.append("Reward");
            } else {
                builder.append(reward.type);
            }
            builder.append(" ");
            builder.append(reward.count);
            if (reward.addMaxCount > 0) {
                builder.append("-");
                builder.append(reward.count + reward.addMaxCount);
            }
            label.setText(builder.toString());
            return label;
        }
    }
}

