/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.RewardData;
import forge.adventure.editor.DocumentChangeListener;
import forge.adventure.editor.FormPanel;
import forge.adventure.editor.TextListEdit;
import forge.card.CardType;
import forge.game.keyword.Keyword;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RewardEdit
extends FormPanel {
    RewardData currentData;
    JComboBox typeField = new JComboBox<String>(new String[]{"card", "gold", "life", "deckCard", "item", "shards"});
    JSpinner probability = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.1f));
    JSpinner count = new JSpinner(new SpinnerNumberModel(0, 0, 1000, 1));
    JSpinner addMaxCount = new JSpinner(new SpinnerNumberModel(0, 0, 1000, 1));
    JTextField cardName = new JTextField();
    JTextField itemName = new JTextField();
    TextListEdit editions = new TextListEdit();
    TextListEdit colors = new TextListEdit(new String[]{"White", "Blue", "Black", "Red", "Green"});
    TextListEdit rarity = new TextListEdit(new String[]{"Basic Land", "Common", "Uncommon", "Rare", "Mythic Rare"});
    TextListEdit subTypes = new TextListEdit();
    TextListEdit cardTypes = new TextListEdit((String[])Arrays.asList(CardType.CoreType.values()).stream().map(Enum::toString).toArray(String[]::new));
    TextListEdit superTypes = new TextListEdit((String[])Arrays.asList(CardType.Supertype.values()).stream().map(Enum::toString).toArray(String[]::new));
    TextListEdit manaCosts = new TextListEdit();
    TextListEdit keyWords = new TextListEdit((String[])Arrays.asList(Keyword.values()).stream().map(Keyword::toString).toArray(String[]::new));
    JComboBox colorType = new JComboBox<String>(new String[]{"Any", "Colorless", "MultiColor", "MonoColor"});
    JTextField cardText = new JTextField();
    private boolean updating = false;

    public RewardEdit() {
        this.add("Type:", (JComponent)this.typeField);
        this.add("probability:", (JComponent)this.probability);
        this.add("count:", (JComponent)this.count);
        this.add("addMaxCount:", (JComponent)this.addMaxCount);
        this.add("cardName:", (JComponent)this.cardName);
        this.add("itemName:", (JComponent)this.itemName);
        this.add("editions:", (JComponent)this.editions);
        this.add("colors:", (JComponent)this.colors);
        this.add("rarity:", (JComponent)this.rarity);
        this.add("subTypes:", (JComponent)this.subTypes);
        this.add("cardTypes:", (JComponent)this.cardTypes);
        this.add("superTypes:", (JComponent)this.superTypes);
        this.add("manaCosts:", (JComponent)this.manaCosts);
        this.add("keyWords:", (JComponent)this.keyWords);
        this.add("colorType:", (JComponent)this.colorType);
        this.add("cardText:", (JComponent)this.cardText);
        this.typeField.addActionListener(e -> this.updateReward());
        this.probability.addChangeListener(e -> this.updateReward());
        this.count.addChangeListener(e -> this.updateReward());
        this.addMaxCount.addChangeListener(e -> this.updateReward());
        this.cardName.getDocument().addDocumentListener(new DocumentChangeListener(this::updateReward));
        this.itemName.getDocument().addDocumentListener(new DocumentChangeListener(this::updateReward));
        this.editions.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateReward));
        this.colors.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateReward));
        this.rarity.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateReward));
        this.subTypes.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateReward));
        this.cardTypes.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateReward));
        this.superTypes.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateReward));
        this.manaCosts.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateReward));
        this.keyWords.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateReward));
        this.colorType.addActionListener(e -> this.updateReward());
        this.cardText.getDocument().addDocumentListener(new DocumentChangeListener(this::updateReward));
    }

    private void updateReward() {
        if (this.currentData == null || this.updating) {
            return;
        }
        this.currentData.type = this.typeField.getSelectedItem() == null ? null : this.typeField.getSelectedItem().toString();
        this.currentData.probability = ((Double)this.probability.getValue()).floatValue();
        this.currentData.count = (Integer)this.count.getValue();
        this.currentData.addMaxCount = (Integer)this.addMaxCount.getValue();
        this.currentData.cardName = this.cardName.getText().isEmpty() ? null : this.cardName.getText();
        this.currentData.itemNames = this.itemName.getText().isEmpty() ? null : this.itemName.getText().split(",");
        this.currentData.editions = this.editions.getList();
        this.currentData.colors = this.colors.getList();
        this.currentData.rarity = this.rarity.getList();
        this.currentData.subTypes = this.subTypes.getList();
        this.currentData.cardTypes = this.cardTypes.getList();
        this.currentData.superTypes = this.superTypes.getList();
        this.currentData.manaCosts = this.manaCosts.getListAsInt();
        this.currentData.keyWords = this.keyWords.getList();
        this.currentData.colorType = this.colorType.getSelectedItem() == null ? null : this.colorType.getSelectedItem().toString();
        this.currentData.cardText = this.cardText.getText().isEmpty() ? null : this.cardText.getText();
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        if (listeners != null && listeners.length > 0) {
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void setCurrentReward(RewardData data) {
        this.currentData = data;
        this.refresh();
    }

    private void refresh() {
        this.setEnabled(this.currentData != null);
        if (this.currentData == null) {
            return;
        }
        this.updating = true;
        this.typeField.setSelectedItem(this.currentData.type);
        this.probability.setValue(this.currentData.probability);
        this.count.setValue(this.currentData.count);
        this.addMaxCount.setValue(this.currentData.addMaxCount);
        this.cardName.setText(this.currentData.cardName);
        this.itemName.setText(this.currentData.itemName);
        this.editions.setText(this.currentData.editions);
        this.colors.setText(this.currentData.colors);
        this.rarity.setText(this.currentData.rarity);
        this.subTypes.setText(this.currentData.subTypes);
        this.cardTypes.setText(this.currentData.cardTypes);
        this.superTypes.setText(this.currentData.superTypes);
        this.manaCosts.setText(this.currentData.manaCosts);
        this.keyWords.setText(this.currentData.keyWords);
        this.colorType.setSelectedItem(this.currentData.colorType);
        this.cardText.setText(this.currentData.cardText);
        this.updating = false;
    }
}

