/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.editor.QuestController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class QuestTagSelector
extends JComponent {
    DefaultListModel<String> allItems = new DefaultListModel();
    DefaultListModel<String> selectedItems = new DefaultListModel();
    JList<String> unselectedList;
    JList<String> selectedList;
    boolean useEnemyTags = false;
    boolean usePOITags = false;
    private boolean updating = false;

    public QuestTagSelector(String title, boolean useEnemyTags, boolean usePOITags) {
        if (useEnemyTags) {
            this.useEnemyTags = true;
        } else if (usePOITags) {
            this.usePOITags = true;
        } else {
            return;
        }
        this.unselectedList = new JList<String>(this.allItems);
        this.selectedList = new JList<String>(this.selectedItems);
        JButton addButton = new JButton("add");
        JButton removeButton = new JButton("remove");
        addButton.addActionListener(e -> this.addTag());
        removeButton.addActionListener(e -> this.removeTag());
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        if (title.length() > 0) {
            this.add((Component)new JLabel(title), "First");
        }
        this.add((Component)new JScrollPane(this.unselectedList), "Before");
        this.add((Component)new JScrollPane(this.selectedList), "After");
        JPanel buttonPanel = new JPanel();
        GridLayout buttonLayout = new GridLayout(2, 0);
        buttonPanel.setLayout(buttonLayout);
        buttonPanel.add(addButton);
        buttonPanel.add(removeButton);
        this.add(buttonPanel);
    }

    public void addTag() {
        if (this.unselectedList.isSelectionEmpty()) {
            return;
        }
        for (String toAdd : this.unselectedList.getSelectedValuesList()) {
            if (this.selectedItems.contains(toAdd)) continue;
            this.selectedItems.addElement(toAdd);
        }
        this.refresh();
    }

    public void removeTag() {
        if (this.selectedList.isSelectionEmpty()) {
            return;
        }
        for (String toRemove : this.selectedList.getSelectedValuesList()) {
            this.selectedItems.removeElement(toRemove);
        }
        this.refresh();
    }

    public void load(DefaultListModel<String> selectedNames) {
        this.allItems.clear();
        this.selectedItems.clear();
        if (this.useEnemyTags) {
            this.allItems = QuestController.getInstance().getEnemyTags();
        } else if (this.usePOITags) {
            this.allItems = QuestController.getInstance().getPOITags();
        }
        this.unselectedList.setModel(this.allItems);
        for (int i = 0; i < this.allItems.size(); ++i) {
            if (!selectedNames.contains(this.allItems.get(i))) continue;
            this.selectedItems.addElement(this.allItems.get(i));
        }
    }

    private void refresh() {
        this.setEnabled(this.allItems != null);
        if (this.allItems == null) {
            return;
        }
        this.updating = true;
        this.updating = false;
    }
}

