/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.AdventureQuestData;
import forge.adventure.data.AdventureQuestStage;
import forge.adventure.editor.QuestStageEdit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class QuestStageEditor
extends JComponent {
    DefaultListModel<AdventureQuestStage> model = new DefaultListModel();
    JList<AdventureQuestStage> list = new JList<AdventureQuestStage>(this.model);
    JScrollPane scroll;
    JToolBar toolBar = new JToolBar("toolbar");
    QuestStageEdit edit = new QuestStageEdit();
    AdventureQuestData currentData;

    public void addButton(String name, ActionListener action) {
        JButton newButton = new JButton(name);
        newButton.addActionListener(action);
        this.toolBar.add(newButton);
    }

    public QuestStageEditor() {
        this.list.setCellRenderer(new QuestStageRenderer());
        this.list.addListSelectionListener(e -> this.updateEdit());
        this.addButton("Add Quest Stage", e -> this.addStage());
        this.addButton("Remove Selected", e -> this.remove());
        this.toolBar.setFloatable(false);
        this.setLayout(new BorderLayout());
        this.scroll = new JScrollPane(this.list);
        this.add((Component)this.scroll, "West");
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new BorderLayout());
        this.add((Component)this.toolBar, "North");
        editPanel.add((Component)this.edit, "Center");
        this.add(editPanel);
        this.edit.addChangeListener(e -> this.emitChanged());
    }

    protected void emitChanged() {
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        if (listeners != null && listeners.length > 0) {
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    private void updateEdit() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.edit.setCurrentStage(this.model.get(selected), this.currentData);
    }

    void addStage() {
        AdventureQuestStage data = new AdventureQuestStage();
        data.name = "New Stage";
        this.model.add(this.model.size(), data);
        this.edit.setVisible(true);
        this.scroll.setVisible(true);
        int id = 0;
        for (int i = 0; i < this.model.size(); ++i) {
            if (this.model.get((int)i).id < id) continue;
            id = this.model.get((int)i).id + 1;
        }
        data.id = id;
        if (this.model.size() == 1) {
            this.list.setSelectedIndex(0);
        }
        this.emitChanged();
    }

    void remove() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.model.remove(selected);
        this.edit.setVisible(false);
        this.scroll.setVisible(this.list.getModel().getSize() > 0);
        this.emitChanged();
    }

    public void setStages(AdventureQuestData data) {
        this.currentData = data;
        this.model.clear();
        if (data == null || data.stages == null || data.stages.length == 0) {
            this.edit.setVisible(false);
            return;
        }
        for (int i = 0; i < data.stages.length; ++i) {
            this.model.add(i, data.stages[i]);
        }
        if (this.model.size() > 0) {
            this.list.setSelectedIndex(0);
        }
    }

    public AdventureQuestStage[] getStages() {
        AdventureQuestStage[] stages = new AdventureQuestStage[this.model.getSize()];
        for (int i = 0; i < this.model.getSize(); ++i) {
            stages[i] = this.model.get(i);
        }
        return stages;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public class QuestStageRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof AdventureQuestStage)) {
                return label;
            }
            AdventureQuestStage stageData = (AdventureQuestStage)value;
            label.setText(stageData.name);
            return label;
        }
    }
}

