/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.AdventureQuestData;
import forge.adventure.data.AdventureQuestStage;
import forge.adventure.editor.DialogEditor;
import forge.adventure.editor.DocumentChangeListener;
import forge.adventure.editor.FormPanel;
import forge.adventure.editor.QuestTagSelector;
import forge.adventure.editor.TextListEdit;
import forge.adventure.util.AdventureQuestController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class QuestStageEdit
extends FormPanel {
    private boolean updating = false;
    AdventureQuestStage currentData;
    AdventureQuestData currentQuestData;
    public JTextField name = new JTextField("", 25);
    public JTextField description = new JTextField("", 25);
    public TextListEdit itemNames = new TextListEdit();
    public TextListEdit spriteNames = new TextListEdit();
    public TextListEdit equipNames = new TextListEdit();
    public TextListEdit prerequisites;
    JTabbedPane tabs;
    DialogEditor prologueEditor;
    DialogEditor epilogueEditor;
    private JComboBox<AdventureQuestController.ObjectiveTypes> objectiveType;
    private final JLabel nyi;
    private final JTextField deliveryItem;
    private final JTextField mapFlag;
    private Box mapFlagGroup;
    private final JSpinner flagSpinner;
    private Box flagValueGroup;
    private final JRadioButton anyPOI;
    private final JRadioButton specificPOI;
    private final ButtonGroup anyPOIGroup;
    private final JCheckBox here;
    private final JCheckBox mixedEnemies;
    private final JLabel count1Description;
    private final JLabel count2Description;
    private final JLabel count3Description;
    private final JLabel count4Description;
    private final JSpinner count1Spinner;
    private final JSpinner count2Spinner;
    private final JSpinner count3Spinner;
    private final JSpinner count4Spinner;
    private final JLabel arenaLabel;
    private final JLabel characterFlagLabel;
    private final JLabel clearLabel;
    private final JLabel completeQuestLabel;
    private final JLabel defeatLabel;
    private final JLabel deliveryLabel;
    private final JLabel escortLabel;
    private final JLabel eventFinishLabel;
    private final JLabel eventWinLabel;
    private final JLabel eventWinMatchLabel;
    private final JLabel fetchLabel;
    private final JLabel findLabel;
    private final JLabel gatherLabel;
    private final JLabel giveLabel;
    private final JLabel haveReputationLabel;
    private final JLabel haveReputationInCurrentLocationLabel;
    private final JLabel huntLabel;
    private final JLabel leaveLabel;
    private final JLabel mapFlagLabel;
    private final JLabel noneLabel;
    private final JLabel patrolLabel;
    private final JLabel rescueLabel;
    private final JLabel siegeLabel;
    private final JLabel questFlagLabel;
    private final JLabel travelLabel;
    private final JLabel useLabel;
    private JTabbedPane poiPane;
    private final QuestTagSelector poiSelector;
    private final QuestTagSelector enemySelector;
    private final JTextField poiTokenInput;
    private final JLabel poiTokenLabel;
    private final JLabel poiTokenDescription;

    public QuestStageEdit() {
        this.prerequisites = new TextListEdit(this.currentQuestData != null ? (String[])Arrays.stream(this.currentQuestData.stages).filter(q -> !q.equals(this.currentData)).toArray() : new String[]{});
        this.tabs = new JTabbedPane();
        this.prologueEditor = new DialogEditor();
        this.epilogueEditor = new DialogEditor();
        this.nyi = new JLabel("Not yet implemented");
        this.deliveryItem = new JTextField(25);
        this.mapFlag = new JTextField(25);
        this.flagSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 1000, 1));
        this.anyPOI = new JRadioButton("Any Point of Interest matching tags is valid");
        this.specificPOI = new JRadioButton("Only a specific Point of Interest is valid");
        this.anyPOIGroup = new ButtonGroup();
        this.here = new JCheckBox("Use current map instead of selecting tags");
        this.mixedEnemies = new JCheckBox("Mixture of enemy types matching");
        this.count1Description = new JLabel("(Count 1 description)");
        this.count2Description = new JLabel("(Count 2 description)");
        this.count3Description = new JLabel("(Count 3 description)");
        this.count4Description = new JLabel("(Count 4 description)");
        this.count1Spinner = new JSpinner(new SpinnerNumberModel(1, 0, 100, 1));
        this.count2Spinner = new JSpinner(new SpinnerNumberModel(1, 0, 100, 1));
        this.count3Spinner = new JSpinner(new SpinnerNumberModel(1, 0, 100, 1));
        this.count4Spinner = new JSpinner(new SpinnerNumberModel(1, 0, 100, 1));
        this.arenaLabel = new JLabel("Enter the arena and prove your worth. (Note: Please be sure the PoIs selected have an arena)");
        this.characterFlagLabel = new JLabel("Have the selected character flag set to a given value. (Caution: You're probably looking for QuestFlag or MapFlag instead)");
        this.clearLabel = new JLabel("Clear all enemies from the target area.");
        this.completeQuestLabel = new JLabel("Complete other quests issued by target POI. Primarily used for busy work as a part of storyline quests.");
        this.defeatLabel = new JLabel("Defeat a number of enemies of the indicated type.");
        this.deliveryLabel = new JLabel("Travel to the given destination to deliver an item (not tracked in inventory).");
        this.escortLabel = new JLabel("Protect your target as they travel to their destination.");
        this.eventFinishLabel = new JLabel("Finish (win or lose) tavern events");
        this.eventWinLabel = new JLabel("Finish and win tavern events");
        this.eventWinMatchLabel = new JLabel("Win individual matches in tavern events");
        this.fetchLabel = new JLabel("Obtain the requested items (not tracked in inventory).");
        this.findLabel = new JLabel("Locate the and enter a PoI.");
        this.gatherLabel = new JLabel("Have the requested item in your inventory (tracked in inventory)");
        this.giveLabel = new JLabel("Have the requested items removed from your inventory.");
        this.haveReputationLabel = new JLabel("Have a minimum reputation in the selected PoI");
        this.haveReputationInCurrentLocationLabel = new JLabel("Have a minimum reputation in the selected PoI (and be in it)");
        this.huntLabel = new JLabel("Track down and defeat your target (on the overworld map).");
        this.leaveLabel = new JLabel("Exit the current PoI and return to the overworld map.");
        this.mapFlagLabel = new JLabel("Have a map flag set to a minimum value");
        this.noneLabel = new JLabel("No visible objective. Use in coordination with hidden parallel objectives to track when to progress");
        this.patrolLabel = new JLabel("Get close to generated coordinates before starting your next objective");
        this.rescueLabel = new JLabel("Reach and rescue the target");
        this.siegeLabel = new JLabel("Travel to the target location and defeat enemies attacking it");
        this.questFlagLabel = new JLabel("Have a global quest flag set to a minimum value");
        this.travelLabel = new JLabel("Travel to the given destination.");
        this.useLabel = new JLabel("Use the indicated item from your inventory.");
        this.poiPane = new JTabbedPane();
        this.poiSelector = new QuestTagSelector("Destination Tags", false, true);
        this.enemySelector = new QuestTagSelector("Enemy Tags", true, false);
        this.poiTokenInput = new JTextField(25);
        this.poiTokenLabel = new JLabel();
        this.poiTokenDescription = new JLabel("At the bottom of many objectives involving a PoI, you will see a text field in the format of '$poi_#'.Enter that tag here to ignore the PoI tag selector of this stage and instead use the same PoI that was selected for that stage as the target PoI for this one as well.");
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getInfoTab());
        this.add(this.tabs);
        this.tabs.add("Objective", this.getObjectiveTab());
        this.tabs.add("Prologue", this.getPrologueTab());
        this.tabs.add("Epilogue", this.getEpilogueTab());
        this.tabs.add("Prerequisites", this.getPrereqTab());
        this.nyi.setForeground(Color.red);
        this.addListeners();
    }

    public JPanel getInfoTab() {
        JPanel infoTab = new JPanel();
        FormPanel center = new FormPanel();
        center.add("name:", (JComponent)this.name);
        center.add("description:", (JComponent)this.description);
        this.name.setSize(400, this.name.getHeight());
        this.description.setSize(400, this.description.getHeight());
        infoTab.add(center);
        this.name.getDocument().addDocumentListener(new DocumentChangeListener(this::updateStage));
        this.description.getDocument().addDocumentListener(new DocumentChangeListener(this::updateStage));
        this.prerequisites.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateStage));
        return infoTab;
    }

    public JPanel getPrologueTab() {
        JPanel prologueTab = new JPanel();
        prologueTab.setLayout(new BoxLayout(prologueTab, 1));
        FormPanel center = new FormPanel();
        center.add(this.prologueEditor);
        prologueTab.add(center);
        return prologueTab;
    }

    public JPanel getEpilogueTab() {
        JPanel epilogueTab = new JPanel();
        epilogueTab.setLayout(new BoxLayout(epilogueTab, 1));
        FormPanel center = new FormPanel();
        center.add(this.epilogueEditor);
        epilogueTab.add(center);
        return epilogueTab;
    }

    private void hideAllControls() {
        this.arenaLabel.setVisible(false);
        this.clearLabel.setVisible(false);
        this.deliveryLabel.setVisible(false);
        this.defeatLabel.setVisible(false);
        this.escortLabel.setVisible(false);
        this.fetchLabel.setVisible(false);
        this.findLabel.setVisible(false);
        this.gatherLabel.setVisible(false);
        this.giveLabel.setVisible(false);
        this.haveReputationLabel.setVisible(false);
        this.huntLabel.setVisible(false);
        this.leaveLabel.setVisible(false);
        this.noneLabel.setVisible(false);
        this.patrolLabel.setVisible(false);
        this.rescueLabel.setVisible(false);
        this.siegeLabel.setVisible(false);
        this.mapFlagLabel.setVisible(false);
        this.questFlagLabel.setVisible(false);
        this.travelLabel.setVisible(false);
        this.useLabel.setVisible(false);
        this.deliveryItem.setVisible(false);
        this.mapFlagGroup.setVisible(false);
        this.flagValueGroup.setVisible(false);
        this.anyPOI.setVisible(false);
        this.specificPOI.setVisible(false);
        this.here.setVisible(false);
        this.mixedEnemies.setVisible(false);
        this.enemySelector.setVisible(false);
        this.count1Description.setVisible(false);
        this.count2Description.setVisible(false);
        this.count3Description.setVisible(false);
        this.count4Description.setVisible(false);
        this.count1Spinner.setVisible(false);
        this.count2Spinner.setVisible(false);
        this.count3Spinner.setVisible(false);
        this.count4Spinner.setVisible(false);
        this.poiPane.setVisible(false);
        this.poiTokenLabel.setVisible(false);
        this.nyi.setVisible(false);
    }

    private void switchPanels() {
        this.hideAllControls();
        if (this.objectiveType.getSelectedItem() == null) {
            return;
        }
        switch (this.objectiveType.getSelectedItem().toString()) {
            case "Arena": {
                this.arenaLabel.setVisible(true);
                this.poiPane.setVisible(true);
                this.count3Description.setText("Arena tournaments to win (minimum 1)");
                this.count3Description.setVisible(true);
                this.count3Spinner.setVisible(true);
                this.count4Description.setText("Fail after tournaments not won (only applied if > 0)");
                this.count4Description.setVisible(true);
                this.count4Spinner.setVisible(true);
                this.anyPOI.setVisible(true);
                this.here.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                break;
            }
            case "CharacterFlag": {
                this.characterFlagLabel.setVisible(true);
                this.nyi.setVisible(true);
                this.mapFlagGroup.setVisible(true);
                this.flagValueGroup.setVisible(true);
                break;
            }
            case "Clear": {
                this.clearLabel.setVisible(true);
                this.poiPane.setVisible(true);
                this.count1Description.setText("Target % of possible distances");
                this.count1Description.setVisible(true);
                this.count1Spinner.setVisible(true);
                this.count2Description.setText("Plus or minus %");
                this.count2Description.setVisible(true);
                this.count2Spinner.setVisible(true);
                this.anyPOI.setVisible(true);
                this.here.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                break;
            }
            case "CompleteQuest": {
                this.completeQuestLabel.setVisible(true);
                this.poiPane.setVisible(true);
                this.count1Description.setText("Target % of possible distances");
                this.count1Description.setVisible(true);
                this.count1Spinner.setVisible(true);
                this.count2Description.setText("Plus or minus %");
                this.count2Description.setVisible(true);
                this.count2Spinner.setVisible(true);
                this.count3Description.setText("Number of quests to complete (minimum 1)");
                this.count3Description.setVisible(true);
                this.count3Spinner.setVisible(true);
                this.anyPOI.setVisible(true);
                this.here.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                break;
            }
            case "Defeat": {
                this.defeatLabel.setVisible(true);
                this.mixedEnemies.setVisible(true);
                this.count3Description.setText("Matches to win");
                this.count3Description.setVisible(true);
                this.count3Spinner.setVisible(true);
                this.count4Description.setText("Fail after matches not won (only applied if > 0)");
                this.count4Description.setVisible(true);
                this.count4Spinner.setVisible(true);
                this.enemySelector.setVisible(true);
                break;
            }
            case "Delivery": {
                this.deliveryLabel.setVisible(true);
                this.nyi.setVisible(true);
                this.poiPane.setVisible(true);
                this.anyPOI.setVisible(true);
                this.here.setVisible(true);
                this.deliveryItem.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                break;
            }
            case "Escort": {
                this.escortLabel.setVisible(true);
                this.nyi.setVisible(true);
                this.poiPane.setVisible(true);
                this.here.setVisible(true);
                this.spriteNames.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                break;
            }
            case "EventFinish": {
                this.eventFinishLabel.setVisible(true);
                this.poiPane.setVisible(true);
                this.count1Description.setText("Target % of possible distances");
                this.count1Description.setVisible(true);
                this.count1Spinner.setVisible(true);
                this.count2Description.setText("Plus or minus %");
                this.count2Description.setVisible(true);
                this.count2Spinner.setVisible(true);
                this.count3Description.setText("Events to complete (minimum 1)");
                this.count3Description.setVisible(true);
                this.count3Spinner.setVisible(true);
                this.anyPOI.setVisible(true);
                this.here.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                break;
            }
            case "EventWin": {
                this.eventWinLabel.setVisible(true);
                this.poiPane.setVisible(true);
                this.count1Description.setText("Target % of possible distances");
                this.count1Description.setVisible(true);
                this.count1Spinner.setVisible(true);
                this.count2Description.setText("Plus or minus %");
                this.count2Description.setVisible(true);
                this.count2Spinner.setVisible(true);
                this.count3Description.setText("Events to win (minimum 1)");
                this.count3Description.setVisible(true);
                this.count3Spinner.setVisible(true);
                this.count4Description.setText("Fail after events not won (only applied if > 0)");
                this.count4Description.setVisible(true);
                this.count4Spinner.setVisible(true);
                this.anyPOI.setVisible(true);
                this.here.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                break;
            }
            case "EventWinMatch": {
                this.eventWinMatchLabel.setVisible(true);
                this.poiPane.setVisible(true);
                this.count1Description.setText("Target % of possible distances");
                this.count1Description.setVisible(true);
                this.count1Spinner.setVisible(true);
                this.count2Description.setText("Plus or minus %");
                this.count2Description.setVisible(true);
                this.count2Spinner.setVisible(true);
                this.count3Description.setText("Event matches to win (minimum 1)");
                this.count3Description.setVisible(true);
                this.count3Spinner.setVisible(true);
                this.count4Description.setText("Fail after matches not won (only applied if > 0)");
                this.count4Description.setVisible(true);
                this.count4Spinner.setVisible(true);
                this.anyPOI.setVisible(true);
                this.here.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                break;
            }
            case "Fetch": {
                this.fetchLabel.setVisible(true);
                this.nyi.setVisible(true);
                this.poiPane.setVisible(true);
                this.anyPOI.setVisible(true);
                this.here.setVisible(true);
                this.deliveryItem.setVisible(true);
                this.enemySelector.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                break;
            }
            case "Find": {
                this.findLabel.setVisible(true);
                this.nyi.setVisible(true);
                this.poiPane.setVisible(true);
                this.anyPOI.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                break;
            }
            case "Gather": {
                this.gatherLabel.setVisible(true);
                this.gatherLabel.setVisible(true);
                this.nyi.setVisible(true);
                this.itemNames.setVisible(true);
                break;
            }
            case "Give": {
                this.giveLabel.setVisible(true);
                this.nyi.setVisible(true);
                this.itemNames.setVisible(true);
                this.poiPane.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                this.here.setVisible(true);
                break;
            }
            case "HaveReputation": {
                this.poiPane.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                this.anyPOI.setVisible(true);
                this.here.setVisible(true);
                this.count1Description.setText("Target % of possible distances");
                this.count1Description.setVisible(true);
                this.count1Spinner.setVisible(true);
                this.count2Description.setText("Plus or minus %");
                this.count2Description.setVisible(true);
                this.count2Spinner.setVisible(true);
                this.count3Description.setText("Minimum reputation needed");
                this.count3Description.setVisible(true);
                this.count3Spinner.setVisible(true);
                break;
            }
            case "haveReputationInCurrentLocation": {
                this.haveReputationInCurrentLocationLabel.setVisible(true);
                this.poiPane.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                this.anyPOI.setVisible(true);
                this.here.setVisible(true);
                this.count1Description.setText("Target % of possible distances");
                this.count1Description.setVisible(true);
                this.count1Spinner.setVisible(true);
                this.count2Description.setText("Plus or minus %");
                this.count2Description.setVisible(true);
                this.count2Spinner.setVisible(true);
                this.count3Description.setText("Minimum reputation needed");
                this.count3Description.setVisible(true);
                this.count3Spinner.setVisible(true);
                break;
            }
            case "Hunt": {
                this.huntLabel.setVisible(true);
                this.enemySelector.setVisible(true);
                this.count3Description.setText("Lifespan (seconds to complete hunt before despawn)");
                this.count3Description.setVisible(true);
                this.count3Spinner.setVisible(true);
                break;
            }
            case "Leave": {
                this.leaveLabel.setVisible(true);
                this.poiPane.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                this.anyPOI.setVisible(true);
                this.here.setVisible(true);
                this.count1Description.setText("Target % of possible distances");
                this.count1Description.setVisible(true);
                this.count1Spinner.setVisible(true);
                this.count2Description.setText("Plus or minus %");
                this.count2Description.setVisible(true);
                this.count2Spinner.setVisible(true);
                this.count3Description.setText("Number of times to leave before triggering (minimum 1)");
                this.count3Description.setVisible(true);
                this.count3Spinner.setVisible(true);
                break;
            }
            case "MapFlag": {
                this.mapFlagLabel.setVisible(true);
                this.poiPane.setVisible(true);
                this.here.setVisible(true);
                this.anyPOI.setVisible(true);
                this.mapFlagGroup.setVisible(true);
                this.flagValueGroup.setVisible(true);
                break;
            }
            case "None": {
                this.noneLabel.setVisible(true);
                this.nyi.setVisible(true);
                break;
            }
            case "Patrol": {
                this.patrolLabel.setVisible(true);
                this.nyi.setVisible(true);
                break;
            }
            case "Rescue": {
                this.rescueLabel.setVisible(true);
                this.nyi.setVisible(true);
                this.poiPane.setVisible(true);
                this.anyPOI.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                this.here.setVisible(true);
                this.spriteNames.setVisible(true);
                this.enemySelector.setVisible(true);
                break;
            }
            case "Siege": {
                this.siegeLabel.setVisible(true);
                this.nyi.setVisible(true);
                this.poiPane.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                this.anyPOI.setVisible(true);
                this.here.setVisible(true);
                this.enemySelector.setVisible(true);
                this.mixedEnemies.setVisible(true);
                this.poiPane.setVisible(true);
                this.count1Description.setText("Target % of possible distances");
                this.count1Description.setVisible(true);
                this.count1Spinner.setVisible(true);
                this.count2Description.setText("Plus or minus %");
                this.count2Description.setVisible(true);
                this.count2Spinner.setVisible(true);
                this.count3Description.setText("Number of enemies to defeat");
                this.count3Description.setVisible(true);
                this.count3Spinner.setVisible(true);
                this.count3Spinner.setVisible(true);
                this.count4Description.setText("Time limit (will only fail if > 0)");
                this.count4Description.setVisible(true);
                this.count4Spinner.setVisible(true);
                break;
            }
            case "QuestFlag": {
                this.questFlagLabel.setVisible(true);
                this.mapFlagGroup.setVisible(true);
                this.flagValueGroup.setVisible(true);
                break;
            }
            case "Travel": {
                this.travelLabel.setVisible(true);
                this.poiPane.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                this.poiTokenInput.setVisible(true);
                this.anyPOI.setVisible(true);
                this.here.setVisible(true);
                this.count1Description.setText("Target % of possible distances");
                this.count1Description.setVisible(true);
                this.count1Spinner.setVisible(true);
                this.count2Description.setText("Plus or minus %");
                this.count2Description.setVisible(true);
                this.count2Spinner.setVisible(true);
                this.count3Description.setText("Number of times to enter before triggering (minimum 1)");
                this.count3Description.setVisible(true);
                this.count3Spinner.setVisible(true);
                break;
            }
            case "Use": {
                this.useLabel.setVisible(true);
                this.nyi.setVisible(true);
                this.itemNames.setVisible(true);
                this.poiPane.setVisible(true);
                this.anyPOI.setVisible(true);
                this.here.setVisible(true);
                this.poiTokenLabel.setVisible(true);
                this.here.setVisible(true);
                this.count3Description.setText("Number of times to use triggering (minimum 1)");
                this.count3Description.setVisible(true);
                this.count3Spinner.setVisible(true);
            }
        }
        this.specificPOI.setVisible(this.anyPOI.isVisible());
    }

    private void changeObjective() {
        if (this.objectiveType.getSelectedItem() != null) {
            this.currentData.objective = AdventureQuestController.ObjectiveTypes.valueOf(this.objectiveType.getSelectedItem().toString());
        }
        this.switchPanels();
    }

    private JPanel getObjectiveTab() {
        this.objectiveType = new JComboBox<AdventureQuestController.ObjectiveTypes>(AdventureQuestController.ObjectiveTypes.values());
        this.objectiveType.addActionListener(e -> this.changeObjective());
        JPanel objectiveTab = new JPanel();
        JScrollPane scrollPane = new JScrollPane();
        objectiveTab.add(scrollPane);
        FormPanel center = new FormPanel();
        center.add(this.objectiveType);
        scrollPane.add(center);
        this.mapFlagGroup = new Box(1);
        this.mapFlagGroup.add(new JLabel("Map flag to check"));
        this.mapFlagGroup.add(this.mapFlag);
        this.flagValueGroup = new Box(1);
        this.flagValueGroup.add(new JLabel("Flag value to check"));
        this.flagValueGroup.add(this.flagSpinner);
        this.anyPOIGroup.add(this.anyPOI);
        this.anyPOIGroup.add(this.specificPOI);
        JPanel poiSelectorPane = new JPanel();
        poiSelectorPane.setLayout(new BorderLayout());
        poiSelectorPane.add((Component)this.poiSelector, "Center");
        JPanel poiTokenPanel = new JPanel();
        JPanel tokenPanel = new JPanel();
        tokenPanel.add(new JLabel("Token to use:"));
        tokenPanel.add(this.poiTokenInput);
        tokenPanel.setBorder(new EmptyBorder(10, 10, 30, 10));
        poiTokenPanel.add(this.poiTokenDescription);
        poiTokenPanel.add(tokenPanel);
        poiTokenPanel.add(this.here);
        GroupLayout poiTokenLayout = new GroupLayout(poiTokenPanel);
        poiTokenLayout.setHorizontalGroup(poiTokenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.poiTokenDescription).addComponent(tokenPanel, -2, -1, -2).addComponent(this.here));
        poiTokenLayout.setVerticalGroup(poiTokenLayout.createSequentialGroup().addComponent(this.poiTokenDescription).addComponent(tokenPanel, -2, -1, -2).addComponent(this.here));
        poiTokenPanel.setLayout(poiTokenLayout);
        this.poiPane.add("Specific PoI", poiTokenPanel);
        this.poiPane.add("Tag Selector", poiSelectorPane);
        this.poiPane.setPreferredSize(new Dimension(0, 200));
        center.add(this.arenaLabel);
        center.add(this.clearLabel);
        center.add(this.defeatLabel);
        center.add(this.deliveryLabel);
        center.add(this.escortLabel);
        center.add(this.fetchLabel);
        center.add(this.findLabel);
        center.add(this.gatherLabel);
        center.add(this.giveLabel);
        center.add(this.haveReputationLabel);
        center.add(this.huntLabel);
        center.add(this.leaveLabel);
        center.add(this.noneLabel);
        center.add(this.patrolLabel);
        center.add(this.rescueLabel);
        center.add(this.siegeLabel);
        center.add(this.mapFlagLabel);
        center.add(this.questFlagLabel);
        center.add(this.travelLabel);
        center.add(this.useLabel);
        center.add(this.nyi);
        center.add(this.deliveryItem);
        center.add(this.mapFlagGroup);
        center.add(this.flagValueGroup);
        center.add(this.anyPOI);
        center.add(this.specificPOI);
        center.add(this.mixedEnemies);
        center.add(this.enemySelector);
        center.add(this.count1Description);
        center.add(this.count1Spinner);
        center.add(this.count2Description);
        center.add(this.count2Spinner);
        center.add(this.count3Description);
        center.add(this.count3Spinner);
        center.add(this.count4Description);
        center.add(this.count4Spinner);
        center.add(this.poiPane);
        center.add(this.poiTokenLabel);
        this.switchPanels();
        this.poiSelector.selectedItems.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                QuestStageEdit.this.rebuildPOIList();
                QuestStageEdit.this.rebuildEnemyList();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                QuestStageEdit.this.rebuildPOIList();
                QuestStageEdit.this.rebuildEnemyList();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                QuestStageEdit.this.rebuildPOIList();
                QuestStageEdit.this.rebuildEnemyList();
            }
        });
        return center;
    }

    private void rebuildPOIList() {
        ArrayList<String> currentList = new ArrayList<String>();
        for (int i = 0; i < this.poiSelector.selectedItems.getSize(); ++i) {
            currentList.add(this.poiSelector.selectedItems.getElementAt(i));
        }
        this.currentData.POITags = currentList;
    }

    private void rebuildEnemyList() {
        ArrayList<String> currentList = new ArrayList<String>();
        for (int i = 0; i < this.enemySelector.selectedItems.getSize(); ++i) {
            currentList.add(this.enemySelector.selectedItems.getElementAt(i));
        }
        this.currentData.enemyTags = currentList;
    }

    private JPanel getPrereqTab() {
        JPanel prereqTab = new JPanel();
        prereqTab.add(new JLabel("Insert Prereq data here"));
        return prereqTab;
    }

    private void refresh() {
        DefaultListModel<String> selectedPOI;
        int i;
        if (this.currentData == null) {
            return;
        }
        this.setEnabled(false);
        this.updating = true;
        this.objectiveType.setSelectedItem((Object)this.currentData.objective);
        if (this.objectiveType.getSelectedItem() != null) {
            this.currentData.objective = AdventureQuestController.ObjectiveTypes.valueOf(this.objectiveType.getSelectedItem().toString());
        }
        this.name.setText(this.currentData.name);
        this.description.setText(this.currentData.description);
        this.deliveryItem.setText(this.currentData.deliveryItem);
        if (this.currentData.enemyTags != null) {
            DefaultListModel<String> selectedEnemies = new DefaultListModel<String>();
            for (i = 0; i < this.currentData.enemyTags.size(); ++i) {
                selectedEnemies.add(i, this.currentData.enemyTags.get(i));
            }
            this.enemySelector.load(selectedEnemies);
        }
        if (this.currentData.POITags != null) {
            selectedPOI = new DefaultListModel<String>();
            for (i = 0; i < this.currentData.POITags.size(); ++i) {
                selectedPOI.add(i, this.currentData.POITags.get(i));
            }
            this.poiSelector.load(selectedPOI);
        }
        this.itemNames.setText(this.currentData.itemNames);
        this.equipNames.setText(this.currentData.equipNames);
        this.prologueEditor.loadData(this.currentData.prologue);
        this.epilogueEditor.loadData(this.currentData.epilogue);
        if (this.currentData.POITags != null) {
            selectedPOI = new DefaultListModel();
            for (i = 0; i < this.currentData.POITags.size(); ++i) {
                selectedPOI.add(i, this.currentData.POITags.get(i));
            }
            this.poiSelector.load(selectedPOI);
        }
        this.here.getModel().setSelected(this.currentData.here);
        this.anyPOI.getModel().setSelected(this.currentData.anyPOI);
        this.specificPOI.getModel().setSelected(!this.currentData.anyPOI);
        this.poiTokenInput.setText(this.currentData.POIToken);
        this.poiTokenLabel.setText("To reference this point of interest: $(poi_" + this.currentData.id + ")");
        ArrayList<String> temp = new ArrayList<String>();
        for (AdventureQuestStage stage : this.currentQuestData.stages) {
            if (stage.equals(this.currentData)) continue;
            temp.add(stage.name);
        }
        this.prerequisites.setOptions(temp);
        this.count1Spinner.getModel().setValue(this.currentData.count1);
        this.count2Spinner.getModel().setValue(this.currentData.count2);
        this.count3Spinner.getModel().setValue(this.currentData.count3);
        this.count4Spinner.getModel().setValue(this.currentData.count4);
        this.updating = false;
        this.setEnabled(true);
    }

    public void updateStage() {
        if (this.currentData == null || this.updating) {
            return;
        }
        this.currentData.name = this.name.getText();
        this.currentData.description = this.description.getText();
        this.currentData.prologue = this.prologueEditor.getDialogData();
        this.currentData.epilogue = this.epilogueEditor.getDialogData();
        this.currentData.deliveryItem = this.deliveryItem.getText();
        this.currentData.itemNames = this.itemNames.getList() == null ? new ArrayList() : Arrays.asList(this.itemNames.getList());
        this.currentData.equipNames = this.equipNames.getList() == null ? new ArrayList() : Arrays.asList(this.equipNames.getList());
        this.currentData.anyPOI = this.anyPOI.getModel().isSelected();
        this.currentData.mapFlag = this.mapFlag.getText();
        this.currentData.mapFlagValue = Integer.parseInt(this.flagSpinner.getModel().getValue().toString());
        this.currentData.count1 = Integer.parseInt(this.count1Spinner.getModel().getValue().toString());
        this.currentData.count2 = Integer.parseInt(this.count2Spinner.getModel().getValue().toString());
        this.currentData.count3 = Integer.parseInt(this.count3Spinner.getModel().getValue().toString());
        this.currentData.count4 = Integer.parseInt(this.count4Spinner.getModel().getValue().toString());
        this.currentData.mixedEnemies = this.mixedEnemies.getModel().isSelected();
        this.currentData.here = this.here.getModel().isSelected();
        this.currentData.POIToken = this.poiTokenInput.getText();
        this.rebuildPOIList();
        this.rebuildEnemyList();
        this.emitChanged();
    }

    public void setCurrentStage(AdventureQuestStage stageData, AdventureQuestData data) {
        if (stageData == null) {
            stageData = new AdventureQuestStage();
        }
        if (data == null) {
            data = new AdventureQuestData();
        }
        this.currentData = stageData;
        this.currentQuestData = data;
        this.setVisible(true);
        this.refresh();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    protected void emitChanged() {
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        if (listeners != null && listeners.length > 0) {
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    private void addListeners() {
        this.deliveryItem.getDocument().addDocumentListener(new DocumentChangeListener(this::updateStage));
        this.mapFlag.getDocument().addDocumentListener(new DocumentChangeListener(this::updateStage));
        this.flagSpinner.getModel().addChangeListener(q -> this.updateStage());
        this.count1Spinner.getModel().addChangeListener(q -> this.updateStage());
        this.count2Spinner.getModel().addChangeListener(q -> this.updateStage());
        this.count3Spinner.getModel().addChangeListener(q -> this.updateStage());
        this.count4Spinner.getModel().addChangeListener(q -> this.updateStage());
        this.mixedEnemies.getModel().addChangeListener(q -> this.updateStage());
        this.here.getModel().addChangeListener(q -> this.updateStage());
        this.anyPOI.getModel().addChangeListener(q -> this.updateStage());
        this.deliveryItem.getDocument().addDocumentListener(new DocumentChangeListener(this::updateStage));
        this.mapFlag.getDocument().addDocumentListener(new DocumentChangeListener(this::updateStage));
        this.prologueEditor.addChangeListener(q -> this.updateStage());
        this.epilogueEditor.addChangeListener(q -> this.updateStage());
    }
}

