/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import forge.adventure.data.AdventureQuestData;
import forge.adventure.editor.QuestController;
import forge.adventure.editor.QuestEdit;
import forge.adventure.util.Config;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class QuestEditor
extends JComponent {
    JList<AdventureQuestData> list = new JList<AdventureQuestData>(QuestController.getInstance().getAllQuests());
    JToolBar toolBar = new JToolBar("toolbar");
    QuestEdit edit = new QuestEdit();

    public void addButton(String name, ActionListener action) {
        JButton newButton = new JButton(name);
        newButton.addActionListener(action);
        this.toolBar.add(newButton);
    }

    public QuestEditor() {
        this.list.setCellRenderer(new QuestDataRenderer());
        this.list.addListSelectionListener(e -> this.updateEdit());
        this.addButton("Add Quest", e -> this.addStage());
        this.addButton("Remove", e -> this.remove());
        this.addButton("Copy", e -> this.copy());
        this.addButton("Load", e -> QuestController.getInstance().load());
        this.addButton("Save", e -> this.save());
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add((Component)new JScrollPane(this.list), "Before");
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "First");
        this.add((Component)this.edit, "Center");
        this.edit.setVisible(false);
    }

    private void copy() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        AdventureQuestData data = new AdventureQuestData(QuestController.getInstance().getAllQuests().get(selected));
        data.isTemplate = true;
        QuestController.getInstance().getAllQuests().add(QuestController.getInstance().getAllQuests().size(), data);
    }

    private void updateEdit() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.edit.setCurrentQuest(QuestController.getInstance().getAllQuests().get(selected));
    }

    void save() {
        Array<AdventureQuestData> allQuests = new Array<AdventureQuestData>();
        for (int i = 0; i < QuestController.getInstance().getAllQuests().getSize(); ++i) {
            allQuests.add(QuestController.getInstance().getAllQuests().get(i));
        }
        Json json = new Json(JsonWriter.OutputType.json);
        FileHandle handle = Config.instance().getFile("world/quests.json");
        handle.writeString(json.prettyPrint(json.toJson(allQuests, Array.class, AdventureQuestData.class)), false);
        QuestController.getInstance().save();
    }

    void addStage() {
        AdventureQuestData data = new AdventureQuestData();
        data.name = "New Quest " + QuestController.getInstance().getAllQuests().getSize();
        data.isTemplate = true;
        QuestController.getInstance().getAllQuests().add(QuestController.getInstance().getAllQuests().size(), data);
    }

    void remove() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        QuestController.getInstance().getAllQuests().remove(selected);
        this.edit.setVisible(false);
    }

    public class QuestDataRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof AdventureQuestData)) {
                return label;
            }
            AdventureQuestData quest = (AdventureQuestData)value;
            label.setText(quest.name);
            return label;
        }
    }
}

