/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.AdventureQuestData;
import forge.adventure.editor.DialogEditor;
import forge.adventure.editor.DocumentChangeListener;
import forge.adventure.editor.FormPanel;
import forge.adventure.editor.QuestController;
import forge.adventure.editor.QuestStageEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class QuestEdit
extends FormPanel {
    AdventureQuestData currentData;
    public JLabel id = new JLabel();
    public JTextField name = new JTextField();
    public JTextField description = new JTextField();
    public JTextField synopsis = new JTextField();
    public JCheckBox storyQuest = new JCheckBox();
    public JTextField rewardDescription = new JTextField();
    public QuestStageEditor stages = new QuestStageEditor();
    JTabbedPane tabs = new JTabbedPane();
    public DialogEditor prologueEditor = new DialogEditor();
    public DialogEditor epilogueEditor = new DialogEditor();
    public DialogEditor offerEditor = new DialogEditor();
    public DialogEditor failureEditor = new DialogEditor();
    public DialogEditor declineEditor = new DialogEditor();
    private boolean updating = false;
    JTextField manualEntry = new JTextField(20);
    DefaultListModel<String> existingModel = new DefaultListModel();
    DefaultListModel<String> selectedTagModel = new DefaultListModel();
    JList<String> existingTags;
    JList<String> selectedTags;
    JPanel tags = new JPanel();

    public QuestEdit() {
        FormPanel center = new FormPanel(){};
        center.add("Quest ID:", (JComponent)this.id);
        center.add("Name:", (JComponent)this.name);
        center.add("Description:", (JComponent)this.description);
        center.add("Reward Description:", (JComponent)this.rewardDescription);
        center.add("Storyline Quest", (JComponent)this.storyQuest);
        this.add(center);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.tabs);
        this.tabs.add("Quest Stages", this.getStagesTab());
        this.tabs.add("Offer Dialog", this.getOfferTab());
        this.tabs.add("Prologue", this.getPrologueTab());
        this.tabs.add("Epilogue", this.getEpilogueTab());
        this.tabs.add("Failure Dialog", this.getFailureTab());
        this.tabs.add("Decline Dialog", this.getDeclineTab());
        this.tabs.add("Quest Sources", this.getSourcesTab());
        this.existingTags = new JList();
        this.existingTags.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "addSelected");
        this.existingTags.getActionMap().put("addSelected", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuestEdit.this.addSelected();
                int index = QuestEdit.this.existingTags.getSelectedIndex();
                String selectedItem = QuestEdit.this.existingTags.getSelectedValue();
                if (selectedItem != null) {
                    QuestEdit.this.selectedTagModel.addElement(selectedItem);
                    QuestEdit.this.existingTags.grabFocus();
                    QuestEdit.this.existingTags.setSelectedIndex(index < QuestEdit.this.existingModel.size() ? index : index - 1);
                }
            }
        });
        this.existingModel = QuestController.getInstance().getSourceTags();
        this.existingTags.setModel(this.existingModel);
        this.selectedTags = new JList();
        this.selectedTagModel = new DefaultListModel();
        this.selectedTags.setModel(this.selectedTagModel);
        this.selectedTags.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                QuestEdit.this.doUpdate();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                QuestEdit.this.doUpdate();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                QuestEdit.this.doUpdate();
            }
        });
        JButton select = new JButton("Select");
        select.addActionListener(q -> this.addSelected());
        JButton add = new JButton("Manual Add");
        add.addActionListener(q -> this.manualAdd(this.selectedTagModel));
        JButton remove = new JButton("Remove Item");
        remove.addActionListener(q -> this.removeSelected());
        this.tags.setLayout(new BorderLayout());
        JPanel left = new JPanel();
        left.setLayout(new BorderLayout());
        left.add((Component)new JLabel("Tags already in use"), "North");
        JScrollPane listScroller = new JScrollPane(this.existingTags);
        listScroller.setMinimumSize(new Dimension(400, 800));
        left.add((Component)listScroller, "Center");
        this.tags.add((Component)left, "West");
        FormPanel tagEdit = new FormPanel();
        tagEdit.setLayout(new BorderLayout());
        FormPanel mappedTags = new FormPanel();
        mappedTags.setLayout(new BorderLayout());
        mappedTags.add((Component)new JLabel("Tags Mapped to this object"), "North");
        JScrollPane listScroller2 = new JScrollPane(this.selectedTags);
        listScroller2.setMinimumSize(new Dimension(400, 800));
        mappedTags.add((Component)listScroller2, "Center");
        tagEdit.add((Component)mappedTags, "East");
        JPanel controlPanel = new JPanel();
        controlPanel.add(select);
        controlPanel.add(add);
        controlPanel.add(this.manualEntry);
        this.manualEntry.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "addTyped");
        this.manualEntry.getActionMap().put("addTyped", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!QuestEdit.this.manualEntry.getText().trim().isEmpty()) {
                    QuestEdit.this.manualAdd(QuestEdit.this.selectedTagModel);
                    QuestEdit.this.manualEntry.grabFocus();
                }
            }
        });
        controlPanel.add(remove);
        tagEdit.add((Component)controlPanel, "Center");
        this.tags.add((Component)tagEdit, "Center");
        JTextArea right1 = new JTextArea("This is really just to pad some space\nbut also to explain the use of tags.\nRather than adding 100's of object names\nto every quest definition, instead we will\ncategorize enemies and points of interest with\ntags and reference those categories in quests");
        right1.setEnabled(false);
        this.tags.add((Component)right1, "East");
        this.name.getDocument().addDocumentListener(new DocumentChangeListener(this::updateQuest));
        this.description.getDocument().addDocumentListener(new DocumentChangeListener(this::updateQuest));
        this.synopsis.getDocument().addDocumentListener(new DocumentChangeListener(this::updateQuest));
        this.storyQuest.getModel().addChangeListener(q -> this.updateQuest());
        this.rewardDescription.getDocument().addDocumentListener(new DocumentChangeListener(this::updateQuest));
        this.stages.addChangeListener(e -> this.updateQuest());
        this.offerEditor.addChangeListener(e -> this.updateQuest());
        this.prologueEditor.addChangeListener(e -> this.updateQuest());
        this.epilogueEditor.addChangeListener(e -> this.updateQuest());
        this.failureEditor.addChangeListener(e -> this.updateQuest());
        this.declineEditor.addChangeListener(e -> this.updateQuest());
        this.stages.addChangeListener(e -> this.updateQuest());
        this.selectedTagModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                QuestEdit.this.updateQuest();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                QuestEdit.this.updateQuest();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                QuestEdit.this.updateQuest();
            }
        });
        this.refresh();
    }

    private void doUpdate() {
        this.updateQuest();
    }

    private void addSelected() {
        if (this.existingTags.getSelectedIndex() > -1) {
            this.selectedTagModel.addElement(this.existingTags.getModel().getElementAt(this.existingTags.getSelectedIndex()));
        }
        this.doUpdate();
    }

    private void removeSelected() {
        if (this.selectedTags.getSelectedIndex() > -1) {
            this.selectedTagModel.remove(this.selectedTags.getSelectedIndex());
        }
        this.doUpdate();
    }

    private void filterExisting(DefaultListModel<String> filter) {
        DefaultListModel<String> toReturn = new DefaultListModel<String>();
        Enumeration<String> e = QuestController.getInstance().getSourceTags().elements();
        while (e.hasMoreElements()) {
            String toTest = e.nextElement();
            if (!(toTest != null & !filter.contains(toTest))) continue;
            toReturn.addElement(toTest);
        }
        this.existingTags.setModel(toReturn);
    }

    private void manualAdd(DefaultListModel<String> model) {
        if (!this.manualEntry.getText().trim().isEmpty()) {
            model.addElement(this.manualEntry.getText().trim());
        }
        this.manualEntry.setText("");
        this.doUpdate();
    }

    protected void updateQuest() {
        if (this.currentData == null || this.updating) {
            return;
        }
        this.currentData.name = this.name.getText();
        this.currentData.storyQuest = this.storyQuest.isSelected();
        this.currentData.synopsis = this.synopsis.getText();
        this.currentData.description = this.description.getText();
        this.currentData.rewardDescription = this.rewardDescription.getText();
        this.currentData.stages = this.stages.getStages();
        this.currentData.offerDialog = this.offerEditor.getDialogData();
        this.currentData.prologue = this.prologueEditor.getDialogData();
        this.currentData.epilogue = this.epilogueEditor.getDialogData();
        this.currentData.failureDialog = this.failureEditor.getDialogData();
        this.currentData.declinedDialog = this.declineEditor.getDialogData();
        ArrayList<String> tags = new ArrayList<String>();
        Enumeration<String> e = this.selectedTagModel.elements();
        while (e.hasMoreElements()) {
            tags.add(e.nextElement());
        }
        this.currentData.questSourceTags = tags.toArray(this.currentData.questSourceTags);
        QuestController.getInstance().refresh();
        this.filterExisting(this.selectedTagModel);
    }

    public void setCurrentQuest(AdventureQuestData data) {
        this.currentData = data;
        this.refresh();
    }

    private void refresh() {
        this.setEnabled(this.currentData != null);
        if (this.currentData == null) {
            return;
        }
        this.setVisible(true);
        this.updating = true;
        this.id.setText(this.currentData.getID() + "");
        this.name.setText(this.currentData.name);
        this.description.setText(this.currentData.description);
        this.synopsis.setText(this.currentData.synopsis);
        this.storyQuest.getModel().setSelected(this.currentData.storyQuest);
        this.rewardDescription.setText(this.currentData.rewardDescription);
        this.stages.setStages(this.currentData);
        this.offerEditor.loadData(this.currentData.offerDialog);
        this.prologueEditor.loadData(this.currentData.prologue);
        this.epilogueEditor.loadData(this.currentData.epilogue);
        this.failureEditor.loadData(this.currentData.failureDialog);
        this.declineEditor.loadData(this.currentData.declinedDialog);
        this.selectedTagModel.clear();
        for (String val : this.currentData.questSourceTags) {
            if (val == null) continue;
            this.selectedTagModel.addElement(val);
        }
        this.filterExisting(this.selectedTagModel);
        this.updating = false;
    }

    public JPanel getOfferTab() {
        JPanel offerTab = new JPanel();
        offerTab.setLayout(new BoxLayout(offerTab, 1));
        FormPanel center = new FormPanel();
        center.add(this.offerEditor);
        offerTab.add(center);
        return offerTab;
    }

    public JPanel getPrologueTab() {
        JPanel prologueTab = new JPanel();
        prologueTab.setLayout(new BoxLayout(prologueTab, 1));
        FormPanel center = new FormPanel();
        center.add(this.prologueEditor);
        prologueTab.add(center);
        return prologueTab;
    }

    public JPanel getEpilogueTab() {
        JPanel epilogueTab = new JPanel();
        epilogueTab.setLayout(new BoxLayout(epilogueTab, 1));
        FormPanel center = new FormPanel();
        center.add(this.epilogueEditor);
        epilogueTab.add(center);
        return epilogueTab;
    }

    public JPanel getFailureTab() {
        JPanel failureTab = new JPanel();
        failureTab.setLayout(new BoxLayout(failureTab, 1));
        FormPanel center = new FormPanel();
        center.add(this.failureEditor);
        failureTab.add(center);
        return failureTab;
    }

    public JPanel getDeclineTab() {
        JPanel declineTab = new JPanel();
        declineTab.setLayout(new BoxLayout(declineTab, 1));
        FormPanel center = new FormPanel();
        center.add(this.declineEditor);
        declineTab.add(center);
        return declineTab;
    }

    public JPanel getStagesTab() {
        JPanel stagesTab = new JPanel();
        stagesTab.setLayout(new BoxLayout(stagesTab, 1));
        FormPanel center = new FormPanel();
        center.add(this.stages);
        stagesTab.add(center);
        return stagesTab;
    }

    public JPanel getSourcesTab() {
        JPanel sourcesTab = new JPanel();
        sourcesTab.setLayout(new BoxLayout(sourcesTab, 1));
        FormPanel center = new FormPanel();
        center.add(this.tags);
        sourcesTab.add(center);
        return sourcesTab;
    }
}

