/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import forge.adventure.data.AdventureQuestData;
import forge.adventure.data.EnemyData;
import forge.adventure.data.PointOfInterestData;
import forge.adventure.util.Config;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;

public class QuestController {
    public final DefaultListModel<String> POITags = new DefaultListModel();
    public final DefaultListModel<String> enemyTags = new DefaultListModel();
    public final DefaultListModel<String> questEnemyTags = new DefaultListModel();
    public final DefaultListModel<String> questTags = new DefaultListModel();
    public final DefaultListModel<String> questPOITags = new DefaultListModel();
    private final DefaultListModel<PointOfInterestData> allPOI = new DefaultListModel();
    private final DefaultListModel<EnemyData> allEnemies = new DefaultListModel();
    private final DefaultListModel<String> questSourceTags = new DefaultListModel();
    private final DefaultListModel<AdventureQuestData> allQuests = new DefaultListModel();
    private static QuestController instance;

    public static QuestController getInstance() {
        if (instance == null) {
            instance = new QuestController();
        }
        return instance;
    }

    public DefaultListModel<AdventureQuestData> getAllQuests() {
        return this.allQuests;
    }

    private QuestController() {
        this.load();
    }

    public DefaultListModel<String> getEnemyTags() {
        DefaultListModel<String> toReturn = new DefaultListModel<String>();
        for (int i = 0; i < this.enemyTags.size(); ++i) {
            toReturn.removeElement(this.enemyTags.get(i));
            toReturn.addElement(this.enemyTags.get(i));
        }
        List sortedObjects = Arrays.stream(toReturn.toArray()).sorted().collect(Collectors.toList());
        toReturn.clear();
        for (Object sortedObject : sortedObjects) {
            toReturn.addElement((String)sortedObject);
        }
        return toReturn;
    }

    public DefaultListModel<String> getPOITags() {
        DefaultListModel<String> toReturn = new DefaultListModel<String>();
        for (int i = 0; i < this.POITags.size(); ++i) {
            toReturn.removeElement(this.POITags.get(i));
            toReturn.addElement(this.POITags.get(i));
        }
        List sortedObjects = Arrays.stream(toReturn.toArray()).sorted().collect(Collectors.toList());
        toReturn.clear();
        for (Object sortedObject : sortedObjects) {
            toReturn.addElement((String)sortedObject);
        }
        return toReturn;
    }

    public DefaultListModel<String> getSourceTags() {
        DefaultListModel<String> toReturn = new DefaultListModel<String>();
        for (int i = 0; i < this.questSourceTags.size(); ++i) {
            toReturn.removeElement(this.questSourceTags.get(i));
            toReturn.addElement(this.questSourceTags.get(i));
        }
        List sortedObjects = Arrays.stream(toReturn.toArray()).sorted().collect(Collectors.toList());
        toReturn.clear();
        for (Object sortedObject : sortedObjects) {
            toReturn.addElement((String)sortedObject);
        }
        return toReturn;
    }

    public void refresh() {
        int i;
        this.enemyTags.clear();
        this.POITags.clear();
        this.questPOITags.clear();
        this.questEnemyTags.clear();
        this.questTags.clear();
        this.questSourceTags.clear();
        for (i = 0; i < this.allEnemies.size(); ++i) {
            for (String tag : this.allEnemies.get((int)i).questTags) {
                this.enemyTags.removeElement(tag);
                if (tag == null) continue;
                this.enemyTags.addElement(tag);
            }
        }
        for (i = 0; i < this.allPOI.size(); ++i) {
            for (String tag : this.allPOI.get((int)i).questTags) {
                this.POITags.removeElement(tag);
                if (tag == null) continue;
                this.POITags.addElement(tag);
            }
        }
        for (i = 0; i < this.allQuests.size(); ++i) {
            for (String tag : this.allQuests.get((int)i).questEnemyTags) {
                this.questEnemyTags.removeElement(tag);
                if (tag == null) continue;
                this.questEnemyTags.addElement(tag);
            }
            for (String tag : this.allQuests.get((int)i).questPOITags) {
                this.questPOITags.removeElement(tag);
                if (tag == null) continue;
                this.questPOITags.addElement(tag);
            }
            for (String tag : this.allQuests.get((int)i).questSourceTags) {
                this.questSourceTags.removeElement(tag);
                if (tag == null) continue;
                this.questSourceTags.addElement(tag);
            }
        }
    }

    public void load() {
        this.allEnemies.clear();
        Array enemyJSON = new Array();
        Json json = new Json();
        FileHandle handle = Config.instance().getFile("world/enemies.json");
        if (handle.exists()) {
            enemyJSON = json.fromJson(Array.class, EnemyData.class, handle);
        }
        for (int i = 0; i < enemyJSON.size; ++i) {
            this.allEnemies.add(i, (EnemyData)enemyJSON.get(i));
            for (String tag : ((EnemyData)enemyJSON.get((int)i)).questTags) {
                this.enemyTags.removeElement(tag);
                if (tag == null) continue;
                this.enemyTags.addElement(tag);
            }
        }
        this.allPOI.clear();
        Array POIJSON = new Array();
        json = new Json();
        handle = Config.instance().getFile("world/points_of_interest.json");
        if (handle.exists()) {
            POIJSON = json.fromJson(Array.class, PointOfInterestData.class, handle);
        }
        for (int i = 0; i < POIJSON.size; ++i) {
            this.allPOI.add(i, (PointOfInterestData)POIJSON.get(i));
            for (String tag : ((PointOfInterestData)POIJSON.get((int)i)).questTags) {
                this.POITags.removeElement(tag);
                if (tag == null) continue;
                this.POITags.addElement(tag);
            }
        }
        this.allQuests.clear();
        Array questJSON = new Array();
        json = new Json();
        handle = Config.instance().getFile("world/quests.json");
        if (handle.exists()) {
            questJSON = json.fromJson(Array.class, AdventureQuestData.class, handle);
        }
        for (int i = 0; i < questJSON.size; ++i) {
            AdventureQuestData template = (AdventureQuestData)questJSON.get(i);
            template.isTemplate = true;
            this.allQuests.add(i, template);
            for (String tag : template.questEnemyTags) {
                this.questEnemyTags.removeElement(tag);
                if (tag == null) continue;
                this.questEnemyTags.addElement(tag);
            }
            for (String tag : template.questPOITags) {
                this.questPOITags.removeElement(tag);
                if (tag == null) continue;
                this.questPOITags.addElement(tag);
            }
            for (String tag : template.questSourceTags) {
                this.questSourceTags.removeElement(tag);
                if (tag == null) continue;
                this.questSourceTags.addElement(tag);
            }
        }
    }

    void save() {
        Json json = new Json(JsonWriter.OutputType.json);
        FileHandle handle = Config.instance().getFile("world/quests.json");
        AdventureQuestData[] saveData = (AdventureQuestData[])Arrays.stream(this.allQuests.toArray()).map(AdventureQuestData.class::cast).toArray(AdventureQuestData[]::new);
        handle.writeString(json.prettyPrint(json.toJson((Object)saveData, Array.class, AdventureQuestData.class)), false);
    }
}

