/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import forge.adventure.data.PointOfInterestData;
import forge.adventure.editor.PointOfInterestEdit;
import forge.adventure.editor.QuestController;
import forge.adventure.editor.SwingAtlas;
import forge.adventure.util.Config;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class PointOfInterestEditor
extends JComponent {
    DefaultListModel<PointOfInterestData> model = new DefaultListModel();
    JList<PointOfInterestData> list = new JList<PointOfInterestData>(this.model);
    JToolBar toolBar = new JToolBar("toolbar");
    PointOfInterestEdit edit = new PointOfInterestEdit();
    static HashMap<String, SwingAtlas> atlas = new HashMap();

    public void addButton(String name, ActionListener action) {
        JButton newButton = new JButton(name);
        newButton.addActionListener(action);
        this.toolBar.add(newButton);
    }

    public PointOfInterestEditor() {
        this.list.setCellRenderer(new PointOfInterestRenderer());
        this.list.addListSelectionListener(e -> this.updateEdit());
        this.addButton("add", e -> this.addItem());
        this.addButton("remove", e -> this.remove());
        this.addButton("copy", e -> this.copy());
        this.addButton("load", e -> this.load());
        this.addButton("save", e -> this.save());
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add((Component)new JScrollPane(this.list), "Before");
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "First");
        this.add((Component)this.edit, "Center");
        this.load();
    }

    private void copy() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        PointOfInterestData data = new PointOfInterestData(this.model.get(selected));
        this.model.add(this.model.size(), data);
    }

    private void updateEdit() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.edit.setCurrent(this.model.get(selected));
    }

    void save() {
        Array<PointOfInterestData> allEnemies = new Array<PointOfInterestData>();
        for (int i = 0; i < this.model.getSize(); ++i) {
            allEnemies.add(this.model.get(i));
        }
        Json json = new Json(JsonWriter.OutputType.json);
        FileHandle handle = Config.instance().getFile("world/points_of_interest.json");
        handle.writeString(json.prettyPrint(json.toJson(allEnemies, Array.class, PointOfInterestData.class)), false);
    }

    void load() {
        this.model.clear();
        Array allEnemies = new Array();
        Json json = new Json();
        FileHandle handle = Config.instance().getFile("world/points_of_interest.json");
        if (handle.exists()) {
            allEnemies = json.fromJson(Array.class, PointOfInterestData.class, handle);
        }
        for (int i = 0; i < allEnemies.size; ++i) {
            this.model.add(i, (PointOfInterestData)allEnemies.get(i));
        }
        QuestController.getInstance().load();
    }

    void addItem() {
        PointOfInterestData data = new PointOfInterestData();
        data.name = "PoI " + this.model.getSize();
        this.model.add(this.model.size(), data);
    }

    void remove() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.model.remove(selected);
    }

    public static class PointOfInterestRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SwingAtlas poiAtlas;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof PointOfInterestData)) {
                return label;
            }
            PointOfInterestData poi = (PointOfInterestData)value;
            label.setText(poi.name);
            if (!atlas.containsKey(poi.spriteAtlas)) {
                atlas.put(poi.spriteAtlas, new SwingAtlas(Config.instance().getFile(poi.spriteAtlas)));
            }
            if ((poiAtlas = atlas.get(poi.spriteAtlas)).has(poi.sprite)) {
                label.setIcon(poiAtlas.get(poi.sprite));
            } else {
                ImageIcon img = poiAtlas.getAny();
                if (img != null) {
                    label.setIcon(img);
                }
            }
            return label;
        }
    }
}

