/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.PointOfInterestData;
import forge.adventure.editor.DocumentChangeListener;
import forge.adventure.editor.FilePicker;
import forge.adventure.editor.FormPanel;
import forge.adventure.editor.QuestController;
import forge.adventure.editor.SwingAtlasPreview;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class PointOfInterestEdit
extends JComponent {
    PointOfInterestData currentData;
    JTextField name = new JTextField();
    JTextField type = new JTextField();
    JSpinner count = new JSpinner(new SpinnerNumberModel(0, 0, 1000, 1));
    FilePicker spriteAtlas = new FilePicker(new String[]{"atlas"});
    JTextField sprite = new JTextField();
    FilePicker map = new FilePicker(new String[]{"tmx"});
    JSpinner radiusFactor = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 2.0, 0.1f));
    SwingAtlasPreview preview = new SwingAtlasPreview(256, 2000);
    JTextField manualEntry = new JTextField(20);
    DefaultListModel<String> existingModel = new DefaultListModel();
    DefaultListModel<String> POIModel = new DefaultListModel();
    JList<String> existingTags;
    JList<String> POITags;
    private boolean updating = false;

    public PointOfInterestEdit() {
        JTabbedPane tabs = new JTabbedPane();
        this.add((Component)tabs, "Center");
        this.setLayout(new BoxLayout(this, 1));
        FormPanel parameters = new FormPanel();
        parameters.setBorder(BorderFactory.createTitledBorder("Parameter"));
        JPanel tags = new JPanel();
        tabs.addTab("Basic Info", parameters);
        tabs.addTab("Quest Tags", tags);
        parameters.add("Name:", (JComponent)this.name);
        parameters.add("Type:", (JComponent)this.type);
        parameters.add("Count:", (JComponent)this.count);
        parameters.add("Sprite atlas:", (JComponent)this.spriteAtlas);
        parameters.add("Sprite:", (JComponent)this.sprite);
        parameters.add("Map:", (JComponent)this.map);
        parameters.add("Radius factor:", (JComponent)this.radiusFactor);
        parameters.add(this.preview);
        this.name.getDocument().addDocumentListener(new DocumentChangeListener(this::updateItem));
        this.type.getDocument().addDocumentListener(new DocumentChangeListener(this::updateItem));
        this.count.addChangeListener(e -> this.updateItem());
        this.spriteAtlas.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateItem));
        this.sprite.getDocument().addDocumentListener(new DocumentChangeListener(this::updateItem));
        this.map.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateItem));
        this.radiusFactor.addChangeListener(e -> this.updateItem());
        this.existingTags = new JList();
        this.existingTags.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "addSelected");
        this.existingTags.getActionMap().put("addSelected", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = PointOfInterestEdit.this.existingTags.getSelectedIndex();
                String selectedItem = PointOfInterestEdit.this.existingTags.getSelectedValue();
                if (selectedItem != null) {
                    PointOfInterestEdit.this.POIModel.addElement(selectedItem);
                    PointOfInterestEdit.this.existingTags.grabFocus();
                    PointOfInterestEdit.this.existingTags.setSelectedIndex(index < PointOfInterestEdit.this.existingModel.size() ? index : index - 1);
                }
            }
        });
        this.existingModel = QuestController.getInstance().getPOITags();
        this.existingTags.setModel(this.existingModel);
        this.POITags = new JList();
        this.POIModel = new DefaultListModel();
        this.POITags.setModel(this.POIModel);
        this.POITags.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                PointOfInterestEdit.this.updateItem();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                PointOfInterestEdit.this.updateItem();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                PointOfInterestEdit.this.updateItem();
            }
        });
        JButton select = new JButton("Select");
        select.addActionListener(q -> this.addSelected());
        JButton add = new JButton("Manual Add");
        add.addActionListener(q -> this.manualAdd(this.POIModel));
        JButton remove = new JButton("Remove Item");
        remove.addActionListener(q -> this.removeSelected());
        tags.setLayout(new BorderLayout());
        JPanel left = new JPanel();
        left.setLayout(new BorderLayout());
        left.add((Component)new JLabel("Tags already in use"), "North");
        JScrollPane listScroller = new JScrollPane(this.existingTags);
        listScroller.setMinimumSize(new Dimension(400, 800));
        left.add((Component)listScroller, "Center");
        tags.add((Component)left, "West");
        FormPanel tagEdit = new FormPanel();
        tagEdit.setLayout(new BorderLayout());
        FormPanel mappedTags = new FormPanel();
        mappedTags.setLayout(new BorderLayout());
        mappedTags.add((Component)new JLabel("Tags Mapped to this object"), "North");
        JScrollPane listScroller2 = new JScrollPane(this.POITags);
        listScroller2.setMinimumSize(new Dimension(400, 800));
        mappedTags.add((Component)listScroller2, "Center");
        tagEdit.add((Component)mappedTags, "East");
        JPanel controlPanel = new JPanel();
        controlPanel.add(select);
        controlPanel.add(add);
        controlPanel.add(this.manualEntry);
        this.manualEntry.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "addTyped");
        this.manualEntry.getActionMap().put("addTyped", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PointOfInterestEdit.this.manualEntry.getText().trim().isEmpty()) {
                    PointOfInterestEdit.this.manualAdd(PointOfInterestEdit.this.POIModel);
                    PointOfInterestEdit.this.manualEntry.grabFocus();
                }
            }
        });
        controlPanel.add(remove);
        tagEdit.add((Component)controlPanel, "Center");
        tags.add((Component)tagEdit, "Center");
        JTextArea right1 = new JTextArea("This is really just to pad some space\nbut also to explain the use of tags.\nRather than adding 100's of object names\nto every quest definition, instead we will\ncategorize enemies and points of interest with\ntags and reference those categories in quests");
        right1.setEnabled(false);
        tags.add((Component)right1, "East");
        this.refresh();
    }

    private void updateItem() {
        if (this.currentData == null || this.updating) {
            return;
        }
        this.currentData.name = this.name.getText();
        this.currentData.type = this.type.getText();
        this.currentData.count = (Integer)this.count.getValue();
        this.currentData.spriteAtlas = this.spriteAtlas.getEdit().getText();
        this.currentData.sprite = this.sprite.getText();
        this.currentData.map = this.map.getEdit().getText();
        this.currentData.radiusFactor = ((Float)this.radiusFactor.getValue()).floatValue();
        ArrayList<String> tags = new ArrayList<String>();
        Enumeration<String> e = this.POIModel.elements();
        while (e.hasMoreElements()) {
            tags.add(e.nextElement());
        }
        this.currentData.questTags = tags.toArray(this.currentData.questTags);
        QuestController.getInstance().refresh();
        this.filterExisting(this.POIModel);
    }

    public void setCurrent(PointOfInterestData data) {
        this.currentData = data;
        this.refresh();
    }

    private void addSelected() {
        if (this.existingTags.getSelectedIndex() > -1) {
            this.POIModel.addElement(this.existingTags.getModel().getElementAt(this.existingTags.getSelectedIndex()));
        }
        this.updateItem();
    }

    private void removeSelected() {
        if (this.POITags.getSelectedIndex() > -1) {
            this.POIModel.remove(this.POITags.getSelectedIndex());
        }
        this.updateItem();
    }

    private void filterExisting(DefaultListModel<String> filter) {
        DefaultListModel<String> toReturn = new DefaultListModel<String>();
        Enumeration<String> e = QuestController.getInstance().getPOITags().elements();
        while (e.hasMoreElements()) {
            String toTest = e.nextElement();
            if (!(toTest != null & !filter.contains(toTest))) continue;
            toReturn.addElement(toTest);
        }
        this.existingTags.setModel(toReturn);
    }

    private void manualAdd(DefaultListModel<String> model) {
        if (!this.manualEntry.getText().trim().isEmpty()) {
            model.addElement(this.manualEntry.getText().trim());
        }
        this.manualEntry.setText("");
        this.updateItem();
    }

    private void refresh() {
        this.setEnabled(this.currentData != null);
        if (this.currentData == null) {
            return;
        }
        this.updating = true;
        this.name.setText(this.currentData.name);
        this.type.setText(this.currentData.type);
        this.count.setValue(this.currentData.count);
        this.spriteAtlas.getEdit().setText(this.currentData.spriteAtlas);
        this.sprite.setText(this.currentData.sprite);
        this.map.getEdit().setText(this.currentData.map);
        this.radiusFactor.setValue(Float.valueOf(this.currentData.radiusFactor));
        this.preview.setSpritePath(this.currentData.spriteAtlas, this.currentData.sprite);
        this.POIModel.clear();
        for (String val : this.currentData.questTags) {
            if (val == null) continue;
            this.POIModel.addElement(val);
        }
        this.filterExisting(this.POIModel);
        this.updating = false;
    }
}

