/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import forge.adventure.data.ItemData;
import forge.adventure.editor.ItemEdit;
import forge.adventure.editor.SwingAtlas;
import forge.adventure.util.Config;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class ItemsEditor
extends JComponent {
    DefaultListModel<ItemData> model = new DefaultListModel();
    JList<ItemData> list = new JList<ItemData>(this.model);
    JToolBar toolBar = new JToolBar("toolbar");
    ItemEdit edit = new ItemEdit();
    static SwingAtlas itemAtlas;

    public void addButton(String name, ActionListener action) {
        JButton newButton = new JButton(name);
        newButton.addActionListener(action);
        this.toolBar.add(newButton);
    }

    public ItemsEditor() {
        this.list.setCellRenderer(new ItemDataRenderer());
        this.list.addListSelectionListener(e -> this.updateEdit());
        this.addButton("add", e -> this.addItem());
        this.addButton("remove", e -> this.remove());
        this.addButton("copy", e -> this.copy());
        this.addButton("load", e -> this.load());
        this.addButton("save", e -> this.save());
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add((Component)new JScrollPane(this.list), "Before");
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "First");
        this.add((Component)this.edit, "Center");
        this.load();
    }

    private void copy() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        ItemData data = new ItemData(this.model.get(selected));
        this.model.add(this.model.size(), data);
    }

    private void updateEdit() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.edit.setCurrentItem(this.model.get(selected));
    }

    void save() {
        Array<ItemData> allEnemies = new Array<ItemData>();
        for (int i = 0; i < this.model.getSize(); ++i) {
            allEnemies.add(this.model.get(i));
        }
        Json json = new Json(JsonWriter.OutputType.json);
        FileHandle handle = Config.instance().getFile("world/items.json");
        handle.writeString(json.prettyPrint(json.toJson(allEnemies, Array.class, ItemData.class)), false);
    }

    void load() {
        this.model.clear();
        Array allEnemies = new Array();
        Json json = new Json();
        FileHandle handle = Config.instance().getFile("world/items.json");
        if (handle.exists()) {
            allEnemies = json.fromJson(Array.class, ItemData.class, handle);
        }
        for (int i = 0; i < allEnemies.size; ++i) {
            this.model.add(i, (ItemData)allEnemies.get(i));
        }
    }

    void addItem() {
        ItemData data = new ItemData();
        data.name = "Item " + this.model.getSize();
        this.model.add(this.model.size(), data);
    }

    void remove() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.model.remove(selected);
    }

    public class ItemDataRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof ItemData)) {
                return label;
            }
            ItemData Item2 = (ItemData)value;
            label.setText(Item2.name);
            if (itemAtlas == null) {
                itemAtlas = new SwingAtlas(Config.instance().getFile("sprites/items.atlas"));
            }
            if (itemAtlas.has(Item2.iconName)) {
                label.setIcon(itemAtlas.get(Item2.iconName));
            } else {
                ImageIcon img = itemAtlas.getAny();
                if (img != null) {
                    label.setIcon(img);
                }
            }
            return label;
        }
    }
}

