/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.ItemData;
import forge.adventure.editor.DocumentChangeListener;
import forge.adventure.editor.EffectEditor;
import forge.adventure.editor.FormPanel;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class ItemEdit
extends JComponent {
    ItemData currentData;
    JTextField nameField = new JTextField();
    JTextField equipmentSlot = new JTextField();
    JTextField iconName = new JTextField();
    EffectEditor effect = new EffectEditor(false);
    JTextField description = new JTextField();
    JCheckBox questItem = new JCheckBox();
    JSpinner cost = new JSpinner(new SpinnerNumberModel(0, 0, 100000, 1));
    private boolean updating = false;

    public ItemEdit() {
        this.setLayout(new BoxLayout(this, 1));
        FormPanel parameters = new FormPanel();
        parameters.setBorder(BorderFactory.createTitledBorder("Parameter"));
        parameters.add("Name:", (JComponent)this.nameField);
        parameters.add("equipmentSlot:", (JComponent)this.equipmentSlot);
        parameters.add("description:", (JComponent)this.description);
        parameters.add("iconName", (JComponent)this.iconName);
        parameters.add("questItem", (JComponent)this.questItem);
        parameters.add("cost", (JComponent)this.cost);
        this.add(parameters);
        this.add(this.effect);
        this.add(new Box.Filler(new Dimension(0, 0), new Dimension(0, Integer.MAX_VALUE), new Dimension(0, Integer.MAX_VALUE)));
        this.nameField.getDocument().addDocumentListener(new DocumentChangeListener(this::updateItem));
        this.equipmentSlot.getDocument().addDocumentListener(new DocumentChangeListener(this::updateItem));
        this.description.getDocument().addDocumentListener(new DocumentChangeListener(this::updateItem));
        this.iconName.getDocument().addDocumentListener(new DocumentChangeListener(this::updateItem));
        this.cost.addChangeListener(e -> this.updateItem());
        this.questItem.addChangeListener(e -> this.updateItem());
        this.effect.addChangeListener(e -> this.updateItem());
        this.refresh();
    }

    private void updateItem() {
        if (this.currentData == null || this.updating) {
            return;
        }
        this.currentData.name = this.nameField.getText();
        this.currentData.equipmentSlot = this.equipmentSlot.getText();
        this.currentData.effect = this.effect.getCurrentEffect();
        this.currentData.description = this.description.getText();
        this.currentData.iconName = this.iconName.getText();
        this.currentData.questItem = this.questItem.isSelected();
        this.currentData.cost = (Integer)this.cost.getValue();
    }

    public void setCurrentItem(ItemData data) {
        this.currentData = data;
        this.refresh();
    }

    private void refresh() {
        this.setEnabled(this.currentData != null);
        if (this.currentData == null) {
            return;
        }
        this.updating = true;
        this.nameField.setText(this.currentData.name);
        this.effect.setCurrentEffect(this.currentData.effect);
        this.equipmentSlot.setText(this.currentData.equipmentSlot);
        this.description.setText(this.currentData.description);
        this.iconName.setText(this.currentData.iconName);
        this.questItem.setSelected(this.currentData.questItem);
        this.cost.setValue(this.currentData.cost);
        this.updating = false;
    }
}

