/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.util.Config;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FilePicker
extends Box {
    JTextField edit = new JTextField();
    JButton findButton = new JButton(UIManager.getIcon("FileView.directoryIcon"));
    private final String[] fileEndings;

    public FilePicker(String[] fileEndings) {
        super(0);
        this.fileEndings = fileEndings;
        this.findButton.addActionListener(e -> this.find());
        this.add(this.edit);
        this.add(this.findButton);
    }

    JTextField getEdit() {
        return this.edit;
    }

    private void find() {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File(Config.instance().getFilePath(this.edit.getText())));
        fc.setFileFilter(new FileNameExtensionFilter("Pick File", this.fileEndings));
        fc.setMultiSelectionEnabled(false);
        if (fc.showOpenDialog(this) == 0) {
            File selected = fc.getSelectedFile();
            try {
                if (selected != null && selected.getCanonicalPath().startsWith(new File(Config.instance().getFilePath("")).getCanonicalPath())) {
                    this.edit.setText(selected.getCanonicalPath().substring(new File(Config.instance().getFilePath("")).getCanonicalPath().length() + 1).replace('\\', '/'));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

