/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import forge.adventure.data.EnemyData;
import forge.adventure.editor.EnemyEdit;
import forge.adventure.editor.QuestController;
import forge.adventure.editor.SwingAtlas;
import forge.adventure.util.Config;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class EnemyEditor
extends JComponent {
    DefaultListModel<EnemyData> model = new DefaultListModel();
    JList<EnemyData> list = new JList<EnemyData>(this.model);
    JToolBar toolBar = new JToolBar("toolbar");
    EnemyEdit edit = new EnemyEdit();

    public void addButton(String name, ActionListener action) {
        JButton newButton = new JButton(name);
        newButton.addActionListener(action);
        this.toolBar.add(newButton);
    }

    public EnemyEditor() {
        this.list.setCellRenderer(new EnemyDataRenderer());
        this.list.addListSelectionListener(e -> this.updateEdit());
        this.addButton("add", e -> this.addEnemy());
        this.addButton("remove", e -> this.remove());
        this.addButton("copy", e -> this.copy());
        this.addButton("load", e -> {
            this.load();
            QuestController.getInstance().load();
        });
        this.addButton("save", e -> this.save());
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add((Component)new JScrollPane(this.list), "Before");
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "First");
        this.add((Component)this.edit, "Center");
        this.load();
    }

    private void copy() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        EnemyData data = new EnemyData(this.model.get(selected));
        this.model.add(this.model.size(), data);
    }

    private void updateEdit() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.edit.setCurrentEnemy(this.model.get(selected));
        this.edit.updateEnemy();
    }

    void save() {
        Array<EnemyData> allEnemies = new Array<EnemyData>();
        for (int i = 0; i < this.model.getSize(); ++i) {
            allEnemies.add(this.model.get(i));
        }
        Json json = new Json(JsonWriter.OutputType.json);
        FileHandle handle = Config.instance().getFile("world/enemies.json");
        handle.writeString(json.prettyPrint(json.toJson(allEnemies, Array.class, EnemyData.class)), false);
    }

    void load() {
        this.model.clear();
        Array allEnemies = new Array();
        Json json = new Json();
        FileHandle handle = Config.instance().getFile("world/enemies.json");
        if (handle.exists()) {
            allEnemies = json.fromJson(Array.class, EnemyData.class, handle);
        }
        for (int i = 0; i < allEnemies.size; ++i) {
            this.model.add(i, (EnemyData)allEnemies.get(i));
        }
    }

    void addEnemy() {
        EnemyData data = new EnemyData();
        data.name = "Enemy " + this.model.getSize();
        this.model.add(this.model.size(), data);
    }

    void remove() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.model.remove(selected);
    }

    public class EnemyDataRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof EnemyData)) {
                return label;
            }
            EnemyData enemy = (EnemyData)value;
            label.setText(enemy.name);
            SwingAtlas atlas = new SwingAtlas(Config.instance().getFile(enemy.sprite));
            if (atlas.has("Avatar")) {
                label.setIcon(atlas.get("Avatar"));
            } else {
                ImageIcon img = atlas.getAny();
                if (img != null) {
                    label.setIcon(img);
                }
            }
            return label;
        }
    }
}

