/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.EnemyData;
import forge.adventure.editor.DocumentChangeListener;
import forge.adventure.editor.FilePicker;
import forge.adventure.editor.FloatSpinner;
import forge.adventure.editor.FormPanel;
import forge.adventure.editor.QuestController;
import forge.adventure.editor.RewardsEditor;
import forge.adventure.editor.SwingAtlasPreview;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class EnemyEdit
extends FormPanel {
    EnemyData currentData;
    JTextField nameField = new JTextField();
    JTextField nameOverride = new JTextField();
    JTextField colorField = new JTextField();
    JTextField ai = new JTextField();
    JCheckBox flying = new JCheckBox();
    JCheckBox boss = new JCheckBox();
    JCheckBox ignoreDungeonEffect = new JCheckBox();
    FloatSpinner lifeFiled = new FloatSpinner(0.0f, 1000.0f, 1.0f);
    FloatSpinner spawnRate = new FloatSpinner(0.0f, 1.0f, 0.1f);
    FloatSpinner scale = new FloatSpinner(0.0f, 8.0f, 0.1f);
    FloatSpinner difficulty = new FloatSpinner(0.0f, 1.0f, 0.1f);
    FloatSpinner speed = new FloatSpinner(0.0f, 100.0f, 1.0f);
    FilePicker deck = new FilePicker(new String[]{"dck", "json"});
    FilePicker atlas = new FilePicker(new String[]{"atlas"});
    JTextField equipment = new JTextField();
    RewardsEditor rewards = new RewardsEditor();
    SwingAtlasPreview preview = new SwingAtlasPreview();
    JTextField manualEntry = new JTextField(20);
    private boolean updating = false;
    DefaultListModel<String> existingModel = new DefaultListModel();
    DefaultListModel<String> enemyModel = new DefaultListModel();
    JList<String> existingTags;
    JList<String> enemyTags;

    public EnemyEdit() {
        this.setLayout(new BorderLayout());
        FormPanel top = new FormPanel(){};
        this.add((Component)top, "North");
        JTabbedPane tabs = new JTabbedPane();
        this.add((Component)tabs, "Center");
        FormPanel basicInfo = new FormPanel(){};
        tabs.addTab("Basic Info", basicInfo);
        top.add("Name:", (JComponent)this.nameField);
        top.add("Display Name:", (JComponent)this.nameOverride);
        basicInfo.add("Life:", (JComponent)this.lifeFiled);
        basicInfo.add("Spawn rate:", (JComponent)this.spawnRate);
        basicInfo.add("Scale:", (JComponent)this.scale);
        basicInfo.add("Difficulty:", (JComponent)this.difficulty);
        basicInfo.add("Speed:", (JComponent)this.speed);
        basicInfo.add("Deck:", (JComponent)this.deck);
        basicInfo.add("Equipment:", (JComponent)this.equipment);
        basicInfo.add("Colors:", (JComponent)this.colorField);
        basicInfo.add("ai:", (JComponent)this.ai);
        basicInfo.add("flying:", (JComponent)this.flying);
        basicInfo.add("boss:", (JComponent)this.boss);
        JPanel visual = new JPanel();
        visual.add("Sprite:", this.atlas);
        visual.add(this.preview);
        JPanel tags = new JPanel();
        this.existingTags = new JList();
        this.existingTags.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "addSelected");
        this.existingTags.getActionMap().put("addSelected", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnemyEdit.this.addSelected();
                int index = EnemyEdit.this.existingTags.getSelectedIndex();
                String selectedItem = EnemyEdit.this.existingTags.getSelectedValue();
                if (selectedItem != null) {
                    EnemyEdit.this.enemyModel.addElement(selectedItem);
                    EnemyEdit.this.existingTags.grabFocus();
                    EnemyEdit.this.existingTags.setSelectedIndex(index < EnemyEdit.this.existingModel.size() ? index : index - 1);
                }
            }
        });
        this.existingModel = QuestController.getInstance().getEnemyTags();
        this.existingTags.setModel(this.existingModel);
        this.enemyTags = new JList();
        this.enemyModel = new DefaultListModel();
        this.enemyTags.setModel(this.enemyModel);
        this.enemyTags.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                EnemyEdit.this.doUpdate();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                EnemyEdit.this.doUpdate();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                EnemyEdit.this.doUpdate();
            }
        });
        JButton select = new JButton("Select");
        select.addActionListener(q -> this.addSelected());
        JButton add = new JButton("Manual Add");
        add.addActionListener(q -> this.manualAdd(this.enemyModel));
        JButton remove = new JButton("Remove Item");
        remove.addActionListener(q -> this.removeSelected());
        tags.setLayout(new BorderLayout());
        JPanel left = new JPanel();
        left.setLayout(new BorderLayout());
        left.add((Component)new JLabel("Tags already in use"), "North");
        JScrollPane listScroller = new JScrollPane(this.existingTags);
        listScroller.setMinimumSize(new Dimension(400, 800));
        left.add((Component)listScroller, "Center");
        tags.add((Component)left, "West");
        FormPanel tagEdit = new FormPanel();
        tagEdit.setLayout(new BorderLayout());
        FormPanel mappedTags = new FormPanel();
        mappedTags.setLayout(new BorderLayout());
        mappedTags.add((Component)new JLabel("Tags Mapped to this object"), "North");
        JScrollPane listScroller2 = new JScrollPane(this.enemyTags);
        listScroller2.setMinimumSize(new Dimension(400, 800));
        mappedTags.add((Component)listScroller2, "Center");
        tagEdit.add((Component)mappedTags, "East");
        JPanel controlPanel = new JPanel();
        controlPanel.add(select);
        controlPanel.add(add);
        controlPanel.add(this.manualEntry);
        this.manualEntry.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "addTyped");
        this.manualEntry.getActionMap().put("addTyped", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EnemyEdit.this.manualEntry.getText().trim().isEmpty()) {
                    EnemyEdit.this.manualAdd(EnemyEdit.this.enemyModel);
                    EnemyEdit.this.manualEntry.grabFocus();
                }
            }
        });
        controlPanel.add(remove);
        tagEdit.add((Component)controlPanel, "Center");
        tags.add((Component)tagEdit, "Center");
        JTextArea right1 = new JTextArea("This is really just to pad some space\nbut also to explain the use of tags.\nRather than adding 100's of object names\nto every quest definition, instead we will\ncategorize enemies and points of interest with\ntags and reference those categories in quests");
        right1.setEnabled(false);
        tags.add((Component)right1, "East");
        tabs.addTab("Sprite", visual);
        tabs.addTab("Rewards", this.rewards);
        tabs.addTab("Quest Tags", tags);
        this.equipment.getDocument().addDocumentListener(new DocumentChangeListener(this::updateEnemy));
        this.atlas.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateEnemy));
        this.colorField.getDocument().addDocumentListener(new DocumentChangeListener(this::updateEnemy));
        this.ai.getDocument().addDocumentListener(new DocumentChangeListener(this::updateEnemy));
        this.flying.addChangeListener(e -> this.updateEnemy());
        this.boss.addChangeListener(e -> this.updateEnemy());
        this.ignoreDungeonEffect.addChangeListener(e -> this.updateEnemy());
        this.nameField.getDocument().addDocumentListener(new DocumentChangeListener(this::updateEnemy));
        this.nameOverride.getDocument().addDocumentListener(new DocumentChangeListener(this::updateEnemy));
        this.deck.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateEnemy));
        this.lifeFiled.addChangeListener(e -> this.updateEnemy());
        this.speed.addChangeListener(e -> this.updateEnemy());
        this.scale.addChangeListener(e -> this.updateEnemy());
        this.difficulty.addChangeListener(e -> this.updateEnemy());
        this.spawnRate.addChangeListener(e -> this.updateEnemy());
        this.rewards.addChangeListener(e -> this.updateEnemy());
        this.lifeFiled.addChangeListener(e -> this.updateEnemy());
        this.enemyModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                EnemyEdit.this.updateEnemy();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                EnemyEdit.this.updateEnemy();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                EnemyEdit.this.updateEnemy();
            }
        });
        this.refresh();
    }

    private void doUpdate() {
        this.updateEnemy();
    }

    private void addSelected() {
        if (this.existingTags.getSelectedIndex() > -1) {
            this.enemyModel.addElement(this.existingTags.getModel().getElementAt(this.existingTags.getSelectedIndex()));
        }
        this.doUpdate();
    }

    private void removeSelected() {
        if (this.enemyTags.getSelectedIndex() > -1) {
            this.enemyModel.remove(this.enemyTags.getSelectedIndex());
        }
        this.doUpdate();
    }

    private void filterExisting(DefaultListModel<String> filter) {
        DefaultListModel<String> toReturn = new DefaultListModel<String>();
        Enumeration<String> e = QuestController.getInstance().getEnemyTags().elements();
        while (e.hasMoreElements()) {
            String toTest = e.nextElement();
            if (!(toTest != null & !filter.contains(toTest))) continue;
            toReturn.addElement(toTest);
        }
        this.existingTags.setModel(toReturn);
    }

    private void manualAdd(DefaultListModel<String> model) {
        if (!this.manualEntry.getText().trim().isEmpty()) {
            model.addElement(this.manualEntry.getText().trim());
        }
        this.manualEntry.setText("");
        this.doUpdate();
    }

    public void updateEnemy() {
        if (this.currentData == null || this.updating) {
            return;
        }
        this.currentData.name = this.nameField.getText();
        this.currentData.colors = this.colorField.getText();
        this.currentData.ai = this.ai.getText();
        this.currentData.flying = this.flying.isSelected();
        this.currentData.boss = this.boss.isSelected();
        this.currentData.life = (Integer)this.lifeFiled.getValue();
        this.currentData.sprite = this.atlas.getEdit().getText();
        this.currentData.equipment = this.equipment.getText().isEmpty() ? null : this.equipment.getText().split(",");
        this.currentData.speed = this.speed.floatValue();
        this.currentData.scale = this.scale.floatValue();
        this.currentData.spawnRate = this.spawnRate.floatValue();
        this.currentData.difficulty = this.difficulty.floatValue();
        this.currentData.deck = this.deck.getEdit().getText().split(",");
        this.currentData.rewards = this.rewards.getRewards();
        this.preview.setSpritePath(this.currentData.sprite);
        ArrayList<String> tags = new ArrayList<String>();
        Enumeration<String> e = this.enemyModel.elements();
        while (e.hasMoreElements()) {
            tags.add(e.nextElement());
        }
        tags.removeIf(String::isEmpty);
        this.currentData.questTags = tags.toArray(this.currentData.questTags);
        QuestController.getInstance().refresh();
        this.filterExisting(this.enemyModel);
    }

    public void setCurrentEnemy(EnemyData data) {
        this.currentData = data;
        this.refresh();
    }

    private void refresh() {
        this.setEnabled(this.currentData != null);
        if (this.currentData == null) {
            return;
        }
        this.updating = true;
        this.nameField.setText(this.currentData.name);
        this.colorField.setText(this.currentData.colors);
        this.ai.setText(this.currentData.ai);
        this.boss.setSelected(this.currentData.boss);
        this.flying.setSelected(this.currentData.flying);
        this.lifeFiled.setValue(this.currentData.life);
        this.atlas.getEdit().setText(this.currentData.sprite);
        if (this.currentData.equipment != null) {
            this.equipment.setText(String.join((CharSequence)",", this.currentData.equipment));
        } else {
            this.equipment.setText("");
        }
        this.deck.getEdit().setText(String.join((CharSequence)",", this.currentData.deck));
        this.speed.setValue(Float.valueOf(this.currentData.speed));
        this.scale.setValue(Float.valueOf(this.currentData.scale));
        this.spawnRate.setValue(Float.valueOf(this.currentData.spawnRate));
        this.difficulty.setValue(Float.valueOf(this.currentData.difficulty));
        this.rewards.setRewards(this.currentData.rewards);
        this.preview.setSpritePath(this.currentData.sprite);
        this.enemyModel.clear();
        for (String val : this.currentData.questTags) {
            if (val == null) continue;
            this.enemyModel.addElement(val);
        }
        this.filterExisting(this.enemyModel);
        this.updating = false;
    }
}

