/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.EffectData;
import forge.adventure.editor.DocumentChangeListener;
import forge.adventure.editor.FormPanel;
import forge.adventure.editor.TextListEdit;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EffectEditor
extends JComponent {
    EffectData currentData;
    JTextField name = new JTextField();
    JSpinner changeStartCards = new JSpinner(new SpinnerNumberModel(0, 0, 1000, 1));
    JSpinner lifeModifier = new JSpinner(new SpinnerNumberModel(0, 0, 1000, 1));
    JSpinner moveSpeed = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.1f));
    TextListEdit startBattleWithCard = new TextListEdit();
    JCheckBox colorView = new JCheckBox();
    EffectEditor opponent = null;
    private boolean updating = false;

    public EffectEditor(boolean isOpponentEffect) {
        if (!isOpponentEffect) {
            this.opponent = new EffectEditor(true);
        }
        this.setLayout(new BoxLayout(this, 1));
        FormPanel parameters = new FormPanel();
        parameters.setBorder(BorderFactory.createTitledBorder("Effect"));
        parameters.add("Name:", (JComponent)this.name);
        parameters.add("Start with extra cards:", (JComponent)this.changeStartCards);
        parameters.add("Change life:", (JComponent)this.lifeModifier);
        parameters.add("Movement speed:", (JComponent)this.moveSpeed);
        parameters.add("Start battle with cards:", (JComponent)this.startBattleWithCard);
        parameters.add("color view:", (JComponent)this.colorView);
        this.add(parameters);
        if (!isOpponentEffect) {
            this.add(new JLabel("Opponent:"));
            this.add(this.opponent);
        }
        this.changeStartCards.addChangeListener(e -> this.updateEffect());
        this.lifeModifier.addChangeListener(e -> this.updateEffect());
        this.moveSpeed.addChangeListener(e -> this.updateEffect());
        this.colorView.addChangeListener(e -> this.updateEffect());
        this.name.getDocument().addDocumentListener(new DocumentChangeListener(this::updateEffect));
        this.startBattleWithCard.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateEffect));
        if (this.opponent != null) {
            this.opponent.addChangeListener(e -> this.updateEffect());
        }
    }

    private void updateEffect() {
        if (this.currentData == null || this.updating) {
            return;
        }
        this.currentData.name = this.name.getText();
        this.currentData.changeStartCards = (Integer)this.changeStartCards.getValue();
        this.currentData.lifeModifier = (Integer)this.lifeModifier.getValue();
        this.currentData.moveSpeed = ((Float)this.moveSpeed.getValue()).floatValue();
        this.currentData.startBattleWithCard = this.startBattleWithCard.getList();
        this.currentData.colorView = this.colorView.isSelected();
        this.currentData.opponent = this.opponent.currentData;
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        if (listeners != null && listeners.length > 0) {
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void setCurrentEffect(EffectData data) {
        if (data == null) {
            return;
        }
        this.currentData = data;
        this.refresh();
    }

    public EffectData getCurrentEffect() {
        return this.currentData;
    }

    private void refresh() {
        this.setEnabled(this.currentData != null);
        if (this.currentData == null) {
            return;
        }
        this.updating = true;
        this.name.setText(this.currentData.name);
        this.lifeModifier.setValue(this.currentData.lifeModifier);
        this.changeStartCards.setValue(this.currentData.changeStartCards);
        this.startBattleWithCard.setText(this.currentData.startBattleWithCard);
        this.colorView.setSelected(this.currentData.colorView);
        this.moveSpeed.setValue(Float.valueOf(this.currentData.moveSpeed));
        if (this.opponent != null) {
            this.opponent.setCurrentEffect(this.currentData.opponent);
        }
        this.updating = false;
    }
}

