/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import com.badlogic.gdx.tools.particleeditor.ParticleEditor;
import forge.adventure.editor.EnemyEditor;
import forge.adventure.editor.ItemsEditor;
import forge.adventure.editor.PointOfInterestEditor;
import forge.adventure.editor.QuestEditor;
import forge.adventure.editor.WorldEditor;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.Lang;
import forge.util.Localizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class EditorMainWindow
extends JFrame {
    public static final WorldEditor worldEditor = new WorldEditor();
    JTabbedPane tabs = new JTabbedPane();

    public EditorMainWindow() {
        UIManager.LookAndFeelInfo[] var1 = UIManager.getInstalledLookAndFeels();
        FModel.initialize(null, preferences -> {
            preferences.setPref(ForgePreferences.FPref.LOAD_CARD_SCRIPTS_LAZILY, true);
            return null;
        });
        Lang.createInstance(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_LANGUAGE));
        Localizer.getInstance().initialize(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_LANGUAGE), ForgeConstants.LANG_DIR);
        int var2 = var1.length;
        for (UIManager.LookAndFeelInfo info : var1) {
            if (!"Nimbus".equals(info.getName())) continue;
            try {
                UIManager.setLookAndFeel(info.getClassName());
            }
            catch (Throwable throwable) {}
            break;
        }
        BorderLayout layout = new BorderLayout();
        JToolBar toolBar = new JToolBar("toolbar");
        JButton newButton = new JButton("open ParticleEditor");
        newButton.addActionListener(e -> EventQueue.invokeLater(ParticleEditor::new));
        toolBar.add(newButton);
        this.setLayout(layout);
        toolBar.setFloatable(false);
        this.add((Component)toolBar, "North");
        this.add((Component)this.tabs, "Center");
        this.tabs.addTab("World", worldEditor);
        this.tabs.addTab("POI", new PointOfInterestEditor());
        this.tabs.addTab("Items", new ItemsEditor());
        this.tabs.addTab("Enemies", new EnemyEditor());
        this.tabs.addTab("Quests", new QuestEditor());
        this.setVisible(true);
        this.setSize(800, 600);
        GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(this);
    }
}

