/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.DialogData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DialogTree
extends JPanel {
    private JTree dialogTree;
    private JScrollPane scrollPane;
    private final List<TreeSelectionListener> selectionListeners = new ArrayList<TreeSelectionListener>();

    public DialogTree() {
        this.setLayout(new BorderLayout());
        this.dialogTree = new JTree();
        this.dialogTree.getSelectionModel().setSelectionMode(1);
        this.addSelectionListener();
        this.scrollPane = new JScrollPane(this.dialogTree);
        this.add((Component)this.scrollPane, "Center");
    }

    public void loadDialog(DialogData dialogData) {
        ((DefaultTreeModel)this.dialogTree.getModel()).setRoot(this.buildBranches(dialogData));
    }

    public DefaultMutableTreeNode buildBranches(DialogData dialogData) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(dialogData);
        for (DialogData option : dialogData.options) {
            node.add(this.buildBranches(option));
        }
        return node;
    }

    public void addSelectionListener() {
        this.dialogTree.getSelectionModel().addTreeSelectionListener(this::emitChanged);
    }

    public void addSelectionListener(TreeSelectionListener listener) {
        this.selectionListeners.remove(listener);
        this.selectionListeners.add(listener);
    }

    protected void emitChanged(TreeSelectionEvent evt) {
        if (this.selectionListeners != null && this.selectionListeners.size() > 0) {
            for (TreeSelectionListener listener : this.selectionListeners) {
                listener.valueChanged(evt);
            }
        }
    }

    public void replaceCurrent() {
        if (this.dialogTree.getSelectionPath() == null || this.dialogTree.getSelectionPath().getLastPathComponent() == null) {
            return;
        }
        this.dialogTree.updateUI();
    }

    public DialogData getSelectedData() {
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.dialogTree.getLastSelectedPathComponent();
        if (selectedNode != null) {
            return (DialogData)selectedNode.getUserObject();
        }
        return null;
    }

    public void removeSelectedData() {
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.dialogTree.getLastSelectedPathComponent();
        DialogData parentData = (DialogData)((DefaultMutableTreeNode)selectedNode.getParent()).getUserObject();
        parentData.options = (DialogData[])Arrays.stream(parentData.options).filter(q -> q != selectedNode.getUserObject()).toArray(DialogData[]::new);
        ((DefaultTreeModel)this.dialogTree.getModel()).removeNodeFromParent(selectedNode);
        ((DefaultTreeModel)this.dialogTree.getModel()).reload();
        this.setSelectedData(parentData);
    }

    public void setSelectedData(DialogData data) {
        DefaultMutableTreeNode node = this.findNode((DefaultMutableTreeNode)this.dialogTree.getModel().getRoot(), data);
        if (node != null) {
            this.dialogTree.setSelectionPath(new TreePath(node.getPath()));
        }
    }

    private DefaultMutableTreeNode findNode(DefaultMutableTreeNode parent, DialogData data) {
        if (parent.getUserObject() == data) {
            return parent;
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
            DefaultMutableTreeNode result = this.findNode(child, data);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

