/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.DialogData;
import forge.adventure.editor.DialogOptionEdit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DialogOptionEditor
extends JComponent {
    DefaultListModel<DialogData> model = new DefaultListModel();
    JList<DialogData> list = new JList<DialogData>(this.model);
    JToolBar toolBar = new JToolBar("toolbar");
    DialogOptionEdit edit = new DialogOptionEdit();

    public void addButton(String name, ActionListener action) {
        JButton newButton = new JButton(name);
        newButton.addActionListener(action);
        this.toolBar.add(newButton);
    }

    public DialogOptionEditor() {
        this.list.setCellRenderer(new DialogDataRenderer());
        this.list.addListSelectionListener(e -> this.updateEdit());
        this.addButton("add", e -> this.addOption());
        this.addButton("remove", e -> this.remove());
        this.addButton("copy", e -> this.copy());
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add(this.list, "Before");
        this.add((Component)this.toolBar, "First");
        this.toolBar.setFloatable(false);
        this.add((Component)this.edit, "Center");
        this.edit.setVisible(false);
        this.edit.addChangeListener(e -> this.emitChanged());
    }

    protected void emitChanged() {
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        if (listeners != null && listeners.length > 0) {
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    private void copy() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        DialogData data = new DialogData(this.model.get(selected));
        this.model.add(this.model.size(), data);
    }

    private void updateEdit() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            this.edit.setCurrentOption(new DialogData());
        } else {
            this.edit.setCurrentOption(this.model.get(selected));
        }
    }

    void addOption() {
        DialogData data = new DialogData();
        this.model.add(this.model.size(), data);
        this.edit.setVisible(true);
        this.list.setSelectedIndex(this.model.size() - 1);
    }

    void remove() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.model.remove(selected);
        this.edit.setVisible(this.model.size() > 0);
    }

    public void setOptions(DialogData[] options) {
        this.model.clear();
        if (options == null || options.length == 0) {
            options = new DialogData[]{};
        }
        for (int i = 0; i < options.length; ++i) {
            this.model.add(i, options[i]);
        }
        if (this.model.size() > 0) {
            this.edit.setVisible(true);
            this.list.setSelectedIndex(0);
            this.updateEdit();
        } else {
            this.edit.setVisible(false);
        }
    }

    public DialogData[] getOptions() {
        DialogData[] options = new DialogData[this.model.getSize()];
        for (int i = 0; i < this.model.getSize(); ++i) {
            options[i] = this.model.get(i);
        }
        return options;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public class DialogDataRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof DialogData)) {
                return label;
            }
            DialogData dialog = (DialogData)value;
            StringBuilder builder = new StringBuilder();
            if (dialog.name == null || dialog.name.isEmpty()) {
                builder.append("[[Blank Option]]");
            } else {
                builder.append(dialog.name, 0, Math.min(dialog.name.length(), 25));
            }
            label.setText(builder.toString());
            return label;
        }
    }
}

