/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.DialogData;
import forge.adventure.editor.DocumentChangeListener;
import forge.adventure.editor.FormPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DialogOptionEdit
extends FormPanel {
    DialogData currentData;
    JLabel nameLabel = new JLabel("Name (Player dialog / action)");
    JLabel textLabel = new JLabel("Text (Game response to Name - Leave blank to end dialog)");
    JTextArea text = new JTextArea(3, 80);
    JTextArea name = new JTextArea(3, 80);
    JButton add = new JButton();
    JButton load = new JButton();
    private boolean updating = false;

    public DialogOptionEdit() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel upper = new JPanel();
        upper.setLayout(new BorderLayout());
        upper.add((Component)this.nameLabel, "North");
        upper.add((Component)this.name, "Center");
        this.add(upper);
        JPanel middle = new JPanel();
        middle.setLayout(new BorderLayout());
        middle.add((Component)this.textLabel, "North");
        middle.add((Component)this.text, "Center");
        this.add(middle);
        this.name.getDocument().addDocumentListener(new DocumentChangeListener(this::updateDialog));
        this.text.getDocument().addDocumentListener(new DocumentChangeListener(this::updateDialog));
    }

    private void updateDialog() {
        if (this.currentData == null || this.updating) {
            return;
        }
        this.currentData.text = this.text.getText().trim();
        this.currentData.name = this.name.getText().trim();
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        if (listeners != null && listeners.length > 0) {
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void setCurrentOption(DialogData data) {
        this.currentData = data;
        this.refresh();
    }

    private void refresh() {
        this.setEnabled(this.currentData != null);
        this.updating = true;
        this.text.setText(this.currentData.text != null ? this.currentData.text : "");
        this.name.setText(this.currentData.name != null ? this.currentData.name : "");
        this.updating = false;
    }
}

