/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import com.google.common.collect.ObjectArrays;
import forge.adventure.data.DialogData;
import forge.adventure.data.RewardData;
import forge.adventure.editor.ActionEditor;
import forge.adventure.editor.DialogEdit;
import forge.adventure.editor.DialogOptionEditor;
import forge.adventure.editor.DialogTree;
import forge.adventure.editor.RewardsEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DialogEditor
extends JComponent {
    private boolean updating = false;
    private List<DialogData> allNodes = new ArrayList<DialogData>();
    public JTextArea text = new JTextArea("(Initial dialog text)", 3, 80);
    public RewardsEditor rewardsEditor = new RewardsEditor();
    public ActionEditor actionEditor = new ActionEditor();
    public DialogOptionEditor optionEditor = new DialogOptionEditor();
    public DialogTree navTree = new DialogTree();
    public DialogEdit edit = new DialogEdit();
    private DialogData root = new DialogData();
    private DialogData current = new DialogData();
    JTabbedPane tabs = new JTabbedPane();
    JToolBar conditionsToolbar = new JToolBar("conditionsToolbar");
    JToolBar actionsToolbar = new JToolBar("actionsToolbar");
    JToolBar optionsToolbar = new JToolBar("optionsToolbar");
    JToolBar tokensToolbar = new JToolBar("tokensToolbar");
    JPanel conditionsPanel = new JPanel();
    JPanel actionsPanel = new JPanel();
    JPanel optionsPanel = new JPanel();
    JPanel rewardsPanel = new JPanel();
    JPanel tokensPanel = new JPanel();

    public DialogEditor() {
        this.buildUI();
        this.navTree.addSelectionListener(q -> this.loadNewNodeSelection());
        this.edit.addChangeListener(q -> this.acceptEdits());
        this.edit.addNode.addActionListener(q -> this.addNode());
        this.edit.removeNode.addActionListener(q -> this.removeNode());
    }

    public void loadData(DialogData rootDialogData) {
        this.updating = true;
        if (rootDialogData == null) {
            rootDialogData = new DialogData();
        }
        this.root = rootDialogData;
        this.navTree.loadDialog(rootDialogData);
        this.text.setText(rootDialogData.text);
        this.updating = false;
    }

    public DialogData getDialogData() {
        return this.root;
    }

    public void buildUI() {
        this.buildTabs();
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        JPanel textArea = new JPanel();
        textArea.setLayout(new FlowLayout());
        textArea.add(new JLabel("Dialog Start"));
        textArea.add(this.text);
        this.text.getDocument().addDocumentListener(new QuestTextDocumentListener());
        JSplitPane splitPane = new JSplitPane();
        splitPane.setLeftComponent(this.navTree);
        splitPane.setRightComponent(this.tabs);
        splitPane.setResizeWeight(0.2);
        splitPane.setDividerLocation(0.2);
        this.add((Component)textArea, "North");
        this.add((Component)splitPane, "Center");
    }

    public void loadNewNodeSelection() {
        this.updating = true;
        this.current = this.navTree.getSelectedData();
        this.edit.currentData = this.navTree.getSelectedData();
        this.edit.refresh(this.root.equals(this.current));
        this.rewardsEditor.clear();
        this.actionEditor.clear();
        if (this.navTree.getSelectedData() != null) {
            for (DialogData.ActionData action : this.navTree.getSelectedData().action) {
                if (action.grantRewards == null || action.grantRewards.length <= 0) continue;
                this.rewardsEditor.setRewards(action.grantRewards);
            }
            this.actionEditor.setAction(this.navTree.getSelectedData().action);
        }
        this.updating = false;
    }

    public void acceptEdits() {
        if (this.current == null) {
            return;
        }
        this.current.name = this.edit.name.getText();
        this.current.text = this.edit.text.getText();
        this.current.locname = this.edit.locname.getText();
        this.current.loctext = this.edit.loctext.getText();
        this.root.text = this.text.getText();
        DialogData.ActionData[] action = this.actionEditor.getAction();
        ArrayList<DialogData.ActionData> actionsList = new ArrayList<DialogData.ActionData>(Arrays.stream(action).collect(Collectors.toList()));
        RewardData[] rewards = this.rewardsEditor.getRewards();
        if (rewards.length > 0) {
            DialogData.ActionData rewardAction = new DialogData.ActionData();
            rewardAction.grantRewards = rewards;
            actionsList.add(rewardAction);
        }
        this.current.action = actionsList.toArray(this.current.action);
        this.navTree.replaceCurrent();
        this.emitChanged();
    }

    public void addNode() {
        DialogData newNode = new DialogData();
        newNode.name = "NewResponse";
        DialogData parent = this.navTree.getSelectedData() != null ? this.navTree.getSelectedData() : this.root;
        parent.options = ObjectArrays.concat(parent.options, newNode);
        this.navTree.loadDialog(this.root);
        this.navTree.setSelectedData(newNode);
        this.emitChanged();
    }

    public void removeNode() {
        if (this.navTree.getSelectedData() == null) {
            return;
        }
        this.navTree.removeSelectedData();
        this.emitChanged();
    }

    public void buildTabs() {
        this.buildToolBars();
        this.actionsPanel.add(this.actionsToolbar);
        this.actionsPanel.add(this.actionEditor);
        this.optionsPanel.add(this.edit);
        this.rewardsPanel.add(this.rewardsEditor);
        this.rewardsEditor.addChangeListener(e -> this.acceptEdits());
        this.actionEditor.addChangeListener(e -> this.acceptEdits());
        this.tokensPanel.add(this.tokensToolbar);
        this.tokensPanel.add(new JLabel("Insert token editor here"));
        this.tabs.addTab("Options", this.optionsPanel);
        this.tabs.addTab("Conditions", this.conditionsPanel);
        this.tabs.addTab("Actions", this.actionsPanel);
        this.tabs.addTab("Rewards", this.rewardsPanel);
        this.tabs.addTab("Tokens", this.tokensPanel);
    }

    public void buildToolBars() {
        this.conditionsToolbar.setFloatable(false);
        this.actionsToolbar.setFloatable(false);
        this.optionsToolbar.setFloatable(false);
        JButton addOption = new JButton("Add Option");
        addOption.addActionListener(e -> this.addOption());
        this.optionsToolbar.add(addOption);
        JButton copyOption = new JButton("Copy Selected");
        copyOption.addActionListener(e -> this.copyOption());
        this.optionsToolbar.add(copyOption);
        JButton removeOption = new JButton("Remove Selected");
        removeOption.addActionListener(e -> this.removeOption());
        this.optionsToolbar.add(removeOption);
    }

    public void addOption() {
        this.optionEditor.addOption();
        this.emitChanged();
    }

    public void copyOption() {
        this.emitChanged();
    }

    public void removeOption() {
        int selected = this.optionEditor.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.optionEditor.model.remove(selected);
        this.emitChanged();
    }

    protected void emitChanged() {
        if (this.updating) {
            return;
        }
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        if (listeners != null && listeners.length > 0) {
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    class QuestTextDocumentListener
    implements DocumentListener {
        QuestTextDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ((DialogEditor)DialogEditor.this).root.text = DialogEditor.this.text.getText();
            DialogEditor.this.emitChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ((DialogEditor)DialogEditor.this).root.text = DialogEditor.this.text.getText();
            DialogEditor.this.emitChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ((DialogEditor)DialogEditor.this).root.text = DialogEditor.this.text.getText();
            DialogEditor.this.emitChanged();
        }
    }
}

