/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.DialogData;
import forge.adventure.editor.FormPanel;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DialogEdit
extends FormPanel {
    private boolean updating = false;
    DialogData currentData;
    public JTextField name = new JTextField(80);
    public JTextField text = new JTextField(80);
    public JTextField locname = new JTextField(80);
    public JTextField loctext = new JTextField(80);
    JPanel namePanel;
    JPanel locNamePanel;
    public JButton addNode = new JButton("Add node");
    public JButton removeNode = new JButton("Remove node");

    public DialogEdit() {
        FormPanel center = new FormPanel(){};
        this.name.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!DialogEdit.this.updating) {
                    DialogEdit.this.emitChanged();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!DialogEdit.this.updating) {
                    DialogEdit.this.emitChanged();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!DialogEdit.this.updating) {
                    DialogEdit.this.emitChanged();
                }
            }
        });
        this.text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!DialogEdit.this.updating) {
                    DialogEdit.this.emitChanged();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!DialogEdit.this.updating) {
                    DialogEdit.this.emitChanged();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!DialogEdit.this.updating) {
                    DialogEdit.this.emitChanged();
                }
            }
        });
        JPanel editData = new JPanel();
        editData.setLayout(new BoxLayout(editData, 1));
        this.namePanel = new JPanel();
        this.namePanel.setLayout(new FlowLayout());
        this.namePanel.add(new JLabel("Name:"));
        this.namePanel.add(this.name);
        editData.add(this.namePanel);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new FlowLayout());
        textPanel.add(new JLabel("Text:"));
        textPanel.add(this.text);
        editData.add(textPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.addNode);
        buttonPanel.add(this.removeNode);
        editData.add(buttonPanel);
        editData.add(new JLabel("localization tokens for translation"));
        this.locNamePanel = new JPanel();
        this.locNamePanel.setLayout(new FlowLayout());
        this.locNamePanel.add(new JLabel("Name Token:"));
        this.locNamePanel.add(this.locname);
        JPanel locTextPanel = new JPanel();
        locTextPanel.setLayout(new FlowLayout());
        locTextPanel.add(new JLabel("Text Token:"));
        locTextPanel.add(this.loctext);
        editData.add(this.locNamePanel);
        editData.add(locTextPanel);
        center.add(editData);
        this.add(center);
        this.refresh();
    }

    public void refresh() {
        this.refresh(false);
    }

    public void refresh(boolean onRootNode) {
        this.setEnabled(this.currentData != null);
        if (this.currentData == null) {
            return;
        }
        this.updating = true;
        this.name.setText(this.currentData.name);
        this.locname.setText(this.currentData.locname);
        this.text.setText(this.currentData.text);
        this.loctext.setText(this.currentData.loctext);
        this.namePanel.setVisible(!onRootNode);
        this.locNamePanel.setVisible(!onRootNode);
        this.updating = false;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    protected void emitChanged() {
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        if (listeners != null && listeners.length > 0) {
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }
}

