/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.BiomeData;
import forge.adventure.data.BiomeTerrainData;
import forge.adventure.editor.DocumentChangeListener;
import forge.adventure.editor.FormPanel;
import forge.adventure.editor.SwingAtlasPreview;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BiomeTerrainEdit
extends FormPanel {
    SwingAtlasPreview preview = new SwingAtlasPreview(128);
    private boolean updating = false;
    BiomeTerrainData currentData;
    BiomeData currentBiomeData;
    public JTextField spriteName = new JTextField();
    public JSpinner min = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.1f));
    public JSpinner max = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.1f));
    public JSpinner resolution = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.1f));

    public BiomeTerrainEdit() {
        FormPanel center = new FormPanel(){};
        center.add("spriteName:", (JComponent)this.spriteName);
        center.add("min:", (JComponent)this.min);
        center.add("max:", (JComponent)this.max);
        center.add("resolution:", (JComponent)this.resolution);
        this.add(center, (JComponent)this.preview);
        this.spriteName.getDocument().addDocumentListener(new DocumentChangeListener(this::updateTerrain));
        this.min.addChangeListener(e -> this.updateTerrain());
        this.max.addChangeListener(e -> this.updateTerrain());
        this.resolution.addChangeListener(e -> this.updateTerrain());
        this.refresh();
    }

    private void refresh() {
        this.setEnabled(this.currentData != null);
        if (this.currentData == null) {
            return;
        }
        this.updating = true;
        this.spriteName.setText(this.currentData.spriteName);
        this.min.setValue(Float.valueOf(this.currentData.min));
        this.max.setValue(Float.valueOf(this.currentData.max));
        this.resolution.setValue(Float.valueOf(this.currentData.resolution));
        if (this.currentBiomeData != null && this.currentData != null) {
            this.preview.setSpritePath(this.currentBiomeData.tilesetAtlas, this.currentData.spriteName);
        }
        this.updating = false;
    }

    public void updateTerrain() {
        if (this.currentData == null || this.updating) {
            return;
        }
        this.currentData.spriteName = this.spriteName.getText();
        this.currentData.min = ((Float)this.min.getValue()).floatValue();
        this.currentData.max = ((Float)this.max.getValue()).floatValue();
        this.currentData.resolution = ((Float)this.resolution.getValue()).floatValue();
        this.preview.setSpritePath(this.currentBiomeData.tilesetAtlas, this.currentData.spriteName);
        this.emitChanged();
    }

    public void setCurrentTerrain(BiomeTerrainData biomeTerrainData, BiomeData data) {
        this.currentData = biomeTerrainData;
        this.currentBiomeData = data;
        this.refresh();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    protected void emitChanged() {
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        if (listeners != null && listeners.length > 0) {
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }
}

