/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.BiomeData;
import forge.adventure.data.BiomeStructureData;
import forge.adventure.editor.BiomeStructureDataMappingEditor;
import forge.adventure.editor.DocumentChangeListener;
import forge.adventure.editor.FloatSpinner;
import forge.adventure.editor.FormPanel;
import forge.adventure.editor.IntSpinner;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BiomeStructureEdit
extends FormPanel {
    private boolean updating = false;
    BiomeStructureData currentData;
    BiomeData currentBiomeData;
    public JTextField structureAtlasPath = new JTextField();
    public FloatSpinner x = new FloatSpinner();
    public FloatSpinner y = new FloatSpinner();
    public FloatSpinner width = new FloatSpinner();
    public FloatSpinner height = new FloatSpinner();
    public JCheckBox randomPosition = new JCheckBox();
    public IntSpinner N = new IntSpinner();
    public JTextField sourcePath = new JTextField();
    public JTextField maskPath = new JTextField();
    public JCheckBox periodicInput = new JCheckBox();
    public IntSpinner ground = new IntSpinner();
    public IntSpinner symmetry = new IntSpinner();
    public JCheckBox periodicOutput = new JCheckBox();
    public BiomeStructureDataMappingEditor data = new BiomeStructureDataMappingEditor();

    public BiomeStructureEdit() {
        FormPanel center = new FormPanel();
        center.add("structureAtlasPath:", (JComponent)this.structureAtlasPath);
        center.add("x:", (JComponent)this.x);
        center.add("y:", (JComponent)this.y);
        center.add("width:", (JComponent)this.width);
        center.add("height:", (JComponent)this.height);
        center.add("N:", (JComponent)this.N);
        center.add("sourcePath:", (JComponent)this.sourcePath);
        center.add("maskPath:", (JComponent)this.maskPath);
        center.add("periodicInput:", (JComponent)this.periodicInput);
        center.add("ground:", (JComponent)this.ground);
        center.add("symmetry:", (JComponent)this.symmetry);
        center.add("periodicOutput:", (JComponent)this.periodicOutput);
        this.add(center);
        this.add(this.data);
        this.structureAtlasPath.getDocument().addDocumentListener(new DocumentChangeListener(this::updateStructure));
        this.x.addChangeListener(e -> this.updateStructure());
        this.y.addChangeListener(e -> this.updateStructure());
        this.width.addChangeListener(e -> this.updateStructure());
        this.height.addChangeListener(e -> this.updateStructure());
        this.randomPosition.addChangeListener(e -> this.updateStructure());
        this.N.addChangeListener(e -> this.updateStructure());
        this.sourcePath.getDocument().addDocumentListener(new DocumentChangeListener(this::updateStructure));
        this.maskPath.getDocument().addDocumentListener(new DocumentChangeListener(this::updateStructure));
        this.periodicInput.addChangeListener(e -> this.updateStructure());
        this.ground.addChangeListener(e -> this.updateStructure());
        this.symmetry.addChangeListener(e -> this.updateStructure());
        this.periodicOutput.addChangeListener(e -> this.updateStructure());
        this.refresh();
    }

    private void refresh() {
        this.setEnabled(this.currentData != null);
        if (this.currentData == null) {
            this.data.setCurrent(null);
            return;
        }
        this.updating = true;
        this.structureAtlasPath.setText(this.currentData.structureAtlasPath);
        this.x.setValue(Float.valueOf(this.currentData.x));
        this.y.setValue(Float.valueOf(this.currentData.y));
        this.width.setValue(Float.valueOf(this.currentData.width));
        this.height.setValue(Float.valueOf(this.currentData.height));
        this.randomPosition.setSelected(this.currentData.randomPosition);
        this.N.setValue(this.currentData.N);
        this.sourcePath.setText(this.currentData.sourcePath);
        this.maskPath.setText(this.currentData.maskPath);
        this.periodicInput.setSelected(this.currentData.periodicInput);
        this.ground.setValue(this.currentData.ground);
        this.symmetry.setValue(this.currentData.symmetry);
        this.periodicOutput.setSelected(this.currentData.periodicOutput);
        this.data.setCurrent(this.currentData);
        this.updating = false;
    }

    public void updateStructure() {
        if (this.currentData == null || this.updating) {
            return;
        }
        this.currentData.structureAtlasPath = this.structureAtlasPath.getText();
        this.currentData.x = this.x.floatValue();
        this.currentData.y = this.y.floatValue();
        this.currentData.width = this.width.floatValue();
        this.currentData.height = this.height.floatValue();
        this.currentData.randomPosition = this.randomPosition.isSelected();
        this.currentData.mappingInfo = this.data.getCurrent();
        this.currentData.N = this.N.intValue();
        this.currentData.sourcePath = this.sourcePath.getText();
        this.currentData.maskPath = this.maskPath.getText();
        this.currentData.periodicInput = this.periodicInput.isSelected();
        this.currentData.ground = this.ground.intValue();
        this.currentData.symmetry = this.symmetry.intValue();
        this.currentData.periodicOutput = this.periodicOutput.isSelected();
        this.emitChanged();
    }

    public void setCurrentStructure(BiomeStructureData biomeTerrainData, BiomeData data) {
        this.currentData = biomeTerrainData;
        this.currentBiomeData = data;
        this.refresh();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    protected void emitChanged() {
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        if (listeners != null && listeners.length > 0) {
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }
}

