/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.BiomeStructureData;
import forge.adventure.editor.DocumentChangeListener;
import forge.adventure.editor.FormPanel;
import forge.adventure.editor.SwingAtlas;
import forge.adventure.util.Config;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class BiomeStructureDataMappingEditor
extends JComponent {
    DefaultListModel<BiomeStructureData.BiomeStructureDataMapping> model = new DefaultListModel();
    JList<BiomeStructureData.BiomeStructureDataMapping> list = new JList<BiomeStructureData.BiomeStructureDataMapping>(this.model);
    JToolBar toolBar = new JToolBar("toolbar");
    BiomeStructureDataMappingEdit edit = new BiomeStructureDataMappingEdit();
    private BiomeStructureData data;

    public void setCurrent(BiomeStructureData data) {
        this.data = data;
        this.model.clear();
        if (data == null || data.mappingInfo == null) {
            return;
        }
        for (int i = 0; i < data.mappingInfo.length; ++i) {
            this.model.addElement(data.mappingInfo[i]);
        }
        this.list.setSelectedIndex(0);
    }

    public BiomeStructureData.BiomeStructureDataMapping[] getCurrent() {
        BiomeStructureData.BiomeStructureDataMapping[] array = new BiomeStructureData.BiomeStructureDataMapping[this.model.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.model.get(i);
        }
        return array;
    }

    public void addButton(String name, ActionListener action) {
        JButton newButton = new JButton(name);
        newButton.addActionListener(action);
        this.toolBar.add(newButton);
    }

    public BiomeStructureDataMappingEditor() {
        this.list.setCellRenderer(new BiomeStructureDataMappingRenderer(this));
        this.list.addListSelectionListener(e -> this.updateEdit());
        this.addButton("add", e -> this.add());
        this.addButton("remove", e -> this.remove());
        this.addButton("copy", e -> this.copy());
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add((Component)new JScrollPane(this.list), "West");
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.edit, "Center");
    }

    private void copy() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        BiomeStructureData.BiomeStructureDataMapping data = new BiomeStructureData.BiomeStructureDataMapping(this.model.get(selected));
        this.model.add(this.model.size(), data);
    }

    private void updateEdit() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.edit.setCurrent(this.model.get(selected));
    }

    void add() {
        BiomeStructureData.BiomeStructureDataMapping data = new BiomeStructureData.BiomeStructureDataMapping();
        data.name = "Structure " + this.model.getSize();
        this.model.add(this.model.size(), data);
    }

    void remove() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.model.remove(selected);
    }

    private class BiomeStructureDataMappingEdit
    extends FormPanel {
        BiomeStructureData.BiomeStructureDataMapping currentData;
        public JTextField name = new JTextField();
        public JTextField color = new JTextField();
        public JCheckBox collision = new JCheckBox();
        private boolean updating = false;

        public BiomeStructureDataMappingEdit() {
            this.add("name:", (JComponent)this.name);
            this.add("color:", (JComponent)this.color);
            this.add("collision:", (JComponent)this.collision);
            this.name.getDocument().addDocumentListener(new DocumentChangeListener(this::update));
            this.color.getDocument().addDocumentListener(new DocumentChangeListener(this::update));
            this.collision.addChangeListener(e -> this.update());
            this.refresh();
        }

        private void update() {
            if (this.currentData == null || this.updating) {
                return;
            }
            this.currentData.name = this.name.getText();
            this.currentData.color = this.color.getText();
            this.currentData.collision = this.collision.isSelected();
        }

        public void setCurrent(BiomeStructureData.BiomeStructureDataMapping data) {
            this.currentData = data;
            this.refresh();
        }

        private void refresh() {
            this.setEnabled(this.currentData != null);
            if (this.currentData == null) {
                return;
            }
            this.updating = true;
            this.name.setText(this.currentData.name);
            this.color.setText(this.currentData.color);
            this.collision.setSelected(this.currentData.collision);
            this.updating = false;
        }
    }

    public class BiomeStructureDataMappingRenderer
    extends DefaultListCellRenderer {
        private final BiomeStructureDataMappingEditor editor;

        public BiomeStructureDataMappingRenderer(BiomeStructureDataMappingEditor biomeStructureDataMappingEditor) {
            this.editor = biomeStructureDataMappingEditor;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof BiomeStructureData.BiomeStructureDataMapping)) {
                return label;
            }
            BiomeStructureData.BiomeStructureDataMapping data = (BiomeStructureData.BiomeStructureDataMapping)value;
            label.setText(data.name);
            if (this.editor.data != null) {
                SwingAtlas itemAtlas = new SwingAtlas(Config.instance().getFile(((BiomeStructureDataMappingEditor)this.editor).data.structureAtlasPath));
                if (itemAtlas.has(data.name)) {
                    label.setIcon(itemAtlas.get(data.name));
                } else {
                    ImageIcon img = itemAtlas.getAny();
                    if (img != null) {
                        label.setIcon(img);
                    }
                }
            }
            return label;
        }
    }
}

