/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.BiomeData;
import forge.adventure.editor.DocumentChangeListener;
import forge.adventure.editor.FilePicker;
import forge.adventure.editor.FormPanel;
import forge.adventure.editor.StructureEditor;
import forge.adventure.editor.TerrainsEditor;
import forge.adventure.editor.TextListEdit;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class BiomeEdit
extends FormPanel {
    BiomeData currentData;
    public JSpinner startPointX = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.1f));
    public JSpinner startPointY = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.1f));
    public JSpinner noiseWeight = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.1f));
    public JSpinner distWeight = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.1f));
    public JTextField name = new JTextField();
    public FilePicker tilesetAtlas = new FilePicker(new String[]{"atlas"});
    public JTextField tilesetName = new JTextField();
    public JSpinner width = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.1f));
    public JSpinner height = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.1f));
    public JTextField color = new JTextField();
    public JCheckBox collision = new JCheckBox();
    public TextListEdit spriteNames = new TextListEdit();
    public TextListEdit enemies = new TextListEdit();
    public TextListEdit pointsOfInterest = new TextListEdit();
    public TerrainsEditor terrain = new TerrainsEditor();
    public StructureEditor structures = new StructureEditor();
    private boolean updating = false;

    public BiomeEdit() {
        FormPanel center = new FormPanel(){};
        center.add("startPointX:", (JComponent)this.startPointX);
        center.add("startPointY:", (JComponent)this.startPointY);
        center.add("noiseWeight:", (JComponent)this.noiseWeight);
        center.add("distWeight:", (JComponent)this.distWeight);
        center.add("name:", (JComponent)this.name);
        center.add("tilesetAtlas:", (JComponent)this.tilesetAtlas);
        center.add("tilesetName:", (JComponent)this.tilesetName);
        center.add("width:", (JComponent)this.width);
        center.add("height:", (JComponent)this.height);
        center.add("spriteNames:", (JComponent)this.spriteNames);
        center.add("enemies:", (JComponent)this.enemies);
        center.add("POITags:", (JComponent)this.pointsOfInterest);
        center.add("color:", (JComponent)this.color);
        center.add("collision:", (JComponent)this.collision);
        center.add("terrain/structures:", (JComponent)new JLabel(""));
        this.add(center);
        this.add(this.terrain);
        this.add(this.structures);
        this.name.getDocument().addDocumentListener(new DocumentChangeListener(this::updateTerrain));
        this.tilesetName.getDocument().addDocumentListener(new DocumentChangeListener(this::updateTerrain));
        this.color.getDocument().addDocumentListener(new DocumentChangeListener(this::updateTerrain));
        this.collision.addChangeListener(e -> this.updateTerrain());
        this.spriteNames.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateTerrain));
        this.enemies.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateTerrain));
        this.terrain.addChangeListener(e -> this.updateTerrain());
        this.startPointX.addChangeListener(e -> this.updateTerrain());
        this.startPointY.addChangeListener(e -> this.updateTerrain());
        this.noiseWeight.addChangeListener(e -> this.updateTerrain());
        this.distWeight.addChangeListener(e -> this.updateTerrain());
        this.tilesetAtlas.getEdit().getDocument().addDocumentListener(new DocumentChangeListener(this::updateTerrain));
        this.width.addChangeListener(e -> this.updateTerrain());
        this.height.addChangeListener(e -> this.updateTerrain());
        this.refresh();
    }

    protected void updateTerrain() {
        if (this.currentData == null || this.updating) {
            return;
        }
        this.currentData.startPointX = ((Float)this.startPointX.getValue()).floatValue();
        this.currentData.startPointY = ((Float)this.startPointY.getValue()).floatValue();
        this.currentData.noiseWeight = ((Float)this.noiseWeight.getValue()).floatValue();
        this.currentData.distWeight = ((Float)this.distWeight.getValue()).floatValue();
        this.currentData.name = this.name.getText();
        this.currentData.tilesetAtlas = this.tilesetAtlas.edit.getText();
        this.currentData.tilesetName = this.tilesetName.getText();
        this.currentData.terrain = this.terrain.getBiomeTerrainData();
        this.currentData.structures = this.structures.getBiomeStructureData();
        this.currentData.width = ((Float)this.width.getValue()).floatValue();
        this.currentData.height = ((Float)this.height.getValue()).floatValue();
        this.currentData.color = this.color.getText();
        this.currentData.collision = this.collision.isSelected();
        this.currentData.spriteNames = this.spriteNames.getList();
        this.currentData.enemies = this.enemies.getList();
        this.currentData.pointsOfInterest = this.pointsOfInterest.getList();
    }

    public void setCurrentBiome(BiomeData data) {
        this.currentData = data;
        this.refresh();
    }

    private void refresh() {
        this.setEnabled(this.currentData != null);
        if (this.currentData == null) {
            return;
        }
        this.updating = true;
        this.startPointX.setValue(Float.valueOf(this.currentData.startPointX));
        this.startPointY.setValue(Float.valueOf(this.currentData.startPointY));
        this.noiseWeight.setValue(Float.valueOf(this.currentData.noiseWeight));
        this.distWeight.setValue(Float.valueOf(this.currentData.distWeight));
        this.name.setText(this.currentData.name);
        this.tilesetAtlas.edit.setText(this.currentData.tilesetAtlas);
        this.tilesetName.setText(this.currentData.tilesetName);
        this.terrain.setTerrains(this.currentData);
        this.structures.setStructures(this.currentData);
        this.width.setValue(Float.valueOf(this.currentData.width));
        this.height.setValue(Float.valueOf(this.currentData.height));
        this.color.setText(this.currentData.color);
        this.spriteNames.setText(this.currentData.spriteNames);
        this.enemies.setText(this.currentData.enemies);
        this.collision.setSelected(this.currentData.collision);
        this.pointsOfInterest.setText(this.currentData.pointsOfInterest);
        this.updating = false;
    }
}

