/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.DialogData;
import forge.adventure.editor.ActionEdit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ActionEditor
extends JComponent {
    DefaultListModel<DialogData.ActionData> model = new DefaultListModel();
    JList<DialogData.ActionData> list = new JList<DialogData.ActionData>(this.model);
    JToolBar toolBar = new JToolBar("toolbar");
    ActionEdit edit = new ActionEdit();
    boolean updating;

    public void addButton(String name, ActionListener action) {
        JButton newButton = new JButton(name);
        newButton.addActionListener(action);
        this.toolBar.add(newButton);
    }

    public ActionEditor() {
        this.list.setCellRenderer(new RewardDataRenderer());
        this.list.addListSelectionListener(e -> this.updateEdit());
        this.addButton("add", e -> this.addAction());
        this.addButton("remove", e -> this.remove());
        this.addButton("copy", e -> this.copy());
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add(this.list, "Before");
        this.add((Component)this.toolBar, "First");
        this.add((Component)this.edit, "Center");
        this.edit.addChangeListener(e -> this.emitChanged());
    }

    protected void emitChanged() {
        if (this.updating) {
            return;
        }
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        if (listeners != null && listeners.length > 0) {
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    private void copy() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        DialogData.ActionData data = new DialogData.ActionData(this.model.get(selected));
        this.model.add(this.model.size(), data);
    }

    private void updateEdit() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.edit.setCurrentAction(this.model.get(selected));
    }

    void addAction() {
        DialogData.ActionData data = new DialogData.ActionData();
        this.model.add(this.model.size(), data);
    }

    void remove() {
        int selected = this.list.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        this.model.remove(selected);
    }

    public void setAction(DialogData.ActionData[] actions) {
        this.model.clear();
        if (actions == null) {
            return;
        }
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i].grantRewards.length > 0) continue;
            this.model.add(i, actions[i]);
        }
    }

    public DialogData.ActionData[] getAction() {
        DialogData.ActionData[] action = new DialogData.ActionData[this.model.getSize()];
        for (int i = 0; i < this.model.getSize(); ++i) {
            action[i] = this.model.get(i);
        }
        return action;
    }

    public void clear() {
        this.updating = true;
        this.model.clear();
        this.updating = false;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public class RewardDataRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof DialogData.ActionData)) {
                return label;
            }
            DialogData.ActionData action = (DialogData.ActionData)value;
            StringBuilder builder = new StringBuilder();
            builder.append("Action");
            label.setText(builder.toString());
            return label;
        }
    }
}

