/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.editor;

import forge.adventure.data.DialogData;
import forge.adventure.editor.DocumentChangeListener;
import forge.adventure.editor.FormPanel;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ActionEdit
extends FormPanel {
    DialogData.ActionData currentData;
    JTextField issueQuest = new JTextField();
    JTextField characterFlagName = new JTextField();
    JTextField mapFlagName = new JTextField();
    JTextField questFlagName = new JTextField();
    JTextField advanceCharacterFlag = new JTextField();
    JTextField advanceMapFlag = new JTextField();
    JTextField advanceQuestFlag = new JTextField();
    JTextField battleWithActorID = new JTextField();
    JTextField activateObjectID = new JTextField();
    JTextField deleteMapObject = new JTextField();
    JTextField setColorIdentity = new JTextField();
    JSpinner addReputation = new JSpinner(new SpinnerNumberModel(0, -1000, 1000, 1));
    JSpinner addLife = new JSpinner(new SpinnerNumberModel(0, -1000, 1000, 1));
    JTextField POIReference = new JTextField();
    JTextField removeItem = new JTextField();
    JSpinner characterFlagValue = new JSpinner(new SpinnerNumberModel(0, 0, 1000, 1));
    JSpinner mapFlagValue = new JSpinner(new SpinnerNumberModel(0, 0, 1000, 1));
    JSpinner questFlagValue = new JSpinner(new SpinnerNumberModel(0, 0, 1000, 1));
    private boolean updating = false;

    public ActionEdit() {
        this.add("Issue Quest:", (JComponent)this.issueQuest);
        this.add("Set Map Flag Name:", (JComponent)this.mapFlagName);
        this.add("Map Flag value to set:", (JComponent)this.mapFlagValue);
        this.add("Set Quest Flag name:", (JComponent)this.questFlagName);
        this.add("Quest Flag value to set:", (JComponent)this.questFlagValue);
        this.add("Set Character Flag name:", (JComponent)this.characterFlagName);
        this.add("Character Flag value to set:", (JComponent)this.characterFlagValue);
        this.add("Advance Map Flag name:", (JComponent)this.advanceMapFlag);
        this.add("Advance Quest Flag name:", (JComponent)this.advanceQuestFlag);
        this.add("Advance Character Flag name:", (JComponent)this.advanceCharacterFlag);
        this.add("Battle with actor ID:", (JComponent)this.battleWithActorID);
        this.add("Delete map object:", (JComponent)this.deleteMapObject);
        this.add("Set color identity:", (JComponent)this.setColorIdentity);
        this.add("Add Reputation:", (JComponent)this.addReputation);
        this.add("Add Life:", (JComponent)this.addLife);
        this.add("POI Reference:", (JComponent)this.POIReference);
        this.add("Remove Item:", (JComponent)this.removeItem);
        this.issueQuest.getDocument().addDocumentListener(new DocumentChangeListener(this::updateAction));
        this.mapFlagName.getDocument().addDocumentListener(new DocumentChangeListener(this::updateAction));
        this.mapFlagValue.getModel().addChangeListener(e -> this.updateAction());
        this.questFlagName.getDocument().addDocumentListener(new DocumentChangeListener(this::updateAction));
        this.questFlagValue.getModel().addChangeListener(e -> this.updateAction());
        this.advanceMapFlag.getDocument().addDocumentListener(new DocumentChangeListener(this::updateAction));
        this.advanceQuestFlag.getDocument().addDocumentListener(new DocumentChangeListener(this::updateAction));
        this.battleWithActorID.getDocument().addDocumentListener(new DocumentChangeListener(this::updateAction));
        this.activateObjectID.getDocument().addDocumentListener(new DocumentChangeListener(this::updateAction));
        this.deleteMapObject.getDocument().addDocumentListener(new DocumentChangeListener(this::updateAction));
        this.setColorIdentity.getDocument().addDocumentListener(new DocumentChangeListener(this::updateAction));
        this.addLife.getModel().addChangeListener(e -> this.updateAction());
        this.addReputation.getModel().addChangeListener(e -> this.updateAction());
        this.POIReference.getDocument().addDocumentListener(new DocumentChangeListener(this::updateAction));
        this.removeItem.getDocument().addDocumentListener(new DocumentChangeListener(this::updateAction));
    }

    private void updateAction() {
        if (this.updating) {
            return;
        }
        if (this.currentData == null) {
            this.currentData = new DialogData.ActionData();
        }
        DialogData.ActionData.QuestFlag characterFlag = new DialogData.ActionData.QuestFlag();
        characterFlag.key = this.characterFlagName.getText();
        characterFlag.val = (Integer)this.characterFlagValue.getModel().getValue();
        this.currentData.setCharacterFlag = characterFlag;
        DialogData.ActionData.QuestFlag mapFlag = new DialogData.ActionData.QuestFlag();
        mapFlag.key = this.mapFlagName.getText();
        mapFlag.val = (Integer)this.mapFlagValue.getModel().getValue();
        this.currentData.setMapFlag = mapFlag;
        DialogData.ActionData.QuestFlag questFlag = new DialogData.ActionData.QuestFlag();
        questFlag.key = this.questFlagName.getText();
        questFlag.val = (Integer)this.questFlagValue.getModel().getValue();
        this.currentData.setQuestFlag = questFlag;
        this.currentData.issueQuest = this.issueQuest.getText();
        this.currentData.advanceMapFlag = this.advanceMapFlag.getText();
        this.currentData.advanceQuestFlag = this.advanceQuestFlag.getText();
        this.currentData.advanceCharacterFlag = this.advanceCharacterFlag.getText();
        this.currentData.battleWithActorID = Integer.parseInt(this.battleWithActorID.getText());
        this.currentData.activateMapObject = Integer.parseInt(this.activateObjectID.getText());
        this.currentData.deleteMapObject = Integer.parseInt(this.deleteMapObject.getText());
        this.currentData.setColorIdentity = this.setColorIdentity.getText();
        this.currentData.addLife = (Integer)this.addLife.getModel().getValue();
        this.currentData.addMapReputation = (Integer)this.addReputation.getModel().getValue();
        this.currentData.POIReference = this.POIReference.getText();
        this.currentData.removeItem = this.removeItem.getText();
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        if (listeners != null && listeners.length > 0) {
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void setCurrentAction(DialogData.ActionData data) {
        this.currentData = data;
        this.refresh();
    }

    private void refresh() {
        this.setEnabled(this.currentData != null);
        if (this.currentData == null) {
            return;
        }
        this.updating = true;
        this.mapFlagName.setText(this.currentData.setMapFlag == null ? "" : this.currentData.setMapFlag.key);
        this.mapFlagValue.getModel().setValue(this.currentData.setMapFlag == null ? 0 : this.currentData.setMapFlag.val);
        this.questFlagName.setText(this.currentData.setQuestFlag == null ? "" : this.currentData.setQuestFlag.key);
        this.questFlagValue.getModel().setValue(this.currentData.setQuestFlag == null ? 0 : this.currentData.setQuestFlag.val);
        this.issueQuest.setText(this.currentData.issueQuest);
        this.advanceMapFlag.setText(this.currentData.advanceMapFlag);
        this.advanceQuestFlag.setText(this.currentData.advanceQuestFlag);
        this.advanceCharacterFlag.setText(this.currentData.advanceCharacterFlag);
        this.battleWithActorID.setText("" + this.currentData.battleWithActorID);
        this.activateObjectID.setText("" + this.currentData.battleWithActorID);
        this.deleteMapObject.setText("" + this.currentData.deleteMapObject);
        this.setColorIdentity.setText(this.currentData.setColorIdentity);
        this.addLife.getModel().setValue(this.currentData.addLife);
        this.addReputation.getModel().setValue(this.currentData.addMapReputation);
        this.POIReference.setText(this.currentData.POIReference);
        this.removeItem.setText(this.currentData.removeItem);
        this.updating = false;
    }
}

