/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.data;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.SerializationException;
import forge.adventure.data.BiomeData;
import forge.adventure.data.EnemyData;
import forge.adventure.data.ShopData;
import forge.adventure.util.Config;
import forge.adventure.world.BiomeSprites;
import forge.util.FileUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class WorldData
implements Serializable {
    public int width;
    public int height;
    public float playerStartPosX;
    public float playerStartPosY;
    public float noiseZoomBiome;
    public int tileSize;
    public int miniMapTileSize;
    public BiomeData roadTileset;
    public String biomesSprites;
    public float maxRoadDistance;
    public String[] biomesNames;
    private BiomeSprites sprites;
    private List<BiomeData> biomes;
    private static Array<EnemyData> allEnemies;
    private static Array<ShopData> shopList;

    public static Array<ShopData> getShopList() {
        if (shopList == null) {
            shopList = new Array();
            Json json = new Json();
            FileHandle handle = Config.instance().getFile("world/shops.json");
            if (handle.exists()) {
                Array readList;
                shopList = readList = json.fromJson(Array.class, ShopData.class, handle);
            }
        }
        return shopList;
    }

    public static Array<EnemyData> getAllEnemies() {
        if (allEnemies == null) {
            Json json = new Json();
            FileHandle handle = Config.instance().getFile("world/enemies.json");
            if (handle.exists()) {
                Array readList;
                allEnemies = readList = json.fromJson(Array.class, EnemyData.class, handle);
            }
        }
        return allEnemies;
    }

    public static EnemyData getEnemy(String enemy) {
        for (EnemyData data : new Array.ArrayIterator<EnemyData>(WorldData.getAllEnemies())) {
            if (!data.name.equals(enemy)) continue;
            return data;
        }
        for (EnemyData data : new Array.ArrayIterator<EnemyData>(WorldData.getAllEnemies())) {
            if (data.getName() == null || !data.getName().equals(enemy)) continue;
            return data;
        }
        return null;
    }

    public static ArrayList<String> getTownNames(String name) {
        return new ArrayList<String>(FileUtil.readFile(Config.instance().getFilePath("world/town_names_" + name + ".txt")));
    }

    public BiomeSprites GetBiomeSprites() {
        if (this.sprites == null) {
            Json json = new Json();
            this.sprites = json.fromJson(BiomeSprites.class, Config.instance().getFile(this.biomesSprites));
        }
        return this.sprites;
    }

    public List<BiomeData> GetBiomes() {
        if (this.biomes == null) {
            try {
                this.biomes = new ArrayList<BiomeData>();
                Json json = new Json();
                for (String name : this.biomesNames) {
                    this.biomes.add(json.fromJson(BiomeData.class, Config.instance().getFile(name)));
                }
            }
            catch (SerializationException ex) {
                ex.printStackTrace();
            }
        }
        return this.biomes;
    }
}

