/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.data;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import forge.adventure.data.DialogData;
import forge.adventure.data.EffectData;
import forge.adventure.util.Config;

public class ItemData {
    public String name;
    public String equipmentSlot;
    public EffectData effect;
    public String description;
    public String iconName;
    public boolean questItem = false;
    public int cost = 1000;
    public boolean usableOnWorldMap;
    public boolean usableInPoi;
    public boolean isCracked;
    public String commandOnUse;
    public int shardsNeeded;
    public DialogData dialogOnUse;
    private static Array<ItemData> itemList;

    public ItemData() {
    }

    public ItemData(ItemData cpy) {
        this.name = cpy.name;
        this.equipmentSlot = cpy.equipmentSlot;
        this.effect = new EffectData(cpy.effect);
        this.description = cpy.description;
        this.iconName = cpy.iconName;
        this.questItem = cpy.questItem;
        this.cost = cpy.cost;
        this.usableInPoi = cpy.usableInPoi;
        this.usableOnWorldMap = cpy.usableOnWorldMap;
        this.commandOnUse = cpy.commandOnUse;
        this.shardsNeeded = cpy.shardsNeeded;
        this.dialogOnUse = cpy.dialogOnUse;
    }

    public Sprite sprite() {
        return Config.instance().getItemSprite(this.iconName);
    }

    public static Array<ItemData> getAllItems() {
        if (itemList == null) {
            Json json = new Json();
            FileHandle handle = Config.instance().getFile("world/items.json");
            if (handle.exists()) {
                Array readJson;
                itemList = readJson = json.fromJson(Array.class, ItemData.class, handle);
            }
        }
        return itemList;
    }

    public static ItemData getItem(String name) {
        for (ItemData data : new Array.ArrayIterator<ItemData>(ItemData.getAllItems())) {
            if (!data.name.equals(name)) continue;
            return data;
        }
        return null;
    }

    public String getDescription() {
        String result = "";
        if (this.description != null && !this.description.isEmpty()) {
            result = result + this.description + "\n";
        }
        if (this.equipmentSlot != null && !this.equipmentSlot.isEmpty()) {
            result = result + "Slot: " + this.equipmentSlot + "\n";
        }
        if (this.effect != null) {
            result = result + this.effect.getDescription();
        }
        if (this.shardsNeeded != 0) {
            result = result + this.shardsNeeded + " [+Shards]";
        }
        return result;
    }
}

