/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.data;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.ObjectMap;
import forge.Forge;
import forge.adventure.data.HeroData;
import forge.adventure.util.Config;

public class HeroListData {
    private static HeroListData instance;
    public HeroData[] heroes;
    public String avatar;
    private TextureAtlas avatarAtlas;
    private final ObjectMap<String, Array<Sprite>> avatarSprites = new ObjectMap();

    private static HeroListData read() {
        Json json = new Json();
        FileHandle handle = Config.instance().getFile("world/heroes.json");
        if (handle.exists()) {
            instance = json.fromJson(HeroListData.class, handle);
            HeroListData.instance.avatarAtlas = Config.instance().getAtlas(HeroListData.instance.avatar);
        }
        return instance;
    }

    public static String getHero(int raceIndex, boolean female) {
        if (instance == null) {
            instance = HeroListData.read();
        }
        HeroData data = HeroListData.instance.heroes[raceIndex];
        if (female) {
            return data.female;
        }
        return data.male;
    }

    public static TextureRegion getAvatar(int heroRace, boolean isFemale, int avatarIndex) {
        if (instance == null) {
            instance = HeroListData.read();
        }
        HeroData data = HeroListData.instance.heroes[heroRace];
        Array<Sprite> sprites = HeroListData.instance.avatarSprites.get(isFemale ? data.femaleAvatar : data.maleAvatar);
        if (sprites == null) {
            sprites = HeroListData.instance.avatarAtlas.createSprites(isFemale ? data.femaleAvatar : data.maleAvatar);
            HeroListData.instance.avatarSprites.put(isFemale ? data.femaleAvatar : data.maleAvatar, sprites);
        }
        if ((avatarIndex %= sprites.size) < 0) {
            avatarIndex += sprites.size;
        }
        return sprites.get(avatarIndex);
    }

    public static Array<String> getRaces() {
        if (instance == null) {
            instance = HeroListData.read();
        }
        Array<String> ret = new Array<String>();
        for (HeroData hero : HeroListData.instance.heroes) {
            ret.add(Forge.getLocalizer().getMessageorUseDefault("lbl" + hero.name, hero.name, new Object[0]));
        }
        return ret;
    }
}

