/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.data;

import com.badlogic.gdx.utils.Array;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.item.PaperToken;
import forge.model.FModel;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EffectData
implements Serializable {
    public String name = null;
    public int lifeModifier = 0;
    public int changeStartCards = 0;
    public String[] startBattleWithCard;
    public String[] startBattleWithCardInCommandZone;
    public boolean colorView = false;
    public float moveSpeed = 1.0f;
    public float goldModifier = -1.0f;
    public int cardRewardBonus = 0;
    public int extraManaShards = 0;
    public EffectData opponent;

    public EffectData() {
    }

    public EffectData(EffectData effect) {
        this.name = effect.name;
        this.lifeModifier = effect.lifeModifier;
        this.changeStartCards = effect.changeStartCards;
        this.startBattleWithCard = effect.startBattleWithCard;
        this.colorView = effect.colorView;
        this.opponent = effect.opponent == null ? null : new EffectData(effect.opponent);
        this.extraManaShards = effect.extraManaShards;
    }

    public Array<IPaperCard> startBattleWithCards() {
        Array<IPaperCard> startCards = new Array<IPaperCard>(IPaperCard.class);
        if (this.startBattleWithCard != null) {
            for (String name : this.startBattleWithCard) {
                PaperCard C2 = FModel.getMagicDb().getCommonCards().getCard(name);
                if (C2 != null) {
                    startCards.add(C2);
                    continue;
                }
                try {
                    PaperToken T = FModel.getMagicDb().getAllTokens().getToken(name);
                    if (T != null) {
                        startCards.add(T);
                        continue;
                    }
                    System.err.print("Can not find card/token \"" + name + "\"\n");
                }
                catch (Exception e) {
                    System.err.print("Can not find card/token \"" + name + "\"\n");
                }
            }
        }
        return startCards;
    }

    public Array<IPaperCard> startBattleWithCardsInCommandZone() {
        Array<IPaperCard> startCardsInCommandZone = new Array<IPaperCard>(IPaperCard.class);
        if (this.startBattleWithCardInCommandZone != null) {
            for (String name : this.startBattleWithCardInCommandZone) {
                PaperCard C2 = FModel.getMagicDb().getCommonCards().getCard(name);
                if (C2 != null) {
                    startCardsInCommandZone.add(C2);
                    continue;
                }
                try {
                    PaperToken T = FModel.getMagicDb().getAllTokens().getToken(name);
                    if (T != null) {
                        startCardsInCommandZone.add(T);
                        continue;
                    }
                    System.err.print("Can not find card/token \"" + name + "\"\n");
                }
                catch (Exception e) {
                    System.err.print("Can not find card/token \"" + name + "\"\n");
                }
            }
        }
        return startCardsInCommandZone;
    }

    public String itemize(Array<IPaperCard> paperCards) {
        StringBuilder ret = new StringBuilder();
        Map duplicateCountMap = Arrays.stream(paperCards.toArray()).collect(Collectors.toMap(Function.identity(), cards -> 1, Math::addExact));
        duplicateCountMap.forEach((key, value) -> ret.append("\n").append(value).append("x ").append(key));
        return ret.toString();
    }

    public String getDescription() {
        String description = "";
        if (this.colorView) {
            description = description + "Manasight.\n";
        }
        if (this.lifeModifier != 0) {
            description = description + "[+Life] " + (this.lifeModifier > 0 ? "+" : "") + this.lifeModifier + "\n";
        }
        if (this.startBattleWithCard != null && this.startBattleWithCard.length != 0) {
            description = description + "Battlefield:" + this.itemize(this.startBattleWithCards()) + "\n";
        }
        if (this.startBattleWithCardInCommandZone != null && this.startBattleWithCardInCommandZone.length != 0) {
            description = description + "Command:" + this.itemize(this.startBattleWithCardsInCommandZone()) + "\n";
        }
        if (this.changeStartCards != 0) {
            description = description + "Starting hand: " + this.changeStartCards + "\n";
        }
        if (this.moveSpeed != 0.0f && this.moveSpeed != 1.0f) {
            description = description + "[+MovementSpeed] " + (this.moveSpeed > 0.0f ? "+" : "") + Math.round((this.moveSpeed - 1.0f) * 100.0f) + "%\n";
        }
        if (this.goldModifier > 0.0f) {
            description = description + "Shop discount: x" + this.goldModifier + "\n";
        }
        if (this.cardRewardBonus > 0) {
            description = description + "Bonus enemy deck rewards: +" + this.cardRewardBonus + "\n";
        }
        if (this.opponent != null) {
            String oppEffect = this.opponent.getDescription();
            description = description + "Gives Opponent:\n";
            if (!oppEffect.isEmpty()) {
                description = description + oppEffect;
            }
        }
        return description;
    }
}

