/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.data;

import forge.adventure.data.EffectData;
import forge.adventure.data.RewardData;
import forge.util.Callback;
import java.io.Serializable;
import java.util.ArrayList;

public class DialogData
implements Serializable {
    public ActionData[] action = new ActionData[0];
    public ConditionData[] condition = new ConditionData[0];
    public String name = "";
    public String locname = "";
    public String text = "";
    public String loctext = "";
    public DialogData[] options = new DialogData[0];
    public boolean isDisabled = false;
    public transient Callback callback;
    public String voiceFile;

    public DialogData() {
    }

    public DialogData(DialogData other) {
        if (other == null) {
            return;
        }
        this.action = (ActionData[])other.action.clone();
        this.condition = (ConditionData[])other.condition.clone();
        this.name = other.name;
        this.locname = other.locname.isEmpty() ? "" : "Copy of " + other.locname;
        this.text = other.text;
        this.loctext = other.loctext;
        ArrayList<DialogData> clonedOptions = new ArrayList<DialogData>();
        for (DialogData option : other.options) {
            clonedOptions.add(new DialogData(option));
        }
        this.options = clonedOptions.toArray(new DialogData[0]);
        this.voiceFile = other.voiceFile;
        this.isDisabled = other.isDisabled;
    }

    public String toString() {
        return this.name;
    }

    public static class ConditionData
    implements Serializable {
        private static final long SerialVersionUID = 1L;
        public String item;
        public int actorID = 0;
        public String hasBlessing = null;
        public int hasGold = 0;
        public int hasShards = 0;
        public int hasMapReputation = Integer.MIN_VALUE;
        public int hasLife = 0;
        public String colorIdentity = null;
        public String checkCharacterFlag = null;
        public String checkQuestFlag = null;
        public String checkMapFlag = null;
        public QueryQuestFlag getCharacterFlag = null;
        public QueryQuestFlag getQuestFlag = null;
        public QueryQuestFlag getMapFlag = null;
        public boolean not = false;

        public static class QueryQuestFlag {
            public String key;
            public String op;
            public int val;
        }
    }

    public static class ActionData
    implements Serializable {
        public static final long serialVersionUID = 2848523275822677205L;
        public String removeItem;
        public String addItem;
        public int addLife = 0;
        public int addGold = 0;
        public int addShards = 0;
        public int deleteMapObject = 0;
        public int activateMapObject = 0;
        public int battleWithActorID = 0;
        public EffectData giveBlessing;
        public String setColorIdentity;
        public String advanceCharacterFlag;
        public String advanceQuestFlag;
        public String advanceMapFlag;
        public EffectData setEffect;
        public QuestFlag setCharacterFlag;
        public QuestFlag setQuestFlag;
        public QuestFlag setMapFlag;
        public RewardData[] grantRewards = new RewardData[0];
        public String issueQuest;
        public int addMapReputation = 0;
        public String POIReference;

        public ActionData() {
        }

        public ActionData(ActionData other) {
            this.removeItem = other.removeItem;
            this.addItem = other.removeItem;
            this.addLife = other.addLife;
            this.addGold = other.addGold;
            this.addShards = other.addShards;
            this.deleteMapObject = other.deleteMapObject;
            this.activateMapObject = other.activateMapObject;
            this.battleWithActorID = other.battleWithActorID;
            this.giveBlessing = other.giveBlessing;
            this.setColorIdentity = other.setColorIdentity;
            this.advanceQuestFlag = other.advanceQuestFlag;
            this.advanceMapFlag = other.advanceMapFlag;
            this.setEffect = other.setEffect;
            this.setQuestFlag = new QuestFlag();
            if (other.setQuestFlag != null) {
                this.setQuestFlag.key = other.setQuestFlag.key;
                this.setQuestFlag.val = other.setQuestFlag.val;
            }
            this.setMapFlag = new QuestFlag();
            if (other.setMapFlag != null) {
                this.setMapFlag.key = other.setMapFlag.key;
                this.setMapFlag.val = other.setMapFlag.val;
            }
            this.grantRewards = (RewardData[])other.grantRewards.clone();
            this.issueQuest = other.issueQuest;
            this.addMapReputation = other.addMapReputation;
            this.POIReference = other.POIReference;
        }

        public static class QuestFlag
        implements Serializable {
            public String key;
            public int val;
        }
    }
}

