/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.data;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import forge.adventure.data.BiomeStructureData;
import forge.adventure.data.BiomeTerrainData;
import forge.adventure.data.EnemyData;
import forge.adventure.data.PointOfInterestData;
import forge.adventure.data.WorldData;
import forge.adventure.util.AdventureQuestController;
import forge.util.Aggregates;
import forge.util.MyRandom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BiomeData
implements Serializable {
    public float startPointX;
    public float startPointY;
    public float noiseWeight;
    public float distWeight;
    public String name;
    public String tilesetAtlas;
    public String tilesetName;
    public BiomeTerrainData[] terrain;
    public float width;
    public float height;
    public String color;
    public boolean collision;
    public boolean invertHeight;
    public String[] spriteNames;
    public String[] enemies;
    public String[] pointsOfInterest;
    public BiomeStructureData[] structures;
    private ArrayList<EnemyData> enemyList;
    private ArrayList<PointOfInterestData> pointOfInterestList;
    private final Random rand = MyRandom.getRandom();
    private ArrayList<String> unusedTownNames;

    public Color GetColor() {
        return Color.valueOf(this.color);
    }

    public ArrayList<EnemyData> getEnemyList() {
        if (this.enemyList == null) {
            this.enemyList = new ArrayList();
            if (this.enemies == null) {
                return this.enemyList;
            }
            for (EnemyData data : new Array.ArrayIterator<EnemyData>(WorldData.getAllEnemies())) {
                for (String enemyName : this.enemies) {
                    if (!data.getName().equals(enemyName)) continue;
                    this.enemyList.add(data);
                    break;
                }
                EnemyData zeroSpawnRate = new EnemyData(data);
                zeroSpawnRate.spawnRate = 0.0f;
                this.enemyList.add(zeroSpawnRate);
            }
        }
        return this.enemyList;
    }

    public ArrayList<PointOfInterestData> getPointsOfInterest() {
        if (this.pointOfInterestList == null) {
            this.pointOfInterestList = new ArrayList();
            if (this.pointsOfInterest == null) {
                return this.pointOfInterestList;
            }
            Array<PointOfInterestData> allTowns = PointOfInterestData.getAllPointOfInterest();
            block0: for (PointOfInterestData data : new Array.ArrayIterator<PointOfInterestData>(allTowns)) {
                for (String poiName : this.pointsOfInterest) {
                    if (!data.name.equals(poiName)) continue;
                    this.pointOfInterestList.add(data);
                    continue block0;
                }
            }
        }
        ArrayList<PointOfInterestData> cavesDungeon = new ArrayList<PointOfInterestData>();
        for (PointOfInterestData data : this.pointOfInterestList) {
            if (!"cave".equalsIgnoreCase(data.type) && !"dungeon".equalsIgnoreCase(data.type)) continue;
            cavesDungeon.add(data);
        }
        this.pointOfInterestList.removeAll(cavesDungeon);
        this.pointOfInterestList.addAll(cavesDungeon);
        return this.pointOfInterestList;
    }

    public EnemyData getExtraSpawnEnemy(float difficultyFactor) {
        List<EnemyData> extraSpawnEnemies = AdventureQuestController.instance().getExtraQuestSpawns(difficultyFactor);
        if (extraSpawnEnemies.isEmpty()) {
            return null;
        }
        return Aggregates.random(extraSpawnEnemies);
    }

    public EnemyData getEnemy(float difficultyFactor) {
        float totalDistribution = 0.0f;
        for (EnemyData data : this.enemyList) {
            totalDistribution += data.spawnRate;
        }
        float f = totalDistribution * this.rand.nextFloat();
        for (int i = 0; i < this.enemyList.size(); ++i) {
            if (!((f -= this.enemyList.get((int)i).spawnRate) <= 0.0f)) continue;
            return this.enemyList.get(i);
        }
        return Aggregates.random(this.enemyList);
    }

    public String getNewTownName() {
        return Aggregates.removeRandom(this.getUnusedTownNames());
    }

    public ArrayList<String> getUnusedTownNames() {
        if (this.unusedTownNames == null) {
            this.unusedTownNames = WorldData.getTownNames(this.name);
        }
        return this.unusedTownNames;
    }
}

