/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.data;

import forge.adventure.character.EnemySprite;
import forge.adventure.data.DialogData;
import forge.adventure.data.EnemyData;
import forge.adventure.pointofintrest.PointOfInterest;
import forge.adventure.scene.TileMapScene;
import forge.adventure.stage.MapStage;
import forge.adventure.util.AdventureQuestController;
import forge.adventure.util.AdventureQuestEvent;
import forge.adventure.util.AdventureQuestEventType;
import forge.adventure.util.Current;
import forge.util.Aggregates;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;

public class AdventureQuestStage
implements Serializable {
    private static final long serialVersionUID = 12042023L;
    public int id;
    private AdventureQuestController.QuestStatus status = AdventureQuestController.QuestStatus.INACTIVE;
    public String name = "";
    public String description = "";
    public boolean anyPOI = false;
    public String mapFlag;
    public int mapFlagValue;
    public int count1;
    public int count2;
    public int count3;
    public int count4;
    private int progress1;
    private int progress2;
    private int progress3;
    private int progress4;
    public boolean mixedEnemies;
    public boolean here;
    private PointOfInterest targetPOI;
    private transient EnemySprite targetSprite;
    private EnemyData targetEnemyData;
    public List<String> POITags = new ArrayList<String>();
    public boolean worldMapOK = false;
    public AdventureQuestController.ObjectiveTypes objective;
    public List<Integer> prerequisiteIDs = new ArrayList<Integer>();
    public List<String> enemyTags = new ArrayList<String>();
    public List<String> enemyExcludeTags = new ArrayList<String>();
    public List<String> itemNames = new ArrayList<String>();
    public List<String> equipNames = new ArrayList<String>();
    public boolean prologueDisplayed = false;
    public boolean epilogueDisplayed = false;
    public DialogData prologue;
    public DialogData epilogue;
    public DialogData failureDialog;
    public String deliveryItem = "";
    public String POIToken;
    private transient List<Integer> _parsedPrerequisiteNames;
    private transient List<PointOfInterest> validPOIs;
    public boolean allowInactivePOI = false;
    public UUID stageID;

    public void initialize() {
        if (this.stageID == null) {
            this.stageID = UUID.randomUUID();
        }
        this.validPOIs = Current.world().getAllPointOfInterest();
    }

    public void checkPrerequisites(List<Integer> completedStages) {
        if (this.status != AdventureQuestController.QuestStatus.INACTIVE) {
            return;
        }
        for (Integer prereqID : this.prerequisiteIDs) {
            if (completedStages.contains(prereqID)) continue;
            return;
        }
        this.status = AdventureQuestController.QuestStatus.ACTIVE;
    }

    public AdventureQuestController.QuestStatus getStatus() {
        return this.status;
    }

    public PointOfInterest getTargetPOI() {
        return this.targetPOI;
    }

    public void setTargetPOI(PointOfInterest target) {
        if (!this.anyPOI) {
            this.targetPOI = target;
        }
    }

    public void setTargetPOI(Dictionary<String, PointOfInterest> poiTokens, String questName) {
        if (this.worldMapOK) {
            return;
        }
        if (this.POIToken != null && !this.POIToken.isEmpty()) {
            PointOfInterest tokenTarget = poiTokens.get(this.POIToken);
            if (tokenTarget != null) {
                this.setTargetPOI(tokenTarget);
                return;
            }
            System.out.println("Quest '" + questName + "' -  Stage '" + this.name + "' failed to generate POI from token reference: '" + this.POIToken + "'");
        }
        if (this.here) {
            this.setTargetPOI(AdventureQuestController.instance().mostRecentPOI);
            return;
        }
        if (!this.allowInactivePOI) {
            this.validPOIs.removeIf(q -> !q.getActive());
        }
        for (String tag : this.POITags) {
            this.validPOIs.removeIf(q -> Arrays.stream(q.getData().questTags).noneMatch(tag::equals));
        }
        if (!this.anyPOI) {
            if (this.validPOIs.isEmpty()) {
                this.validPOIs = Current.world().getAllPointOfInterest();
                return;
            }
            int targetIndex = this.count1 * this.validPOIs.size() / 100;
            int variance = this.count2 * this.validPOIs.size() / 100;
            if ((targetIndex = Math.max(0, (int)((float)(targetIndex - variance) + new Random().nextFloat() * (float)variance * 2.0f))) < this.validPOIs.size() && targetIndex >= 0) {
                this.validPOIs.sort(new AdventureQuestController.DistanceSort());
                this.setTargetPOI(this.validPOIs.get(targetIndex));
            } else {
                if (this.count1 != 0 || this.count2 != 0) {
                    System.out.println("Quest '" + questName + "' -  Stage '" + this.name + "' has invalid count1 ('" + this.count1 + "') and/or count2 ('" + this.count2 + "') value");
                }
                this.setTargetPOI(Aggregates.random(this.validPOIs));
            }
        }
    }

    public EnemySprite getTargetSprite() {
        return this.targetSprite;
    }

    public void setTargetEnemyData(EnemyData target) {
        this.targetEnemyData = target;
    }

    public EnemyData getTargetEnemyData() {
        if (this.targetEnemyData == null && this.targetSprite != null) {
            return this.targetSprite.getData();
        }
        return this.targetEnemyData;
    }

    public void setTargetSprite(EnemySprite target) {
        this.targetSprite = target;
    }

    public boolean checkIfTargetLocation() {
        return this.checkIfTargetLocation(TileMapScene.instance().rootPoint);
    }

    public boolean checkIfTargetLocation(PointOfInterest locationToCheck) {
        if (!MapStage.getInstance().isInMap()) {
            return this.worldMapOK;
        }
        if (this.targetPOI == null) {
            List enteredTags = Arrays.stream(locationToCheck.getData().questTags).collect(Collectors.toList());
            for (String tag : this.POITags) {
                if (enteredTags.contains(tag)) continue;
                return false;
            }
        }
        if (this.targetPOI != null) {
            return this.targetPOI.getPosition().equals(locationToCheck.getPosition());
        }
        return this.anyPOI;
    }

    public boolean checkIfTargetEnemy(EnemySprite enemy) {
        if (this.targetEnemyData != null) {
            return enemy.getData().match(this.targetEnemyData);
        }
        if (this.targetSprite == null) {
            ArrayList<String> candidateTags = new ArrayList<String>(Arrays.asList(enemy.getData().questTags));
            int tagCount = candidateTags.size();
            candidateTags.removeAll(this.enemyExcludeTags);
            if (candidateTags.size() != tagCount) {
                return false;
            }
            candidateTags.removeAll(this.enemyTags);
            return candidateTags.size() == tagCount - this.enemyTags.size();
        }
        return this.targetSprite.equals(enemy);
    }

    public AdventureQuestStage() {
    }

    public AdventureQuestStage(AdventureQuestStage other) {
        this.status = other.status;
        this.prologueDisplayed = other.prologueDisplayed;
        this.prologue = new DialogData(other.prologue);
        this.epilogueDisplayed = other.epilogueDisplayed;
        this.epilogue = new DialogData(other.epilogue);
        this.failureDialog = new DialogData(other.failureDialog);
        this.name = other.name;
        this.description = other.description;
        this.progress1 = other.progress1;
        this.progress2 = other.progress2;
        this.progress3 = other.progress3;
        this.count1 = other.count1;
        this.count2 = other.count2;
        this.count3 = other.count3;
        this.count4 = other.count4;
        this.enemyTags = other.enemyTags;
        this.enemyExcludeTags = other.enemyExcludeTags;
        this.anyPOI = other.anyPOI;
        this.here = other.here;
        this.targetPOI = other.targetPOI;
        this.objective = other.objective;
        this.mapFlagValue = other.mapFlagValue;
        this.mapFlag = other.mapFlag;
        this.equipNames = other.equipNames;
        this.mixedEnemies = other.mixedEnemies;
        this.itemNames = other.itemNames;
        this.prerequisiteIDs = other.prerequisiteIDs;
        this.POIToken = other.POIToken;
        this.id = other.id;
        this.POITags = other.POITags;
        this.targetEnemyData = other.targetEnemyData;
        this.deliveryItem = other.deliveryItem;
        this.worldMapOK = other.worldMapOK;
        this.allowInactivePOI = other.allowInactivePOI;
    }

    public List<PointOfInterest> getValidPOIs() {
        if (this.worldMapOK) {
            return new ArrayList<PointOfInterest>();
        }
        if (this.objective == AdventureQuestController.ObjectiveTypes.Hunt) {
            return new ArrayList<PointOfInterest>();
        }
        if (this.validPOIs == null) {
            this.validPOIs = new ArrayList<PointOfInterest>();
        }
        if (this.validPOIs.size() != 1 && this.targetPOI != null) {
            this.validPOIs.clear();
            this.validPOIs.add(this.targetPOI);
        }
        if (this.validPOIs.isEmpty() && this.targetPOI == null && !this.POITags.isEmpty()) {
            this.validPOIs = Current.world().getAllPointOfInterest();
            if (!this.allowInactivePOI) {
                this.validPOIs.removeIf(q -> !q.getActive());
            }
            for (String tag : this.POITags) {
                this.validPOIs.removeIf(q -> Arrays.stream(q.getData().questTags).noneMatch(tag::equals));
            }
        }
        return this.validPOIs;
    }

    public AdventureQuestController.QuestStatus handleEvent(AdventureQuestEvent event) {
        if (!this.checkIfTargetLocation(event.poi)) {
            return this.status;
        }
        if (event.enemy != null && !this.checkIfTargetEnemy(event.enemy)) {
            return this.status;
        }
        switch (this.objective) {
            case CharacterFlag: {
                if (event.type != AdventureQuestEventType.CHARACTERFLAG) break;
                this.status = event.flagName != null && event.flagName.equals(this.mapFlag) && event.flagValue >= this.mapFlagValue ? AdventureQuestController.QuestStatus.COMPLETE : this.status;
                break;
            }
            case CompleteQuest: {
                this.status = event.type == AdventureQuestEventType.QUESTCOMPLETE && (this.anyPOI || event.otherQuest != null && event.otherQuest.sourceID.equals(this.targetPOI.getID())) && ++this.progress3 >= this.count3 ? AdventureQuestController.QuestStatus.COMPLETE : this.status;
                break;
            }
            case Clear: {
                if (!event.clear || !event.winner) break;
                this.status = AdventureQuestController.QuestStatus.COMPLETE;
                break;
            }
            case Defeat: {
                if (event.type != AdventureQuestEventType.MATCHCOMPLETE) break;
                if (event.winner) {
                    this.status = ++this.progress3 >= this.count3 ? AdventureQuestController.QuestStatus.COMPLETE : this.status;
                    break;
                }
                this.status = ++this.progress4 >= this.count4 && this.count4 > 0 ? AdventureQuestController.QuestStatus.FAILED : this.status;
                break;
            }
            case Arena: {
                this.status = event.type == AdventureQuestEventType.ARENACOMPLETE && event.winner && ++this.progress3 >= this.count3 ? AdventureQuestController.QuestStatus.COMPLETE : this.status;
                break;
            }
            case EventFinish: {
                if (event.type != AdventureQuestEventType.EVENTCOMPLETE) break;
                this.status = ++this.progress3 >= this.count3 ? AdventureQuestController.QuestStatus.COMPLETE : this.status;
                break;
            }
            case EventWin: {
                if (event.type != AdventureQuestEventType.EVENTCOMPLETE) break;
                if (event.winner) {
                    this.status = ++this.progress3 >= this.count3 ? AdventureQuestController.QuestStatus.COMPLETE : this.status;
                    break;
                }
                this.status = ++this.progress4 >= this.count4 && this.count4 > 0 ? AdventureQuestController.QuestStatus.FAILED : this.status;
                break;
            }
            case EventWinMatches: {
                if (event.type != AdventureQuestEventType.EVENTMATCHCOMPLETE) break;
                if (event.winner) {
                    this.status = ++this.progress3 >= this.count3 ? AdventureQuestController.QuestStatus.COMPLETE : this.status;
                    break;
                }
                this.status = ++this.progress4 >= this.count4 && this.count4 > 0 ? AdventureQuestController.QuestStatus.FAILED : this.status;
                break;
            }
            case Fetch: {
                this.status = event.type == AdventureQuestEventType.RECEIVEITEM && this.itemNames.isEmpty() || event.item != null && this.itemNames.contains(event.item.name) && ++this.progress1 >= this.count1 ? AdventureQuestController.QuestStatus.COMPLETE : this.status;
                break;
            }
            case Hunt: {
                if (event.type == AdventureQuestEventType.DESPAWN) {
                    this.status = event.enemy.equals(this.targetSprite) ? AdventureQuestController.QuestStatus.FAILED : this.status;
                    break;
                }
                if (event.type != AdventureQuestEventType.MATCHCOMPLETE) break;
                if (event.winner) {
                    this.status = event.enemy.equals(this.targetSprite) ? AdventureQuestController.QuestStatus.COMPLETE : this.status;
                    break;
                }
                this.status = ++this.progress4 >= this.count4 && this.count4 > 0 ? AdventureQuestController.QuestStatus.FAILED : this.status;
                break;
            }
            case Leave: {
                if (event.type != AdventureQuestEventType.LEAVEPOI) break;
                this.status = ++this.progress3 >= this.count3 ? AdventureQuestController.QuestStatus.COMPLETE : this.status;
                break;
            }
            case MapFlag: {
                if (event.type != AdventureQuestEventType.MAPFLAG) break;
                this.status = event.flagName != null && event.flagName.equals(this.mapFlag) && event.flagValue >= this.mapFlagValue ? AdventureQuestController.QuestStatus.COMPLETE : this.status;
                break;
            }
            case QuestFlag: {
                if (event.type != AdventureQuestEventType.QUESTFLAG) break;
                this.status = event.flagName != null && event.flagName.equals(this.mapFlag) && event.flagValue >= this.mapFlagValue ? AdventureQuestController.QuestStatus.COMPLETE : this.status;
                break;
            }
            case HaveReputation: {
                if (event.type != AdventureQuestEventType.REPUTATION) break;
                this.status = this.checkIfTargetLocation(event.poi) && event.count3 >= this.count3 ? AdventureQuestController.QuestStatus.COMPLETE : this.status;
                break;
            }
            case HaveReputationInCurrentLocation: {
                if (event.type != AdventureQuestEventType.ENTERPOI && event.type != AdventureQuestEventType.REPUTATION) break;
                this.status = event.count3 >= this.count3 ? AdventureQuestController.QuestStatus.COMPLETE : this.status;
                break;
            }
            case Delivery: 
            case Travel: {
                this.status = ++this.progress3 >= this.count3 ? AdventureQuestController.QuestStatus.COMPLETE : this.status;
                break;
            }
            case Use: {
                this.status = event.type == AdventureQuestEventType.USEITEM && this.itemNames.isEmpty() || this.itemNames.contains(event.item.name) && ++this.progress3 >= this.count3 ? AdventureQuestController.QuestStatus.COMPLETE : this.status;
            }
        }
        return this.status;
    }
}

