/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.character;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import forge.adventure.character.EntryActor;
import forge.adventure.scene.TileMapScene;
import forge.adventure.stage.MapStage;
import forge.adventure.util.Config;
import java.util.HashMap;

public class PortalActor
extends EntryActor {
    private final HashMap<PortalAnimationTypes, Animation<TextureRegion>> animations = new HashMap();
    private Animation<TextureRegion> currentAnimation = null;
    private PortalAnimationTypes currentAnimationType = PortalAnimationTypes.Closed;
    float timer;
    float transitionTimer;

    public PortalActor(MapStage stage, int id, String targetMap, float x, float y, float w, float h2, String direction, String currentMap, int portalTargetObject, String path) {
        super(stage, id, targetMap, x, y, w, h2, direction, currentMap, portalTargetObject);
        this.load(path);
    }

    @Override
    public MapStage getMapStage() {
        return this.stage;
    }

    @Override
    public void onPlayerCollide() {
        if (this.currentAnimationType == PortalAnimationTypes.Inactive) {
            // empty if block
        }
        if (this.currentAnimationType == PortalAnimationTypes.Active) {
            if (this.targetMap == null || this.targetMap.isEmpty()) {
                this.stage.exitDungeon(false);
            } else if (this.targetMap.equals(this.currentMap)) {
                this.stage.spawn(this.entryTargetObject);
                this.stage.getPlayerSprite().playEffect("particle_effects/teleport.p", 0.5f);
                this.stage.startPause(1.5f);
            } else {
                this.currentMap = this.targetMap;
                TileMapScene.instance().loadNext(this.targetMap, this.entryTargetObject);
                this.stage.getPlayerSprite().playEffect("particle_effects/teleport.p", 0.5f);
            }
        }
    }

    @Override
    public void spawn() {
        switch (this.direction) {
            case "up": {
                this.stage.getPlayerSprite().setPosition(this.x + this.w / 2.0f - this.stage.getPlayerSprite().getWidth() / 2.0f, this.y + this.h);
                break;
            }
            case "down": {
                this.stage.getPlayerSprite().setPosition(this.x + this.w / 2.0f - this.stage.getPlayerSprite().getWidth() / 2.0f, this.y - this.stage.getPlayerSprite().getHeight());
                break;
            }
            case "right": {
                this.stage.getPlayerSprite().setPosition(this.x - this.stage.getPlayerSprite().getWidth(), this.y + this.h / 2.0f - this.stage.getPlayerSprite().getHeight() / 2.0f);
                break;
            }
            case "left": {
                this.stage.getPlayerSprite().setPosition(this.x + this.w, this.y + this.h / 2.0f - this.stage.getPlayerSprite().getHeight() / 2.0f);
            }
        }
    }

    protected void load(String path) {
        if (path == null || path.isEmpty()) {
            return;
        }
        this.animations.clear();
        for (PortalAnimationTypes stand : PortalAnimationTypes.values()) {
            Array<Sprite> anim = Config.instance().getAnimatedSprites(path, stand.toString());
            if (anim.size == 0) continue;
            this.animations.put(stand, new Animation<Sprite>(0.2f, anim));
            if ((double)this.getWidth() != 0.0) continue;
            this.setWidth(anim.first().getWidth());
            this.setHeight(anim.first().getHeight());
        }
        this.setAnimation(PortalAnimationTypes.Closed);
        this.updateAnimation();
    }

    public void setAnimation(PortalAnimationTypes type) {
        if (this.currentAnimationType != type) {
            this.currentAnimationType = type;
            this.updateAnimation();
        }
    }

    public void setAnimation(String typeName) {
        switch (typeName.toLowerCase()) {
            case "active": {
                this.setAnimation(PortalAnimationTypes.Active);
                break;
            }
            case "inactive": {
                this.setAnimation(PortalAnimationTypes.Inactive);
                break;
            }
            case "closed": {
                this.setAnimation(PortalAnimationTypes.Closed);
                break;
            }
            case "opening": {
                this.setAnimation(PortalAnimationTypes.Opening);
                break;
            }
            case "closing": {
                this.setAnimation(PortalAnimationTypes.Closing);
            }
        }
    }

    public String getAnimation() {
        return this.currentAnimationType.toString().toLowerCase();
    }

    private void updateAnimation() {
        PortalAnimationTypes aniType = this.currentAnimationType;
        if (!this.animations.containsKey((Object)aniType)) {
            aniType = PortalAnimationTypes.Inactive;
        }
        if (!this.animations.containsKey((Object)aniType)) {
            return;
        }
        this.currentAnimation = this.animations.get((Object)aniType);
    }

    @Override
    public void act(float delta) {
        this.timer += delta;
        super.act(delta);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.currentAnimation == null) {
            return;
        }
        super.draw(batch, parentAlpha);
        this.beforeDraw(batch, parentAlpha);
        TextureRegion currentFrame = this.currentAnimationType.equals((Object)PortalAnimationTypes.Opening) || this.currentAnimationType.equals((Object)PortalAnimationTypes.Closing) ? this.currentAnimation.getKeyFrame(this.transitionTimer, false) : this.currentAnimation.getKeyFrame(this.timer, true);
        this.setHeight(currentFrame.getRegionHeight());
        this.setWidth(currentFrame.getRegionWidth());
        Color oldColor = batch.getColor().cpy();
        batch.setColor(this.getColor());
        batch.draw(currentFrame, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        batch.setColor(oldColor);
        super.draw(batch, parentAlpha);
    }

    public static enum PortalAnimationTypes {
        Closed,
        Active,
        Inactive,
        Opening,
        Closing;

    }
}

