/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.character;

import forge.adventure.character.MapActor;
import forge.adventure.scene.TileMapScene;
import forge.adventure.stage.MapStage;

public class EntryActor
extends MapActor {
    final MapStage stage;
    String targetMap;
    float x;
    float y;
    float w;
    float h;
    String direction;
    String currentMap;
    int entryTargetObject;

    public EntryActor(MapStage stage, int id, String targetMap, float x, float y, float w, float h2, String direction, String currentMap, int entryTargetObject) {
        super(id);
        this.stage = stage;
        this.targetMap = targetMap;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h2;
        this.currentMap = currentMap;
        this.entryTargetObject = entryTargetObject;
        this.direction = direction;
    }

    public MapStage getMapStage() {
        return this.stage;
    }

    @Override
    public void onPlayerCollide() {
        if (this.targetMap == null || this.targetMap.isEmpty()) {
            this.stage.exitDungeon(false);
        } else if (this.targetMap.equals(this.currentMap)) {
            this.stage.spawn(this.entryTargetObject);
        } else {
            this.currentMap = this.targetMap;
            TileMapScene.instance().loadNext(this.targetMap, this.entryTargetObject);
        }
    }

    public void spawn() {
        switch (this.direction) {
            case "up": {
                this.stage.getPlayerSprite().setPosition(this.x + this.w / 2.0f - this.stage.getPlayerSprite().getWidth() / 2.0f, this.y + this.h);
                break;
            }
            case "down": {
                this.stage.getPlayerSprite().setPosition(this.x + this.w / 2.0f - this.stage.getPlayerSprite().getWidth() / 2.0f, this.y - this.stage.getPlayerSprite().getHeight());
                break;
            }
            case "right": {
                this.stage.getPlayerSprite().setPosition(this.x - this.stage.getPlayerSprite().getWidth(), this.y + this.h / 2.0f - this.stage.getPlayerSprite().getHeight() / 2.0f);
                break;
            }
            case "left": {
                this.stage.getPlayerSprite().setPosition(this.x + this.w, this.y + this.h / 2.0f - this.stage.getPlayerSprite().getHeight() / 2.0f);
            }
        }
    }
}

