/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.character;

import com.badlogic.gdx.ai.steer.Steerable;
import com.badlogic.gdx.ai.steer.SteeringAcceleration;
import com.badlogic.gdx.ai.steer.SteeringBehavior;
import com.badlogic.gdx.ai.steer.behaviors.Arrive;
import com.badlogic.gdx.ai.steer.behaviors.FollowPath;
import com.badlogic.gdx.ai.steer.behaviors.Seek;
import com.badlogic.gdx.ai.steer.utils.paths.LinePath;
import com.badlogic.gdx.ai.utils.Location;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import com.google.common.base.Predicates;
import forge.Forge;
import forge.adventure.character.CharacterSprite;
import forge.adventure.character.PlayerSprite;
import forge.adventure.data.DialogData;
import forge.adventure.data.EffectData;
import forge.adventure.data.EnemyData;
import forge.adventure.data.RewardData;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.util.Current;
import forge.adventure.util.MapDialog;
import forge.adventure.util.Reward;
import forge.adventure.util.pathfinding.MovementBehavior;
import forge.adventure.util.pathfinding.NavigationVertex;
import forge.adventure.util.pathfinding.ProgressableGraphPath;
import forge.card.CardRarity;
import forge.card.CardRulesPredicates;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.item.PaperCard;
import forge.util.Aggregates;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class EnemySprite
extends CharacterSprite
implements Steerable<Vector2> {
    private static final SteeringAcceleration<Vector2> steerOutput = new SteeringAcceleration<Vector2>(new Vector2());
    Vector2 position;
    float orientation;
    Vector2 linearVelocity = new Vector2(1.0f, 0.0f);
    float angularVelocity;
    float maxSpeed;
    boolean independentFacing;
    SteeringBehavior<Vector2> behavior;
    boolean tagged;
    EnemyData data;
    public MapDialog dialog;
    public MapDialog defeatDialog;
    public EffectData effect;
    public String nameOverride = "";
    public RewardData[] rewards;
    public DialogData.ConditionData spawnCondition;
    public LinkedList<MovementBehavior> movementBehaviors = new LinkedList();
    public Vector2 targetVector;
    private final Vector2 _previousPosition = new Vector2();
    private final Vector2 _previousPosition2 = new Vector2();
    private final Vector2 _previousPosition3 = new Vector2();
    private final Vector2 _previousPosition4 = new Vector2();
    private final Vector2 _previousPosition5 = new Vector2();
    private final Vector2 _previousPosition6 = new Vector2();
    private final Float _movementTimeout = Float.valueOf(150.0f);
    private boolean _freeze = false;
    public float unfreezeRange = 30.0f;
    public float threatRange = 0.0f;
    public float pursueRange = 0.0f;
    public float fleeRange = 0.0f;
    public float speedModifier = 0.0f;
    public boolean aggro = false;
    public boolean ignoreDungeonEffect = false;
    public String questStageID;
    private ProgressableGraphPath<NavigationVertex> navPath;
    public Vector2 fleeTarget;

    public EnemySprite(EnemyData enemyData) {
        this(0, enemyData);
    }

    public EnemySprite(int id, EnemyData enemyData) {
        super(id, enemyData.sprite);
        this.data = enemyData;
        float scale = this.data.scale;
        if (scale < 0.0f) {
            scale = 1.0f;
        }
        this.setWidth(this.getWidth() * scale);
        this.setHeight(this.getHeight() * scale);
        this.updateBoundingRect();
        this.initializeBaseMovementBehavior();
    }

    public void parseWaypoints(String waypoints) {
        String[] wp;
        for (String s2 : wp = waypoints.replaceAll("\\s", "").split(",")) {
            this.movementBehaviors.addLast(new MovementBehavior());
            if (this.movementBehaviors.isEmpty()) continue;
            if (s2.startsWith("wait")) {
                this.movementBehaviors.peekLast().duration = Float.parseFloat(s2.substring(4));
                continue;
            }
            this.movementBehaviors.peekLast().destination = s2;
        }
    }

    @Override
    void updateBoundingRect() {
        float scale;
        float f = scale = this.data == null ? 1.0f : this.data.scale;
        if (scale < 0.0f) {
            scale = 1.0f;
        }
        this.boundingRect.set(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.unfreezeRange = 30.0f * scale;
    }

    public void moveTo(Actor other, float delta) {
        Vector2 diff = new Vector2(other.getX(), other.getY()).sub(this.pos());
        diff.setLength(this.data.speed * delta);
        this.moveBy(diff.x, diff.y, delta);
    }

    public void initializeBaseMovementBehavior() {
        Location<Vector2> seekTarget = new Location<Vector2>(){

            @Override
            public Vector2 getPosition() {
                return ((NavigationVertex)((EnemySprite)EnemySprite.this).navPath.nodes.get((int)0)).pos;
            }

            @Override
            public float getOrientation() {
                return 0.0f;
            }

            @Override
            public void setOrientation(float orientation) {
            }

            @Override
            public float vectorToAngle(Vector2 vector) {
                return 0.0f;
            }

            @Override
            public Vector2 angleToVector(Vector2 outVector, float angle) {
                return null;
            }

            @Override
            public Location<Vector2> newLocation() {
                return null;
            }
        };
        Seek<Vector2> seek = new Seek<Vector2>(this);
        seek.setTarget(seekTarget);
        Array<Vector2> wp = new Array<Vector2>();
        if (this.navPath != null && this.navPath.nodes != null) {
            for (NavigationVertex v : this.navPath.nodes) {
                wp.add(v.pos);
            }
        }
        LinePath linePath = null;
        FollowPath followWaypoints = null;
        if (wp.size == 1) {
            wp.insert(0, this.pos());
        }
        if (wp.size >= 2) {
            linePath = new LinePath(wp, false);
            followWaypoints = new FollowPath(this, linePath);
            followWaypoints.setPathOffset(0.5f);
        }
        Arrive<Vector2> moveDirectlyToDestination = new Arrive<Vector2>(this, new Location<Vector2>(){

            @Override
            public Vector2 getPosition() {
                if (EnemySprite.this.navPath == null || ((EnemySprite)EnemySprite.this).navPath.nodes.size == 0) {
                    return EnemySprite.this.pos();
                }
                return ((NavigationVertex)((EnemySprite)EnemySprite.this).navPath.get((int)0)).pos;
            }

            @Override
            public float getOrientation() {
                return 0.0f;
            }

            @Override
            public void setOrientation(float orientation) {
            }

            @Override
            public float vectorToAngle(Vector2 vector) {
                return 0.0f;
            }

            @Override
            public Vector2 angleToVector(Vector2 outVector, float angle) {
                return null;
            }

            @Override
            public Location<Vector2> newLocation() {
                return null;
            }
        }).setTimeToTarget(0.01f).setArrivalTolerance(0.0f).setDecelerationRadius(10.0f);
        if (followWaypoints != null) {
            this.setBehavior(followWaypoints);
        } else {
            this.setBehavior(moveDirectlyToDestination);
        }
    }

    public void setBehavior(SteeringBehavior<Vector2> behavior) {
        this.behavior = behavior;
    }

    public SteeringBehavior<Vector2> getBehavior() {
        return this.behavior;
    }

    public void update(float delta) {
        if (this.behavior != null) {
            this.behavior.calculateSteering(steerOutput);
            while (steerOutput.isZero() && this.navPath != null && this.navPath.getCount() > 1) {
                this.navPath.remove(0);
                this.behavior.calculateSteering(steerOutput);
            }
            this.applySteering(delta);
        }
    }

    private void applySteering(float delta) {
        if (!((Vector2)EnemySprite.steerOutput.linear).isZero()) {
            Vector2 force = ((Vector2)EnemySprite.steerOutput.linear).scl(delta);
            force.setLength(Math.min(this.speed() * delta, force.len()));
            this.moveBy(force.x, force.y);
        }
    }

    @Override
    public float vectorToAngle(Vector2 vector) {
        return (float)Math.atan2(-vector.x, vector.y);
    }

    @Override
    public Vector2 angleToVector(Vector2 outVector, float angle) {
        outVector.x = -((float)Math.sin(angle));
        outVector.y = (float)Math.cos(angle);
        return outVector;
    }

    @Override
    public Vector2 getLinearVelocity() {
        return this.linearVelocity;
    }

    @Override
    public float getAngularVelocity() {
        return this.angularVelocity;
    }

    @Override
    public float getBoundingRadius() {
        return this.getWidth() / 2.0f;
    }

    @Override
    public boolean isTagged() {
        return this.tagged;
    }

    @Override
    public Vector2 getPosition() {
        return this.pos();
    }

    @Override
    public float getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(float value) {
        this.orientation = value;
    }

    @Override
    public Location<Vector2> newLocation() {
        return null;
    }

    @Override
    public void setTagged(boolean value) {
        this.tagged = value;
    }

    public void freezeMovement() {
        this._freeze = true;
        this.setPosition(this._previousPosition6.x, this._previousPosition6.y);
    }

    public Vector2 getTargetVector(PlayerSprite player, ArrayList<NavigationVertex> sortedGraphNodes, float delta) {
        Vector2 target = this.pos();
        Vector2 spriteToPlayer = new Vector2(player.pos()).sub(target);
        if (this._freeze) {
            float distance = spriteToPlayer.len();
            if (distance < this.unfreezeRange) {
                this.timer += delta;
                return Vector2.Zero;
            }
            this._freeze = false;
        }
        NavigationVertex targetPoint = null;
        if (this.threatRange > 0.0f || this.fleeRange > 0.0f) {
            if (spriteToPlayer.len() <= this.threatRange || this.aggro && spriteToPlayer.len() <= this.pursueRange) {
                if (sortedGraphNodes != null) {
                    for (NavigationVertex candidate : sortedGraphNodes) {
                        Vector2 candidateToPlayer = new Vector2(candidate.pos).sub(player.pos());
                        if (!(candidateToPlayer.x * candidateToPlayer.x + candidateToPlayer.y * candidateToPlayer.y < spriteToPlayer.x * spriteToPlayer.x + spriteToPlayer.y * spriteToPlayer.y)) continue;
                        targetPoint = candidate;
                        break;
                    }
                }
                this.aggro = true;
                if (targetPoint != null) {
                    return targetPoint.pos;
                }
                return new Vector2(player.pos());
            }
            if (spriteToPlayer.len() <= this.fleeRange) {
                float fleeDistance = this.fleeRange - spriteToPlayer.len();
                return new Vector2(this.pos()).sub(player.pos()).setLength(fleeDistance).add(this.pos());
            }
            if (this.aggro && spriteToPlayer.len() > this.pursueRange) {
                this.aggro = false;
                if (this.navPath != null) {
                    this.navPath.clear();
                }
                this.initializeBaseMovementBehavior();
            }
        }
        if (this.movementBehaviors.peek() != null) {
            MovementBehavior peek = this.movementBehaviors.peek();
            if (peek.getDuration() == 0.0f && peek.getNextTargetVector(this.objectId, this.pos()).dst(this.pos()) < 2.0f) {
                MovementBehavior current = this.movementBehaviors.pop();
                current.currentTargetVector = null;
                this.movementBehaviors.addLast(current);
            } else if (peek.getDuration() > 0.0f) {
                if (this.timer >= peek.getDuration() + delta) {
                    MovementBehavior current = this.movementBehaviors.pop();
                    current.currentTargetVector = null;
                    this.movementBehaviors.addLast(current);
                } else {
                    this.timer += delta;
                    return new Vector2(this.pos());
                }
            }
            target = (double)peek.getNextTargetVector(this.objectId, this.pos()).dst(this.pos()) > 0.3 ? new Vector2(peek.getNextTargetVector(this.objectId, this.pos())) : new Vector2(this.pos());
        } else {
            target = new Vector2(this.pos());
        }
        return target;
    }

    public void updatePositon() {
        this._previousPosition6.set(this._previousPosition5);
        this._previousPosition5.set(this._previousPosition4);
        this._previousPosition4.set(this._previousPosition3);
        this._previousPosition3.set(this._previousPosition2);
        this._previousPosition2.set(this._previousPosition);
        this._previousPosition.set(this.pos());
    }

    public EnemyData getData() {
        return this.data;
    }

    public void overrideDeck(String deckPath) {
        this.data.deck = new String[1];
        this.data.deck[0] = deckPath;
    }

    @Override
    public String getName() {
        if (this.nameOverride == null || this.nameOverride.isEmpty()) {
            return this.data.getName();
        }
        return this.nameOverride;
    }

    public Array<Reward> getRewards() {
        Array<Reward> ret = new Array<Reward>();
        if (this.data.copyPlayerDeck && AdventurePlayer.current().isFantasyMode()) {
            if (Current.latestDeck() != null) {
                List rareCards;
                List commmonCards;
                List paperCardList = Current.latestDeck().getMain().toFlatList().stream().filter(paperCard -> !paperCard.isVeryBasicLand() && !paperCard.getName().startsWith("Mox")).collect(Collectors.toList());
                List uncommonCards = paperCardList.stream().filter(paperCard -> CardRarity.Uncommon.equals((Object)paperCard.getRarity()) || CardRarity.Special.equals((Object)paperCard.getRarity())).collect(Collectors.toList());
                if (!uncommonCards.isEmpty()) {
                    ret.add(new Reward((PaperCard)Aggregates.random(uncommonCards)));
                    ret.add(new Reward((PaperCard)Aggregates.random(uncommonCards)));
                }
                if (!(commmonCards = paperCardList.stream().filter(paperCard -> CardRarity.Common.equals((Object)paperCard.getRarity())).collect(Collectors.toList())).isEmpty()) {
                    ret.add(new Reward((PaperCard)Aggregates.random(commmonCards)));
                    ret.add(new Reward((PaperCard)Aggregates.random(commmonCards)));
                    ret.add(new Reward((PaperCard)Aggregates.random(commmonCards)));
                }
                if (!(rareCards = paperCardList.stream().filter(paperCard -> CardRarity.Rare.equals((Object)paperCard.getRarity()) || CardRarity.MythicRare.equals((Object)paperCard.getRarity())).collect(Collectors.toList())).isEmpty()) {
                    ret.add(new Reward((PaperCard)Aggregates.random(rareCards)));
                    ret.add(new Reward((PaperCard)Aggregates.random(rareCards)));
                }
            }
            int val = (MyRandom.getRandom().nextInt(2) + 1) * 100 + MyRandom.getRandom().nextInt(101);
            ret.add(new Reward(val));
            ret.add(new Reward(Reward.Type.Life, 1));
        } else {
            if (this.data.rewards != null) {
                Deck enemyDeck = Current.latestDeck();
                CardPool deckNoBasicLands = enemyDeck.getMain().getFilteredPool(Predicates.compose(Predicates.not(CardRulesPredicates.Presets.IS_BASIC_LAND), PaperCard::getRules));
                for (RewardData rdata : this.data.rewards) {
                    ret.addAll(rdata.generate(false, enemyDeck == null ? null : deckNoBasicLands.toFlatList(), true));
                }
            }
            if (this.rewards != null) {
                for (RewardData rdata : this.rewards) {
                    ret.addAll(rdata.generate(false, Current.latestDeck() != null ? Current.latestDeck().getMain().toFlatList() : null, true));
                }
            }
        }
        return ret;
    }

    private void drawColorHints(Batch batch) {
        int size = Math.min(this.data.colors.length(), 6);
        float DX = this.getX() - 2.0f;
        float DY = this.getY();
        block8: for (int i = 0; i < size; ++i) {
            char C2 = this.data.colors.toUpperCase().charAt(i);
            switch (C2) {
                default: {
                    continue block8;
                }
                case 'C': {
                    batch.setColor(Color.DARK_GRAY);
                    batch.draw(Forge.getGraphics().getDummyTexture(), DX, DY, 2.0f, 2.0f);
                    DY += 2.0f;
                    continue block8;
                }
                case 'B': {
                    batch.setColor(Color.PURPLE);
                    batch.draw(Forge.getGraphics().getDummyTexture(), DX, DY, 2.0f, 2.0f);
                    DY += 2.0f;
                    continue block8;
                }
                case 'G': {
                    batch.setColor(Color.GREEN);
                    batch.draw(Forge.getGraphics().getDummyTexture(), DX, DY, 2.0f, 2.0f);
                    DY += 2.0f;
                    continue block8;
                }
                case 'R': {
                    batch.setColor(Color.RED);
                    batch.draw(Forge.getGraphics().getDummyTexture(), DX, DY, 2.0f, 2.0f);
                    DY += 2.0f;
                    continue block8;
                }
                case 'U': {
                    batch.setColor(Color.BLUE);
                    batch.draw(Forge.getGraphics().getDummyTexture(), DX, DY, 2.0f, 2.0f);
                    DY += 2.0f;
                    continue block8;
                }
                case 'W': {
                    batch.setColor(Color.WHITE);
                    batch.draw(Forge.getGraphics().getDummyTexture(), DX, DY, 2.0f, 2.0f);
                    DY += 2.0f;
                }
            }
        }
        batch.setColor(Color.WHITE);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        TextureRegion TR;
        Texture T;
        if (this.inactive || this.hidden) {
            return;
        }
        super.draw(batch, parentAlpha);
        if (Current.player().hasColorView() && !this.data.colors.isEmpty()) {
            this.drawColorHints(batch);
        }
        if (this.dialog != null && this.dialog.canShow()) {
            T = Current.world().getGlobalTexture();
            TR = new TextureRegion(T, 0, 0, 16, 16);
            batch.draw(TR, this.getX(), this.getY() + 16.0f, 16.0f, 16.0f);
        }
        if (this.effect != null) {
            T = Current.world().getGlobalTexture();
            TR = new TextureRegion(T, 16, 0, 16, 16);
            batch.draw(TR, this.getX(), this.getY() + 16.0f, 16.0f * this.getScaleX(), 16.0f * this.getScaleY());
        }
    }

    public float speed() {
        return Float.max(this.data.speed + this.speedModifier, 0.0f);
    }

    public float getLifetime() {
        float lifetime = 20.0f;
        return Math.max(this.data.lifetime, lifetime);
    }

    public void setNavPath(ProgressableGraphPath<NavigationVertex> navPath) {
        this.navPath = navPath;
    }

    public ProgressableGraphPath<NavigationVertex> getNavPath() {
        return this.navPath;
    }

    @Override
    public float getZeroLinearSpeedThreshold() {
        return 0.0f;
    }

    @Override
    public void setZeroLinearSpeedThreshold(float value) {
    }

    @Override
    public float getMaxLinearSpeed() {
        return 500.0f;
    }

    @Override
    public void setMaxLinearSpeed(float maxLinearSpeed) {
    }

    @Override
    public float getMaxLinearAcceleration() {
        return 5000.0f;
    }

    @Override
    public void setMaxLinearAcceleration(float maxLinearAcceleration) {
    }

    @Override
    public float getMaxAngularSpeed() {
        return 0.0f;
    }

    @Override
    public void setMaxAngularSpeed(float maxAngularSpeed) {
    }

    @Override
    public float getMaxAngularAcceleration() {
        return 0.0f;
    }

    @Override
    public void setMaxAngularAcceleration(float maxAngularAcceleration) {
    }

    public void steer(Vector2 currentVector) {
    }

    public boolean isFrozen() {
        return this._freeze;
    }
}

