/*
 * Decompiled with CFR 0.152.
 */
package forge;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.google.common.base.Function;
import forge.Forge;
import forge.Graphics;
import forge.ImageKeys;
import forge.adventure.stage.MapStage;
import forge.assets.FBufferedImage;
import forge.assets.FDelayLoadImage;
import forge.assets.FImage;
import forge.assets.FSkin;
import forge.assets.FTextureImage;
import forge.assets.ImageCache;
import forge.card.CardRenderer;
import forge.deck.Deck;
import forge.deck.FDeckViewer;
import forge.error.BugReportDialog;
import forge.gamemodes.match.HostedMatch;
import forge.gui.FThreads;
import forge.gui.download.GuiDownloadService;
import forge.gui.interfaces.IGuiBase;
import forge.gui.interfaces.IGuiGame;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.skin.FSkinProp;
import forge.localinstance.skin.ISkinImage;
import forge.screens.LoadingOverlay;
import forge.screens.match.MatchController;
import forge.screens.quest.QuestMenu;
import forge.screens.settings.GuiDownloader;
import forge.sound.AudioClip;
import forge.sound.AudioMusic;
import forge.sound.IAudioClip;
import forge.sound.IAudioMusic;
import forge.sound.SoundSystem;
import forge.toolbox.FOptionPane;
import forge.toolbox.GuiChoose;
import forge.util.Callback;
import forge.util.FileUtil;
import forge.util.ImageFetcher;
import forge.util.LibGDXImageFetcher;
import forge.util.Localizer;
import forge.util.ThreadUtil;
import forge.util.WaitCallback;
import forge.util.WaitRunnable;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class GuiMobile
implements IGuiBase {
    private final String assetsDir;
    private ImageFetcher imageFetcher = new LibGDXImageFetcher();
    private List<Integer> integerChoices = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);

    public GuiMobile(String assetsDir0) {
        this.assetsDir = assetsDir0;
    }

    @Override
    public boolean isRunningOnDesktop() {
        return Gdx.app == null ? true : Gdx.app.getType() == Application.ApplicationType.Desktop;
    }

    @Override
    public boolean isLibgdxPort() {
        return true;
    }

    @Override
    public String getCurrentVersion() {
        return "1.6.65-SNAPSHOT";
    }

    @Override
    public String getAssetsDir() {
        return this.assetsDir;
    }

    @Override
    public ImageFetcher getImageFetcher() {
        return this.imageFetcher;
    }

    @Override
    public void invokeInEdtNow(Runnable proc) {
        proc.run();
        Gdx.graphics.requestRendering();
    }

    @Override
    public void invokeInEdtLater(Runnable proc) {
        Gdx.app.postRunnable(proc);
    }

    @Override
    public void invokeInEdtAndWait(final Runnable proc) {
        if (this.isGuiThread()) {
            proc.run();
        } else {
            new WaitRunnable(){

                @Override
                public void run() {
                    proc.run();
                }
            }.invokeAndWait();
        }
    }

    @Override
    public boolean isGuiThread() {
        return !ThreadUtil.isGameThread();
    }

    @Override
    public ISkinImage getSkinIcon(FSkinProp skinProp) {
        if (skinProp == null) {
            return null;
        }
        return FSkin.getImages().get((Object)skinProp);
    }

    @Override
    public ISkinImage getUnskinnedIcon(String path) {
        if (this.isGuiThread()) {
            return new FTextureImage(Forge.getAssets().getTexture(Gdx.files.absolute(path)));
        }
        return new FDelayLoadImage(path);
    }

    @Override
    public ISkinImage getCardArt(PaperCard card) {
        return CardRenderer.getCardArt(card);
    }

    @Override
    public ISkinImage getCardArt(PaperCard card, boolean backFace) {
        return CardRenderer.getCardArt(card, backFace);
    }

    @Override
    public ISkinImage createLayeredImage(final PaperCard paperCard, final FSkinProp background, final String overlayFilename, float opacity) {
        return new FBufferedImage(background.getWidth(), background.getHeight(), opacity){

            @Override
            protected void draw(Graphics g2, float w, float h2) {
                Texture cardImage;
                g2.drawImage(FSkin.getImages().get((Object)background), 0.0f, 0.0f, (float)background.getWidth(), (float)background.getHeight());
                float cardImageWidth = 90.0f;
                float cardImageHeight = 128.0f;
                if (FileUtil.doesFileExist(overlayFilename)) {
                    try {
                        Texture overlay = Forge.getAssets().getTexture(Gdx.files.absolute(overlayFilename));
                        g2.drawImage(overlay, (float)((background.getWidth() - overlay.getWidth()) / 2), (float)((background.getHeight() - overlay.getHeight()) / 2), (float)overlay.getWidth(), (float)overlay.getHeight());
                    }
                    catch (Exception overlay) {}
                } else if (paperCard != null && (cardImage = ImageCache.getImage(paperCard.getCardImageKey(), false)) != null) {
                    g2.drawCardRoundRect(cardImage, null, ((float)background.getWidth() - 90.0f) / 2.0f, ((float)background.getHeight() - 128.0f) / 3.8f, 90.0f, 128.0f, false, false);
                }
                Gdx.graphics.requestRendering();
            }
        };
    }

    @Override
    public void showImageDialog(final ISkinImage image, final String message, final String title) {
        if (Forge.isMobileAdventureMode) {
            FThreads.invokeInEdtNowOrLater(() -> MapStage.getInstance().showImageDialog("Achievement Earned\n" + message, (FBufferedImage)image, null));
            return;
        }
        new WaitCallback<Integer>(){

            @Override
            public void run() {
                FOptionPane.showMessageDialog(message, title, (FImage)image, this);
            }
        }.invokeAndWait();
    }

    @Override
    public int showOptionDialog(final String message, final String title, final FSkinProp icon, final List<String> options, final int defaultOption) {
        return (Integer)new WaitCallback<Integer>(){

            @Override
            public void run() {
                FOptionPane.showOptionDialog(message, title, icon == null ? null : (FImage)FSkin.getImages().get((Object)icon), options, defaultOption, this);
            }
        }.invokeAndWait();
    }

    @Override
    public String showInputDialog(final String message, final String title, FSkinProp icon, final String initialInput, final List<String> inputOptions, final boolean isNumeric) {
        return (String)new WaitCallback<String>(){

            @Override
            public void run() {
                FOptionPane.showInputDialog(message, title, initialInput, inputOptions, this, isNumeric);
            }
        }.invokeAndWait();
    }

    @Override
    public <T> List<T> getChoices(final String message, final int min2, final int max, final Collection<T> choices, final T selected, final Function<T, String> display) {
        return (List)new WaitCallback<List<T>>(){

            @Override
            public void run() {
                GuiChoose.getChoices(message, min2, max, choices, selected, display, this);
            }
        }.invokeAndWait();
    }

    @Override
    public <T> List<T> order(final String title, final String top, final int remainingObjectsMin, final int remainingObjectsMax, final List<T> sourceChoices, final List<T> destChoices) {
        return (List)new WaitCallback<List<T>>(){

            @Override
            public void run() {
                GuiChoose.order(title, top, remainingObjectsMin, remainingObjectsMax, sourceChoices, destChoices, null, this);
            }
        }.invokeAndWait();
    }

    @Override
    public void showBugReportDialog(String title, String text, boolean showExitAppBtn) {
        BugReportDialog.show(title, text, showExitAppBtn);
    }

    @Override
    public void showCardList(String title, String message, List<PaperCard> list) {
        Deck deck = new Deck(title + " - " + message);
        deck.getMain().addAllFlat(list);
        FDeckViewer.show(deck, true);
    }

    @Override
    public boolean showBoxedProduct(String title, String message, List<PaperCard> list) {
        Deck deck = new Deck(title + " - " + message);
        deck.getMain().addAllFlat(list);
        FDeckViewer.show(deck);
        return false;
    }

    @Override
    public PaperCard chooseCard(final String title, final String message, final List<PaperCard> list) {
        return (PaperCard)new WaitCallback<PaperCard>(){

            @Override
            public void run() {
                GuiChoose.one(title + " - " + message, list, this);
            }
        }.invokeAndWait();
    }

    @Override
    public int getAvatarCount() {
        if (FSkin.isLoaded()) {
            return FSkin.getAvatars().size();
        }
        return 0;
    }

    @Override
    public int getSleevesCount() {
        if (FSkin.isLoaded()) {
            return FSkin.getSleeves().size();
        }
        return 0;
    }

    @Override
    public String showFileDialog(String title, String defaultDir) {
        List<Object> v = this.getChoices(title, 0, 1, this.integerChoices, null, null);
        if (v == null || v.isEmpty()) {
            return null;
        }
        return defaultDir + "state" + v.get(0) + ".txt";
    }

    @Override
    public File getSaveFile(File defaultFile) {
        List<Object> v = this.getChoices(Localizer.getInstance().getMessage("lblSelectGameStateFile", new Object[0]), 0, 1, this.integerChoices, null, null);
        if (v == null || v.isEmpty()) {
            return null;
        }
        return new File(ForgeConstants.USER_GAMES_DIR + "state" + v.get(0) + ".txt");
    }

    @Override
    public void download(GuiDownloadService service, Callback<Boolean> callback) {
        new GuiDownloader(service, callback).show();
    }

    @Override
    public void refreshSkin() {
    }

    @Override
    public void copyToClipboard(String text) {
        Forge.getClipboard().setContents(text);
    }

    @Override
    public void browseToUrl(String url) {
        Gdx.net.openURI(url);
    }

    @Override
    public IAudioClip createAudioClip(String filename) {
        return AudioClip.createClip(SoundSystem.instance.getSoundDirectory() + filename);
    }

    @Override
    public IAudioMusic createAudioMusic(String filename) {
        return new AudioMusic(filename);
    }

    @Override
    public void startAltSoundSystem(String filename, boolean isSynchronized) {
    }

    @Override
    public void clearImageCache() {
        ImageCache.clear();
        ImageKeys.clearMissingCards();
    }

    @Override
    public void showSpellShop() {
        QuestMenu.showSpellShop();
    }

    @Override
    public void showBazaar() {
        QuestMenu.showBazaar();
    }

    @Override
    public IGuiGame getNewGuiGame() {
        return MatchController.instance;
    }

    @Override
    public HostedMatch hostMatch() {
        return MatchController.hostMatch();
    }

    @Override
    public void runBackgroundTask(String message, Runnable task) {
        LoadingOverlay.runBackgroundTask(message, task);
    }

    @Override
    public String encodeSymbols(String str, boolean formatReminderText) {
        return str;
    }

    @Override
    public void preventSystemSleep(boolean preventSleep) {
        Forge.getDeviceAdapter().preventSystemSleep(preventSleep);
    }

    @Override
    public float getScreenScale() {
        return 1.0f;
    }
}

