/*
 * Decompiled with CFR 0.152.
 */
package forge;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;
import forge.Forge;
import forge.Shaders;
import forge.adventure.util.Config;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.ImageCache;
import forge.toolbox.FDisplayObject;
import forge.util.TextBounds;
import forge.util.Utils;
import java.util.ArrayDeque;
import java.util.Deque;

public class Graphics {
    private static final int GL_BLEND = 3042;
    private static final int GL_LINE_SMOOTH = 2848;
    private final SpriteBatch batch = new SpriteBatch();
    private final ShapeRenderer shapeRenderer = new ShapeRenderer();
    private final Deque<Matrix4> Dtransforms = new ArrayDeque<Matrix4>();
    private final Vector3 tmp = new Vector3();
    private float regionHeight;
    private Rectangle bounds;
    private Rectangle visibleBounds;
    private int failedClipCount;
    private float alphaComposite = 1.0f;
    private int transformCount = 0;
    private final ShaderProgram shaderOutline = new ShaderProgram(Gdx.files.internal("shaders").child("outline.vert"), Gdx.files.internal("shaders").child("outline.frag"));
    private final ShaderProgram shaderGrayscale = new ShaderProgram(Gdx.files.internal("shaders").child("grayscale.vert"), Gdx.files.internal("shaders").child("grayscale.frag"));
    private final ShaderProgram shaderWarp = new ShaderProgram(Gdx.files.internal("shaders").child("grayscale.vert"), Gdx.files.internal("shaders").child("warp.frag"));
    private final ShaderProgram shaderUnderwater = new ShaderProgram(Gdx.files.internal("shaders").child("grayscale.vert"), Gdx.files.internal("shaders").child("underwater.frag"));
    private final ShaderProgram shaderNightDay = new ShaderProgram(Shaders.vertexShaderDayNight, Shaders.fragmentShaderDayNight);
    private final ShaderProgram shaderPixelate = new ShaderProgram("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\n\nuniform mat4 u_projTrans;\n\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n    v_color = a_color;\n    v_texCoords = a_texCoord0;\n    gl_Position = u_projTrans * a_position;\n}", "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nuniform sampler2D u_texture;\nuniform float u_cellSize;\nuniform vec2 u_resolution;\nuniform float u_yflip;\nuniform float u_bias;\n\nvoid main() {\n\tvec2 p = floor(gl_FragCoord.xy/u_cellSize) * u_cellSize;\n\tvec2 p2 = p/u_resolution.xy;\n\tvec4 texColor;\n\tif (u_yflip > 0)\n\t    texColor = texture2D(u_texture, vec2(p2.x, 1.-p2.y));\n\telse\n\t    texColor = texture2D(u_texture, p2);\n\tgl_FragColor = mix(vec4(0.0, 0.0, 0.0, 1.0), texColor, u_bias);\n}");
    private final ShaderProgram shaderRipple = new ShaderProgram("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\n\nuniform mat4 u_projTrans;\n\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n    v_color = a_color;\n    v_texCoords = a_texCoord0;\n    gl_Position = u_projTrans * a_position;\n}", "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nuniform sampler2D u_texture;\nvarying vec2 v_texCoords;\nuniform float u_time;\nuniform float u_bias;\n\nvoid main() {\n    vec2 uv = v_texCoords;\n    float len = length(uv - vec2(.5)) * 50.;\n    vec2 s = normalize(uv) * ( sin((len - u_time * 10.))) * (.01 * u_time);\n    LOWP vec4 tex = texture2D(u_texture, uv + s);\n    gl_FragColor = mix(vec4(0.0, 0.0, 0.0, 1.0), tex, u_bias);\n}");
    private final ShaderProgram shaderPixelateWarp = new ShaderProgram("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\n\nuniform mat4 u_projTrans;\n\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n    v_color = a_color;\n    v_texCoords = a_texCoord0;\n    gl_Position = u_projTrans * a_position;\n}", "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\n\nuniform float u_time;\nuniform float u_speed;\nuniform float u_amount;\nuniform float u_cellSize;\nuniform vec2 u_resolution;\nuniform vec2 u_viewport;\nuniform vec2 u_position;\n\nfloat random2d(vec2 n) {\n    return fract(sin(dot(n, vec2(12.9898, 4.1414))) * 43758.5453);\n}\n\nfloat randomRange (in vec2 seed, in float min, in float max) {\n    return min + random2d(seed) * (max - min);\n}\n\nfloat insideRange(float v, float bottom, float top) {\n   return step(bottom, v) - step(top, v);\n}\n\nvoid main()\n{\n    float time = floor(u_time * u_speed * 60.0);\n\n    vec3 outCol = texture2D(u_texture, v_texCoords).rgb;\n\n    float maxOffset = u_amount/2.0;\n    for (float i = 0.0; i < 2.0; i += 1.0) {\n        float sliceY = random2d(vec2(time, 2345.0 + float(i)));\n        float sliceH = random2d(vec2(time, 9035.0 + float(i))) * 0.25;\n        float hOffset = randomRange(vec2(time, 9625.0 + float(i)), -maxOffset, maxOffset);\n        vec2 uvOff = v_texCoords;\n        uvOff.x += hOffset;\n        if (insideRange(v_texCoords.y, sliceY, fract(sliceY+sliceH)) == 1.0){\n            outCol = texture2D(u_texture, uvOff).rgb;\n        }\n    }\n\n    float maxColOffset = u_amount / 6.0;\n    float rnd = random2d(vec2(time , 9545.0));\n    vec2 colOffset = vec2(randomRange(vec2(time , 9545.0), -maxColOffset, maxColOffset),\n                       randomRange(vec2(time , 7205.0), -maxColOffset, maxColOffset));\n    if (rnd < 0.33) {\n        outCol.r = texture2D(u_texture, v_texCoords + colOffset).r;\n    } else if (rnd < 0.66) {\n        outCol.g = texture2D(u_texture, v_texCoords + colOffset).g;\n    } else {\n        outCol.b = texture2D(u_texture, v_texCoords + colOffset).b;\n    }\n\n\tvec2 p = floor(gl_FragCoord.xy/u_cellSize) * u_cellSize;\n\tvec4 texColor = texture2D(u_texture, p/u_resolution.xy);\n    gl_FragColor = mix(vec4(outCol, 1.0), texColor, 0.6);\n}");
    private final ShaderProgram shaderChromaticAbberation = new ShaderProgram("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\n\nuniform mat4 u_projTrans;\n\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n    v_color = a_color;\n    v_texCoords = a_texCoord0;\n    gl_Position = u_projTrans * a_position;\n}", "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nuniform float u_time;\n\nvoid main() {\n\tvec2 uv = v_texCoords;\n\tfloat amount = 0.0;\n\tamount = (1.0 + sin(u_time*6.0)) * 0.5;\n\tamount *= 1.0 + sin(u_time*16.0) * 0.5;\n\tamount *= 1.0 + sin(u_time*19.0) * 0.5;\n\tamount *= 1.0 + sin(u_time*27.0) * 0.5;\n\tamount = pow(amount, 3.0);\n\tamount *= 0.05;\n    vec3 col;\n    col.r = texture2D(u_texture, vec2(uv.x+amount,uv.y)).r;\n    col.g = texture2D(u_texture, uv ).g;\n    col.b = texture2D(u_texture, vec2(uv.x-amount,uv.y)).b;\n\tcol *= (1.0 - amount * 0.5);\n    gl_FragColor = vec4(col,1.0);\n}");
    private final ShaderProgram shaderHueShift = new ShaderProgram("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\n\nuniform mat4 u_projTrans;\n\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n    v_color = a_color;\n    v_texCoords = a_texCoord0;\n    gl_Position = u_projTrans * a_position;\n}", "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nuniform float u_time;\n\nvec3 hs(vec3 c, float s) {\n    vec3 m=vec3(cos(s),s=sin(s)*.5774,-s);\n    return c*mat3(m+=(1.-m.x)/3.,m.zxy,m.yzx);\n}\n\nvoid main() {\n\tvec2 uv = v_texCoords;\n    vec4 orig = texture2D(u_texture, uv);\n    vec3 col = texture2D(u_texture, uv).rgb;\n    vec4 col2 = vec4(hs(col, u_time), 1.);\n    //multiply the original texture alpha to render only opaque shifted colors \n    col2.a *= orig.a;\n    gl_FragColor = col2;\n}");
    private final ShaderProgram shaderRoundedRect = new ShaderProgram("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\n\nuniform mat4 u_projTrans;\n\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n    v_color = a_color;\n    v_texCoords = a_texCoord0;\n    gl_Position = u_projTrans * a_position;\n}", "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nuniform vec2 u_resolution;\nuniform float edge_radius;\nuniform float u_gray;\nLOWP vec4 color = vec4(1.0,1.0,1.0,1.0);\nfloat gradientIntensity = 0.5;\n\nvoid main() {\n    vec2 uv = v_texCoords;\n    vec2 uv_base_center = uv * 2.0 - 1.0;\n\n    vec2 half_resolution = u_resolution.xy * 0.5;\n    vec2 abs_rounded_center = half_resolution.xy - edge_radius;\n    vec2 abs_pixel_coord = vec2( abs(uv_base_center.x * half_resolution.x), abs(uv_base_center.y * half_resolution.y) );\n\n    float alpha = 1.0;\n    LOWP vec4 col = color * texture2D(u_texture, uv);\n    if (abs_pixel_coord.x > abs_rounded_center.x && abs_pixel_coord.y > abs_rounded_center.y) {\n         float r = length(abs_pixel_coord - abs_rounded_center);\n         alpha = smoothstep(edge_radius, edge_radius - gradientIntensity, r);\n         \n    }\n    if (u_gray > 0.0) {\n        LOWP float grey = dot( col.rgb, vec3(0.22, 0.707, 0.071) );\n        LOWP vec3 blendedColor = mix(col.rgb, vec3(grey), 1.0);\n        col = vec4(blendedColor.rgb, col.a);\n    }\n    gl_FragColor = col*alpha;\n}");
    private final ShaderProgram shaderNoiseFade = new ShaderProgram("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\n\nuniform mat4 u_projTrans;\n\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n    v_color = a_color;\n    v_texCoords = a_texCoord0;\n    gl_Position = u_projTrans * a_position;\n}", "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nuniform sampler2D u_texture;\nvarying vec2 v_texCoords;\nuniform float u_time;\n\nvoid main()\n{\n\tvec2 uv = v_texCoords;\n    LOWP vec4 orig = texture2D(u_texture, uv);\n    float th = u_time;\n    \n    float tex = ((orig.r -.5) + 2. * uv.x ) / 3.;\n    float mask = smoothstep( th - .1, th, tex);\n    float dist = smoothstep( th - .3, th + .05, tex);\n    float col = pow( smoothstep( th - .2, th + .15, tex), 3.);\n    \n    LOWP vec3 color = vec4(orig.rgb, uv * (.7 + pow(dist, 2.) * .3 )).rgb;\n    LOWP vec3 discolor = color * vec3( 0.5, 0.4, 0.3 );\n    \n\tgl_FragColor = vec4( mix(discolor, color, col) * mask, 1.0);\n}");
    private final ShaderProgram shaderPortal = new ShaderProgram("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\n\nuniform mat4 u_projTrans;\n\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n    v_color = a_color;\n    v_texCoords = a_texCoord0;\n    gl_Position = u_projTrans * a_position;\n}", "#ifdef GL_ES\n#define LOWP lowp\n#define PI 3.14159\nprecision mediump float;\n#else\n#define LOWP \n#define PI 3.14159\n#endif\n\nuniform sampler2D u_texture;\nvarying vec2 v_texCoords;\nuniform vec2 u_resolution;\nuniform float u_time;\nuniform float u_opaque;\n\nvoid main()\n{\n    vec2 uv = v_texCoords;\n    \n    float t1 = u_time;\n    if (t1>1.25)\n        t1=0.0;\n    t1 = clamp(t1,0.0,1.0);\n    float nt = fract(t1);\n\n    float eRad = 1.5 * nt;\n    float eAng = (2. * PI) * (nt*4.5);\n\n    vec2 centre = vec2(.5,.5);\n    uv -= centre;\n    float len = length(uv * vec2(u_resolution.x / u_resolution.y, 1.));\n    float ang = atan(uv.y, uv.x) + eAng * smoothstep(eRad, 0., len);\n    float rad = length(uv);\n    \n    vec3 col1 = texture2D(u_texture, vec2(rad * cos(ang), rad * sin(ang)) + centre ).xyz;    \n    float nt2 = (len*2.0) - (nt*2.0);\n    nt2 = mix(1.0,nt2-nt,nt);\n    nt2 = clamp(nt2,0.0,1.0);\n   \tvec3 col2 = texture2D(u_texture,uv+ centre).xyz;  \n    col2 = vec3(0.0);\n    \n    vec4 col3 =  vec4(mix(col2,col1,nt2), 1.);\n    if (u_opaque < 1.)        col3.a *= nt2;\n    gl_FragColor = col3;\n}");
    private final ShaderProgram shaderPixelateSimple = new ShaderProgram("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\n\nuniform mat4 u_projTrans;\n\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n    v_color = a_color;\n    v_texCoords = a_texCoord0;\n    gl_Position = u_projTrans * a_position;\n}", "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\n\nuniform sampler2D u_texture;\nvarying vec2 v_texCoords;\nuniform vec2 u_resolution;\nuniform float u_time;\nuniform float u_cellSize;\n\nvoid main()\n{\n    float t = u_time;\n    \n\tvec2 uv = v_texCoords;\n    \n    float res = floor((pow(t,1.4)) * u_cellSize) * 2.0 + 0.01;\n    \n    uv *= u_resolution.xy / res;\n    uv = floor(uv);\n    uv /= u_resolution.xy / res;\n    \n    uv += res * 0.002;\n    vec4 texColor = texture2D(u_texture, uv);\n    //texColor.g *= (1.-t);\n    //texColor.b *= (1.-t);\n\tgl_FragColor = texColor * clamp(1.4 - t, 1.0, 1.0);\n}");
    private Texture dummyTexture = null;

    public Graphics() {
        ShaderProgram.pedantic = false;
    }

    public ShaderProgram getShaderOutline() {
        return this.shaderOutline;
    }

    public ShaderProgram getShaderGrayscale() {
        return this.shaderGrayscale;
    }

    public ShaderProgram getShaderRoundedRect() {
        return this.shaderRoundedRect;
    }

    public ShaderProgram getShaderWarp() {
        return this.shaderWarp;
    }

    public ShaderProgram getShaderUnderwater() {
        return this.shaderUnderwater;
    }

    public ShaderProgram getShaderNightDay() {
        return this.shaderNightDay;
    }

    public void begin(float regionWidth0, float regionHeight0) {
        this.batch.begin();
        this.bounds = new Rectangle(0.0f, 0.0f, regionWidth0, regionHeight0);
        this.regionHeight = regionHeight0;
        this.visibleBounds = new Rectangle(this.bounds);
    }

    public void end() {
        if (this.batch.isDrawing()) {
            this.batch.end();
        }
        if (this.shapeRenderer.getCurrentType() != null) {
            this.shapeRenderer.end();
        }
    }

    public void dispose() {
        this.batch.dispose();
        this.shapeRenderer.dispose();
        this.shaderOutline.dispose();
        this.shaderGrayscale.dispose();
        this.shaderUnderwater.dispose();
        this.shaderWarp.dispose();
        if (this.dummyTexture != null) {
            this.dummyTexture.dispose();
        }
    }

    public SpriteBatch getBatch() {
        return this.batch;
    }

    public boolean startClip() {
        return this.startClip(0.0f, 0.0f, this.bounds.width, this.bounds.height);
    }

    public boolean startClip(float x, float y, float w, float h2) {
        this.batch.flush();
        Rectangle clip = new Rectangle(this.adjustX(x), this.adjustY(y, h2), w, h2);
        if (!this.Dtransforms.isEmpty()) {
            float minY;
            float minX;
            this.tmp.set(clip.x, clip.y, 0.0f);
            this.tmp.mul(this.batch.getTransformMatrix());
            float maxX = minX = this.tmp.x;
            float maxY = minY = this.tmp.y;
            this.tmp.set(clip.x + clip.width, clip.y, 0.0f);
            this.tmp.mul(this.batch.getTransformMatrix());
            if (this.tmp.x < minX) {
                minX = this.tmp.x;
            } else if (this.tmp.x > maxX) {
                maxX = this.tmp.x;
            }
            if (this.tmp.y < minY) {
                minY = this.tmp.y;
            } else if (this.tmp.y > maxY) {
                maxY = this.tmp.y;
            }
            this.tmp.set(clip.x + clip.width, clip.y + clip.height, 0.0f);
            this.tmp.mul(this.batch.getTransformMatrix());
            if (this.tmp.x < minX) {
                minX = this.tmp.x;
            } else if (this.tmp.x > maxX) {
                maxX = this.tmp.x;
            }
            if (this.tmp.y < minY) {
                minY = this.tmp.y;
            } else if (this.tmp.y > maxY) {
                maxY = this.tmp.y;
            }
            this.tmp.set(clip.x, clip.y + clip.height, 0.0f);
            this.tmp.mul(this.batch.getTransformMatrix());
            if (this.tmp.x < minX) {
                minX = this.tmp.x;
            } else if (this.tmp.x > maxX) {
                maxX = this.tmp.x;
            }
            if (this.tmp.y < minY) {
                minY = this.tmp.y;
            } else if (this.tmp.y > maxY) {
                maxY = this.tmp.y;
            }
            clip.set(minX, minY, maxX - minX, maxY - minY);
        }
        if (!ScissorStack.pushScissors(clip)) {
            ++this.failedClipCount;
            return false;
        }
        return true;
    }

    public void endClip() {
        if (this.failedClipCount == 0) {
            this.batch.flush();
            ScissorStack.popScissors();
        } else {
            --this.failedClipCount;
        }
    }

    public void draw(FDisplayObject displayObj) {
        if (displayObj.getWidth() <= 0.0f || displayObj.getHeight() <= 0.0f) {
            return;
        }
        Rectangle parentBounds = this.bounds;
        this.bounds = new Rectangle(parentBounds.x + displayObj.getLeft(), parentBounds.y + displayObj.getTop(), displayObj.getWidth(), displayObj.getHeight());
        if (!this.Dtransforms.isEmpty()) {
            this.updateScreenPosForRotation(displayObj);
        } else {
            displayObj.screenPos.set(this.bounds);
        }
        Rectangle intersection = Utils.getIntersection(this.bounds, this.visibleBounds);
        if (intersection != null) {
            Rectangle backup = this.visibleBounds;
            this.visibleBounds = intersection;
            if (displayObj.getRotate90()) {
                this.startRotateTransform(displayObj.getWidth(), 0.0f, -90.0f);
                this.updateScreenPosForRotation(displayObj);
            } else if (displayObj.getRotate180()) {
                this.startRotateTransform(displayObj.getWidth() / 2.0f, displayObj.getHeight() / 2.0f, 180.0f);
            }
            displayObj.draw(this);
            if (displayObj.getRotate90() || displayObj.getRotate180()) {
                this.endTransform();
            }
            this.visibleBounds = backup;
        }
        this.bounds = parentBounds;
    }

    private void updateScreenPosForRotation(FDisplayObject displayObj) {
        float minY;
        float minX;
        this.tmp.set(this.bounds.x, this.regionHeight - this.bounds.y, 0.0f);
        this.tmp.mul(this.batch.getTransformMatrix());
        this.tmp.y = this.regionHeight - this.tmp.y;
        float maxX = minX = this.tmp.x;
        float maxY = minY = this.tmp.y;
        this.tmp.set(this.bounds.x + this.bounds.width, this.regionHeight - this.bounds.y, 0.0f);
        this.tmp.mul(this.batch.getTransformMatrix());
        this.tmp.y = this.regionHeight - this.tmp.y;
        if (this.tmp.x < minX) {
            minX = this.tmp.x;
        } else if (this.tmp.x > maxX) {
            maxX = this.tmp.x;
        }
        if (this.tmp.y < minY) {
            minY = this.tmp.y;
        } else if (this.tmp.y > maxY) {
            maxY = this.tmp.y;
        }
        this.tmp.set(this.bounds.x + this.bounds.width, this.regionHeight - this.bounds.y - this.bounds.height, 0.0f);
        this.tmp.mul(this.batch.getTransformMatrix());
        this.tmp.y = this.regionHeight - this.tmp.y;
        if (this.tmp.x < minX) {
            minX = this.tmp.x;
        } else if (this.tmp.x > maxX) {
            maxX = this.tmp.x;
        }
        if (this.tmp.y < minY) {
            minY = this.tmp.y;
        } else if (this.tmp.y > maxY) {
            maxY = this.tmp.y;
        }
        this.tmp.set(this.bounds.x, this.regionHeight - this.bounds.y - this.bounds.height, 0.0f);
        this.tmp.mul(this.batch.getTransformMatrix());
        this.tmp.y = this.regionHeight - this.tmp.y;
        if (this.tmp.x < minX) {
            minX = this.tmp.x;
        } else if (this.tmp.x > maxX) {
            maxX = this.tmp.x;
        }
        if (this.tmp.y < minY) {
            minY = this.tmp.y;
        } else if (this.tmp.y > maxY) {
            maxY = this.tmp.y;
        }
        displayObj.screenPos.set(minX, minY, maxX - minX, maxY - minY);
    }

    public void drawLine(float thickness, FSkinColor skinColor, float x1, float y1, float x2, float y2) {
        this.drawLine(thickness, skinColor.getColor(), x1, y1, x2, y2);
    }

    public void drawLine(float thickness, Color color, float x1, float y1, float x2, float y2) {
        boolean needSmoothing;
        this.batch.end();
        if (thickness > 1.0f) {
            Gdx.gl.glLineWidth(thickness);
        }
        if (this.alphaComposite < 1.0f) {
            color = FSkinColor.alphaColor(color, color.a * this.alphaComposite);
        }
        boolean bl = needSmoothing = x1 != x2 && y1 != y2;
        if (color.a < 1.0f || needSmoothing) {
            Gdx.gl.glEnable(3042);
        }
        if (needSmoothing) {
            Gdx.gl.glEnable(2848);
        }
        this.startShape(ShapeRenderer.ShapeType.Line);
        this.shapeRenderer.setColor(color);
        this.shapeRenderer.line(this.adjustX(x1), this.adjustY(y1, 0.0f), this.adjustX(x2), this.adjustY(y2, 0.0f));
        this.endShape();
        if (needSmoothing) {
            Gdx.gl.glDisable(2848);
        }
        if (color.a < 1.0f || needSmoothing) {
            Gdx.gl.glDisable(3042);
        }
        if (thickness > 1.0f) {
            Gdx.gl.glLineWidth(1.0f);
        }
        this.batch.begin();
    }

    public void drawLineArrow(float arrowThickness, FSkinColor skinColor, float x1, float y1, float x2, float y2) {
        this.fillCircle(skinColor.getColor(), x2, y2, arrowThickness);
        this.drawLineArrow(arrowThickness, skinColor.getColor(), x1, y1, x2, y2);
        this.fillCircle(Color.WHITE, x2, y2, arrowThickness / 2.0f);
        this.drawLine(arrowThickness / 3.0f, Color.WHITE, x1, y1, x2, y2);
    }

    public void drawLineArrow(float thickness, Color color, float x1, float y1, float x2, float y2) {
        boolean needSmoothing;
        this.batch.end();
        float angle = new Vector2(x1 - x2, y1 - y2).angleRad();
        float arrowHeadRotation = 2.5132742f;
        Vector2 arrowCorner3 = new Vector2(x2 + thickness / 3.0f * (float)Math.cos(angle + arrowHeadRotation), y2 + thickness / 3.0f * (float)Math.sin(angle + arrowHeadRotation));
        Vector2 arrowCorner4 = new Vector2(x2 + thickness / 3.0f * (float)Math.cos(angle - arrowHeadRotation), y2 + thickness / 3.0f * (float)Math.sin(angle - arrowHeadRotation));
        if (thickness > 1.0f) {
            Gdx.gl.glLineWidth(thickness);
        }
        if (this.alphaComposite < 1.0f) {
            color = FSkinColor.alphaColor(color, color.a * this.alphaComposite);
        }
        boolean bl = needSmoothing = x1 != x2 && y1 != y2;
        if (color.a < 1.0f || needSmoothing) {
            Gdx.gl.glEnable(3042);
        }
        if (needSmoothing) {
            Gdx.gl.glEnable(2848);
        }
        this.startShape(ShapeRenderer.ShapeType.Line);
        this.shapeRenderer.setColor(color);
        this.shapeRenderer.line(this.adjustX(x1), this.adjustY(y1, 0.0f), this.adjustX(x2), this.adjustY(y2, 0.0f));
        this.endShape();
        if (needSmoothing) {
            Gdx.gl.glDisable(2848);
        }
        if (color.a < 1.0f || needSmoothing) {
            Gdx.gl.glDisable(3042);
        }
        if (thickness > 1.0f) {
            Gdx.gl.glLineWidth(1.0f);
        }
        this.batch.begin();
    }

    public void drawArrow(float borderThickness, float arrowThickness, float arrowSize, FSkinColor skinColor, float x1, float y1, float x2, float y2) {
        this.drawArrow(borderThickness, arrowThickness, arrowSize, skinColor.getColor(), x1, y1, x2, y2);
    }

    public void drawArrow(float borderThickness, float arrowThickness, float arrowSize, Color color, float x1, float y1, float x2, float y2) {
        this.batch.end();
        if (this.alphaComposite < 1.0f) {
            color = FSkinColor.alphaColor(color, color.a * this.alphaComposite);
        }
        Gdx.gl.glEnable(3042);
        Gdx.gl.glEnable(2848);
        float angle = new Vector2(x2 - x1, y2 - y1).angleRad();
        float perpRotation = 1.5707964f;
        float arrowHeadRotation = 2.5132742f;
        float arrowTipAngle = (float)(Math.PI - (double)arrowHeadRotation);
        float halfThickness = arrowThickness / 2.0f;
        int index = 0;
        float[] vertices = new float[14];
        Vector2 arrowCorner1 = new Vector2(x2 + arrowSize * (float)Math.cos(angle + arrowHeadRotation), y2 + arrowSize * (float)Math.sin(angle + arrowHeadRotation));
        Vector2 arrowCorner2 = new Vector2(x2 + arrowSize * (float)Math.cos(angle - arrowHeadRotation), y2 + arrowSize * (float)Math.sin(angle - arrowHeadRotation));
        float arrowCornerLen = (arrowCorner1.dst(arrowCorner2) - arrowThickness) / 2.0f;
        float arrowHeadLen = arrowSize * (float)Math.cos(arrowTipAngle);
        index = this.addVertex(arrowCorner1.x, arrowCorner1.y, vertices, index);
        index = this.addVertex(x2, y2, vertices, index);
        index = this.addVertex(arrowCorner2.x, arrowCorner2.y, vertices, index);
        index = this.addVertex(arrowCorner2.x + arrowCornerLen * (float)Math.cos(angle + perpRotation), arrowCorner2.y + arrowCornerLen * (float)Math.sin(angle + perpRotation), vertices, index);
        index = this.addVertex(x1 + halfThickness * (float)Math.cos(angle - perpRotation), y1 + halfThickness * (float)Math.sin(angle - perpRotation), vertices, index);
        index = this.addVertex(x1 + halfThickness * (float)Math.cos(angle + perpRotation), y1 + halfThickness * (float)Math.sin(angle + perpRotation), vertices, index);
        index = this.addVertex(arrowCorner1.x + arrowCornerLen * (float)Math.cos(angle - perpRotation), arrowCorner1.y + arrowCornerLen * (float)Math.sin(angle - perpRotation), vertices, index);
        this.startShape(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setColor(color);
        this.shapeRenderer.rectLine(this.adjustX(x1), this.adjustY(y1, 0.0f), this.adjustX(x2 - arrowHeadLen * (float)Math.cos(angle)), this.adjustY(y2 - arrowHeadLen * (float)Math.sin(angle), 0.0f), arrowThickness);
        this.shapeRenderer.triangle(vertices[0], vertices[1], vertices[2], vertices[3], vertices[4], vertices[5]);
        this.endShape();
        if (borderThickness > 1.0f) {
            Gdx.gl.glLineWidth(borderThickness);
        }
        this.startShape(ShapeRenderer.ShapeType.Line);
        this.shapeRenderer.setColor(Color.BLACK);
        this.shapeRenderer.polygon(vertices);
        this.endShape();
        if (borderThickness > 1.0f) {
            Gdx.gl.glLineWidth(1.0f);
        }
        Gdx.gl.glDisable(2848);
        Gdx.gl.glDisable(3042);
        this.batch.begin();
    }

    private int addVertex(float x, float y, float[] vertices, int index) {
        vertices[index] = this.adjustX(x);
        vertices[index + 1] = this.adjustY(y, 0.0f);
        return index + 2;
    }

    public void drawfillBorder(float thickness, Color color, float x, float y, float w, float h2, float cornerRadius) {
        this.drawRoundRect(thickness, color, x, y, w, h2, cornerRadius);
        this.fillRoundRect(color, x, y, w, h2, cornerRadius);
    }

    public void drawRoundRect(float thickness, FSkinColor skinColor, float x, float y, float w, float h2, float cornerRadius) {
        this.drawRoundRect(thickness, skinColor.getColor(), x, y, w, h2, cornerRadius);
    }

    public void drawRoundRect(float thickness, Color color, float x, float y, float w, float h2, float cornerRadius) {
        this.batch.end();
        if (thickness > 1.0f) {
            Gdx.gl.glLineWidth(thickness);
        }
        if (this.alphaComposite < 1.0f) {
            color = FSkinColor.alphaColor(color, color.a * this.alphaComposite);
        }
        if (color.a < 1.0f || cornerRadius > 0.0f) {
            Gdx.gl.glEnable(3042);
        }
        if (cornerRadius > 0.0f) {
            Gdx.gl.glEnable(2848);
        }
        w = Math.round(w + 1.0f);
        h2 = Math.round(h2 + 1.0f);
        this.startShape(ShapeRenderer.ShapeType.Line);
        this.shapeRenderer.setColor(color);
        this.shapeRenderer.arc(this.adjustX(x) + cornerRadius, this.adjustY(y + cornerRadius, 0.0f), cornerRadius, 90.0f, 90.0f);
        this.shapeRenderer.arc(this.adjustX(x) + w - cornerRadius, this.adjustY(y + cornerRadius, 0.0f), cornerRadius, 0.0f, 90.0f);
        this.shapeRenderer.arc(this.adjustX(x) + w - cornerRadius, this.adjustY(y + h2 - cornerRadius, 0.0f), cornerRadius, 270.0f, 90.0f);
        this.shapeRenderer.arc(this.adjustX(x) + cornerRadius, this.adjustY(y + h2 - cornerRadius, 0.0f), cornerRadius, 180.0f, 90.0f);
        this.shapeRenderer.rect(this.adjustX(x), this.adjustY(y + cornerRadius, h2 - cornerRadius * 2.0f), w, h2 - cornerRadius * 2.0f);
        this.shapeRenderer.rect(this.adjustX(x + cornerRadius), this.adjustY(y, h2), w - cornerRadius * 2.0f, h2);
        this.endShape();
        if (cornerRadius > 0.0f) {
            Gdx.gl.glDisable(2848);
        }
        if (color.a < 1.0f || cornerRadius > 0.0f) {
            Gdx.gl.glDisable(3042);
        }
        if (thickness > 1.0f) {
            Gdx.gl.glLineWidth(1.0f);
        }
        this.batch.begin();
    }

    public void fillRoundRect(FSkinColor skinColor, float x, float y, float w, float h2, float cornerRadius) {
        this.fillRoundRect(skinColor.getColor(), x, y, w, h2, cornerRadius);
    }

    public void fillRoundRect(Color color, float x, float y, float w, float h2, float cornerRadius) {
        this.batch.end();
        if (this.alphaComposite < 1.0f) {
            color = FSkinColor.alphaColor(color, color.a * this.alphaComposite);
        }
        if (color.a < 1.0f) {
            Gdx.gl.glEnable(3042);
        }
        this.startShape(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setColor(color);
        this.shapeRenderer.arc(this.adjustX(x) + cornerRadius, this.adjustY(y + cornerRadius, 0.0f), cornerRadius, 90.0f, 90.0f);
        this.shapeRenderer.arc(this.adjustX(x) + w - cornerRadius, this.adjustY(y + cornerRadius, 0.0f), cornerRadius, 0.0f, 90.0f);
        this.shapeRenderer.arc(this.adjustX(x) + w - cornerRadius, this.adjustY(y + h2 - cornerRadius, 0.0f), cornerRadius, 270.0f, 90.0f);
        this.shapeRenderer.arc(this.adjustX(x) + cornerRadius, this.adjustY(y + h2 - cornerRadius, 0.0f), cornerRadius, 180.0f, 90.0f);
        this.shapeRenderer.rect(this.adjustX(x), this.adjustY(y + cornerRadius, h2 - cornerRadius * 2.0f), w, h2 - cornerRadius * 2.0f);
        this.shapeRenderer.rect(this.adjustX(x + cornerRadius), this.adjustY(y, h2), w - cornerRadius * 2.0f, h2);
        this.endShape();
        if (color.a < 1.0f) {
            Gdx.gl.glDisable(3042);
        }
        this.batch.begin();
    }

    public void drawRect(float thickness, FSkinColor skinColor, float x, float y, float w, float h2) {
        this.drawRect(thickness, skinColor.getColor(), x, y, w, h2);
    }

    public void drawRect(float thickness, Color color, float x, float y, float w, float h2) {
        this.batch.end();
        if (thickness > 1.0f) {
            Gdx.gl.glLineWidth(thickness);
        }
        if (this.alphaComposite < 1.0f) {
            color = FSkinColor.alphaColor(color, color.a * this.alphaComposite);
        }
        Gdx.gl.glEnable(3042);
        Gdx.gl.glEnable(2848);
        this.startShape(ShapeRenderer.ShapeType.Line);
        this.shapeRenderer.setColor(color);
        this.shapeRenderer.rect(this.adjustX(x), this.adjustY(y, h2), w, h2);
        this.endShape();
        Gdx.gl.glDisable(2848);
        Gdx.gl.glDisable(3042);
        if (thickness > 1.0f) {
            Gdx.gl.glLineWidth(1.0f);
        }
        this.batch.begin();
    }

    public void drawRectLines(float thickness, Color color, float x, float y, float w, float h2) {
        this.drawLine(thickness, color, x, y, x + w, y);
        this.drawLine(thickness, color, x + thickness / 2.0f, y + thickness / 2.0f, x + thickness / 2.0f, y + h2 - thickness / 2.0f);
        this.drawLine(thickness, color, x, y + h2, x + w, y + h2);
        this.drawLine(thickness, color, x + w - thickness / 2.0f, y + thickness / 2.0f, x + w - thickness / 2.0f, y + h2 - thickness / 2.0f);
    }

    public void fillRect(FSkinColor skinColor, float x, float y, float w, float h2) {
        this.fillRect(skinColor.getColor(), x, y, w, h2);
    }

    public void fillRect(Color color, float x, float y, float w, float h2) {
        this.batch.end();
        if (this.alphaComposite < 1.0f) {
            color = FSkinColor.alphaColor(color, color.a * this.alphaComposite);
        }
        if (color.a < 1.0f) {
            Gdx.gl.glEnable(3042);
        }
        this.startShape(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setColor(color);
        this.shapeRenderer.rect(this.adjustX(x), this.adjustY(y, h2), w, h2);
        this.endShape();
        if (color.a < 1.0f) {
            Gdx.gl.glDisable(3042);
        }
        this.batch.begin();
    }

    public void drawCircle(float thickness, FSkinColor skinColor, float x, float y, float radius) {
        this.drawCircle(thickness, skinColor.getColor(), x, y, radius);
    }

    public void drawCircle(float thickness, Color color, float x, float y, float radius) {
        this.batch.end();
        if (thickness > 1.0f) {
            Gdx.gl.glLineWidth(thickness);
        }
        if (this.alphaComposite < 1.0f) {
            color = FSkinColor.alphaColor(color, color.a * this.alphaComposite);
        }
        Gdx.gl.glEnable(3042);
        Gdx.gl.glEnable(2848);
        this.startShape(ShapeRenderer.ShapeType.Line);
        this.shapeRenderer.setColor(color);
        this.shapeRenderer.circle(this.adjustX(x), this.adjustY(y, 0.0f), radius);
        this.endShape();
        Gdx.gl.glDisable(2848);
        Gdx.gl.glDisable(3042);
        if (thickness > 1.0f) {
            Gdx.gl.glLineWidth(1.0f);
        }
        this.batch.begin();
    }

    public void fillCircle(FSkinColor skinColor, float x, float y, float radius) {
        this.fillCircle(skinColor.getColor(), x, y, radius);
    }

    public void fillCircle(Color color, float x, float y, float radius) {
        this.batch.end();
        if (this.alphaComposite < 1.0f) {
            color = FSkinColor.alphaColor(color, color.a * this.alphaComposite);
        }
        if (color.a < 1.0f) {
            Gdx.gl.glEnable(3042);
        }
        this.startShape(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setColor(color);
        this.shapeRenderer.circle(this.adjustX(x), this.adjustY(y, 0.0f), radius);
        this.endShape();
        if (color.a < 1.0f) {
            Gdx.gl.glDisable(3042);
        }
        this.batch.begin();
    }

    public void fillTriangle(FSkinColor skinColor, float x1, float y1, float x2, float y2, float x3, float y3) {
        this.fillTriangle(skinColor.getColor(), x1, y1, x2, y2, x3, y3);
    }

    public void fillTriangle(Color color, float x1, float y1, float x2, float y2, float x3, float y3) {
        this.batch.end();
        if (this.alphaComposite < 1.0f) {
            color = FSkinColor.alphaColor(color, color.a * this.alphaComposite);
        }
        if (color.a < 1.0f) {
            Gdx.gl.glEnable(3042);
        }
        this.startShape(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setColor(color);
        this.shapeRenderer.triangle(this.adjustX(x1), this.adjustY(y1, 0.0f), this.adjustX(x2), this.adjustY(y2, 0.0f), this.adjustX(x3), this.adjustY(y3, 0.0f));
        this.endShape();
        if (color.a < 1.0f) {
            Gdx.gl.glDisable(3042);
        }
        this.batch.begin();
    }

    public void fillGradientRect(FSkinColor skinColor1, FSkinColor skinColor2, boolean vertical, float x, float y, float w, float h2) {
        this.fillGradientRect(skinColor1.getColor(), skinColor2.getColor(), vertical, x, y, w, h2);
    }

    public void fillGradientRect(FSkinColor skinColor1, Color color2, boolean vertical, float x, float y, float w, float h2) {
        this.fillGradientRect(skinColor1.getColor(), color2, vertical, x, y, w, h2);
    }

    public void fillGradientRect(Color color1, FSkinColor skinColor2, boolean vertical, float x, float y, float w, float h2) {
        this.fillGradientRect(color1, skinColor2.getColor(), vertical, x, y, w, h2);
    }

    public void fillGradientRect(Color color1, Color color2, boolean vertical, float x, float y, float w, float h2) {
        boolean needBlending;
        this.batch.end();
        if (this.alphaComposite < 1.0f) {
            color1 = FSkinColor.alphaColor(color1, color1.a * this.alphaComposite);
            color2 = FSkinColor.alphaColor(color2, color2.a * this.alphaComposite);
        }
        boolean bl = needBlending = color1.a < 1.0f || color2.a < 1.0f;
        if (needBlending) {
            Gdx.gl.glEnable(3042);
        }
        Color topLeftColor = color1;
        Color topRightColor = vertical ? color1 : color2;
        Color bottomLeftColor = vertical ? color2 : color1;
        Color bottomRightColor = color2;
        this.startShape(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.rect(this.adjustX(x), this.adjustY(y, h2), w, h2, bottomLeftColor, bottomRightColor, topRightColor, topLeftColor);
        this.endShape();
        if (needBlending) {
            Gdx.gl.glDisable(3042);
        }
        this.batch.begin();
    }

    private void startShape(ShapeRenderer.ShapeType shapeType) {
        if (!this.Dtransforms.isEmpty()) {
            this.shapeRenderer.setTransformMatrix(this.batch.getTransformMatrix());
        }
        this.shapeRenderer.begin(shapeType);
    }

    private void endShape() {
        this.shapeRenderer.end();
    }

    public void setColorRGBA(float r, float g2, float b, float alphaComposite0) {
        this.alphaComposite = alphaComposite0;
        this.batch.setColor(new Color(r, g2, b, this.alphaComposite));
    }

    public void resetColorRGBA(float alphaComposite0) {
        this.alphaComposite = alphaComposite0;
        this.batch.setColor(Color.WHITE);
    }

    public void setAlphaComposite(float alphaComposite0) {
        this.alphaComposite = alphaComposite0;
        this.batch.setColor(new Color(1.0f, 1.0f, 1.0f, this.alphaComposite));
    }

    public void resetAlphaComposite() {
        this.alphaComposite = 1.0f;
        this.batch.setColor(Color.WHITE);
    }

    public float getfloatAlphaComposite() {
        return this.alphaComposite;
    }

    public void drawBorderImage(FImage image, Color borderColor, Color tintColor, float x, float y, float w, float h2, boolean tint) {
        float oldalpha = this.alphaComposite;
        if (tint && !tintColor.equals(borderColor)) {
            this.drawRoundRect(2.0f, this.borderLining(borderColor.toString()), x, y, w, h2, (h2 - w) / 12.0f);
            this.fillRoundRect(tintColor, x, y, w, h2, (h2 - w) / 12.0f);
        } else if (image != null) {
            image.draw(this, x, y, w, h2);
            this.fillRoundRect(borderColor, x, y, w, h2, (h2 - w) / 10.0f);
        }
        this.setAlphaComposite(oldalpha);
    }

    public void drawborderImage(Color borderColor, float x, float y, float w, float h2) {
        float oldalpha = this.alphaComposite;
        this.fillRoundRect(borderColor, x, y, w, h2, (h2 - w) / 12.0f);
        this.setAlphaComposite(oldalpha);
    }

    public void drawImage(FImage image, Color borderColor, float x, float y, float w, float h2) {
        if (image == null) {
            return;
        }
        image.draw(this, x, y, w, h2);
        this.fillRoundRect(borderColor, x + 1.0f, y + 1.0f, w - 1.5f, h2 - 1.5f, (h2 - w) / 10.0f);
    }

    public void drawAvatarImage(FImage image, float x, float y, float w, float h2, boolean drawGrayscale, float amount) {
        if (image == null) {
            return;
        }
        if (amount > 0.0f) {
            this.batch.end();
            this.shaderWarp.bind();
            this.shaderWarp.setUniformf("u_amount", 0.2f);
            this.shaderWarp.setUniformf("u_speed", 0.2f);
            this.shaderWarp.setUniformf("u_time", amount);
            this.batch.setShader(this.shaderWarp);
            this.batch.begin();
            image.draw(this, x, y, w, h2);
            this.batch.end();
            this.batch.setShader(null);
            this.batch.begin();
        } else if (!drawGrayscale) {
            image.draw(this, x, y, w, h2);
        } else {
            this.batch.end();
            this.shaderGrayscale.bind();
            this.shaderGrayscale.setUniformf("u_grayness", 1.0f);
            this.shaderGrayscale.setUniformf("u_bias", 1.0f);
            this.batch.setShader(this.shaderGrayscale);
            this.batch.begin();
            image.draw(this, x, y, w, h2);
            this.batch.end();
            this.batch.setShader(null);
            this.batch.begin();
        }
    }

    public void drawCardImage(FImage image, TextureRegion damage_overlay, float x, float y, float w, float h2, boolean drawGrayscale, boolean damaged) {
        if (image == null) {
            return;
        }
        if (!drawGrayscale) {
            image.draw(this, x, y, w, h2);
            if (damage_overlay != null && damaged) {
                this.batch.draw(damage_overlay, this.adjustX(x), this.adjustY(y, h2), w, h2);
            }
        } else {
            this.batch.end();
            this.shaderGrayscale.bind();
            this.shaderGrayscale.setUniformf("u_grayness", 1.0f);
            this.shaderGrayscale.setUniformf("u_bias", 0.8f);
            this.batch.setShader(this.shaderGrayscale);
            this.batch.begin();
            image.draw(this, x, y, w, h2);
            this.batch.end();
            this.batch.setShader(null);
            this.batch.begin();
        }
    }

    public void drawCardImage(Texture image, TextureRegion damage_overlay, float x, float y, float w, float h2, boolean drawGrayscale, boolean damaged) {
        if (!drawGrayscale) {
            this.batch.draw(image, this.adjustX(x), this.adjustY(y, h2), w, h2);
            if (damage_overlay != null && damaged) {
                this.batch.draw(damage_overlay, this.adjustX(x), this.adjustY(y, h2), w, h2);
            }
        } else {
            this.batch.end();
            this.shaderGrayscale.bind();
            this.shaderGrayscale.setUniformf("u_grayness", 1.0f);
            this.shaderGrayscale.setUniformf("u_bias", 0.8f);
            this.batch.setShader(this.shaderGrayscale);
            this.batch.begin();
            this.batch.draw(image, this.adjustX(x), this.adjustY(y, h2), w, h2);
            this.batch.end();
            this.batch.setShader(null);
            this.batch.begin();
        }
    }

    public void drawCardImage(TextureRegion image, TextureRegion damage_overlay, float x, float y, float w, float h2, boolean drawGrayscale, boolean damaged) {
        if (image != null) {
            if (!drawGrayscale) {
                this.batch.draw(image, this.adjustX(x), this.adjustY(y, h2), w, h2);
                if (damage_overlay != null && damaged) {
                    this.batch.draw(damage_overlay, this.adjustX(x), this.adjustY(y, h2), w, h2);
                }
            } else {
                this.batch.end();
                this.shaderGrayscale.bind();
                this.shaderGrayscale.setUniformf("u_grayness", 1.0f);
                this.shaderGrayscale.setUniformf("u_bias", 0.8f);
                this.batch.setShader(this.shaderGrayscale);
                this.batch.begin();
                this.batch.draw(image, this.adjustX(x), this.adjustY(y, h2), w, h2);
                this.batch.end();
                this.batch.setShader(null);
                this.batch.begin();
            }
        }
    }

    public void drawGrayTransitionImage(FImage image, float x, float y, float w, float h2, float percentage) {
        if (image == null) {
            return;
        }
        this.batch.end();
        this.shaderGrayscale.bind();
        this.shaderGrayscale.setUniformf("u_grayness", percentage);
        this.shaderGrayscale.setUniformf("u_bias", 0.6f);
        this.batch.setShader(this.shaderGrayscale);
        this.batch.begin();
        image.draw(this, x, y, w, h2);
        this.batch.end();
        this.batch.setShader(null);
        this.batch.begin();
    }

    public void drawGrayTransitionImage(Texture image, float x, float y, float w, float h2, boolean withDarkOverlay, float percentage) {
        this.batch.end();
        this.shaderGrayscale.bind();
        this.shaderGrayscale.setUniformf("u_grayness", percentage);
        this.shaderGrayscale.setUniformf("u_bias", withDarkOverlay ? 0.5f : 1.0f);
        this.batch.setShader(this.shaderGrayscale);
        this.batch.begin();
        this.batch.draw(image, x, y, w, h2);
        this.batch.end();
        this.batch.setShader(null);
        this.batch.begin();
    }

    public void drawGrayTransitionImage(TextureRegion image, float x, float y, float w, float h2, boolean withDarkOverlay, float percentage) {
        this.batch.end();
        this.shaderGrayscale.bind();
        this.shaderGrayscale.setUniformf("u_grayness", percentage);
        this.shaderGrayscale.setUniformf("u_bias", withDarkOverlay ? 0.5f : 1.0f);
        this.batch.setShader(this.shaderGrayscale);
        this.batch.begin();
        this.batch.draw(image, x, y, w, h2);
        this.batch.end();
        this.batch.setShader(null);
        this.batch.begin();
    }

    public void drawCardRoundRect(Texture image, TextureRegion damage_overlay, float x, float y, float w, float h2, boolean drawGray, boolean damaged) {
        if (image == null) {
            return;
        }
        this.batch.end();
        this.shaderRoundedRect.bind();
        this.shaderRoundedRect.setUniformf("u_resolution", (float)image.getWidth(), (float)image.getHeight());
        this.shaderRoundedRect.setUniformf("edge_radius", (float)(image.getHeight() / image.getWidth() * ImageCache.getRadius(image)));
        this.shaderRoundedRect.setUniformf("u_gray", drawGray ? 0.8f : 0.0f);
        this.batch.setShader(this.shaderRoundedRect);
        this.batch.begin();
        this.batch.draw(image, this.adjustX(x), this.adjustY(y, h2), w, h2);
        this.batch.end();
        this.batch.setShader(null);
        this.batch.begin();
        if (damage_overlay != null && damaged) {
            this.batch.draw(damage_overlay, this.adjustX(x), this.adjustY(y, h2), w, h2);
        }
    }

    public void drawCardRoundRect(Texture image, float x, float y, float w, float h2, float originX, float originY, float rotation) {
        if (image == null) {
            return;
        }
        this.batch.end();
        this.shaderRoundedRect.bind();
        this.shaderRoundedRect.setUniformf("u_resolution", (float)image.getWidth(), (float)image.getHeight());
        this.shaderRoundedRect.setUniformf("edge_radius", (float)(image.getHeight() / image.getWidth() * ImageCache.getRadius(image)));
        this.shaderRoundedRect.setUniformf("u_gray", 0.0f);
        this.batch.setShader(this.shaderRoundedRect);
        this.batch.begin();
        this.drawRotatedImage(image, x, y, w, h2, originX, originY, 0, 0, image.getWidth(), image.getHeight(), rotation);
        this.batch.end();
        this.batch.setShader(null);
        this.batch.begin();
    }

    public void drawNoiseFade(TextureRegion image, float x, float y, float w, float h2, Float time) {
        if (image == null) {
            return;
        }
        if (time != null) {
            this.batch.end();
            this.shaderNoiseFade.bind();
            this.shaderNoiseFade.setUniformf("u_time", time.floatValue());
            this.batch.setShader(this.shaderNoiseFade);
            this.batch.begin();
            this.batch.draw(image, x, y, w, h2);
            this.batch.end();
            this.batch.setShader(null);
            this.batch.begin();
        } else {
            this.drawImage(image, x, y, w, h2);
        }
    }

    public void drawPortalFade(TextureRegion image, float x, float y, float w, float h2, Float time, boolean opaque) {
        if (image == null) {
            return;
        }
        if (time != null) {
            this.batch.end();
            this.shaderPortal.bind();
            this.shaderPortal.setUniformf("u_resolution", (float)image.getRegionWidth(), (float)image.getRegionHeight());
            this.shaderPortal.setUniformf("u_time", time.floatValue());
            this.shaderPortal.setUniformf("u_opaque", opaque ? 1.0f : 0.0f);
            this.batch.setShader(this.shaderPortal);
            this.batch.begin();
            this.batch.draw(image, x, y, w, h2);
            this.batch.end();
            this.batch.setShader(null);
            this.batch.begin();
        } else {
            this.drawImage(image, x, y, w, h2);
        }
    }

    public void drawHueShift(Texture image, float x, float y, float w, float h2, Float time) {
        if (image == null) {
            return;
        }
        if (time != null) {
            this.batch.end();
            this.shaderHueShift.bind();
            this.shaderHueShift.setUniformf("u_time", time.floatValue());
            this.batch.setShader(this.shaderHueShift);
            this.batch.begin();
            this.batch.draw(image, x, y, w, h2);
            this.batch.end();
            this.batch.setShader(null);
            this.batch.begin();
        } else {
            this.drawImage(image, x, y, w, h2);
        }
    }

    public void drawHueShift(TextureRegion image, float x, float y, float w, float h2, Float time) {
        if (image == null) {
            return;
        }
        if (time != null) {
            this.batch.end();
            this.shaderHueShift.bind();
            this.shaderHueShift.setUniformf("u_time", time.floatValue());
            this.batch.setShader(this.shaderHueShift);
            this.batch.begin();
            this.batch.draw(image, x, y, w, h2);
            this.batch.end();
            this.batch.setShader(null);
            this.batch.begin();
        } else {
            this.drawImage(image, x, y, w, h2);
        }
    }

    public void drawChromatic(TextureRegion image, float x, float y, float w, float h2, Float time) {
        if (image == null) {
            return;
        }
        if (time != null) {
            this.batch.end();
            this.shaderChromaticAbberation.bind();
            this.shaderChromaticAbberation.setUniformf("u_time", time.floatValue());
            this.batch.setShader(this.shaderChromaticAbberation);
            this.batch.begin();
            this.batch.draw(image, x, y, w, h2);
            this.batch.end();
            this.batch.setShader(null);
            this.batch.begin();
        } else {
            this.drawImage(image, x, y, w, h2);
        }
    }

    public void drawRipple(FImage image, float x, float y, float w, float h2, Float amount) {
        if (image == null) {
            return;
        }
        if (amount != null) {
            this.batch.end();
            this.shaderRipple.bind();
            this.shaderRipple.setUniformf("u_time", amount.floatValue());
            this.shaderRipple.setUniformf("u_bias", 0.7f);
            this.batch.setShader(this.shaderRipple);
            this.batch.begin();
            image.draw(this, x, y, w, h2);
            this.batch.end();
            this.batch.setShader(null);
            this.batch.begin();
        } else {
            this.drawImage(image, x, y, w, h2);
        }
    }

    public void drawPixelated(FImage image, float x, float y, float w, float h2, Float amount, boolean flipY) {
        if (image == null) {
            return;
        }
        if (amount != null) {
            this.batch.end();
            this.shaderPixelate.bind();
            this.shaderPixelate.setUniformf("u_resolution", Forge.isLandscapeMode() ? w : h2, Forge.isLandscapeMode() ? h2 : w);
            this.shaderPixelate.setUniformf("u_cellSize", amount.floatValue());
            this.shaderPixelate.setUniformf("u_yflip", flipY ? 1.0f : 0.0f);
            this.shaderPixelate.setUniformf("u_bias", 0.7f);
            this.batch.setShader(this.shaderPixelate);
            this.batch.begin();
            image.draw(this, x, y, w, h2);
            this.batch.end();
            this.batch.setShader(null);
            this.batch.begin();
        } else {
            this.drawImage(image, x, y, w, h2);
        }
    }

    public void drawPixelated(TextureRegion image, float x, float y, float w, float h2, Float amount, boolean flipY) {
        if (image == null) {
            return;
        }
        if (amount != null) {
            this.batch.end();
            this.shaderPixelate.bind();
            this.shaderPixelate.setUniformf("u_resolution", Forge.isLandscapeMode() ? w : h2, Forge.isLandscapeMode() ? h2 : w);
            this.shaderPixelate.setUniformf("u_cellSize", amount.floatValue());
            this.shaderPixelate.setUniformf("u_yflip", flipY ? 1.0f : 0.0f);
            this.shaderPixelate.setUniformf("u_bias", 0.6f);
            this.batch.setShader(this.shaderPixelate);
            this.batch.begin();
            this.batch.draw(image, x, y, w, h2);
            this.batch.end();
            this.batch.setShader(null);
            this.batch.begin();
        } else {
            this.drawImage(image, x, y, w, h2);
        }
    }

    public void drawPixelatedWarp(TextureRegion image, float x, float y, float w, float h2, float amount) {
        if (image == null) {
            return;
        }
        if (amount > 0.0f) {
            this.batch.end();
            this.shaderPixelateWarp.bind();
            this.shaderPixelateWarp.setUniformf("u_resolution", (float)image.getRegionWidth(), (float)image.getRegionHeight());
            this.shaderPixelateWarp.setUniformf("u_cellSize", amount);
            this.shaderPixelateWarp.setUniformf("u_amount", 0.2f * amount);
            this.shaderPixelateWarp.setUniformf("u_speed", 0.5f);
            this.shaderPixelateWarp.setUniformf("u_time", 0.8f);
            this.batch.setShader(this.shaderPixelateWarp);
            this.batch.begin();
            this.batch.draw(image, x, y, w, h2);
            this.batch.end();
            this.batch.setShader(null);
            this.batch.begin();
        } else {
            this.drawImage(image, x, y, w, h2);
        }
    }

    public void drawWarpImage(Texture image, float x, float y, float w, float h2, float time) {
        this.batch.end();
        this.shaderWarp.bind();
        this.shaderWarp.setUniformf("u_amount", 0.2f);
        this.shaderWarp.setUniformf("u_speed", 0.5f);
        this.shaderWarp.setUniformf("u_time", time);
        this.batch.setShader(this.shaderWarp);
        this.batch.begin();
        this.batch.draw(image, x, y, w, h2);
        this.batch.end();
        this.batch.setShader(null);
        this.batch.begin();
    }

    public void drawWarpImage(TextureRegion image, float x, float y, float w, float h2, float time) {
        this.batch.end();
        this.shaderWarp.bind();
        this.shaderWarp.setUniformf("u_amount", 0.2f);
        this.shaderWarp.setUniformf("u_speed", 0.6f);
        this.shaderWarp.setUniformf("u_time", time);
        this.batch.setShader(this.shaderWarp);
        this.batch.begin();
        this.batch.draw(image, x, y, w, h2);
        this.batch.end();
        this.batch.setShader(null);
        this.batch.begin();
    }

    public void drawWarpImage(FImage image, float x, float y, float w, float h2, float time) {
        if (image == null) {
            return;
        }
        this.batch.end();
        this.shaderWarp.bind();
        this.shaderWarp.setUniformf("u_amount", 0.2f);
        this.shaderWarp.setUniformf("u_speed", 0.6f);
        this.shaderWarp.setUniformf("u_time", time);
        this.batch.setShader(this.shaderWarp);
        this.batch.begin();
        image.draw(this, x, y, w, h2);
        this.batch.end();
        this.batch.setShader(null);
        this.batch.begin();
    }

    public void drawUnderWaterImage(FImage image, float x, float y, float w, float h2, float time) {
        if (image == null) {
            return;
        }
        this.batch.end();
        this.shaderUnderwater.bind();
        this.shaderUnderwater.setUniformf("u_amount", 10.0f * time);
        this.shaderUnderwater.setUniformf("u_speed", 0.5f * time);
        this.shaderUnderwater.setUniformf("u_time", time);
        this.shaderUnderwater.setUniformf("u_bias", 0.7f);
        this.batch.setShader(this.shaderUnderwater);
        this.batch.begin();
        image.draw(this, x, y, w, h2);
        this.batch.end();
        this.batch.setShader(null);
        this.batch.begin();
    }

    public void drawNightDay(FImage image, float x, float y, float w, float h2, Float timeOfDay, boolean darkOverlay, float rippleAmount) {
        if (image == null) {
            return;
        }
        if (timeOfDay != null) {
            this.batch.end();
            this.shaderNightDay.bind();
            this.shaderNightDay.setUniformf("u_timeOfDay", timeOfDay.floatValue());
            this.shaderNightDay.setUniformf("u_time", rippleAmount);
            this.shaderNightDay.setUniformf("u_bias", darkOverlay ? 0.7f : 1.0f);
            this.batch.setShader(this.shaderNightDay);
            this.batch.begin();
            image.draw(this, x, y, w, h2);
            this.batch.end();
            this.batch.setShader(null);
            this.batch.begin();
        } else {
            this.drawImage(image, x, y, w, h2);
        }
    }

    public void drawUnderWaterImage(TextureRegion image, float x, float y, float w, float h2, float time) {
        this.batch.end();
        this.shaderUnderwater.bind();
        this.shaderUnderwater.setUniformf("u_amount", 10.0f);
        this.shaderUnderwater.setUniformf("u_speed", 0.5f);
        this.shaderUnderwater.setUniformf("u_time", time);
        this.batch.setShader(this.shaderUnderwater);
        this.batch.begin();
        this.batch.draw(image, this.adjustX(x), this.adjustY(y, h2), w, h2);
        this.batch.end();
        this.batch.setShader(null);
        this.batch.begin();
    }

    public void drawImage(FImage image, float x, float y, float w, float h2) {
        this.drawImage(image, x, y, w, h2, false);
    }

    public void drawImage(FImage image, float x, float y, float w, float h2, boolean withDarkOverlay) {
        if (image == null) {
            return;
        }
        image.draw(this, x, y, w, h2);
        if (withDarkOverlay) {
            float oldalpha = this.alphaComposite;
            this.setAlphaComposite(0.4f);
            this.fillRect(Color.BLACK, x, y, w, h2);
            this.setAlphaComposite(oldalpha);
        }
    }

    public void drawImage(Texture image, float x, float y, float w, float h2) {
        if (image != null) {
            this.batch.draw(image, this.adjustX(x), this.adjustY(y, h2), w, h2);
        }
    }

    public void drawImage(TextureRegion image, float x, float y, float w, float h2) {
        if (image != null) {
            this.batch.draw(image, this.adjustX(x), this.adjustY(y, h2), w, h2);
        }
    }

    public void drawImage(TextureRegion image, TextureRegion glowImageReference, float x, float y, float w, float h2, Color glowColor, boolean selected) {
        if (image == null || glowImageReference == null) {
            return;
        }
        if (!selected) {
            this.batch.draw(image, this.adjustX(x), this.adjustY(y, h2), w, h2);
        } else {
            this.batch.end();
            this.shaderOutline.bind();
            this.shaderOutline.setUniformf("u_viewportInverse", new Vector2(1.0f / w, 1.0f / h2));
            this.shaderOutline.setUniformf("u_offset", 3.0f);
            this.shaderOutline.setUniformf("u_step", Math.min(1.0f, w / 70.0f));
            this.shaderOutline.setUniformf("u_color", new Vector3(glowColor.r, glowColor.g, glowColor.b));
            this.batch.setShader(this.shaderOutline);
            this.batch.begin();
            this.batch.draw(glowImageReference, this.adjustX(x), this.adjustY(y, h2), w, h2);
            this.batch.end();
            this.batch.setShader(null);
            this.batch.begin();
            this.batch.draw(image, this.adjustX(x), this.adjustY(y, h2), w, h2);
        }
    }

    public void drawDeckBox(FImage cardArt, float scale, TextureRegion image, TextureRegion glowImageReference, float x, float y, float w, float h2, Color glowColor, boolean selected) {
        if (image == null || glowImageReference == null) {
            return;
        }
        float yBox = y - h2 * 0.25f;
        if (!selected) {
            cardArt.draw(this, x + (w - w * scale) / 2.0f, y + (h2 - h2 * scale) / 3.0f, w * scale, h2 * scale / 1.85f);
            this.batch.draw(image, this.adjustX(x), this.adjustY(yBox, h2), w, h2);
        } else {
            this.batch.end();
            this.shaderOutline.bind();
            this.shaderOutline.setUniformf("u_viewportInverse", new Vector2(1.0f / w, 1.0f / h2));
            this.shaderOutline.setUniformf("u_offset", 3.0f);
            this.shaderOutline.setUniformf("u_step", Math.min(1.0f, w / 70.0f));
            this.shaderOutline.setUniformf("u_color", new Vector3(glowColor.r, glowColor.g, glowColor.b));
            this.batch.setShader(this.shaderOutline);
            this.batch.begin();
            this.batch.draw(glowImageReference, this.adjustX(x), this.adjustY(yBox, h2), w, h2);
            this.batch.end();
            this.batch.setShader(null);
            this.batch.begin();
            cardArt.draw(this, x + (w - w * scale) / 2.0f, y + (h2 - h2 * scale) / 3.0f, w * scale, h2 * scale / 1.85f);
            this.batch.draw(image, this.adjustX(x), this.adjustY(yBox, h2), w, h2);
        }
    }

    public void drawRepeatingImage(Texture image, float x, float y, float w, float h2) {
        if (image == null) {
            return;
        }
        if (this.startClip(x, y, w, h2)) {
            int tilesW = (int)(w / (float)image.getWidth()) + 1;
            int tilesH = (int)(h2 / (float)image.getHeight()) + 1;
            this.batch.draw(image, this.adjustX(x), this.adjustY(y, h2), image.getWidth() * tilesW, image.getHeight() * tilesH, 0.0f, tilesH, tilesW, 0.0f);
        }
        this.endClip();
    }

    public void drawFlippedImage(Texture image, float x, float y, float w, float h2) {
        this.batch.draw(image, this.adjustX(x), this.adjustY(y, h2), w, h2, 0, 0, image.getWidth(), image.getHeight(), false, true);
    }

    public void drawImageWithTransforms(TextureRegion image, float x, float y, float w, float h2, float rotation, boolean flipX, boolean flipY) {
        float originX = x + w / 2.0f;
        float originY = y + h2 / 2.0f;
        this.batch.draw(image.getTexture(), this.adjustX(x), this.adjustY(y, h2), originX - x, h2 - (originY - y), w, h2, 1.0f, 1.0f, rotation, image.getRegionX(), image.getRegionY(), image.getRegionWidth(), image.getRegionHeight(), flipX, flipY);
    }

    public void setProjectionMatrix(Matrix4 matrix) {
        this.batch.setProjectionMatrix(matrix);
        this.shapeRenderer.setProjectionMatrix(matrix);
    }

    public void startRotateTransform(float originX, float originY, float rotation) {
        this.batch.end();
        this.Dtransforms.addFirst(new Matrix4(this.batch.getTransformMatrix().idt()));
        ++this.transformCount;
        this.batch.getTransformMatrix().idt().translate(this.adjustX(originX), this.adjustY(originY, 0.0f), 0.0f).rotate(Vector3.Z, rotation).translate(-this.adjustX(originX), -this.adjustY(originY, 0.0f), 0.0f);
        this.batch.begin();
    }

    public void endTransform() {
        this.batch.end();
        this.shapeRenderer.setTransformMatrix(this.batch.getTransformMatrix().idt());
        this.Dtransforms.removeFirst();
        --this.transformCount;
        if (this.transformCount != this.Dtransforms.size()) {
            System.err.printf("Stack count: %d, transformCount: %d%n", this.Dtransforms.size(), this.transformCount);
            this.transformCount = 0;
            this.Dtransforms.clear();
        }
        this.batch.getTransformMatrix().idt();
        this.shapeRenderer.getTransformMatrix().idt();
        this.batch.begin();
    }

    public void drawRotatedImage(Texture image, float x, float y, float w, float h2, float originX, float originY, float rotation) {
        this.drawRotatedImage(image, x, y, w, h2, originX, originY, 0, 0, image.getWidth(), image.getHeight(), rotation);
    }

    public void drawRotatedImage(TextureRegion image, float x, float y, float w, float h2, float originX, float originY, float rotation) {
        this.drawRotatedImage(image.getTexture(), x, y, w, h2, originX, originY, image.getRegionX(), image.getRegionY(), image.getRegionWidth(), image.getRegionHeight(), rotation);
    }

    public void drawRotatedImage(Texture image, float x, float y, float w, float h2, float originX, float originY, int srcX, int srcY, int srcWidth, int srcHeight, float rotation) {
        this.batch.draw(image, this.adjustX(x), this.adjustY(y, h2), originX - x, h2 - (originY - y), w, h2, 1.0f, 1.0f, rotation, srcX, srcY, srcWidth, srcHeight, false, false);
    }

    public void drawText(String text, BitmapFont bitmapFont, float x, float y, Color color, float alpha) {
        if (text == null || bitmapFont == null || text.isEmpty()) {
            return;
        }
        bitmapFont.setColor(color.r, color.g, color.b, alpha);
        bitmapFont.draw((Batch)this.batch, text, x, y);
    }

    public void drawText(BitmapFont bitmapFont, GlyphLayout layout, float x, float y) {
        if (bitmapFont == null || layout == null) {
            return;
        }
        bitmapFont.draw((Batch)this.batch, layout, x, y);
    }

    public void drawText(String text, FSkinFont font, FSkinColor skinColor, float x, float y, float w, float h2, boolean wrap, int horzAlignment, boolean centerVertically) {
        this.drawText(text, font, skinColor.getColor(), x, y, w, h2, wrap, horzAlignment, centerVertically);
    }

    public void drawText(String text, FSkinFont font, Color color, float x, float y, float w, float h2, boolean wrap, int horzAlignment, boolean centerVertically) {
        try {
            float textHeight;
            if (text == null) {
                return;
            }
            if (this.alphaComposite < 1.0f) {
                color = FSkinColor.alphaColor(color, color.a * this.alphaComposite);
            }
            if (color.a < 1.0f) {
                Gdx.gl.glEnable(3042);
            }
            TextBounds textBounds = wrap ? font.getWrappedBounds(text, w) : font.getMultiLineBounds(text);
            boolean needClip = false;
            while (textBounds.width > w || textBounds.height > h2) {
                if (font.canShrink()) {
                    font = font.shrink();
                    if (wrap) {
                        textBounds = font.getWrappedBounds(text, w);
                        continue;
                    }
                    textBounds = font.getMultiLineBounds(text);
                    continue;
                }
                needClip = true;
                break;
            }
            if (needClip) {
                this.startClip(x, y, w, h2);
            }
            if (h2 > (textHeight = textBounds.height) && centerVertically) {
                y += (h2 - textHeight) / 2.0f;
            }
            font.draw(this.batch, text, color, this.adjustX(x), this.adjustY(y, 0.0f), w, wrap, horzAlignment);
            if (needClip) {
                this.endClip();
            }
            if (color.a < 1.0f) {
                Gdx.gl.glDisable(3042);
            }
        }
        catch (Exception e) {
            Forge.setForcedEnglishonCJKMissing();
        }
    }

    public void drawOutlinedText(String text, FSkinFont skinFont, Color textColor, Color outlineColor, float x, float y, float w, float h2, boolean wrap, int horzAlignment, boolean centerVertically) {
        this.drawOutlinedText(text, skinFont, textColor, outlineColor, x, y, w, h2, wrap, horzAlignment, centerVertically, false);
    }

    public void drawOutlinedText(String text, FSkinFont skinFont, Color textColor, Color outlineColor, float x, float y, float w, float h2, boolean wrap, int horzAlignment, boolean centerVertically, boolean shadow) {
        if (shadow) {
            float oldAlpha = this.alphaComposite;
            this.alphaComposite = 0.4f;
            this.drawText(text, skinFont, outlineColor, x - 1.5f, y + 1.5f, w, h2, wrap, horzAlignment, centerVertically);
            this.drawText(text, skinFont, outlineColor, x + 1.5f, y + 1.5f, w, h2, wrap, horzAlignment, centerVertically);
            this.drawText(text, skinFont, outlineColor, x + 1.5f, y - 1.5f, w, h2, wrap, horzAlignment, centerVertically);
            this.drawText(text, skinFont, outlineColor, x - 1.5f, y - 1.5f, w, h2, wrap, horzAlignment, centerVertically);
            this.alphaComposite = oldAlpha;
        }
        this.drawText(text, skinFont, outlineColor, x - 1.0f, y, w, h2, wrap, horzAlignment, centerVertically);
        this.drawText(text, skinFont, outlineColor, x, y - 1.0f, w, h2, wrap, horzAlignment, centerVertically);
        this.drawText(text, skinFont, outlineColor, x - 1.0f, y - 1.0f, w, h2, wrap, horzAlignment, centerVertically);
        this.drawText(text, skinFont, outlineColor, x + 1.0f, y, w, h2, wrap, horzAlignment, centerVertically);
        this.drawText(text, skinFont, outlineColor, x, y + 1.0f, w, h2, wrap, horzAlignment, centerVertically);
        this.drawText(text, skinFont, outlineColor, x + 1.0f, y + 1.0f, w, h2, wrap, horzAlignment, centerVertically);
        this.drawText(text, skinFont, textColor, x, y, w, h2, wrap, horzAlignment, centerVertically);
    }

    public float adjustX(float x) {
        return x + this.bounds.x;
    }

    public float adjustY(float y, float height) {
        return this.regionHeight - y - this.bounds.y - height;
    }

    public Color borderLining(String c) {
        int c_b;
        int c_g;
        if (c == null || c == "") {
            return Color.valueOf("#fffffd");
        }
        int c_r = Integer.parseInt(c.substring(0, 2), 16);
        int brightness = (c_r * 299 + (c_g = Integer.parseInt(c.substring(2, 4), 16)) * 587 + (c_b = Integer.parseInt(c.substring(4, 6), 16)) * 114) / 1000;
        return brightness > 155 ? Color.valueOf("#171717") : Color.valueOf("#fffffd");
    }

    public Texture getDummyTexture() {
        if (this.dummyTexture == null) {
            Pixmap P = new Pixmap(1, 1, Pixmap.Format.RGBA8888);
            P.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            P.drawPixel(0, 0);
            this.dummyTexture = new Texture(P);
            P.dispose();
        }
        return this.dummyTexture;
    }

    public static void setVideoMode(String videoMode) {
        if (videoMode == null) {
            videoMode = "720p";
        }
        Config.instance().getSettingData().videomode = videoMode;
        switch (videoMode) {
            case "768p": {
                Config.instance().getSettingData().width = 1366;
                Config.instance().getSettingData().height = 768;
                break;
            }
            case "900p": {
                Config.instance().getSettingData().width = 1600;
                Config.instance().getSettingData().height = 900;
                break;
            }
            case "1080p": {
                Config.instance().getSettingData().width = 1920;
                Config.instance().getSettingData().height = 1080;
                break;
            }
            case "1440p": {
                Config.instance().getSettingData().width = 2560;
                Config.instance().getSettingData().height = 1440;
                break;
            }
            case "2160p": {
                Config.instance().getSettingData().width = 3840;
                Config.instance().getSettingData().height = 2160;
                break;
            }
            default: {
                Config.instance().getSettingData().width = 1280;
                Config.instance().getSettingData().height = 720;
            }
        }
        Config.instance().saveSettings();
    }
}

