/*
 * Decompiled with CFR 0.152.
 */
package forge;

import forge.card.CardRules;
import forge.util.BuildInfo;
import forge.util.FileUtil;
import forge.util.Localizer;
import forge.util.ThreadUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.time.StopWatch;

public class CardStorageReader {
    private static final String CARD_FILE_DOT_EXTENSION = ".txt";
    private static final String UPCOMING = "upcoming";
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private final boolean useThreadPool = ThreadUtil.isMultiCoreSystem();
    private static final int NUMBER_OF_PARTS = 25;
    private final ProgressObserver progressObserver;
    private final boolean loadingTokens;
    private transient File cardsfolder;
    private transient ZipFile zip;
    private transient Map<String, ZipEntry> zipEntriesMap;
    private final transient Charset charset;
    private final boolean loadCardsLazily;

    public CardStorageReader(String cardDataDir, ProgressObserver progressObserver, boolean loadCardsLazily) {
        this.progressObserver = progressObserver != null ? progressObserver : ProgressObserver.emptyObserver;
        this.cardsfolder = new File(cardDataDir);
        this.loadingTokens = cardDataDir.contains("token");
        this.loadCardsLazily = loadCardsLazily;
        if (!this.cardsfolder.exists()) {
            throw new RuntimeException("CardReader : constructor error -- " + this.cardsfolder.getAbsolutePath() + " file/folder not found.");
        }
        if (!this.cardsfolder.isDirectory()) {
            throw new RuntimeException("CardReader : constructor error -- not a directory -- " + this.cardsfolder.getAbsolutePath());
        }
        File zipFile = new File(this.cardsfolder, "cardsfolder.zip");
        if (zipFile.exists()) {
            try {
                this.zip = new ZipFile(zipFile);
            }
            catch (Exception exn) {
                System.err.printf("Error reading zip file \"%s\": %s. Defaulting to txt files in \"%s\".%n", zipFile.getAbsolutePath(), exn, this.cardsfolder.getAbsolutePath());
            }
        }
        this.charset = Charset.forName(DEFAULT_CHARSET_NAME);
    }

    private List<CardRules> loadCardsInRange(List<File> files, int from, int to) {
        CardRules.Reader rulesReader = new CardRules.Reader();
        ArrayList<CardRules> result = new ArrayList<CardRules>();
        for (int i = from; i < to; ++i) {
            File cardTxtFile = files.get(i);
            result.add(this.loadCard(rulesReader, cardTxtFile));
        }
        return result;
    }

    private List<CardRules> loadCardsInRangeFromZip(List<ZipEntry> files, int from, int to) {
        CardRules.Reader rulesReader = new CardRules.Reader();
        ArrayList<CardRules> result = new ArrayList<CardRules>();
        for (int i = from; i < to; ++i) {
            ZipEntry ze = files.get(i);
            result.add(this.loadCard(rulesReader, ze));
        }
        return result;
    }

    private String transformName(String cardName) {
        char[] chars = new char[cardName.length()];
        int charIndex = 0;
        for (int i = 0; i < cardName.length(); ++i) {
            int c = Character.toLowerCase(cardName.charAt(i));
            if (c == 39) continue;
            if (!(c >= 97 && c <= 122 || c >= 48 && c <= 57)) {
                if (charIndex > 0 && chars[charIndex - 1] == '_' || c == 44 && charIndex > 0 && (chars[charIndex - 1] >= '0' || chars[charIndex - 1] <= '9')) continue;
                c = 95;
            }
            chars[charIndex++] = c;
        }
        if (chars[charIndex - 1] == '_') {
            --charIndex;
        }
        return new String(chars, 0, charIndex);
    }

    private ZipEntry findZipEntryForCard(String transformedName) {
        ZipEntry entry;
        if (this.zip == null) {
            return null;
        }
        if (this.zipEntriesMap == null) {
            this.zipEntriesMap = new HashMap<String, ZipEntry>();
            for (ZipEntry entry2 : this.getZipEntries()) {
                this.zipEntriesMap.put(entry2.getName(), entry2);
            }
        }
        if ((entry = this.zipEntriesMap.get((transformedName = transformedName.charAt(0) + "/" + transformedName) + CARD_FILE_DOT_EXTENSION)) == null) {
            for (String fileName : this.zipEntriesMap.keySet()) {
                if (!fileName.startsWith(transformedName)) continue;
                entry = this.zipEntriesMap.get(fileName);
                break;
            }
        }
        return entry;
    }

    private File findFileForCard(String transformedName) {
        String folder = this.cardsfolder.getAbsolutePath() + "/" + transformedName.charAt(0);
        File file = new File(folder + "/" + transformedName + CARD_FILE_DOT_EXTENSION);
        if (!file.exists()) {
            file = null;
            String[] fileNames = new File(folder).list();
            if (fileNames != null) {
                for (String fileName : new File(folder).list()) {
                    if (!fileName.startsWith(transformedName)) continue;
                    file = new File(folder, fileName);
                    break;
                }
            }
        }
        return file;
    }

    public final CardRules attemptToLoadCard(String cardName) {
        String transformedName = this.transformName(cardName);
        CardRules rules = null;
        ZipEntry entry = this.findZipEntryForCard(transformedName);
        if (entry != null) {
            rules = this.loadCard(new CardRules.Reader(), entry);
        } else {
            File file = this.findFileForCard(transformedName);
            if (file != null) {
                rules = this.loadCard(new CardRules.Reader(), file);
            }
        }
        return rules;
    }

    public final Iterable<CardRules> loadCards() {
        Localizer localizer = Localizer.getInstance();
        this.progressObserver.setOperationName(localizer.getMessage("splash.loading.examining-cards", new Object[0]), true);
        TreeSet<CardRules> result = this.loadingTokens ? new TreeSet<CardRules>(Comparator.comparing(CardRules::getNormalizedName, String.CASE_INSENSITIVE_ORDER)) : new TreeSet<CardRules>(Comparator.comparing(CardRules::getName, String.CASE_INSENSITIVE_ORDER));
        if (this.loadCardsLazily) {
            return result;
        }
        List<File> allFiles = CardStorageReader.collectCardFiles(new ArrayList<File>(), this.cardsfolder);
        if (!allFiles.isEmpty()) {
            int fileParts;
            int n = fileParts = this.zip == null ? 25 : 9;
            if (allFiles.size() < fileParts * 100) {
                fileParts = Math.max(1, allFiles.size() / 100);
            }
            CountDownLatch cdlFiles = new CountDownLatch(fileParts);
            List<Callable<List<CardRules>>> taskFiles = this.makeTaskListForFiles(allFiles, cdlFiles);
            this.progressObserver.setOperationName(localizer.getMessage("splash.loading.cards-folders", new Object[0]), true);
            this.progressObserver.report(0, taskFiles.size());
            StopWatch sw = new StopWatch();
            sw.start();
            this.executeLoadTask(result, taskFiles, cdlFiles);
            sw.stop();
            long timeOnParse = sw.getTime();
            System.out.printf("Read cards: %s files in %d ms (%d parts) %s%n", allFiles.size(), timeOnParse, taskFiles.size(), this.useThreadPool ? "using thread pool" : "in same thread");
        }
        if (this.zip != null) {
            CountDownLatch cdlZip = new CountDownLatch(25);
            List<Callable<List<CardRules>>> taskZip = this.makeTaskListForZip(this.getZipEntries(), cdlZip);
            this.progressObserver.setOperationName(localizer.getMessage("splash.loading.cards-archive", new Object[0]), true);
            this.progressObserver.report(0, taskZip.size());
            StopWatch sw = new StopWatch();
            sw.start();
            this.executeLoadTask(result, taskZip, cdlZip);
            sw.stop();
            long timeOnParse = sw.getTime();
            System.out.printf("Read cards: %s archived files in %d ms (%d parts) %s%n", this.zip.size(), timeOnParse, taskZip.size(), this.useThreadPool ? "using thread pool" : "in same thread");
        }
        return result;
    }

    private List<ZipEntry> getZipEntries() {
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> zipEnum = this.zip.entries();
        while (zipEnum.hasMoreElements()) {
            ZipEntry entry = zipEnum.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(CARD_FILE_DOT_EXTENSION)) continue;
            entries.add(entry);
        }
        return entries;
    }

    private void executeLoadTask(Collection<CardRules> result, List<Callable<List<CardRules>>> tasks, CountDownLatch cdl) {
        try {
            if (this.useThreadPool) {
                ExecutorService executor = ThreadUtil.getComputingPool(0.5f);
                List<Future<List<CardRules>>> parts = executor.invokeAll(tasks);
                executor.shutdown();
                cdl.await();
                for (Future<List<CardRules>> pp : parts) {
                    result.addAll((Collection<CardRules>)pp.get());
                }
            } else {
                for (Callable<List<CardRules>> c : tasks) {
                    result.addAll((Collection<CardRules>)c.call());
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Callable<List<CardRules>>> makeTaskListForZip(List<ZipEntry> entries, CountDownLatch cdl) {
        int totalFiles = entries.size();
        int maxParts = (int)cdl.getCount();
        int filesPerPart = totalFiles / maxParts;
        ArrayList<Callable<List<CardRules>>> tasks = new ArrayList<Callable<List<CardRules>>>();
        for (int iPart = 0; iPart < maxParts; ++iPart) {
            int from = iPart * filesPerPart;
            int till = iPart == maxParts - 1 ? totalFiles : from + filesPerPart;
            tasks.add(() -> {
                List<CardRules> res = this.loadCardsInRangeFromZip(entries, from, till);
                cdl.countDown();
                this.progressObserver.report(maxParts - (int)cdl.getCount(), maxParts);
                return res;
            });
        }
        return tasks;
    }

    private List<Callable<List<CardRules>>> makeTaskListForFiles(List<File> allFiles, CountDownLatch cdl) {
        int totalFiles = allFiles.size();
        int maxParts = (int)cdl.getCount();
        int filesPerPart = totalFiles / maxParts;
        ArrayList<Callable<List<CardRules>>> tasks = new ArrayList<Callable<List<CardRules>>>();
        for (int iPart = 0; iPart < maxParts; ++iPart) {
            int from = iPart * filesPerPart;
            int till = iPart == maxParts - 1 ? totalFiles : from + filesPerPart;
            tasks.add(() -> {
                List<CardRules> res = this.loadCardsInRange(allFiles, from, till);
                cdl.countDown();
                this.progressObserver.report(maxParts - (int)cdl.getCount(), maxParts);
                return res;
            });
        }
        return tasks;
    }

    public static List<File> collectCardFiles(List<File> accumulator, File startDir) {
        String[] list;
        for (String filename : list = startDir.list()) {
            File entry = new File(startDir, filename);
            if (!entry.isDirectory()) {
                if (!entry.getName().endsWith(CARD_FILE_DOT_EXTENSION)) continue;
                accumulator.add(entry);
                continue;
            }
            if (filename.startsWith(".") || filename.equalsIgnoreCase(UPCOMING) && !BuildInfo.isDevelopmentVersion()) continue;
            CardStorageReader.collectCardFiles(accumulator, entry);
        }
        return accumulator;
    }

    private List<String> readScript(InputStream inputStream) {
        return FileUtil.readAllLines(new InputStreamReader(inputStream, this.charset), true);
    }

    protected final CardRules loadCard(CardRules.Reader reader, File file) {
        CardRules cardRules;
        block9: {
            InputStream fileInputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                reader.reset();
                List<String> lines = this.readScript(fileInputStream);
                cardRules = reader.readCard(lines, com.google.common.io.Files.getNameWithoutExtension(file.getName()));
                if (fileInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException ex) {
                    throw new RuntimeException("CardReader : run error -- file not found: " + file.getPath(), ex);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error loading cardscript " + file.getName() + ". Please close Forge and resolve this.", ex);
                }
            }
            fileInputStream.close();
        }
        return cardRules;
    }

    protected final CardRules loadCard(CardRules.Reader rulesReader, ZipEntry entry) {
        CardRules cardRules;
        block8: {
            InputStream zipInputStream = this.zip.getInputStream(entry);
            try {
                rulesReader.reset();
                cardRules = rulesReader.readCard(this.readScript(zipInputStream), com.google.common.io.Files.getNameWithoutExtension(entry.getName()));
                if (zipInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (zipInputStream != null) {
                        try {
                            zipInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exn) {
                    throw new RuntimeException(exn);
                }
            }
            zipInputStream.close();
        }
        return cardRules;
    }

    public static interface ProgressObserver {
        public static final ProgressObserver emptyObserver = new ProgressObserver(){

            @Override
            public void setOperationName(String name, boolean usePercents) {
            }

            @Override
            public void report(int current, int total) {
            }
        };

        public void setOperationName(String var1, boolean var2);

        public void report(int var1, int var2);
    }
}

